/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.conversations;

import com.azure.ai.openai.assistants.AssistantsClient;
import com.azure.ai.openai.assistants.models.AssistantThread;
import com.azure.ai.openai.assistants.models.AssistantThreadCreationOptions;
import com.azure.ai.openai.assistants.models.ListSortOrder;
import com.azure.ai.openai.assistants.models.MessageContent;
import com.azure.ai.openai.assistants.models.MessageTextContent;
import com.azure.ai.openai.assistants.models.PageableList;
import com.azure.ai.openai.assistants.models.ThreadMessage;
import com.azure.ai.openai.assistants.models.UpdateAssistantThreadOptions;
import com.ontotext.forest.gpt.chat.GptChatMessage;
import com.ontotext.forest.gpt.conversations.ConversationResponse;
import com.ontotext.forest.gpt.conversations.Usage;
import com.ontotext.forest.gpt.ttyg.JSONUtil;
import com.ontotext.forest.gpt.ttyg.exceptions.NonExistentResourceRequested;
import com.ontotext.graphdb.GraphDBHTTPContext;
import com.ontotext.graphdb.configs.SystemConfig;
import jakarta.annotation.Nullable;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversationGptClient {
    public static String UNNAMED_CHAT_NAME = "[Unnamed chat]";
    public static final String METADATA_NAME = "name";
    public static final String METADATA_INSTALLATION_ID = "graphdb.installationId";
    public static final String METADATA_USERNAME = "graphdb.username";
    public static final String METADATA_UPDATED_AT = "graphdb.updatedAt";
    public static final String METADATA_USAGE = "graphdb.usage";
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    AssistantsClient assistantsOpenAIClient;

    public ConversationGptClient(AssistantsClient assistantsOpenAIClient) {
        this.assistantsOpenAIClient = assistantsOpenAIClient;
    }

    public AssistantThread createConversation() {
        AssistantThreadCreationOptions options = new AssistantThreadCreationOptions();
        options.setMetadata(Map.of(METADATA_NAME, UNNAMED_CHAT_NAME, METADATA_INSTALLATION_ID, SystemConfig.getInstallationId(), METADATA_USERNAME, GraphDBHTTPContext.getAuthenticatedUser().getUsername()));
        return this.assistantsOpenAIClient.createThread(options);
    }

    public ConversationResponse renameConversation(String conversationId, String name) {
        ConversationResponse conversation = this.getConversationWithoutMessages(conversationId);
        conversation.setName(name);
        this.assistantsOpenAIClient.updateThread(conversationId, new UpdateAssistantThreadOptions().setMetadata(Map.of(METADATA_NAME, name)));
        return conversation;
    }

    public ConversationResponse getConversationWithoutMessages(String threadId) {
        AssistantThread thread = this.getThreadWithSecurity(threadId);
        ConversationResponse response = new ConversationResponse();
        response.setId(thread.getId());
        response.setName((String)thread.getMetadata().get(METADATA_NAME));
        long timestamp = thread.getCreatedAt().toEpochSecond();
        String metadataTimestamp = (String)thread.getMetadata().get(METADATA_UPDATED_AT);
        if (metadataTimestamp != null) {
            try {
                timestamp = Long.parseLong(metadataTimestamp);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        response.setTimestamp(timestamp);
        return response;
    }

    public AssistantThread getThreadWithSecurity(String threadId) {
        AssistantThread thread = this.assistantsOpenAIClient.getThread(threadId);
        Map metadata = thread.getMetadata();
        if (!SystemConfig.matchesInstallationId((String)((String)metadata.get(METADATA_INSTALLATION_ID)))) {
            throw new NonExistentResourceRequested("Chat not matching this GraphDB instance");
        }
        if (!GraphDBHTTPContext.getAuthenticatedUser().getUsername().equals(metadata.get(METADATA_USERNAME))) {
            throw new NonExistentResourceRequested("Chat not matching the requesting user");
        }
        return thread;
    }

    public ConversationResponse addAllConversationMessages(ConversationResponse conversation, @Nullable Integer limit) {
        PageableList threadMessages = this.assistantsOpenAIClient.listMessages(conversation.getId(), limit, ListSortOrder.ASCENDING, null, null);
        return this.addConversationMessages(conversation, threadMessages.getData());
    }

    public ConversationResponse addConversationMessages(ConversationResponse conversation, List<ThreadMessage> threadMessages) {
        long latestTimestamp = this.populateConversationMessages(conversation, threadMessages);
        if (latestTimestamp != -1L && latestTimestamp > conversation.getTimestamp()) {
            conversation.setTimestamp(latestTimestamp);
            this.assistantsOpenAIClient.updateThread(conversation.getId(), new UpdateAssistantThreadOptions().setMetadata(Map.of(METADATA_UPDATED_AT, Long.toString(latestTimestamp))));
        }
        return conversation;
    }

    private long populateConversationMessages(ConversationResponse conversation, List<ThreadMessage> threadMessages) {
        long latestTimestamp = -1L;
        ArrayList<GptChatMessage> messages = new ArrayList<GptChatMessage>();
        for (ThreadMessage threadMessage : threadMessages) {
            List attachementList;
            List contentList = threadMessage.getContent();
            if (contentList == null || contentList.isEmpty()) continue;
            long timestamp = threadMessage.getCreatedAt().toEpochSecond();
            if (timestamp > latestTimestamp) {
                latestTimestamp = timestamp;
            }
            GptChatMessage messageResponse = new GptChatMessage();
            messageResponse.setAgentId(threadMessage.getAssistantId());
            MessageContent firstMessage = (MessageContent)contentList.get(0);
            if (firstMessage instanceof MessageTextContent) {
                MessageTextContent messageTextContent = (MessageTextContent)firstMessage;
                messageResponse.setMessage(messageTextContent.getText().getValue());
                List annotationsList = messageTextContent.getText().getAnnotations();
                if (!annotationsList.isEmpty()) {
                    this.logger.warn("Message contains annotations in {}///{}, ignoring {} annotations", new Object[]{threadMessage.getId(), threadMessage.getThreadId(), annotationsList.size()});
                }
            } else {
                this.logger.warn("Unsupported message type in {}///{}: {}", new Object[]{threadMessage.getId(), threadMessage.getThreadId(), firstMessage});
                messageResponse.setMessage("[Unsupported message type: " + firstMessage.getType() + "]");
            }
            if (contentList.size() > 1) {
                this.logger.warn("More than one content item in {}///{}, ignoring {} remaining items", new Object[]{threadMessage.getId(), threadMessage.getThreadId(), contentList.size() - 1});
            }
            if (!(attachementList = threadMessage.getAttachments()).isEmpty()) {
                this.logger.warn("Message contains attachments in {}///{}, ignoring {} attachments", new Object[]{threadMessage.getId(), threadMessage.getThreadId(), attachementList.size()});
            }
            messageResponse.setRole(threadMessage.getRole().toString());
            messageResponse.setConversationId(threadMessage.getThreadId());
            messageResponse.setTimestamp(threadMessage.getCreatedAt().toEpochSecond());
            messageResponse.setId(threadMessage.getId());
            messageResponse.setUsage(threadMessage.getMetadata().get(METADATA_USAGE) != null ? JSONUtil.parseJSON((String)threadMessage.getMetadata().get(METADATA_USAGE), Usage.class) : null);
            messages.add(messageResponse);
        }
        conversation.setMessages(messages);
        return latestTimestamp;
    }

    public ThreadMessage getMessage(AssistantThread thread, String messageId) {
        return this.assistantsOpenAIClient.getMessage(thread.getId(), messageId);
    }
}

