/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.chat.completions;

import com.ontotext.forest.core.Account;
import com.ontotext.forest.core.AccountsService;
import com.ontotext.forest.core.semantic.LLMUpdateProcessor;
import com.ontotext.forest.core.semantic.location.SemanticUpdateProcessor;
import com.ontotext.forest.gpt.chat.completions.AgentService;
import com.ontotext.forest.gpt.chat.completions.ConversationService;
import com.ontotext.forest.gpt.chat.completions.persistence.ConversationPersisted;
import com.ontotext.forest.gpt.ttyg.AgentConfig;
import com.ontotext.graphdb.raft.StateMachine;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LLMUpdateProcessorImpl
implements LLMUpdateProcessor {
    private static final Logger logger = LoggerFactory.getLogger(LLMUpdateProcessorImpl.class);
    private AgentService agentService;
    private ConversationService conversationService;
    private AccountsService accountsService;

    public LLMUpdateProcessorImpl(AgentService agentService, ConversationService conversationService, AccountsService accountsService) {
        this.agentService = agentService;
        this.conversationService = conversationService;
        this.accountsService = accountsService;
    }

    public String processAgentUpdate(DataInputStream configStream) throws IOException {
        String id = StateMachine.readString((DataInputStream)configStream);
        logger.info("Processing agent update with id: {}", (Object)id);
        String name = StateMachine.readString((DataInputStream)configStream);
        String model = StateMachine.readString((DataInputStream)configStream);
        String topP = StateMachine.readString((DataInputStream)configStream);
        String temperature = StateMachine.readString((DataInputStream)configStream);
        String contextSize = StateMachine.readString((DataInputStream)configStream);
        String fingerprint = StateMachine.readString((DataInputStream)configStream);
        Map metadata = (Map)SemanticUpdateProcessor.objectFromStream((DataInputStream)configStream);
        String instructions = StateMachine.readString((DataInputStream)configStream);
        AgentConfig agentConfig = new AgentConfig();
        agentConfig.setId(id);
        agentConfig.setName(name);
        agentConfig.setModel(model);
        agentConfig.setTopP(Double.parseDouble(topP));
        agentConfig.setTemperature(Double.parseDouble(temperature));
        agentConfig.setContextSize(Integer.parseInt(contextSize));
        agentConfig.setFingerprint(fingerprint);
        agentConfig.setFromMetadata(metadata);
        this.agentService.createOrUpdateLocalAgent(agentConfig, instructions);
        logger.info("Processing agent update with id => OK: {}", (Object)id);
        return id;
    }

    public String processAgentDelete(DataInputStream configStream) throws IOException {
        String id = StateMachine.readString((DataInputStream)configStream);
        logger.info("Processing agent delete with id: {}", (Object)id);
        this.agentService.deleteLocalAgent(id);
        logger.info("Processing agent delete with id => OK: {}", (Object)id);
        return id;
    }

    public String processConversationUpdate(DataInputStream configStream) throws IOException {
        String id = StateMachine.readString((DataInputStream)configStream);
        logger.info("Processing conversation update with id: {}", (Object)id);
        String name = StateMachine.readString((DataInputStream)configStream);
        String timestamp = StateMachine.readString((DataInputStream)configStream);
        String username = StateMachine.readString((DataInputStream)configStream);
        List responses = (List)SemanticUpdateProcessor.objectFromStream((DataInputStream)configStream);
        ConversationPersisted conversationPersisted = new ConversationPersisted();
        conversationPersisted.setId(id);
        conversationPersisted.setName(name);
        conversationPersisted.setTimestamp(Long.parseLong(timestamp));
        conversationPersisted.setConversationResponses(responses);
        conversationPersisted.setUsername(username);
        this.conversationService.updateLocalConversation(conversationPersisted, true);
        Account userAccount = this.accountsService.getAccountOrThrow(username).clonePasswordless();
        Set gptThreads = userAccount.getGptThreads();
        if (gptThreads == null) {
            userAccount.setGptThreads(Set.of(id));
        } else if (!gptThreads.contains(id)) {
            gptThreads.add(id);
            this.accountsService.editUserAccountInCluster(userAccount, false);
        }
        logger.info("Processing conversation update with id => OK: {}", (Object)id);
        return id;
    }

    public String processConversationDelete(DataInputStream configStream) throws IOException {
        String id = StateMachine.readString((DataInputStream)configStream);
        String username = StateMachine.readString((DataInputStream)configStream);
        logger.info("Processing conversation delete with id: {}", (Object)id);
        this.conversationService.deleteLocalConversation(id);
        Account userAccount = this.accountsService.getAccountOrThrow(username).clonePasswordless();
        Set userChatIds = userAccount.getGptThreads();
        if (userChatIds != null && userChatIds.contains(id)) {
            userChatIds.remove(id);
            userAccount.setGptThreads(userChatIds);
            this.accountsService.editUserAccountInCluster(userAccount, false);
        }
        logger.info("Processing conversation delete with id => OK: {}", (Object)id);
        return id;
    }
}

