/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.chat.completions;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.core.semantic.LLMUpdateProcessor;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocationManagement;
import com.ontotext.forest.gpt.chat.GptChat;
import com.ontotext.forest.gpt.chat.GptChatMessage;
import com.ontotext.forest.gpt.chat.completions.AgentService;
import com.ontotext.forest.gpt.chat.completions.Assistant;
import com.ontotext.forest.gpt.chat.completions.ConversationService;
import com.ontotext.forest.gpt.chat.completions.LLMUpdateProcessorImpl;
import com.ontotext.forest.gpt.chat.completions.LangchainToolExecutor;
import com.ontotext.forest.gpt.chat.completions.MemoryService;
import com.ontotext.forest.gpt.chat.completions.persistence.ConversationPersisted;
import com.ontotext.forest.gpt.chat.completions.persistence.ConversationResponsePersisted;
import com.ontotext.forest.gpt.chat.completions.persistence.ToolExecutionPersisted;
import com.ontotext.forest.gpt.conversations.ConversationResponse;
import com.ontotext.forest.gpt.conversations.Usage;
import com.ontotext.forest.gpt.model.AssistantsRequest;
import com.ontotext.forest.gpt.model.AssistantsResponse;
import com.ontotext.forest.gpt.ttyg.AgentConfig;
import com.ontotext.forest.gpt.ttyg.AgentInstructions;
import com.ontotext.forest.gpt.ttyg.JSONUtil;
import com.ontotext.forest.gpt.ttyg.tools.Tool;
import com.ontotext.forest.persistence.ConversationsPersistedConfig;
import com.ontotext.forest.persistence.PersistedConfig;
import com.ontotext.graphdb.gpt.explain.ExplainMessage;
import com.ontotext.graphdb.gpt.explain.ExplainRequestMessage;
import com.ontotext.graphdb.gpt.explain.ExplainResponseMessage;
import com.ontotext.graphdb.gpt.quota.QuotaUtils;
import dev.langchain4j.memory.ChatMemory;
import dev.langchain4j.model.openai.internal.chat.Role;
import dev.langchain4j.model.output.TokenUsage;
import dev.langchain4j.service.Result;
import dev.langchain4j.service.tool.ToolExecution;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GptCompletionsChat
extends GptChat {
    private static final Logger logger = LoggerFactory.getLogger(GptCompletionsChat.class);
    private final MemoryService memoryService;
    final AgentService agentService;
    final ConversationService conversationService;
    private LangchainToolExecutor toolExecutor;

    protected GptCompletionsChat(PersistedConfig persistedConfig, ConversationsPersistedConfig conversationsPersistedConfig, SemanticDataManagement dataManagement, SemanticLocationManagement locationManagement) {
        super(dataManagement);
        this.toolExecutor = new LangchainToolExecutor(this);
        this.conversationService = new ConversationService(conversationsPersistedConfig, dataManagement);
        this.memoryService = new MemoryService(this.conversationService);
        this.agentService = new AgentService(this.toolExecutor, this.memoryService, persistedConfig, dataManagement);
        locationManagement.setLLMProcessor((LLMUpdateProcessor)new LLMUpdateProcessorImpl(this.agentService, this.conversationService, locationManagement.getAccountsService()));
    }

    @VisibleForTesting
    protected GptCompletionsChat(ConversationService conversationService, AgentService agentService, SemanticDataManagement dataManagement) {
        super(dataManagement);
        this.conversationService = conversationService;
        this.memoryService = new MemoryService(conversationService);
        this.agentService = agentService;
        this.toolExecutor = new LangchainToolExecutor(this);
    }

    AgentConfig getAgentConfigForMemory(String memoryID) {
        String agentID = this.memoryService.getAgentForMemory(memoryID);
        if (agentID == null) {
            throw new IllegalArgumentException("No agent for memory: " + memoryID);
        }
        return this.agentService.getAgentConfig(agentID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ConversationResponse getConversationResponse(String threadId, String question, String assistantId, Integer tzOffset, AgentConfig agentConfig) {
        try (RepositoryConnection connection = this.getRepositoryConnection(agentConfig.getRepositoryId());){
            Assistant assistant = this.agentService.getAssistant(assistantId, connection);
            ConversationPersisted conversationPersisted = this.conversationService.getConversation(threadId);
            ChatMemory chatMemory = this.memoryService.getOrCreateMemory(threadId, agentConfig);
            synchronized (chatMemory) {
                ConversationResponse conversationResponse;
                try {
                    GptChatMessage questionMessage = GptCompletionsChat.createChatMessage(threadId, null, question, null, Role.USER);
                    Result<String> chatResponse = assistant.chat(threadId, question);
                    TokenUsage tokenUsage = chatResponse.tokenUsage();
                    if (tokenUsage != null) {
                        QuotaUtils.consumeTokens((long)tokenUsage.inputTokenCount().intValue(), (long)tokenUsage.outputTokenCount().intValue());
                    }
                    Usage usage = new Usage(tokenUsage.outputTokenCount().intValue(), tokenUsage.inputTokenCount().intValue(), tokenUsage.totalTokenCount().intValue());
                    ConversationResponse response = new ConversationResponse();
                    response.setId(threadId);
                    response.setName(conversationPersisted.getName());
                    GptChatMessage answerMessage = GptCompletionsChat.createChatMessage(threadId, assistantId, (String)chatResponse.content(), usage, Role.ASSISTANT);
                    response.setTimestamp(conversationPersisted.getTimestamp());
                    if (answerMessage.getTimestamp() > response.getTimestamp()) {
                        response.setTimestamp(answerMessage.getTimestamp());
                    }
                    response.setMessages(List.of(answerMessage));
                    response.setUsage(usage);
                    ConversationPersisted conversationPersistedUpdated = this.addMessageToConversation(conversationPersisted, List.of(questionMessage, answerMessage), chatResponse.toolExecutions());
                    this.conversationService.updateConversation(conversationPersistedUpdated);
                    conversationResponse = response;
                    this.memoryService.rebuildMemoryIfNeeded(threadId, agentConfig);
                }
                catch (Throwable throwable) {
                    this.memoryService.rebuildMemoryIfNeeded(threadId, agentConfig);
                    throw throwable;
                }
                return conversationResponse;
            }
        }
    }

    @NotNull
    private static GptChatMessage createChatMessage(String threadId, String assistantId, String message, Usage usage, Role role) {
        GptChatMessage gptChatMessage = new GptChatMessage();
        gptChatMessage.setAgentId(assistantId);
        gptChatMessage.setMessage(message);
        gptChatMessage.setConversationId(threadId);
        gptChatMessage.setUsage(usage);
        String messageID = "msg_" + String.valueOf(UUID.randomUUID());
        gptChatMessage.setId(messageID);
        gptChatMessage.setRole(role.name().toLowerCase());
        gptChatMessage.setTimestamp(System.currentTimeMillis() / 1000L);
        return gptChatMessage;
    }

    private ConversationPersisted addMessageToConversation(ConversationPersisted conversationPersisted, List<GptChatMessage> chatMessages, List<ToolExecution> toolExecutions) {
        GptChatMessage answer = chatMessages.stream().filter(m -> m.getRole().equalsIgnoreCase(Role.ASSISTANT.name())).findFirst().orElseThrow();
        String threadId = answer.getConversationId();
        ConversationResponsePersisted conversationResponsePersisted = new ConversationResponsePersisted();
        conversationResponsePersisted.setResponseID(threadId);
        conversationResponsePersisted.setAgentID(answer.getAgentId());
        conversationResponsePersisted.setMessages(chatMessages);
        conversationResponsePersisted.getToolExecutions().put(answer.getId(), toolExecutions.stream().map(this::toToolExecutionPersisted).toList());
        if (answer.getTimestamp() > conversationPersisted.getTimestamp()) {
            conversationPersisted.setTimestamp(answer.getTimestamp());
        }
        conversationPersisted.getConversationResponses().add(conversationResponsePersisted);
        return conversationPersisted;
    }

    private ToolExecutionPersisted toToolExecutionPersisted(ToolExecution toolExecution) {
        ToolExecutionPersisted toolExecutionPersisted = new ToolExecutionPersisted();
        toolExecutionPersisted.setRequestID(toolExecution.request().id());
        toolExecutionPersisted.setResult(toolExecution.result());
        toolExecutionPersisted.setRequestArguments(toolExecution.request().arguments());
        toolExecutionPersisted.setRequestName(toolExecution.request().name());
        return toolExecutionPersisted;
    }

    @Override
    protected void editAgentFingerprint(AgentConfig newAgentConfig, RepositoryConnection connection) {
        this.agentService.updateAgent(newAgentConfig, connection);
    }

    @Override
    public ConversationResponse continueChat(String threadId, String runId, String agentId, Integer tzOffset) {
        throw new UnsupportedOperationException("Not implemented yet");
    }

    @Override
    public GptChatMessage createConversation() {
        String id = this.conversationService.createConversation().getId();
        GptChatMessage message = new GptChatMessage();
        message.setConversationId(id);
        return message;
    }

    @Override
    public ConversationResponse renameConversation(String threadId, String name) {
        this.conversationService.renameConversation(threadId, name);
        return this.fromConversationPersisted(this.conversationService.getConversation(threadId));
    }

    private ConversationResponse fromConversationPersisted(ConversationPersisted conversationPersisted) {
        ConversationResponse conversationResponse = new ConversationResponse();
        conversationResponse.setId(conversationPersisted.getId());
        conversationResponse.setName(conversationPersisted.getName());
        conversationResponse.setTimestamp(conversationPersisted.getTimestamp());
        conversationPersisted.getConversationResponses().forEach(crp -> conversationResponse.getMessages().addAll(crp.getMessages()));
        return conversationResponse;
    }

    @Override
    public ConversationResponse getConversation(String threadId) {
        return this.fromConversationPersisted(this.conversationService.getConversation(threadId));
    }

    @Override
    public List<ConversationResponse> getConversations(Set<String> conversationsIDs, Consumer<String> onChatNotFound) {
        return this.conversationService.getConversationsWithoutMessages(conversationsIDs, onChatNotFound).stream().map(this::fromConversationPersisted).toList();
    }

    @Override
    public ConversationResponse deleteConversation(String id) {
        this.memoryService.removeConversationMemory(id);
        return this.fromConversationPersisted(this.conversationService.deleteConversation(id));
    }

    @Override
    public ExplainResponseMessage explainResponse(ExplainRequestMessage explainRequestMessage) {
        ExplainResponseMessage response = new ExplainResponseMessage();
        String answerId = explainRequestMessage.getAnswerId();
        ConversationPersisted conversationPersisted = this.conversationService.getConversation(explainRequestMessage.getConversationId());
        if (conversationPersisted == null) {
            throw new IllegalArgumentException("No such conversation:" + explainRequestMessage.getConversationId());
        }
        try {
            ConversationResponsePersisted conversationResponsePersisted = conversationPersisted.getConversationResponses().stream().filter(crp -> crp.getMessages().stream().map(GptChatMessage::getId).collect(Collectors.toSet()).contains(answerId)).findFirst().orElseThrow();
            logger.debug("TTYG explain: {}", (Object)answerId);
            List<ToolExecutionPersisted> toolExecutions = conversationResponsePersisted.getToolExecutions().get(answerId);
            if (toolExecutions != null) {
                List<ExplainMessage> explainMessages = toolExecutions.stream().map(toolExecution -> this.fromToolExecution((ToolExecutionPersisted)toolExecution, this.agentService.getAgentConfig(conversationResponsePersisted.getAgentID()))).toList();
                response.setQueryMethods(explainMessages);
            }
            response.setAnswerId(answerId);
            response.setConversationId(explainRequestMessage.getConversationId());
            logger.debug("TTYG explain: {}///{} => OK", (Object)answerId, (Object)explainRequestMessage.getConversationId());
            return response;
        }
        catch (NoSuchElementException nse) {
            throw new IllegalArgumentException("No such answer:" + answerId);
        }
    }

    private ExplainMessage fromToolExecution(ToolExecutionPersisted toolExecution, AgentConfig agentConfig) {
        String toolName = toolExecution.getRequestName();
        Tool tool = this.getToolForExplain(agentConfig, toolName);
        String errorOutput = this.getErrorOutput(toolExecution.getResult());
        Map<String, Object> parameters = JSONUtil.parseJSON(toolExecution.getRequestArguments());
        return new ExplainMessage(toolName, tool.getRawQuery(parameters), tool.getNativeQuery(parameters), tool.getType().getNativeQueryType(), errorOutput);
    }

    @Override
    public ConversationResponse exportChat(String id) {
        logger.debug("TTYG exportChat: {}", (Object)id);
        ConversationPersisted result = this.conversationService.getConversation(id);
        logger.debug("TTYG exportChat: {} => OK", (Object)id);
        return this.fromConversationPersisted(result);
    }

    @Override
    public AssistantsResponse createAgent(AssistantsRequest request) {
        try (RepositoryConnection connection = this.getRepositoryConnection(request.getRepositoryId());){
            logger.debug("TTYG createAgent: {} ({})", (Object)request.getName(), (Object)request.getRepositoryId());
            request.setId(UUID.randomUUID().toString());
            AgentConfig agentConfig = this.agentConfigFromRequest(request, connection, AgentConfig::new);
            this.agentService.createAgent(agentConfig, connection);
            logger.debug("TTYG createAgent: {} ({}) => {}", new Object[]{request.getName(), request.getRepositoryId(), request.getId()});
            AssistantsResponse assistantsResponse = this.assistantsResponseFromAgentConfig(agentConfig);
            return assistantsResponse;
        }
    }

    @Override
    public AssistantsResponse editAgent(AssistantsRequest request) {
        try (RepositoryConnection connection = this.getRepositoryConnection(request.getRepositoryId());){
            logger.debug("TTYG editAgent {}: {} ({})", new Object[]{request.getId(), request.getName(), request.getRepositoryId()});
            AgentConfig agentConfig = this.agentConfigFromRequest(request, connection, AgentConfig::new);
            this.agentService.updateAgent(agentConfig, connection);
            logger.debug("TTYG editAgent {}: {} ({}) => OK", new Object[]{request.getId(), request.getName(), request.getRepositoryId()});
            AssistantsResponse assistantsResponse = this.assistantsResponseFromAgentConfig(agentConfig);
            return assistantsResponse;
        }
    }

    @Override
    public void deleteAgent(String agentId) {
        logger.debug("TTYG deleteAgent {}", (Object)agentId);
        this.agentService.deleteAgentWithReplication(agentId);
        logger.debug("TTYG deleteAgent {} => OK", (Object)agentId);
    }

    @Override
    public List<AssistantsResponse> getAllAgents() {
        logger.debug("TTYG getAgents");
        List<AssistantsResponse> agents = this.agentService.getAgentConfigs().stream().map(x$0 -> this.assistantsResponseFromAgentConfig((AgentConfig)x$0)).toList();
        logger.debug("TTYG getAgents => OK");
        return agents;
    }

    @Override
    public AssistantsResponse getAgent(String agentId) {
        logger.debug("TTYG getAgent: {}", (Object)agentId);
        AssistantsResponse assistantsResponse = this.assistantsResponseFromAgentConfig(this.agentService.getAgentConfig(agentId));
        logger.debug("TTYG getAgent: {} => OK", (Object)agentId);
        return assistantsResponse;
    }

    @Override
    public AgentConfig getAgentConfig(String agentId) {
        return this.agentService.getAgentConfig(agentId);
    }

    @Override
    public AgentInstructions explainAgentInstructions(AssistantsRequest request) {
        try (RepositoryConnection connection = this.getRepositoryConnection(request.getRepositoryId());){
            logger.debug("TTYG explainAgentInstructions {}: {} ({})", new Object[]{request.getId(), request.getName(), request.getRepositoryId()});
            AgentInstructions instructions = this.agentConfigFromRequest(request, connection, AgentConfig::new).toAgentInstructions(connection);
            logger.debug("TTYG explainAgentInstructions {}: {} ({}) => OK", new Object[]{request.getId(), request.getName(), request.getRepositoryId()});
            AgentInstructions agentInstructions = instructions;
            return agentInstructions;
        }
    }
}

