/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.chat.completions;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.gpt.ConversationDeleteSystemUpdate;
import com.ontotext.forest.gpt.ConversationSystemUpdate;
import com.ontotext.forest.gpt.chat.completions.ClusterValidationService;
import com.ontotext.forest.gpt.chat.completions.persistence.ConversationPersisted;
import com.ontotext.forest.gpt.chat.completions.persistence.ConversationResponsePersisted;
import com.ontotext.forest.gpt.ttyg.exceptions.NonExistentResourceRequested;
import com.ontotext.forest.persistence.ConversationsPersistedConfig;
import com.ontotext.graphdb.GraphDBHTTPContext;
import com.ontotext.graphdb.configs.SystemConfig;
import com.ontotext.raft.GraphDBReplicationCluster;
import com.ontotext.raft.update.SystemUpdate;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConversationService
implements ClusterValidationService {
    private static final Logger logger = LoggerFactory.getLogger(ConversationService.class);
    public static final String THREAD_PREFIX = "thread_gdb_";
    private final String CONVERSATIONS_DB_KEY = "conversations";
    public static String UNNAMED_CHAT_NAME = "[Unnamed chat]";
    private ConversationsPersistedConfig persistedConfig;
    private SemanticDataManagement dataManagement;
    private final Cache<String, ConversationPersisted> conversationsPersistedCache = CacheBuilder.newBuilder().concurrencyLevel(4).maximumSize(1000L).expireAfterWrite(60L, TimeUnit.MINUTES).build();

    public ConversationService(ConversationsPersistedConfig conversationsPersistedConfig, SemanticDataManagement dataManagement) {
        this.persistedConfig = conversationsPersistedConfig;
        this.dataManagement = dataManagement;
    }

    public ConversationPersisted createConversation() {
        logger.debug("TTYG createConversation");
        ConversationPersisted conversationPersisted = new ConversationPersisted();
        conversationPersisted.setUsername(GraphDBHTTPContext.getAuthenticatedUser().getUsername());
        conversationPersisted.setName(UNNAMED_CHAT_NAME);
        conversationPersisted.setId(THREAD_PREFIX + String.valueOf(UUID.randomUUID()));
        conversationPersisted.setTimestamp(System.currentTimeMillis() / 1000L);
        this.updateConversationWithReplication(conversationPersisted, null, false);
        logger.debug("TTYG createConversation => {}", (Object)conversationPersisted.getId());
        return conversationPersisted;
    }

    public void updateConversation(ConversationPersisted newConversation) {
        logger.debug("TTYG updateConversation: {}", (Object)newConversation.getId());
        ConversationPersisted existingConversation = this.getConversationPersisted(newConversation.getId());
        if (existingConversation == null) {
            throw new IllegalArgumentException("No such conversation:" + newConversation.getId());
        }
        this.updateConversationWithReplication(newConversation, existingConversation, true);
        logger.debug("TTYG updateConversation: {} => OK", (Object)newConversation.getId());
    }

    private void updateConversationWithReplication(ConversationPersisted newConversation, ConversationPersisted existingConversation, boolean limitMessages) {
        GraphDBReplicationCluster replicationCluster = this.dataManagement.getCurrentLocationOrThrow().getReplicationCluster();
        if (replicationCluster != null) {
            boolean isSuccessfulReplication;
            this.validateLeadership(replicationCluster);
            this.updateLocalConversation(newConversation, limitMessages);
            boolean bl = isSuccessfulReplication = replicationCluster.replicateSystemUpdate((SystemUpdate)new ConversationSystemUpdate(newConversation), "LLM") >= 1L;
            if (!isSuccessfulReplication) {
                logger.error("Failed to replicate conversation update for ID: {}", (Object)newConversation.getId());
                if (existingConversation != null) {
                    this.updateLocalConversation(existingConversation, limitMessages);
                } else {
                    this.deleteLocalConversation(newConversation.getId());
                }
                throw new IllegalStateException("Failed to replicate conversation update for ID: " + newConversation.getId());
            }
        } else {
            this.updateLocalConversation(newConversation, limitMessages);
        }
    }

    protected void updateLocalConversation(ConversationPersisted conversationPersisted, boolean limitMessages) {
        this.persistedConfig.updateMapEntry("conversations", ConversationPersisted.class, conversationPersisted.getId(), (Object)conversationPersisted);
        if (limitMessages) {
            this.limitMessages(conversationPersisted);
        }
        this.conversationsPersistedCache.put((Object)conversationPersisted.getId(), (Object)conversationPersisted);
    }

    protected void deleteLocalConversation(String id) {
        this.persistedConfig.deleteMapEntry("conversations", ConversationPersisted.class, id);
        this.conversationsPersistedCache.invalidate((Object)id);
    }

    private void limitMessages(ConversationPersisted newConversation) {
        int size = newConversation.getConversationResponses().size();
        ArrayList<ConversationResponsePersisted> conversationResponses = new ArrayList<ConversationResponsePersisted>(newConversation.getConversationResponses().subList(Math.max(0, size - SystemConfig.getMessageLimit()), size));
        newConversation.setConversationResponses(conversationResponses);
    }

    private ConversationPersisted getConversationPersisted(String threadId) {
        ConversationPersisted conversationPersisted = (ConversationPersisted)this.conversationsPersistedCache.getIfPresent((Object)threadId);
        if (conversationPersisted == null && (conversationPersisted = (ConversationPersisted)this.persistedConfig.getMap("conversations", ConversationPersisted.class).get(threadId)) != null) {
            this.limitMessages(conversationPersisted);
        }
        return conversationPersisted;
    }

    public ConversationPersisted deleteConversation(String id) {
        logger.debug("TTYG deleteConversation: {}", (Object)id);
        ConversationPersisted existingConversation = this.getConversationPersisted(id);
        if (existingConversation == null) {
            throw new IllegalArgumentException("No such conversation:" + id);
        }
        GraphDBReplicationCluster replicationCluster = this.dataManagement.getCurrentLocationOrThrow().getReplicationCluster();
        if (replicationCluster != null) {
            boolean isSuccessfulReplication;
            this.validateLeadership(replicationCluster);
            this.deleteLocalConversation(id);
            boolean bl = isSuccessfulReplication = replicationCluster.replicateSystemUpdate((SystemUpdate)new ConversationDeleteSystemUpdate(id, existingConversation.getUsername()), "LLM") >= 1L;
            if (!isSuccessfulReplication) {
                logger.error("Failed to replicate conversation delete for ID: {}", (Object)id);
                this.updateLocalConversation(existingConversation, false);
                throw new IllegalStateException("Failed to replicate conversation update for ID: " + id);
            }
        } else {
            this.deleteLocalConversation(id);
        }
        logger.debug("TTYG deleteConversation: {} => OK", (Object)id);
        return existingConversation;
    }

    public ConversationPersisted getConversation(String threadId) {
        logger.debug("TTYG getConversation: {}", (Object)threadId);
        ConversationPersisted conversationPersisted = this.getConversationPersisted(threadId);
        if (conversationPersisted == null) {
            throw new IllegalArgumentException("No such conversation:" + threadId);
        }
        if (!GraphDBHTTPContext.getAuthenticatedUser().getUsername().equals(conversationPersisted.getUsername())) {
            throw new NonExistentResourceRequested("Conversation not matching the requesting user");
        }
        logger.debug("TTYG getConversation: {} => OK", (Object)threadId);
        return conversationPersisted;
    }

    public void renameConversation(String threadId, String name) {
        logger.debug("TTYG renameConversation {}: {}", (Object)threadId, (Object)name);
        ConversationPersisted existingConversation = this.getConversationPersisted(threadId);
        if (existingConversation == null) {
            throw new IllegalArgumentException("No such conversation:" + threadId);
        }
        ConversationPersisted newConversation = new ConversationPersisted();
        newConversation.setId(existingConversation.getId());
        newConversation.setUsername(existingConversation.getUsername());
        newConversation.setTimestamp(existingConversation.getTimestamp());
        newConversation.setName(name);
        newConversation.setConversationResponses(existingConversation.getConversationResponses());
        this.updateConversationWithReplication(newConversation, existingConversation, false);
        logger.debug("TTYG renameConversation {}: {} => OK", (Object)threadId, (Object)name);
    }

    public List<ConversationPersisted> getConversationsWithoutMessages(Set<String> conversationsIDs, Consumer<String> onChatNotFound) {
        logger.debug("TTYG getConversations: {} (size)", (Object)conversationsIDs.size());
        ArrayList<ConversationPersisted> conversations = new ArrayList<ConversationPersisted>(conversationsIDs.size());
        for (String id : conversationsIDs) {
            try {
                ConversationPersisted conversationPersisted = this.getConversation(id);
                conversations.add(new ConversationPersisted(conversationPersisted.getId(), conversationPersisted.getName(), conversationPersisted.getTimestamp(), conversationPersisted.getUsername()));
            }
            catch (IllegalArgumentException e) {
                if (!id.startsWith(THREAD_PREFIX)) continue;
                logger.warn("List conversations: Conversation not found: {}", (Object)id);
                onChatNotFound.accept(id);
            }
            catch (NonExistentResourceRequested e) {
                logger.debug("Conversation not matching the requesting user: {}", (Object)e.getMessage());
            }
        }
        logger.debug("TTYG getConversations: {} (size) => {}", (Object)conversationsIDs.size(), (Object)conversations.size());
        return conversations;
    }
}

