/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt.chat.completions;

import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.gpt.AgentDeleteSystemUpdate;
import com.ontotext.forest.gpt.AgentSystemUpdate;
import com.ontotext.forest.gpt.chat.completions.Assistant;
import com.ontotext.forest.gpt.chat.completions.ClusterValidationService;
import com.ontotext.forest.gpt.chat.completions.LangchainToolExecutor;
import com.ontotext.forest.gpt.chat.completions.MemoryService;
import com.ontotext.forest.gpt.chat.completions.persistence.AgentConfigPersisted;
import com.ontotext.forest.gpt.ttyg.AgentConfig;
import com.ontotext.forest.gpt.ttyg.tools.Tool;
import com.ontotext.forest.persistence.PersistedConfig;
import com.ontotext.graphdb.gpt.ChatModelFactory;
import com.ontotext.raft.GraphDBReplicationCluster;
import com.ontotext.raft.update.SystemUpdate;
import dev.langchain4j.memory.chat.ChatMemoryProvider;
import dev.langchain4j.model.chat.ChatModel;
import dev.langchain4j.service.AiServices;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentService
implements ClusterValidationService {
    private static final Logger logger = LoggerFactory.getLogger(AgentService.class);
    private final LangchainToolExecutor toolExecutor;
    private PersistedConfig persistedConfig;
    private SemanticDataManagement dataManagement;
    protected final String AGENTS_DB_KEY = "agents";
    private final MemoryService memoryService;
    final Map<String, Assistant> assistants = new HashMap<String, Assistant>();

    public AgentService(LangchainToolExecutor langchainToolExecutor, MemoryService memoryService, PersistedConfig persistedConfig, SemanticDataManagement dataManagement) {
        this.toolExecutor = langchainToolExecutor;
        this.memoryService = memoryService;
        this.persistedConfig = persistedConfig;
        this.dataManagement = dataManagement;
    }

    public Assistant getAssistant(String assistantId, RepositoryConnection connection) {
        if (!this.assistants.containsKey(assistantId)) {
            AgentConfigPersisted agentConfigPersisted = this.getAgentConfigPersisted(assistantId);
            if (agentConfigPersisted == null) {
                throw new IllegalArgumentException("Agent with ID " + assistantId + " does not exist");
            }
            AgentConfig agentConfig = this.agentConfigFromPersisted(agentConfigPersisted);
            this.createAssistant(agentConfig, agentConfig.toAssistantInstructions(connection));
        }
        return this.assistants.get(assistantId);
    }

    private AgentConfigPersisted getAgentConfigPersisted(String agentID) {
        return (AgentConfigPersisted)this.persistedConfig.getMap("agents", AgentConfigPersisted.class).get(agentID);
    }

    public void createAgent(AgentConfig agentConfig, RepositoryConnection connection) {
        if (this.getAgentConfigPersisted(agentConfig.getId()) != null) {
            throw new IllegalArgumentException("Agent with ID " + agentConfig.getId() + " already exists");
        }
        this.createAgentWithReplication(agentConfig, connection);
    }

    public void updateAgent(AgentConfig agentConfig, RepositoryConnection connection) {
        if (this.getAgentConfigPersisted(agentConfig.getId()) == null) {
            throw new IllegalArgumentException("Agent with ID " + agentConfig.getId() + " does not exist");
        }
        this.updateAgentWithReplication(agentConfig, connection);
    }

    private void createAgentWithReplication(AgentConfig agentConfig, RepositoryConnection connection) {
        GraphDBReplicationCluster replicationCluster = this.dataManagement.getCurrentLocationOrThrow().getReplicationCluster();
        String instructions = agentConfig.toAssistantInstructions(connection);
        if (replicationCluster != null) {
            boolean isSuccessfulReplication;
            this.validateLeadership(replicationCluster);
            this.createOrUpdateLocalAgent(agentConfig, instructions);
            boolean bl = isSuccessfulReplication = replicationCluster.replicateSystemUpdate((SystemUpdate)new AgentSystemUpdate(agentConfig, instructions), "LLM") >= 1L;
            if (!isSuccessfulReplication) {
                logger.error("Failed to replicate agent create for agent ID: {}", (Object)agentConfig.getId());
                this.deleteLocalAgent(agentConfig.getId());
                throw new IllegalStateException("Failed to replicate agent create for agent ID: " + agentConfig.getId());
            }
        } else {
            this.createOrUpdateLocalAgent(agentConfig, instructions);
        }
    }

    private void updateAgentWithReplication(AgentConfig newAgentConfig, RepositoryConnection connection) {
        GraphDBReplicationCluster replicationCluster = this.dataManagement.getCurrentLocationOrThrow().getReplicationCluster();
        AgentConfig saveAgentConfig = this.getAgentConfig(newAgentConfig.getId());
        String instructions = newAgentConfig.toAssistantInstructions(connection);
        if (replicationCluster != null) {
            boolean isSuccessFulReplication;
            this.validateLeadership(replicationCluster);
            this.createOrUpdateLocalAgent(newAgentConfig, instructions);
            boolean bl = isSuccessFulReplication = replicationCluster.replicateSystemUpdate((SystemUpdate)new AgentSystemUpdate(newAgentConfig, instructions), "LLM") >= 1L;
            if (!isSuccessFulReplication) {
                logger.error("Failed to replicate agent update for agent ID: {}", (Object)newAgentConfig.getId());
                this.createOrUpdateLocalAgent(saveAgentConfig, saveAgentConfig.toAssistantInstructions(connection));
                throw new IllegalStateException("Failed to replicate agent update for agent ID: " + newAgentConfig.getId());
            }
        } else {
            this.createOrUpdateLocalAgent(newAgentConfig, instructions);
        }
    }

    public void createOrUpdateLocalAgent(AgentConfig agentConfig, String instructions) {
        this.createAssistant(agentConfig, instructions);
        this.persistedConfig.updateMapEntry("agents", AgentConfigPersisted.class, agentConfig.getId(), (Object)this.persistedConfigFromAgentConfig(agentConfig));
    }

    private void createAssistant(AgentConfig agentConfig, String systemInstructions) {
        ChatModel chatModel = ChatModelFactory.createChatModel((String)agentConfig.getModel(), (double)agentConfig.getTemperature(), (double)agentConfig.getTopP());
        HashMap toolExecutorMap = new HashMap();
        agentConfig.getTools().entrySet().stream().filter(e -> ((Tool)e.getValue()).isEnabled()).forEach(e -> toolExecutorMap.put(((Tool)e.getValue()).toToolSpecification(), this.toolExecutor));
        Assistant assistant = (Assistant)AiServices.builder(Assistant.class).chatModel(chatModel).systemMessageProvider(o -> systemInstructions).tools(toolExecutorMap).chatMemoryProvider((ChatMemoryProvider)this.memoryService).build();
        this.assistants.put(agentConfig.getId(), assistant);
    }

    public AgentConfig getAgentConfig(String agentId) {
        AgentConfigPersisted existingAgentConfig = this.getAgentConfigPersisted(agentId);
        if (existingAgentConfig == null) {
            throw new IllegalArgumentException("Agent with ID " + agentId + " does not exist");
        }
        return this.agentConfigFromPersisted(existingAgentConfig);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void deleteAgentWithReplication(String agentId) {
        boolean isSuccessful;
        AgentConfigPersisted existingAgentConfig = this.getAgentConfigPersisted(agentId);
        if (existingAgentConfig == null) {
            throw new IllegalArgumentException("Agent with ID " + agentId + " does not exist");
        }
        GraphDBReplicationCluster replicationCluster = this.dataManagement.getCurrentLocationOrThrow().getReplicationCluster();
        if (replicationCluster == null) {
            this.deleteLocalAgent(agentId);
            return;
        }
        this.validateLeadership(replicationCluster);
        boolean bl = isSuccessful = replicationCluster.replicateSystemUpdate((SystemUpdate)new AgentDeleteSystemUpdate(agentId), "LLM") >= 1L;
        if (isSuccessful) {
            this.deleteLocalAgent(agentId);
            return;
        }
        logger.error("Failed to replicate agent delete");
        throw new IllegalStateException("Failed to replicate agent delete for agent ID: " + agentId);
    }

    public void deleteLocalAgent(String agentId) {
        this.assistants.remove(agentId);
        this.memoryService.removeAgentMemory(agentId);
        this.persistedConfig.deleteMapEntry("agents", AgentConfigPersisted.class, agentId);
    }

    public List<AgentConfig> getAgentConfigs() {
        Map persistedAgentConfig = this.persistedConfig.getMap("agents", AgentConfigPersisted.class);
        if (persistedAgentConfig == null) {
            return new LinkedList<AgentConfig>();
        }
        return persistedAgentConfig.values().stream().map(this::agentConfigFromPersisted).toList();
    }

    private AgentConfig agentConfigFromPersisted(AgentConfigPersisted persisted) {
        AgentConfig agentConfig = new AgentConfig();
        agentConfig.setId(persisted.getId());
        agentConfig.setName(persisted.getName());
        agentConfig.setModel(persisted.getModel());
        agentConfig.setTemperature(persisted.getTemperature());
        agentConfig.setTopP(persisted.getTopP());
        agentConfig.setContextSize(persisted.getContextSize());
        agentConfig.setFromMetadata(persisted.getMetadata());
        return agentConfig;
    }

    private AgentConfigPersisted persistedConfigFromAgentConfig(AgentConfig agentConfig) {
        AgentConfigPersisted agentConfigPersisted = new AgentConfigPersisted();
        agentConfigPersisted.setId(agentConfig.getId());
        agentConfigPersisted.setTemperature(agentConfig.getTemperature());
        agentConfigPersisted.setModel(agentConfig.getModel());
        agentConfigPersisted.setTopP(agentConfig.getTopP());
        agentConfigPersisted.setContextSize(agentConfig.getContextSize());
        agentConfigPersisted.setName(agentConfig.getName());
        agentConfigPersisted.setMetadata(agentConfig.toMetadata());
        return agentConfigPersisted;
    }
}

