/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.gpt;

import com.azure.core.exception.ResourceNotFoundException;
import com.ontotext.forest.core.Account;
import com.ontotext.forest.core.AccountsService;
import com.ontotext.forest.gpt.chat.GptChat;
import com.ontotext.forest.gpt.chat.GptChatMessage;
import com.ontotext.forest.gpt.chat.completions.GptChatInstanceHolder;
import com.ontotext.forest.gpt.conversations.ConversationResponse;
import com.ontotext.forest.gpt.model.AssistantsRequest;
import com.ontotext.forest.gpt.model.AssistantsRequestDefaultValues;
import com.ontotext.forest.gpt.model.AssistantsResponse;
import com.ontotext.forest.gpt.ttyg.AgentConfig;
import com.ontotext.forest.gpt.ttyg.AgentInstructions;
import com.ontotext.forest.gpt.ttyg.exceptions.NonExistentResourceRequested;
import com.ontotext.forest.gpt.ttyg.tools.ToolType;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.GraphDBHTTPContext;
import com.ontotext.graphdb.configs.LLMConfig;
import com.ontotext.graphdb.configs.SystemConfig;
import com.ontotext.graphdb.gpt.explain.ExplainRequestMessage;
import com.ontotext.graphdb.gpt.explain.ExplainResponseMessage;
import com.ontotext.trree.statistics.SystemStatisticsCollector;
import jakarta.annotation.PostConstruct;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GptChatService {
    private final Logger LOGGER = LoggerFactory.getLogger(GptChatService.class);
    private AccountsService accountsService;
    private GptChatInstanceHolder gptChatInstanceHolder;

    @Autowired
    public GptChatService(AccountsService accountsService, GptChatInstanceHolder chatDelegate) {
        this.accountsService = accountsService;
        this.gptChatInstanceHolder = chatDelegate;
    }

    GptChatService() {
    }

    @PostConstruct
    public void init() {
        String api = Config.getProperty((String)"graphdb.llm.api");
        String url = LLMConfig.getLLMUrl();
        try {
            if (api != null) {
                LLMConfig.getLLMApiKeyOrThrow();
            }
            if (api != null && SystemConfig.getDefaultLlmModel((String)api) == null) {
                throw new IllegalStateException(String.format("The configured %s API requires LLM model to be provided. Set the config property %s to configure LLM model.", api, "graphdb.llm.model"));
            }
            if (url != null) {
                new URL(url);
            }
        }
        catch (MalformedURLException e) {
            String message = String.format("'%s' is not a valid URL.", url);
            this.LOGGER.error(message);
            throw new IllegalArgumentException(message, e);
        }
        catch (IllegalStateException e) {
            this.LOGGER.error(e.getMessage());
            throw e;
        }
        SystemStatisticsCollector.getInstance().setTtygConversationsUpdater(this::setPersistentConversationsCount);
    }

    public GptChat getGptChatInstance() {
        return this.gptChatInstanceHolder.getGPTChatInstance();
    }

    public ConversationResponse chat(String conversationId, String question, String agentId, Integer tzOffset) {
        return this.getGptChatInstance().chat(conversationId, question, agentId, tzOffset);
    }

    public ConversationResponse continueChat(String conversationId, String runId, String agentId, Integer tzOffset) {
        return this.getGptChatInstance().continueChat(conversationId, runId, agentId, tzOffset);
    }

    public GptChatMessage createConversation() {
        GptChatMessage conversation = this.getGptChatInstance().createConversation();
        this.addChatIdToAccount(conversation.getConversationId());
        return conversation;
    }

    public ConversationResponse renameConversation(String id, String name) {
        return this.getGptChatInstance().renameConversation(id, name);
    }

    public ConversationResponse getConversation(String id) {
        return this.getGptChatInstance().getConversation(id);
    }

    public List<ConversationResponse> getConversations() {
        Set conversations;
        List<ConversationResponse> conversationResponseList = List.of();
        Account account = this.accountsService.getAccount(GraphDBHTTPContext.getAuthenticatedUser().getUsername());
        if (account != null && (conversations = account.getGptThreads()) != null && !conversations.isEmpty()) {
            HashSet<String> deletedChatIds = new HashSet<String>();
            conversationResponseList = this.getGptChatInstance().getConversations(conversations, deletedChatIds::add);
            this.removeChatIdsFromAccount(deletedChatIds);
        }
        return conversationResponseList;
    }

    public ConversationResponse deleteConversation(String id) {
        ConversationResponse response = this.getGptChatInstance().deleteConversation(id);
        this.removeChatIdsFromAccount(Set.of(id));
        return response;
    }

    public ExplainResponseMessage explainResponse(ExplainRequestMessage explainRequestMessage) {
        return this.getGptChatInstance().explainResponse(explainRequestMessage);
    }

    public ConversationResponse exportChat(String id) {
        return this.getGptChatInstance().exportChat(id);
    }

    public String generateConversationName(String message) {
        return message.length() > 40 ? message.substring(0, 40) + "..." : message;
    }

    public AssistantsResponse createAgent(AssistantsRequest assistantsRequest) {
        return this.getGptChatInstance().createAgent(assistantsRequest);
    }

    public AssistantsResponse editAgent(AssistantsRequest assistantsRequest) {
        return this.getGptChatInstance().editAgent(assistantsRequest);
    }

    public AgentInstructions explainAgentInstructions(AssistantsRequest assistantsRequest) {
        return this.getGptChatInstance().explainAgentInstructions(assistantsRequest);
    }

    public void deleteAgent(String agentId) {
        this.getGptChatInstance().deleteAgent(agentId);
    }

    public List<AssistantsResponse> getAllAgents() {
        return this.getGptChatInstance().getAllAgents();
    }

    public AssistantsResponse getAgent(String agentId) {
        return this.getGptChatInstance().getAgent(agentId);
    }

    public AssistantsRequestDefaultValues getDefaultAgent() {
        return this.getGptChatInstance().getDefaultAgent();
    }

    public String callTool(String agentId, ToolType toolType, String arguments) {
        AgentConfig agentConfig = this.getGptChatInstance().getAgentConfig(agentId);
        return this.getGptChatInstance().callTool(toolType.getToolName(), arguments, agentConfig, null);
    }

    private synchronized void addChatIdToAccount(String addedId) {
        String username = GraphDBHTTPContext.getAuthenticatedUser().getUsername();
        Account currAccount = this.accountsService.getAccountOrThrow(username).clonePasswordless();
        Set userChatIds = currAccount.getGptThreads();
        if (userChatIds == null) {
            currAccount.setGptThreads(Set.of(addedId));
        } else {
            userChatIds.add(addedId);
        }
        this.accountsService.editUserAccount(currAccount, false);
    }

    private synchronized void removeChatIdsFromAccount(Set<String> deleteIds) {
        String username = GraphDBHTTPContext.getAuthenticatedUser().getUsername();
        Account currAccount = this.accountsService.getAccountOrThrow(username).clonePasswordless();
        Set userChatIds = currAccount.getGptThreads();
        if (userChatIds != null) {
            HashSet newUserChatIds = new HashSet(userChatIds);
            newUserChatIds.removeAll(deleteIds);
            if (newUserChatIds.size() < userChatIds.size()) {
                currAccount.setGptThreads(newUserChatIds);
                this.accountsService.editUserAccount(currAccount, false);
            }
        }
    }

    void setPersistentConversationsCount(AtomicLong ttygConversations) {
        String api = Config.getProperty((String)"graphdb.llm.api");
        if (LLMConfig.getApiKeyOrNull() != null || "openai-completions-http1.1".equalsIgnoreCase(api)) {
            try {
                ttygConversations.set(this.getPersistedGptThreadsCount());
            }
            catch (ResourceNotFoundException | NonExistentResourceRequested throwable) {
                // empty catch block
            }
        }
    }

    int getPersistedGptThreadsCount() {
        Collection accounts = this.accountsService.getAll();
        if (accounts == null || accounts.isEmpty()) {
            return 0;
        }
        int threadsCount = 0;
        for (Account account : accounts) {
            if (account == null || account.getGptThreads() == null) continue;
            threadsCount += account.getGptThreads().size();
        }
        return threadsCount;
    }
}

