/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.query;

import com.ontotext.models.Operation;
import com.ontotext.models.OperationValidator;
import com.ontotext.models.Selectable;
import com.ontotext.models.Selection;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.ValidationContext;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.QueryValidationMessage;
import com.ontotext.models.mutation.CreateMutation;
import com.ontotext.models.mutation.DeleteMutation;
import com.ontotext.models.mutation.UpdateMutation;
import com.ontotext.models.query.Query;
import com.ontotext.models.query.SourceLocation;

public class ObjectHierarchyOperationValidator
implements OperationValidator {
    public OperationResponse validate(Operation operation, ValidationContext validationContext) {
        OperationResponse operationResponse = new OperationResponse();
        this.validateType((Selectable)operation, validationContext.getSomlSchema(), operationResponse);
        return operationResponse;
    }

    public OperationResponse visit(DeleteMutation mutation, ValidationContext validationContext) {
        return this.validate((Operation)mutation, validationContext);
    }

    public OperationResponse visit(Query query, ValidationContext validationContext) {
        return this.validate((Operation)query, validationContext);
    }

    public OperationResponse visit(CreateMutation mutation, ValidationContext validationContext) {
        return this.validate((Operation)mutation, validationContext);
    }

    public OperationResponse visit(Selection selection, ValidationContext validationContext) {
        OperationResponse operationResponse = new OperationResponse();
        this.validateType((Selectable)selection, validationContext.getSomlSchema(), operationResponse);
        return operationResponse;
    }

    public OperationResponse visit(UpdateMutation mutation, ValidationContext validationContext) {
        return this.validate((Operation)mutation, validationContext);
    }

    private void validateType(Selectable selectable, SomlSchema somlSchema, OperationResponse operationResponse) {
        String typeIri = somlSchema.getPrefixes().nameToShortIri(selectable.getType());
        Shape type = (Shape)somlSchema.getObjects().get((Object)typeIri);
        if (type != null && type.isAbstract() && type.getConcreteSubTypes().isEmpty()) {
            operationResponse.add((OperationResponse.OperationMessage)QueryValidationMessage.error((SourceLocation)selectable.getLocation(), (String)"not.allowed.to.query.abstract.class.without.sub.types", (Object[])new Object[]{selectable.getType(), selectable.getPath()}));
        }
        for (Selectable selection : selectable.getSelections()) {
            this.validateType(selection, somlSchema, operationResponse);
        }
    }
}

