/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.query;

import com.ontotext.graphql.validator.SimpleGraphQlError;
import com.ontotext.models.ErrorMessages;
import com.ontotext.models.LangConfig;
import com.ontotext.models.Operation;
import com.ontotext.models.OperationValidator;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Selectable;
import com.ontotext.models.ValidationContext;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.Severity;
import com.ontotext.models.query.LangFilter;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

public class LiteralOrderValidator
implements OperationValidator {
    public OperationResponse validate(Operation operation, ValidationContext validationContext) {
        OperationResponse response = new OperationResponse();
        this.processSelection((Selectable)operation, response);
        return response;
    }

    private void processSelection(Selectable operation, OperationResponse response) {
        for (Selectable selection : operation.getSelections()) {
            this.validateSelection(selection, response);
            this.processSelection(selection, response);
        }
    }

    private void validateSelection(Selectable selectable, OperationResponse response) {
        if (!"Literal".equals(selectable.getType()) || this.sortCurrentProperty(selectable)) {
            return;
        }
        if (!selectable.isQueryable() || selectable.getSelections().stream().filter(Selectable.byName((String)"value")).noneMatch(selection -> selection.getArguments().isAscendingOrder().isPresent())) {
            return;
        }
        selectable.getProperty().filter(this::shouldValidateProperty).ifPresent(propertyShape -> this.doValidation(selectable, (PropertyShape)propertyShape, response));
    }

    private boolean sortCurrentProperty(Selectable selectable) {
        return selectable.getArguments().getLangFilter().filter(filter -> filter.getTokens().stream().noneMatch(token -> token.getType() == LangFilter.TokenType.ALL)).isEmpty();
    }

    private void doValidation(Selectable selectable, PropertyShape orderProperty, OperationResponse response) {
        LangConfig langConfig = orderProperty.getLangConfig();
        Optional<LangFilter.Token> unique = langConfig.getValidator().getTokens().stream().filter(token -> token.getType() == LangFilter.TokenType.UNIQUE).findFirst();
        if (unique.isEmpty()) {
            response.addWarningMessage(LiteralOrderValidator.createValidationWarning("property.lang.validation.notUniqueToOrderBy", orderProperty.getContainedIn().getContainedIn().getId(), orderProperty.getName()));
        } else {
            LangFilter validatingFilter = langConfig.getValidator().toFilter();
            List allowedLangs = validatingFilter.getTokens().stream().filter(LangFilter.Token::isInclusion).map(token -> token.getLanguage().orElse(null)).filter(Objects::nonNull).distinct().collect(Collectors.toList());
            LangFilter effectiveLangFilter = (LangFilter)selectable.getArguments().getLangFilter().orElseThrow(IllegalStateException::new);
            Optional<String> foundLang = effectiveLangFilter.getTokens().stream().filter(LangFilter.Token::isInclusion).map(token -> token.getLanguage().orElse(null)).filter(Objects::nonNull).findFirst();
            if (foundLang.isEmpty()) {
                response.addErrorMessage(LiteralOrderValidator.createValidationError(orderProperty.getContainedIn().getContainedIn().getId(), orderProperty.getName(), effectiveLangFilter.toString()));
                return;
            }
            String orderByLang = foundLang.get();
            if (!allowedLangs.isEmpty() && !allowedLangs.contains(orderByLang)) {
                response.addWarningMessage(LiteralOrderValidator.createValidationWarning("property.lang.validation.notInUniqueValidationToOrderBy", orderProperty.getContainedIn().getContainedIn().getId(), orderProperty.getName(), allowedLangs, orderByLang));
            }
        }
    }

    private boolean shouldValidateProperty(PropertyShape orderProperty) {
        return orderProperty.isMultivalued() && orderProperty.isScalarType() && orderProperty.getScalarType().isLangStringSupported();
    }

    private static Serializable createValidationWarning(String message, Object ... args) {
        return (Serializable)((Object)new SimpleGraphQlError(Severity.WARN, ErrorMessages.get((String)message, (Object[])args), null, null, null).toSpecification());
    }

    private static Serializable createValidationError(Object ... args) {
        return (Serializable)((Object)new SimpleGraphQlError(Severity.ERROR, ErrorMessages.get((String)"property.lang.validation.noLanguageToOrderBy", (Object[])args), null, null, null).toSpecification());
    }
}

