/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.query;

import com.ontotext.models.Shape;
import com.ontotext.models.query.AbstractExpressionVisitor;
import com.ontotext.models.query.Expression;
import com.ontotext.models.query.ExpressionTerm;
import com.ontotext.models.query.ExpressionValue;
import com.ontotext.models.query.ExpressionVisitor;
import com.ontotext.models.query.ExpressionVisitorContext;
import com.ontotext.models.query.Node;
import com.ontotext.models.query.Value;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class ExpressionServiceCollector
extends AbstractExpressionVisitor<Set<String>, ExpressionVisitorContext> {
    private static final String NO_SERVICE = "NO_SERVICE";
    private NodeSelectionCollector nodeSelectionCollector;

    public boolean containsLocalShapes(ExpressionValue<?> expressionTerm) {
        return ((Set)expressionTerm.accept((ExpressionVisitor)this, null)).contains(NO_SERVICE);
    }

    public Set<String> visit(Node target, ExpressionVisitorContext context) {
        String serviceAddress = null;
        Shape rangeShape = target.getPropertyShape().getRangeShape();
        if (rangeShape != null && this.containsNonIdSubSelections(target)) {
            serviceAddress = rangeShape.getServiceAddress() == null ? NO_SERVICE : rangeShape.getServiceAddress();
        }
        if (serviceAddress == null) {
            return (Set)((Expression)target.getValue()).accept((ExpressionVisitor)this, context);
        }
        HashSet<String> combined = new HashSet<String>();
        combined.add(serviceAddress);
        combined.addAll((Collection)((Expression)target.getValue()).accept((ExpressionVisitor)this, context));
        return combined;
    }

    private boolean containsNonIdSubSelections(Node target) {
        if (this.nodeSelectionCollector == null) {
            this.nodeSelectionCollector = new NodeSelectionCollector();
        }
        return !((Set)((Expression)target.getValue()).accept((ExpressionVisitor)this.nodeSelectionCollector, null)).isEmpty();
    }

    protected Set<String> visitExpression(Expression target, ExpressionVisitorContext context) {
        HashSet<String> combined = new HashSet<String>();
        for (ExpressionTerm term : target.getTerms()) {
            combined.addAll((Collection)term.accept((ExpressionVisitor)this, context));
        }
        return combined;
    }

    protected Set<String> visitExpressionTerm(ExpressionTerm target, ExpressionVisitorContext context) {
        return this.visitTermValue(target.getValue(), context);
    }

    private Set<String> visitTermValue(Object target, ExpressionVisitorContext context) {
        if (target instanceof Expression) {
            return (Set)((Expression)target).accept((ExpressionVisitor)this, context);
        }
        if (target instanceof Node) {
            return (Set)((Value)target).accept((ExpressionVisitor)this, context);
        }
        if (target instanceof Collection) {
            HashSet<String> combined = new HashSet<String>();
            for (Object obj : (Collection)target) {
                combined.addAll(this.visitTermValue(obj, context));
            }
            return combined;
        }
        return Collections.emptySet();
    }

    private static class NodeSelectionCollector
    extends ExpressionServiceCollector {
        private NodeSelectionCollector() {
        }

        @Override
        public Set<String> visit(Node target, ExpressionVisitorContext context) {
            if (target.getName().equals("id")) {
                return (Set)((Expression)target.getValue()).accept((ExpressionVisitor)this, context);
            }
            HashSet<String> res = new HashSet<String>();
            res.add(target.getName());
            res.addAll((Collection)((Expression)target.getValue()).accept((ExpressionVisitor)this, context));
            return res;
        }
    }
}

