/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator.mutation;

import com.ontotext.graphql.validator.SimpleGraphQlError;
import com.ontotext.models.OperationValidator;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.ValidationContext;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.mutation.Change;
import com.ontotext.models.mutation.CreateMutation;
import com.ontotext.models.mutation.Mutation;
import com.ontotext.models.mutation.PropertyChange;
import com.ontotext.models.mutation.UpdateMutation;
import com.ontotext.models.query.ValueConversionException;
import graphql.ErrorClassification;
import graphql.ErrorType;
import graphql.language.SourceLocation;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;

public class MutationInputValuesValidator
implements OperationValidator {
    public OperationResponse visit(CreateMutation mutation, ValidationContext context) {
        return this.validateMutationArguments((Mutation)mutation);
    }

    public OperationResponse visit(UpdateMutation mutation, ValidationContext context) {
        return this.validateMutationArguments((Mutation)mutation);
    }

    private OperationResponse validateMutationArguments(Mutation mutation) {
        OperationResponse response = new OperationResponse();
        for (Change change : mutation.getChanges()) {
            for (PropertyChange propChange : change.getChanges()) {
                if (MutationInputValuesValidator.isIri(propChange.getName(), change)) continue;
                try {
                    propChange.getValueOrFail();
                }
                catch (ValueConversionException vce) {
                    MutationInputValuesValidator.onError(response, propChange, vce);
                }
                try {
                    propChange.getPatchOrFail();
                }
                catch (ValueConversionException vce) {
                    MutationInputValuesValidator.onError(response, propChange, vce);
                }
            }
        }
        return response;
    }

    private static boolean isIri(String name, Change change) {
        PropertyShape propertyShape = change.getShape().getPropertyOrFail(name);
        return propertyShape.isScalarType() && propertyShape.getScalarType().is("iri") || propertyShape.isObjectType();
    }

    private static void onError(OperationResponse response, PropertyChange propChange, ValueConversionException vce) {
        response.addErrorMessage((Serializable)((Object)new SimpleGraphQlError(vce.getMessage(), MutationInputValuesValidator.getSourceLocations(propChange), (ErrorClassification)ErrorType.ValidationError).toSpecification()));
    }

    private static List<SourceLocation> getSourceLocations(PropertyChange propChange) {
        return propChange.getSourceLocations().stream().map(location -> new SourceLocation(location.getLine(), location.getColumn())).collect(Collectors.toList());
    }
}

