/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.ErrorMessages;
import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

public class UnionValidator
implements SchemaValidator {
    private static final Set<String> FORBIDDEN_ATTRIBUTES = Set.of("inherits", "regex", "regexFlags", "prefix", "pattern", "type", "typeProp", "name", "extend", "constraints", "closed", "sparqlFederatedService");

    public OperationResponse validate(SomlSchema somlSchema) {
        OperationResponse response = new OperationResponse();
        for (Shape shape : somlSchema.getObjects().values()) {
            if (shape.isUnion()) {
                this.validateUnion(shape, somlSchema, response);
                continue;
            }
            if (!"union".equals(shape.getKind())) continue;
            response.addErrorMessage("object.unionOf.shouldHaveMultipleValues", new Object[]{shape.getId()});
        }
        return response;
    }

    private void validateUnion(Shape shape, SomlSchema somlSchema, OperationResponse response) {
        String missingTypes = shape.getUnionOfAsList().stream().filter(type -> somlSchema.getObjects().resolveShape(type).isEmpty()).collect(Collectors.joining(", "));
        if (!missingTypes.isEmpty()) {
            response.addErrorMessage("object.unionOf.missingTypes", new Object[]{missingTypes, shape.getId()});
        }
        if (shape.getUnionOfAsList().stream().distinct().count() != (long)shape.getUnionOfAsList().size()) {
            response.addWarningMessage("object.unionOf.duplicateEntries", new Object[]{shape.getId()});
        }
        String notAllowedAttributes = FORBIDDEN_ATTRIBUTES.stream().filter(arg_0 -> ((Shape)shape).isTracked(arg_0)).collect(Collectors.joining(", "));
        if (!notAllowedAttributes.isEmpty()) {
            response.addErrorMessage("object.unionOf.shouldNotDefine", new Object[]{shape.getId(), notAllowedAttributes});
        }
        if (this.hasUnionCycle(shape, somlSchema, new HashSet<String>())) {
            List<String> list = this.getInvalidUnionPath(shape, somlSchema.getObjects());
            response.addErrorMessage("object.unionOf.hasCycle", new Object[]{shape.getId(), String.join((CharSequence)" of ", list)});
            return;
        }
        List unionOfShapes = shape.getUnionOfShapes();
        if (unionOfShapes.size() == 1 || "union".equals(shape.getKind()) && unionOfShapes.isEmpty()) {
            response.addErrorMessage("object.unionOf.shouldHaveMultipleValues", new Object[]{shape.getId()});
        }
    }

    private boolean hasUnionCycle(Shape union, SomlSchema somlSchema, Set<String> visited) {
        if (!visited.add(union.getId())) {
            return true;
        }
        return union.getUnionOfAsList().stream().map(type -> somlSchema.getObjects().resolveShape(type).filter(Shape::isUnion).orElse(null)).filter(Objects::nonNull).anyMatch(subUnion -> this.hasUnionCycle((Shape)subUnion, somlSchema, visited));
    }

    private List<String> getInvalidUnionPath(Shape shape, Shapes shapes) {
        for (String unionMember : shape.getUnionOfAsList()) {
            LinkedList<String> unionPathNames = new LinkedList<String>();
            if (!this.checkUnionMember(shape.getId(), shapes, shape, unionMember, unionPathNames)) continue;
            return unionPathNames;
        }
        return Collections.emptyList();
    }

    private boolean checkUnionMember(String primaryShape, Shapes shapes, Shape currentShape, String unionMember, Deque<String> unionPathNames) {
        Shape parentShape = (Shape)shapes.get((Object)unionMember);
        if (parentShape == null) {
            throw new InvalidSchemaException(ErrorMessages.get((String)"undefined.referenced.type", (Object[])new Object[]{currentShape.getId(), unionMember}));
        }
        if (!parentShape.isUnion()) {
            return false;
        }
        unionPathNames.addLast(unionMember);
        currentShape = parentShape;
        for (String unionMemberOfUnion : parentShape.getUnionOfAsList()) {
            if (this.performLoopCheck(primaryShape, currentShape, unionPathNames, unionMemberOfUnion)) {
                return true;
            }
            if (!this.checkUnionMember(primaryShape, shapes, currentShape, unionMemberOfUnion, unionPathNames)) continue;
            return true;
        }
        return false;
    }

    private boolean performLoopCheck(String name, Shape shape, Deque<String> unionPathNames, String unionMember) {
        boolean isParentLooping;
        boolean bl = isParentLooping = null != unionMember && (unionMember.equals(shape.getName()) || unionPathNames.contains(unionMember));
        if (isParentLooping) {
            if (!unionPathNames.contains(unionMember)) {
                unionPathNames.addFirst(unionMember);
            }
            if (!unionPathNames.contains(name)) {
                unionPathNames.addLast(unionMember);
            }
            return true;
        }
        return false;
    }
}

