/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class SystemTypesInheritanceValidator
implements SchemaValidator {
    public OperationResponse validate(SomlSchema schema) {
        if (Boolean.TRUE.equals(schema.getInternal())) {
            return OperationResponse.EMPTY;
        }
        OperationResponse response = new OperationResponse();
        Shapes shapes = schema.getObjects();
        shapes.values().stream().filter(this.hasInheritanceDefined(shapes)).filter(shape -> shape.getInheritsAsList().stream().anyMatch(Shapes.SYSTEM_SHAPES::contains)).forEach(this.reportError(response));
        return response;
    }

    private Predicate<Shape> hasInheritanceDefined(Shapes shapes) {
        return shape -> shape.isSynthetic() == false && shapes.isTracked(shape.getId()) && !shape.getInheritsAsList().isEmpty();
    }

    private Consumer<Shape> reportError(OperationResponse response) {
        return shape -> {
            List inherits = shape.getInheritsAsList();
            if (inherits != null && inherits.size() == 1) {
                inherits = inherits.get(0);
            }
            response.addErrorMessage("soml.forbidden.shape.inheritance", new Object[]{shape.getId(), inherits});
        };
    }
}

