/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import com.ontotext.models.query.LangFilter;
import com.ontotext.models.search.Analysis;
import com.ontotext.models.search.BuiltInAnalyzers;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Stream;

public class SearchAnalyzerValidator
implements SchemaValidator {
    private static final Set<LangFilter.TokenType> WILDCARD_TOKENS = new HashSet<LangFilter.TokenType>(Arrays.asList(LangFilter.TokenType.ANY, LangFilter.TokenType.ANY_LANG, LangFilter.TokenType.START_WITH, LangFilter.TokenType.END_WITH, LangFilter.TokenType.CONTAINS));

    public OperationResponse validate(SomlSchema somlSchema) {
        OperationResponse resp = new OperationResponse();
        this.validateSchemaConfigAnalyzer(somlSchema, resp);
        somlSchema.getProperties().values().forEach(prop -> this.validateProperty(resp, (PropertyShape)prop, prop.getName()));
        somlSchema.getObjects().values().forEach(shape -> this.validateShape((Shape)shape, resp));
        return resp;
    }

    private void validateSchemaConfigAnalyzer(SomlSchema somlSchema, OperationResponse resp) {
        somlSchema.getConfig().getSearch().ifPresent(search -> {
            String analyzer;
            Analysis analysis = search.getAnalysis();
            if (analysis != null && (analyzer = analysis.getAnalyzer()) != null && !BuiltInAnalyzers.exists((String)analyzer)) {
                resp.addErrorMessage("soml.configs.search.analysis.invalid.analyzer", new Object[]{analyzer});
            }
        });
    }

    private void validateShape(Shape shape, OperationResponse resp) {
        shape.getProps().values().stream().forEach(prop -> this.validateProperty(resp, (PropertyShape)prop, shape.getId() + "." + prop.getName()));
    }

    private void validateProperty(OperationResponse resp, PropertyShape prop, String propName) {
        this.validateWildcardLangs(prop, resp);
        if (!this.containsAnalysis(prop)) {
            return;
        }
        this.validateInvalidConfig(prop, resp, propName);
        this.validateThatAnalyzerExists(prop, resp, propName);
        this.validateAnalysisOnNonSearchable(prop, resp, propName);
    }

    private boolean containsAnalysis(PropertyShape prop) {
        return prop.getSearchSafe().getAnalysis() != null;
    }

    private void validateInvalidConfig(PropertyShape prop, OperationResponse resp, String propName) {
        boolean isLangString;
        boolean isString = prop.isScalarType() && prop.getScalarType().is("string");
        boolean bl = isLangString = prop.isScalarType() && prop.getScalarType().isLangStringSupported();
        if (!isString && !isLangString) {
            resp.addErrorMessage("property.analysis.forbidden", new Object[]{propName, prop.getRange()});
            return;
        }
        Map lang = prop.getSearch().getAnalysis().getLang();
        if (lang != null && !lang.isEmpty()) {
            if (!isLangString) {
                resp.addErrorMessage("property.analysis.lang.forbidden", new Object[]{propName});
                return;
            }
            if (lang.values().stream().anyMatch(analysis -> analysis.getLang() != null)) {
                resp.addErrorMessage("property.analysis.lang.lang.forbidden", new Object[]{propName});
            }
        }
    }

    private void validateThatAnalyzerExists(PropertyShape prop, OperationResponse resp, String propName) {
        Analysis analysis = prop.getSearch().getAnalysis();
        this.checkAnalyzerExistence(analysis.getAnalyzer(), resp, propName);
    }

    private void checkAnalyzerExistence(String analyzer, OperationResponse resp, String propName) {
        if (analyzer != null && !BuiltInAnalyzers.exists((String)analyzer)) {
            resp.addWarningMessage("property.analysis.analyzer.nonStandard", new Object[]{propName, analyzer});
        }
    }

    private void validateAnalysisOnNonSearchable(PropertyShape prop, OperationResponse resp, String propName) {
        if (prop.getContainedIn() == null) {
            return;
        }
        if (prop.getContainedIn().getContainedIn().isAbstract()) {
            return;
        }
        Analysis analysis = prop.getSearch().getAnalysis();
        if (!prop.getSearch().isSearchable() && (analysis.isTracked("analyzer") || analysis.isTracked("lang"))) {
            resp.addWarningMessage("property.analysis.analyzer.nonSearchable", new Object[]{propName});
        }
    }

    private void validateWildcardLangs(PropertyShape prop, OperationResponse resp) {
        if (prop.getLangConfig() == null) {
            return;
        }
        if (!prop.getSearchSafe().isSearchable()) {
            return;
        }
        try {
            prop.getLangConfig().getValidator().getTokens().stream().flatMap(token -> token instanceof LangFilter.TokenGroup ? ((LangFilter.TokenGroup)token).getTokens().stream() : Stream.of(token)).filter(LangFilter.Token::isInclusion).filter(token -> WILDCARD_TOKENS.contains(token.getType())).forEach(token -> resp.addWarningMessage("property.analysis.lang.wildcard.ignored", new Object[]{prop.getContainedIn() != null ? prop.getContainedIn().getContainedIn().getId() : "", prop.getName(), token.toString()}));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

