/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.ErrorMessages;
import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;

public class SchemaHierarchyValidator
implements SchemaValidator {
    public OperationResponse validate(SomlSchema somlSchema) {
        OperationResponse operationResponse = new OperationResponse();
        Shapes objects = somlSchema.getObjects();
        objects.forEach((name, shape) -> {
            try {
                objects.getHierarchyOnDemand(name);
            }
            catch (InvalidSchemaException ise) {
                operationResponse.addAll(ise.getValidationReport());
                return;
            }
            if (shape.isHierarchyInvalid()) {
                List<String> types = this.getInvalidHierarchy(objects, (String)name);
                operationResponse.addFatalMessage("loop.inheritance.schema", new Object[]{name, String.join((CharSequence)" of ", types)});
            }
        });
        return operationResponse;
    }

    private List<String> getInvalidHierarchy(Shapes shapes, String name) {
        Shape shape = (Shape)shapes.get((Object)name);
        for (String parent : shape.getInheritsAsList()) {
            LinkedList<String> hierarchyNames;
            if (!this.checkParent(name, shapes, shape, parent, hierarchyNames = new LinkedList<String>())) continue;
            return hierarchyNames;
        }
        return Collections.emptyList();
    }

    private boolean checkParent(String primaryShape, Shapes shapes, Shape currentShape, String parent, Deque<String> hierarchyNames) {
        Shape parentShape = (Shape)shapes.get((Object)parent);
        if (parentShape == null) {
            throw new InvalidSchemaException(ErrorMessages.get((String)"undefined.referenced.type", (Object[])new Object[]{currentShape.getId(), parent}));
        }
        hierarchyNames.addLast(parent);
        currentShape = parentShape;
        for (String parentsParent : parentShape.getInheritsAsList()) {
            if (this.performLoopCheck(primaryShape, currentShape, hierarchyNames, parentsParent)) {
                return true;
            }
            if (!this.checkParent(primaryShape, shapes, currentShape, parentsParent, hierarchyNames)) continue;
            return true;
        }
        return false;
    }

    private boolean performLoopCheck(String name, Shape shape, Deque<String> hierarchyNames, String parent) {
        boolean isParentLooping;
        boolean bl = isParentLooping = null != parent && (parent.equals(shape.getName()) || hierarchyNames.contains(parent));
        if (isParentLooping) {
            if (!hierarchyNames.contains(parent)) {
                hierarchyNames.addFirst(parent);
            }
            if (!hierarchyNames.contains(name)) {
                hierarchyNames.addLast(parent);
            }
            return true;
        }
        return false;
    }
}

