/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.google.common.collect.Sets;
import com.ontotext.models.ErrorMessages;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public class ReservedPropertiesValidator
implements SchemaValidator {
    private static final Set<String> RESERVED_PROPS = new HashSet<String>(Arrays.asList("id", "name", "type"));
    private static final Set<String> OVERWRITABLE_FIELDS = new LinkedHashSet<String>(Arrays.asList("label", "descr", "meta"));

    public OperationResponse validate(SomlSchema somlSchema) {
        OperationResponse response = new OperationResponse();
        for (Shape shape : somlSchema.getObjects().values()) {
            this.validateShape(shape, response);
        }
        return response;
    }

    private void validateShape(Shape shape, OperationResponse response) {
        if (shape.isSystem() || shape.isSynthetic().booleanValue()) {
            return;
        }
        for (PropertyShape prop : shape.getProps().values()) {
            this.validateProperty(prop, shape, response);
        }
    }

    private void validateProperty(PropertyShape prop, Shape shape, OperationResponse response) {
        if (!RESERVED_PROPS.contains(prop.getName())) {
            return;
        }
        boolean isWronglyDefined = this.isRangeWronglyOverridden(prop);
        isWronglyDefined |= this.isMinCardinalityWronglyOverridden(prop);
        Sets.SetView forbidden = Sets.difference((Set)prop.getTrackedEntities(), OVERWRITABLE_FIELDS);
        if (!forbidden.isEmpty() && (isWronglyDefined |= this.isMaxCardinalityWronglyOverridden(prop))) {
            response.addErrorMessage(ErrorMessages.get((String)"property.redefines.reserved.property", (Object[])new Object[]{shape.getId(), prop.getName(), forbidden, OVERWRITABLE_FIELDS}));
        }
    }

    private boolean isRangeWronglyOverridden(PropertyShape prop) {
        if (!prop.isTracked("range")) {
            return false;
        }
        String range = prop.getRange();
        switch (prop.getName()) {
            case "id": 
            case "type": {
                return !range.equals("iri");
            }
            case "name": {
                return !range.equals("string");
            }
        }
        return false;
    }

    private boolean isMinCardinalityWronglyOverridden(PropertyShape prop) {
        if (!prop.isTracked("min")) {
            return false;
        }
        Integer min = prop.getMin();
        switch (prop.getName()) {
            case "id": 
            case "name": {
                return min != 1;
            }
            case "type": {
                return min != 0;
            }
        }
        return false;
    }

    private boolean isMaxCardinalityWronglyOverridden(PropertyShape prop) {
        if (!prop.isTracked("max")) {
            return false;
        }
        String max = prop.getMax();
        switch (prop.getName()) {
            case "id": 
            case "name": {
                return !"1".equals(max);
            }
            case "type": {
                return !"inf".equals(max);
            }
        }
        return false;
    }
}

