/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.ErrorMessages;
import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.Prefixes;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.ScalarType;
import com.ontotext.models.ScalarTypes;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.PropertyRdfPropSparqlFragmentExtension;
import com.ontotext.models.extensions.SchemaValidator;
import com.ontotext.models.extensions.SparqlValidator;
import com.ontotext.models.extensions.TemplateParsers;
import com.ontotext.models.query.InputValueConverter;
import com.ontotext.models.query.PassThroughInputValueConverter;
import com.ontotext.models.query.ValueConversionException;
import com.ontotext.models.templates.Template;
import com.ontotext.models.templates.TemplateArgs;
import com.ontotext.soaas.common.CachingSupplier;
import com.ontotext.soaas.common.SparqlUtil;
import com.ontotext.soaas.plugin.Inject;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertyRdfPropSparqlFragmentValidator
implements SchemaValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(PropertyRdfPropSparqlFragmentValidator.class);
    private static final Pattern LINE_PATTERN = Pattern.compile("at line (\\d+), column");
    private static final String SUBJECT_BINDING = "?_subject";
    private static final String WORD_BOUNDARY = "[\\s\\W]";
    private static final Pattern SUBJECT_PATTERN = Pattern.compile("[\\s\\W]" + Pattern.quote("?_subject") + "[\\s\\W]");
    private static final String VALUE_BINDING = "?_value";
    private static final Pattern VALUE_PATTERN = Pattern.compile("[\\s\\W]" + Pattern.quote("?_value") + "[\\s\\W]");
    private static final String NO_BINDING = "property.rdf.prop.bad.noSparqlTemplateBinding";
    private static final String NO_BINDING_IN_TYPE = "property.rdf.prop.bad.noSparqlTemplateBinding.inType";
    private static final String INVERSE_ALIAS = "property.rdf.prop.inverseAliasTemplate";
    private static final String INVERSE_ALIAS_IN_TYPE = "property.rdf.prop.inverseAliasTemplate.inType";
    private static final Supplier<SparqlValidator> VALIDATOR = new CachingSupplier(SparqlValidator::resolve);
    private InputValueConverter inputValueConverter = PassThroughInputValueConverter.INSTANCE;

    public OperationResponse validate(SomlSchema somlSchema) {
        OperationResponse operationResponse = new OperationResponse();
        Function<PropertyShape, String> queryBuilder = this.queryBuilder(somlSchema.getPrefixes(), somlSchema.getTypes());
        String baseIri = somlSchema.getPrefixes().getBaseIri().orElse("");
        for (PropertyShape property2 : somlSchema.getProperties().values()) {
            if (property2.isTracked("rdfProp") && StringUtils.isNotBlank((CharSequence)property2.getRdfProp()) && property2.isSparqlTemplate()) {
                this.checkSparqlTemplate(property2, queryBuilder, baseIri, operationResponse, null);
            }
            if (!property2.isTracked("inverseAlias")) continue;
            String inverseAlias = property2.getInverseAlias();
            Shape inverseRange = (Shape)somlSchema.getObjects().get((Object)property2.getRange());
            if (inverseRange == null || !inverseRange.getProperty(inverseAlias).filter(PropertyShape::isSparqlTemplate).isPresent()) continue;
            operationResponse.addWarningMessage(INVERSE_ALIAS, new Object[]{inverseAlias, property2.getName()});
        }
        for (Shape shape : somlSchema.getObjects().values()) {
            if (shape.isHierarchyInvalid() || shape.isSynthetic().booleanValue()) continue;
            shape.getAllProperties().values().stream().distinct().filter(property -> shape.getProps().isTracked(property.getName())).filter(property -> property.isTracked("rdfProp")).filter(property -> StringUtils.isNotBlank((CharSequence)property.getRdfProp())).filter(PropertyShape::isSparqlTemplate).forEach(property -> this.checkSparqlTemplate((PropertyShape)property, queryBuilder, baseIri, operationResponse, shape.getId()));
            shape.getAllProperties().values().stream().distinct().filter(property -> shape.getProps().isTracked(property.getName())).filter(property -> property.isTracked("inverseAlias")).forEach(property -> property.getInverseAliasProperty().filter(SparqlUtil::isSparqlTemplate).ifPresent(inverseProperty -> operationResponse.addWarningMessage(INVERSE_ALIAS_IN_TYPE, new Object[]{property.getInverseAlias(), property.getName(), shape.getId()})));
        }
        return operationResponse;
    }

    private void checkSparqlTemplate(PropertyShape property, Function<PropertyShape, String> queryBuilder, String baseIri, OperationResponse operationResponse, String type) {
        this.checkRequiredBindingPresence(type, property, operationResponse);
        try {
            String query = queryBuilder.apply(property);
            VALIDATOR.get().validate(query, baseIri);
        }
        catch (SparqlValidator.QuerySyntaxError qve) {
            Throwable cause = qve.getCause();
            String message = cause.getMessage();
            Matcher matcher = LINE_PATTERN.matcher(message);
            if (matcher.find()) {
                int line = Integer.parseInt(matcher.group(1)) - 1;
                message = message.replace("at line " + matcher.group(1), "at line " + line);
            }
            this.reportQueryValidationError(property, operationResponse, type, message);
        }
        catch (Exception ex) {
            this.reportQueryValidationError(property, operationResponse, type, ex.getMessage());
        }
    }

    private void checkRequiredBindingPresence(String type, PropertyShape property, OperationResponse operationResponse) {
        String rdfProp = StringUtils.wrap((String)property.getRdfProp(), (char)' ');
        String propName = property.getName();
        if (!SUBJECT_PATTERN.matcher(rdfProp).find()) {
            if (type == null) {
                operationResponse.addWarningMessage(NO_BINDING, new Object[]{propName, SUBJECT_BINDING});
            } else {
                operationResponse.addWarningMessage(NO_BINDING_IN_TYPE, new Object[]{propName, type, SUBJECT_BINDING});
            }
            LOGGER.debug("Could not resolve '{}' binding in {} rdfProp: '{}'", new Object[]{SUBJECT_BINDING, property.getName(), property.getRdfProp()});
        }
        if (!VALUE_PATTERN.matcher(rdfProp).find()) {
            if (type == null) {
                operationResponse.addWarningMessage(NO_BINDING, new Object[]{propName, VALUE_BINDING});
            } else {
                operationResponse.addWarningMessage(NO_BINDING_IN_TYPE, new Object[]{propName, type, VALUE_BINDING});
            }
            LOGGER.debug("Could not resolve '{}' binding in {} rdfProp: '{}'", new Object[]{VALUE_BINDING, property.getName(), property.getRdfProp()});
        }
    }

    private void reportQueryValidationError(PropertyShape property, OperationResponse operationResponse, String parent, String message) {
        if (parent == null) {
            operationResponse.addErrorMessage("property.rdf.prop.bad.sparqlTemplate", new Object[]{property.getName(), message});
        } else {
            operationResponse.addErrorMessage("property.rdf.prop.bad.sparqlTemplate.inType", new Object[]{property.getName(), parent, message});
        }
    }

    private Function<PropertyShape, String> queryBuilder(Prefixes prefixes, ScalarTypes types) {
        BinaryOperator queryBuilder = PropertyRdfPropSparqlFragmentExtension.queryBuilder((Prefixes)prefixes);
        return property -> {
            Template sparqlTemplate = property.getSparqlTemplate();
            if (sparqlTemplate == null) {
                Shape shape = property.getContainedIn().getContainedIn();
                sparqlTemplate = TemplateParsers.parse((String)PropertyRdfPropSparqlFragmentValidator.buildName(prefixes, shape.getId(), property.getName()), (String)property.getRdfProp());
            }
            Map<String, Object> templateArgs = null;
            if (sparqlTemplate.hasArgs()) {
                templateArgs = this.generateArguments(sparqlTemplate.getKeys(), types);
            }
            return (String)queryBuilder.apply(sparqlTemplate.apply(templateArgs), "");
        };
    }

    private Map<String, Object> generateArguments(Map<String, TemplateArgs> keys, ScalarTypes types) {
        LinkedHashMap<String, Object> result = new LinkedHashMap<String, Object>();
        keys.forEach((name, args) -> {
            Map<String, Object> resultValue = args.isEmpty() ? this.generateValueBasedOnType((TemplateArgs)args, types) : this.generateArguments(args.getArgsMap(), types);
            if (args.isCollection()) {
                result.put((String)name, Collections.singletonList(resultValue));
            } else {
                result.put((String)name, resultValue);
            }
        });
        return result;
    }

    private Object generateValueBasedOnType(TemplateArgs arg, ScalarTypes types) {
        String type = arg.getType();
        String defaultValue = arg.getDefaultValue();
        if (defaultValue != null) {
            return this.convertDefaultValue(type, defaultValue, types);
        }
        if ("sparql".equals(type)) {
            return "";
        }
        if (ScalarTypes.NUMBER_TYPES.contains(type)) {
            return 0;
        }
        if ("boolean".equals(type) || "condition".equals(type)) {
            return true;
        }
        if (ScalarTypes.TEMPORAL_TYPES.contains(type)) {
            return "\"2021-10-03T01:35:31.124+03:00\"^^<http://www.w3.org/2001/XMLSchema#dateTime>";
        }
        if ("dayTimeDuration".equals(type)) {
            return "\"P0D\"^^<http://www.w3.org/2001/XMLSchema#dayTimeDuration>";
        }
        if (ScalarTypes.DURATION_TYPES.contains(type)) {
            return "\"P0Y\"^^<http://www.w3.org/2001/XMLSchema#" + type + ">";
        }
        return "<urn:a>";
    }

    private Object convertDefaultValue(String type, String defaultValue, ScalarTypes types) {
        if ("sparql".equals(type)) {
            return defaultValue;
        }
        if ("condition".equals(type)) {
            return Boolean.parseBoolean(defaultValue);
        }
        ScalarType scalarType = (ScalarType)types.get((Object)type);
        if (scalarType == null) {
            throw PropertyRdfPropSparqlFragmentValidator.badArgumentTypeException(type);
        }
        try {
            Object convertedValue = this.inputValueConverter.convert((Object)defaultValue, scalarType);
            if (convertedValue instanceof Literal) {
                return convertedValue.toString();
            }
            if (convertedValue instanceof IRI) {
                return "<" + ((IRI)convertedValue).stringValue() + ">";
            }
            return convertedValue;
        }
        catch (ValueConversionException vce) {
            throw PropertyRdfPropSparqlFragmentValidator.badDefaultValueException(type, defaultValue);
        }
    }

    @NotNull
    private static InvalidSchemaException badDefaultValueException(String type, String defaultValue) {
        return new InvalidSchemaException(ErrorMessages.get((String)"property.rdf.prop.bad.sparqlTemplate.badDefaultValue", (Object[])new Object[]{defaultValue, type}));
    }

    @NotNull
    private static InvalidSchemaException badArgumentTypeException(String type) {
        return new InvalidSchemaException(ErrorMessages.get((String)"property.rdf.prop.bad.sparqlTemplate.badType", (Object[])new Object[]{type}));
    }

    private static String buildName(Prefixes prefixes, String ... path) {
        return Arrays.stream(path).map(arg_0 -> ((Prefixes)prefixes).toName(arg_0)).collect(Collectors.joining("."));
    }

    @Inject
    public void setInputValueConverter(InputValueConverter inputValueConverter) {
        this.inputValueConverter = inputValueConverter;
    }
}

