/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;

public class PropertyInheritanceValidator
implements SchemaValidator {
    private static final Map<String, Function<PropertyShape, Object>> immutable = new HashMap<String, Function<PropertyShape, Object>>();

    public OperationResponse validate(SomlSchema soml) {
        OperationResponse operationResponse = new OperationResponse();
        Shapes objects = soml.getObjects();
        for (Shape shape : objects.values()) {
            if (Boolean.TRUE.equals(shape.isSynthetic()) || shape.isHierarchyInvalid()) continue;
            this.validatePropConsistency(shape, operationResponse);
        }
        return operationResponse;
    }

    private void validatePropConsistency(Shape shape, OperationResponse resp) {
        shape.getParents().forEach(parent -> this.validateAgainstParent(shape, resp, (Shape)parent));
    }

    private void validateAgainstParent(Shape shape, OperationResponse resp, Shape parentShape) {
        for (PropertyShape prop : shape.getProps().values()) {
            Optional parentProp = parentShape.getProperty(prop.getName());
            if (!parentProp.isPresent()) continue;
            for (Map.Entry<String, Function<PropertyShape, Object>> immutableEntry : immutable.entrySet()) {
                this.validatePropAgainstParentShape(shape, prop, parentShape, (PropertyShape)parentProp.get(), immutableEntry, resp);
            }
        }
    }

    private void validatePropAgainstParentShape(Shape shape, PropertyShape prop, Shape parentShape, PropertyShape parentProp, Map.Entry<String, Function<PropertyShape, Object>> immutable, OperationResponse resp) {
        if (!prop.isTracked(immutable.getKey()) || !parentProp.isTracked(immutable.getKey())) {
            return;
        }
        Object propValue = immutable.getValue().apply(prop);
        Object parentValue = immutable.getValue().apply(parentProp);
        if (propValue == null || parentValue == null) {
            return;
        }
        if (!propValue.equals(parentValue)) {
            resp.addErrorMessage("property.redefines.immutable.characteristic", new Object[]{shape.getId(), prop.getName(), immutable.getKey(), propValue, parentValue, parentShape.getId(), parentProp.getName()});
        }
    }

    static {
        immutable.put("rangeCheck", PropertyShape::getRangeCheck);
        immutable.put("typeCast", PropertyShape::getTypeCast);
        immutable.put("inverseOf", PropertyShape::getInverseOf);
        immutable.put("symmetric", PropertyShape::getSymmetric);
        immutable.put("kind", PropertyShape::getKind);
    }
}

