/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.ErrorMessages;
import com.ontotext.models.InvalidSchemaException;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.ScalarType;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import com.ontotext.models.query.InputValueConverter;
import com.ontotext.models.query.ValueConversionException;
import com.ontotext.models.shacl.ShaclConstraint;
import com.ontotext.soaas.common.validation.ValidationPatterns;
import com.ontotext.sparql.Rdf4jInputValueConverter;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.rdf4j.model.Literal;

public class PropertyConstraintsValidator
implements SchemaValidator {
    private static final List<String> DATE_DATATYPES = Stream.of("date", "time", "dateTime", "year", "yearMonth").collect(Collectors.toList());
    private static final List<String> NUMBER_DATATYPES = Stream.of("integer", "int", "long", "short", "byte", "double", "decimal", "float", "unsignedLong", "unsignedInt", "unsignedShort", "unsignedByte", "positiveInteger", "nonPositiveInteger", "negativeInteger", "nonNegativeInteger", "negativeFloat", "nonNegativeFloat", "positiveFloat", "nonPositiveFloat").collect(Collectors.toList());
    private static final List<String> NUMERICAL_DATATYPES = Stream.concat(DATE_DATATYPES.stream(), NUMBER_DATATYPES.stream()).collect(Collectors.toList());
    private static final String G_YEAR_DATATYPE = "http://www.w3.org/2001/XMLSchema#gYear";
    private InputValueConverter converter = new Rdf4jInputValueConverter();

    public OperationResponse validate(SomlSchema somlSchema) {
        OperationResponse operationResponse = new OperationResponse();
        Shapes objects = somlSchema.getObjects();
        for (Shape shape : objects.values()) {
            this.validateConstraints(shape, operationResponse);
        }
        return operationResponse;
    }

    private void validateConstraints(Shape shape, OperationResponse response) {
        for (PropertyShape prop : shape.getProps().values()) {
            this.validateLengthConstraint(prop, shape, response);
            response.addAll(this.validateNumericalConstraints(prop, shape));
            this.validateSetConstraints(prop, shape, response);
        }
    }

    private void validateLengthConstraint(PropertyShape prop, Shape shape, OperationResponse response) {
        Integer minLength = prop.getMinLength();
        Integer maxLength = prop.getMaxLength();
        if (!(prop.isScalarType() && prop.getScalarType().treatedAsString() || null == maxLength && null == minLength)) {
            response.addWarningMessage("property.validation.length.range", new Object[]{shape.getId(), prop.getName()});
        }
        if (!prop.isScalarType()) {
            return;
        }
        if (null != minLength && minLength < 0) {
            response.addErrorMessage("property.validation.length.datatype", new Object[]{shape.getId(), prop.getName(), "min", minLength});
        }
        if (null != maxLength && maxLength < 0) {
            response.addErrorMessage("property.validation.length.datatype", new Object[]{shape.getId(), prop.getName(), "max", maxLength});
        }
        if (null != minLength && null != maxLength && minLength > maxLength) {
            response.addErrorMessage("property.validation.length.conflict", new Object[]{shape.getId(), prop.getName(), minLength, maxLength});
        }
        if (shape.isHierarchyInvalid()) {
            return;
        }
        this.checkHierarchyLength(prop, shape, response, minLength, maxLength);
    }

    private void checkHierarchyLength(PropertyShape prop, Shape shape, OperationResponse response, Integer minLength, Integer maxLength) {
        List<Object> parentShapesWithProp = new ArrayList();
        try {
            parentShapesWithProp = shape.getContainedIn().getHierarchy(shape.getId()).stream().filter(hierarchyShape -> !hierarchyShape.getId().equals(shape.getId())).filter(hierarchyShape -> hierarchyShape.getProperty(prop.getName()).isPresent()).collect(Collectors.toList());
        }
        catch (InvalidSchemaException invalidSchemaException) {
            // empty catch block
        }
        for (Shape parent : parentShapesWithProp) {
            PropertyShape parentProp = (PropertyShape)parent.getProperty(prop.getName()).orElseThrow(RuntimeException::new);
            if (null != minLength && parentProp.getMinLength() > minLength) {
                response.addErrorMessage("property.validation.length.invariant", new Object[]{"min", shape.getId(), prop.getName(), minLength, parent.getId(), parentProp.getMinLength()});
            }
            if (null == maxLength || parentProp.getMaxLength() >= maxLength) continue;
            response.addErrorMessage("property.validation.length.invariant", new Object[]{"max", shape.getId(), prop.getName(), maxLength, parent.getId(), parentProp.getMaxLength()});
        }
    }

    private OperationResponse validateNumericalConstraints(PropertyShape prop, Shape shape) {
        OperationResponse localResponse = new OperationResponse();
        ScalarType scalar = prop.getScalarType();
        String qualifiedName = shape.getId() + "." + prop.getName();
        if (this.rangeDefinedForObject(prop) && (!prop.isScalarType() || null != scalar && !NUMERICAL_DATATYPES.contains(scalar.getName()))) {
            localResponse.addWarningMessage("property.validation.minmax.range", new Object[]{qualifiedName, prop.getRange(), NUMERICAL_DATATYPES});
        }
        if (!prop.isScalarType() || localResponse.hasWarnings()) {
            return localResponse;
        }
        ValueConstraint constraintMaxEx = new ValueConstraint(ShaclConstraint.MAX_EXCLUSIVE, qualifiedName, prop.getMaxExclusive(), scalar);
        ValueConstraint constraintMaxIn = new ValueConstraint(ShaclConstraint.MAX_INCLUSIVE, qualifiedName, prop.getMaxInclusive(), scalar);
        ValueConstraint constraintMinEx = new ValueConstraint(ShaclConstraint.MIN_EXCLUSIVE, qualifiedName, prop.getMinExclusive(), scalar);
        ValueConstraint constraintMinIn = new ValueConstraint(ShaclConstraint.MIN_INCLUSIVE, qualifiedName, prop.getMinInclusive(), scalar);
        Set<ValueConstraint> constraints = Stream.of(constraintMaxEx, constraintMaxIn, constraintMinEx, constraintMinIn).collect(Collectors.toSet());
        constraints.forEach(constraint -> constraint.convert(prop.getRange(), localResponse));
        if (!localResponse.getErrors().isEmpty()) {
            return localResponse;
        }
        this.compareValueConstraints(localResponse, constraintMaxEx, constraintMinEx, constraintMaxIn, constraintMinIn);
        if (!localResponse.getErrors().isEmpty()) {
            return localResponse;
        }
        if (!shape.isHierarchyInvalid()) {
            try {
                this.checkParentConstraints(localResponse, shape, prop.getName(), new LinkedList<Shape>(shape.getContainedIn().getHierarchy(shape.getId())), scalar, constraints);
            }
            catch (InvalidSchemaException invalidSchemaException) {
                // empty catch block
            }
        }
        return localResponse;
    }

    private void checkParentConstraints(OperationResponse response, Shape shape, String propName, List<Shape> hierarchy, ScalarType scalar, Set<ValueConstraint> constraints) {
        hierarchy.removeIf(parent -> parent.getId().equals(shape.getId()));
        for (Shape parent2 : hierarchy) {
            Optional parentProperty = parent2.getProperty(propName);
            if (parentProperty.isEmpty()) continue;
            PropertyShape prop = (PropertyShape)parentProperty.get();
            String parentName = parent2.getId() + "." + propName;
            ValueConstraint parentMaxEx = new ValueConstraint(ShaclConstraint.MAX_EXCLUSIVE, parentName, prop.getMaxExclusive(), scalar, true);
            ValueConstraint parentMaxIn = new ValueConstraint(ShaclConstraint.MAX_INCLUSIVE, parentName, prop.getMaxInclusive(), scalar, true);
            ValueConstraint parentMinEx = new ValueConstraint(ShaclConstraint.MIN_EXCLUSIVE, parentName, prop.getMinExclusive(), scalar, true);
            ValueConstraint parentMinIn = new ValueConstraint(ShaclConstraint.MIN_INCLUSIVE, parentName, prop.getMinInclusive(), scalar, true);
            this.compareInheritedValues(response, constraints, parentMaxEx, parentMaxIn, parentMinEx, parentMinIn);
        }
    }

    private void compareInheritedValues(OperationResponse response, Set<ValueConstraint> constraints, ValueConstraint parentMaxEx, ValueConstraint parentMaxIn, ValueConstraint parentMinEx, ValueConstraint parentMinIn) {
        for (ValueConstraint childConstraint : constraints) {
            if (!childConstraint.isPresent()) continue;
            if (childConstraint.getName().equals(ShaclConstraint.MAX_EXCLUSIVE.getLocalName())) {
                this.compareTo(response, childConstraint, parentMaxEx, this.greaterThan(), 0);
                this.compareValueConstraints(response, childConstraint, parentMinEx, parentMaxIn, parentMinIn);
            }
            if (childConstraint.getName().equals(ShaclConstraint.MAX_INCLUSIVE.getLocalName())) {
                this.compareTo(response, childConstraint, parentMaxIn, this.greaterThan(), 0);
                this.compareValueConstraints(response, parentMaxEx, parentMinEx, childConstraint, parentMinIn);
            }
            if (childConstraint.getName().equals(ShaclConstraint.MIN_EXCLUSIVE.getLocalName())) {
                this.compareTo(response, childConstraint, parentMinEx, this.lessThan(), 0);
                this.compareValueConstraints(response, parentMaxEx, childConstraint, parentMaxIn, parentMinIn);
            }
            if (!childConstraint.getName().equals(ShaclConstraint.MIN_INCLUSIVE.getLocalName())) continue;
            this.compareTo(response, childConstraint, parentMinIn, this.lessThan(), 0);
            this.compareValueConstraints(response, parentMaxEx, parentMinEx, parentMaxIn, childConstraint);
        }
    }

    private void compareValueConstraints(OperationResponse response, ValueConstraint constraintMaxEx, ValueConstraint constraintMinEx, ValueConstraint constraintMaxIn, ValueConstraint constraintMinIn) {
        if (constraintMaxEx.isPresent()) {
            this.compareTo(response, constraintMaxEx, constraintMaxIn, this.lessThan(), 1);
            this.compareTo(response, constraintMaxEx, constraintMinIn, this.lessThan(), 1);
            this.compareTo(response, constraintMaxEx, constraintMinEx, this.lessThan(), 1);
        }
        if (constraintMaxIn.isPresent()) {
            this.compareTo(response, constraintMaxIn, constraintMaxEx, this.greaterThan(), 0);
            this.compareTo(response, constraintMaxIn, constraintMinEx, this.greaterThan(), 1);
            this.compareTo(response, constraintMaxIn, constraintMinIn, this.lessThan(), 0);
        }
        if (constraintMinEx.isPresent()) {
            this.compareTo(response, constraintMinEx, constraintMaxEx, this.greaterThan(), -1);
            this.compareTo(response, constraintMinEx, constraintMaxIn, this.greaterThan(), -1);
            this.compareTo(response, constraintMinEx, constraintMinIn, this.greaterThan(), -1);
        }
        if (constraintMinIn.isPresent()) {
            this.compareTo(response, constraintMinIn, constraintMaxEx, this.greaterThan(), -1);
            this.compareTo(response, constraintMinIn, constraintMaxIn, this.greaterThan(), 0);
            this.compareTo(response, constraintMinIn, constraintMinEx, this.lessThan(), 1);
        }
    }

    private void compareTo(OperationResponse response, ValueConstraint source, ValueConstraint target, BiPredicate<Integer, Integer> comparison, int relation) {
        if (target.isPresent() && !source.isParent() && !target.isViolatedBy(source) && comparison.test(source.compareTo(target), relation)) {
            source.addViolator(target);
            target.addViolator(source);
            if (null == target.getTargetName() && !target.isParent()) {
                response.addErrorMessage("property.validation.minmax.conflict", new Object[]{source.getTargetName(), source.getName(), source.getRawValue(), target.getName(), target.getRawValue()});
            } else {
                response.addErrorMessage("property.validation.minmax.parent.conflict", new Object[]{source.getTargetName(), source.getName(), source.getRawValue(), target.getTargetName(), target.getName(), target.getRawValue()});
            }
        }
    }

    private boolean rangeDefinedForObject(PropertyShape prop) {
        return null != prop.getMaxExclusive() || null != prop.getMinExclusive() || null != prop.getMaxInclusive() || null != prop.getMinInclusive();
    }

    private BiPredicate<Integer, Integer> greaterThan() {
        return (source, target) -> source > target;
    }

    private BiPredicate<Integer, Integer> lessThan() {
        return (source, target) -> source < target;
    }

    private void validateSetConstraints(PropertyShape prop, Shape shape, OperationResponse response) {
        List valuesInSet = prop.getValuesIn();
        if (null != valuesInSet && !valuesInSet.isEmpty()) {
            if (prop.isScalarType()) {
                if (valuesInSet.size() == 1) {
                    valuesInSet.forEach(value -> this.checkStringAmbiguities(prop, shape, response, value));
                }
                valuesInSet.forEach(value -> this.checkConversionErrors(prop, shape, response, value));
            } else {
                valuesInSet.forEach(value -> this.checkIriValid(prop, shape, response, value));
            }
        }
    }

    private void checkIriValid(PropertyShape prop, Shape shape, OperationResponse response, Object value) {
        String errorTemplate = null;
        if (!(value instanceof String)) {
            errorTemplate = "property.validation.set.datatypes.object";
        } else if (((String)value).contains("/") && !ValidationPatterns.isValidIri((String)((String)value))) {
            errorTemplate = "property.validation.set.datatypes.object.invalid.iri";
        } else {
            try {
                shape.getContainedIn().getContainedIn().getPrefixes().toIri((String)value);
            }
            catch (InvalidSchemaException ise) {
                errorTemplate = "property.validation.set.datatypes.object.invalid.pfx";
            }
        }
        if (null != errorTemplate) {
            response.addErrorMessage(errorTemplate, new Object[]{shape.getId(), prop.getName(), prop.getRange(), value});
        }
    }

    private void checkStringAmbiguities(PropertyShape prop, Shape shape, OperationResponse response, Object value) {
        if (prop.getScalarType().treatedAsString() && value instanceof String && ((String)value).contains(" ")) {
            response.addWarningMessage((Serializable)((Object)ErrorMessages.get((String)"property.validation.set.format", (Object[])new Object[]{shape.getId(), prop.getName(), prop.getRange(), value})));
        }
    }

    private void checkConversionErrors(PropertyShape prop, Shape shape, OperationResponse response, Object value) {
        try {
            this.converter.convert(value, prop.getScalarType());
        }
        catch (ValueConversionException | ArithmeticException | IllegalArgumentException ex) {
            String errorTemplate = "property.validation.set.datatypes";
            if (value instanceof Date) {
                errorTemplate = "property.validation.set.datatypes.date";
            }
            response.addErrorMessage(errorTemplate, new Object[]{shape.getId(), prop.getName(), prop.getScalarType().getName(), value});
        }
    }

    private class ValueConstraint
    implements Comparable {
        private final String name;
        private Comparable value;
        private Object rawValue;
        private Set<String> violatedBy = new HashSet<String>();
        private final boolean parent;
        private final ScalarType scalar;
        private final String targetName;

        ValueConstraint(ShaclConstraint constraint, String targetName, Object rawValue, ScalarType scalar) {
            this(constraint, targetName, rawValue, scalar, false);
        }

        ValueConstraint(ShaclConstraint constraint, String targetName, Object rawValue, ScalarType scalar, boolean parent) {
            this.parent = parent;
            this.name = constraint.getLocalName();
            this.rawValue = rawValue;
            this.scalar = scalar;
            this.targetName = targetName;
        }

        public int compareTo(Object other) {
            if (!(other instanceof ValueConstraint)) {
                throw new IllegalArgumentException("Comparing ValueConstraint to raw value.");
            }
            if (((ValueConstraint)other).isParent()) {
                ((ValueConstraint)other).convertSilent(this);
            }
            return this.value.compareTo(((ValueConstraint)other).value);
        }

        public boolean equals(Object other) {
            return 0 == this.compareTo(other);
        }

        public int hashCode() {
            return Objects.hash(this.targetName, this.scalar, this.name, this.rawValue);
        }

        public boolean isPresent() {
            return null != this.rawValue;
        }

        public Comparable getValue() {
            return this.value;
        }

        public String getName() {
            return this.name;
        }

        public void convertSilent(ValueConstraint other) {
            Literal literal = (Literal)PropertyConstraintsValidator.this.converter.convert(this.rawValue, this.scalar);
            try {
                this.value = !(this.rawValue instanceof String) ? new BigDecimal(this.rawValue.toString()) : new BigDecimal(literal.calendarValue().toGregorianCalendar().getTimeInMillis());
            }
            catch (Exception conversionEx) {
                this.value = other.getValue();
            }
        }

        public void convert(String range, OperationResponse errorReport) {
            if (null != this.rawValue) {
                try {
                    Literal literal = (Literal)PropertyConstraintsValidator.this.converter.convert(this.rawValue, this.scalar);
                    if (NUMBER_DATATYPES.contains(range) || !(this.rawValue instanceof String)) {
                        if (!"year".equals(this.scalar.getName()) && PropertyConstraintsValidator.G_YEAR_DATATYPE.equals(literal.getDatatype().toString())) {
                            errorReport.addErrorMessage("property.validation.minmax.dates.as.strings", new Object[]{this.targetName, this.scalar.getName(), this.getName(), this.rawValue, DATE_DATATYPES});
                        }
                        this.value = new BigDecimal(this.rawValue.toString());
                    } else {
                        this.value = new BigDecimal(literal.calendarValue().toGregorianCalendar().getTimeInMillis());
                    }
                }
                catch (ValueConversionException | ArithmeticException | IllegalArgumentException ex) {
                    this.addDatatypeError(range, errorReport);
                }
                catch (ClassCastException cce) {
                    throw new IllegalArgumentException("Error while trying to validate SOML value constraints. Value not comparable.", cce);
                }
            }
        }

        private void addDatatypeError(String range, OperationResponse errorReport) {
            if (this.rawValue instanceof Date) {
                errorReport.addErrorMessage("property.validation.minmax.dates.as.strings", new Object[]{this.targetName, this.scalar.getName(), this.getName(), this.rawValue, DATE_DATATYPES});
            } else {
                errorReport.addErrorMessage("property.validation.minmax.datatypes", new Object[]{this.targetName, range, this.getName(), this.rawValue});
            }
        }

        public Object getRawValue() {
            return this.rawValue;
        }

        public void addViolator(ValueConstraint other) {
            this.violatedBy.add(other.getName());
        }

        public boolean isViolatedBy(ValueConstraint other) {
            return this.violatedBy.contains(other.getName());
        }

        public boolean isParent() {
            return this.parent;
        }

        public String getTargetName() {
            return this.targetName;
        }
    }
}

