/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ObjectNameValidator
implements SchemaValidator {
    public OperationResponse validate(SomlSchema somlSchema) {
        OperationResponse operationResponse = new OperationResponse();
        Shapes objects = somlSchema.getObjects();
        for (Shape object : objects.values()) {
            if (Boolean.TRUE.equals(object.isSynthetic()) || object.isHierarchyInvalid()) continue;
            Map<String, List<Shape>> inheritedNames = object.getParents().filter(parent -> parent.getName() != null).collect(Collectors.groupingBy(Shape::getName));
            if (!object.isTracked("name") && inheritedNames.size() > 1) {
                operationResponse.addWarningMessage("warn.colliding.name.inherited.from.multiple.parents", new Object[]{object.getId(), this.listCollidingNamesFromParents(inheritedNames)});
            }
            if (!object.isTracked("name") || object.getNameTemplate() == null || !object.getNameTemplate().hasArgs()) continue;
            operationResponse.addErrorMessage("invalid.use.of.type.name.arguments", new Object[]{object.getId(), object.getName()});
        }
        return operationResponse;
    }

    private String listCollidingNamesFromParents(Map<String, List<Shape>> inheritedNames) {
        StringBuilder result = new StringBuilder();
        inheritedNames.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> result.append(" name: ").append((String)entry.getKey()).append(" from parents: ").append(((List)entry.getValue()).stream().map(Shape::getId).collect(Collectors.joining(", "))).append(";"));
        return result.toString();
    }
}

