/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import java.util.Set;
import java.util.stream.Collectors;

public class ObjectKindValidator
implements SchemaValidator {
    public OperationResponse validate(SomlSchema somlSchema) {
        OperationResponse operationResponse = new OperationResponse();
        Shapes objects = somlSchema.getObjects();
        for (Shape object : objects.values()) {
            if (object.isHierarchyInvalid()) continue;
            this.checkIfSuperClassesAreAbstract(operationResponse, object);
        }
        return operationResponse;
    }

    private void checkIfSuperClassesAreAbstract(OperationResponse operationResponse, Shape object) {
        Set noneAbstractParents;
        if (object.getInherits() != null && !(noneAbstractParents = object.getParents().filter(shape -> !shape.isAbstract()).map(Shape::getId).collect(Collectors.toSet())).isEmpty()) {
            Set invalidParents = noneAbstractParents;
            if (noneAbstractParents.size() == 1) {
                invalidParents = noneAbstractParents.iterator().next();
            }
            operationResponse.addErrorMessage("superclasses.should.be.defined.abstract", new Object[]{object.getId(), invalidParents});
        }
    }
}

