/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import com.ontotext.models.search.Utils;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.tuple.Pair;

public class NestedSearchIndexValidator
implements SchemaValidator {
    public OperationResponse validate(SomlSchema somlSchema) {
        OperationResponse response = new OperationResponse();
        somlSchema.getObjects().values().stream().filter(Shape::isAbstract).filter(Shape::isSearchable).forEach(shape -> this.validateSearchableAbstractShape((Shape)shape, response));
        return response;
    }

    private void validateSearchableAbstractShape(Shape shape, OperationResponse response) {
        shape.getNestedSearchShapes().flatMap(child -> child.getOwnSearchableProperties()).collect(Collectors.groupingBy(this.toGqlPropName())).entrySet().stream().filter(propName -> ((List)propName.getValue()).size() > 1).forEach(this.raiseErrorForConflict(shape, response));
    }

    private Consumer<Map.Entry<String, List<PropertyShape>>> raiseErrorForConflict(Shape shape, OperationResponse response) {
        return conflict -> response.addErrorMessage("error.property.nested.conflict", new Object[]{((List)conflict.getValue()).stream().map(prop -> Pair.of((Object)prop.getContainedIn().getContainedIn().getId(), (Object)prop.getName())).collect(Collectors.toList()), conflict.getKey(), shape.getId()});
    }

    private Function<PropertyShape, String> toGqlPropName() {
        return shape -> Utils.toGraphqlNestedProperty((Shape)shape.getContainedIn().getContainedIn(), (PropertyShape)shape);
    }
}

