/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.Shapes;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class MultipleInheritanceValidator
implements SchemaValidator {
    private static final Map<String, Function<PropertyShape, Object>> fieldsAccessors = new LinkedHashMap<String, Function<PropertyShape, Object>>();

    public OperationResponse validate(SomlSchema somlSchema) {
        OperationResponse operationResponse = new OperationResponse();
        Shapes objects = somlSchema.getObjects();
        objects.values().stream().filter(this::shapeHasMultipleParents).forEach(shape -> this.warnForCollidingProperties((Shape)shape, operationResponse));
        return operationResponse;
    }

    private boolean shapeHasMultipleParents(Shape shape) {
        return shape.getInheritsAsList().size() > 1;
    }

    private void warnForCollidingProperties(Shape shape, OperationResponse operationResponse) {
        Map<String, List<Shape>> parentPropertyMap = this.collectCommonParentProperties(shape);
        parentPropertyMap.forEach((propertyName, parentsList) -> this.warnForCollidingPropertyFields(shape, operationResponse, (String)propertyName, (List<Shape>)parentsList, parentPropertyMap));
    }

    private Map<String, List<Shape>> collectCommonParentProperties(Shape shape) {
        LinkedHashMap<String, List<Shape>> result = new LinkedHashMap<String, List<Shape>>();
        shape.getParents().forEach(parent -> this.populateProperties((Shape)parent, (Map<String, List<Shape>>)result));
        result.values().removeIf(list -> list.size() < 2);
        return result;
    }

    private void populateProperties(Shape shape, Map<String, List<Shape>> result) {
        shape.getAllProperties().values().forEach(property -> result.computeIfAbsent(property.getName(), k -> new ArrayList()).add(shape));
    }

    private void warnForCollidingPropertyFields(Shape shape, OperationResponse operationResponse, String propertyName, List<Shape> parentsList, Map<String, List<Shape>> parentPropertyMap) {
        Map<String, Set<Object>> propertyFields = this.collectCommonPropertyFields(shape, propertyName, parentsList);
        this.generateMessageForCollidingPropertyFields(shape.getId(), propertyName, propertyFields, operationResponse, parentPropertyMap);
    }

    private Map<String, Set<Object>> collectCommonPropertyFields(Shape shape, String propertyName, List<Shape> parentsList) {
        LinkedHashMap<String, Set<Object>> result = new LinkedHashMap<String, Set<Object>>();
        parentsList.forEach(parent -> {
            PropertyShape prop = (PropertyShape)parent.getAllProperties().get((Object)propertyName);
            this.populateCommonPropertyFieldsMap(shape, propertyName, result, prop);
        });
        return result;
    }

    private void populateCommonPropertyFieldsMap(Shape shape, String propertyName, Map<String, Set<Object>> result, PropertyShape prop) {
        fieldsAccessors.forEach((fieldName, fieldAccessor) -> {
            PropertyShape propertyShape = (PropertyShape)shape.getProps().get((Object)propertyName);
            if (propertyShape == null || !propertyShape.isTracked(fieldName)) {
                Object fieldValue = fieldAccessor.apply(prop);
                if (fieldValue instanceof Collection && ((Collection)fieldValue).isEmpty()) {
                    fieldValue = null;
                }
                result.computeIfAbsent((String)fieldName, k -> new LinkedHashSet()).add(fieldValue);
            }
        });
    }

    private void generateMessageForCollidingPropertyFields(String shapeId, String propertyName, Map<String, Set<Object>> propertyFields, OperationResponse operationResponse, Map<String, List<Shape>> parentPropertyMap) {
        propertyFields.values().removeIf(set -> set.size() < 2);
        if (propertyFields.isEmpty()) {
            return;
        }
        operationResponse.addWarningMessage("warn.colliding.property.inherited.form.multiple.parents", new Object[]{propertyName, shapeId, parentPropertyMap.get(propertyName).stream().map(Shape::getId).collect(Collectors.joining(", ")), String.join((CharSequence)", ", propertyFields.keySet())});
    }

    static {
        fieldsAccessors.put("inverseOf", PropertyShape::getInverseOf);
        fieldsAccessors.put("inverseAlias", PropertyShape::getInverseAlias);
        fieldsAccessors.put("pattern", PropertyShape::getPattern);
        fieldsAccessors.put("rdfProp", PropertyShape::getRdfProp);
        fieldsAccessors.put("lang", PropertyShape::getLangConfig);
        fieldsAccessors.put("maxLength", PropertyShape::getMaxLength);
        fieldsAccessors.put("minLength", PropertyShape::getMinLength);
        fieldsAccessors.put("maxInclusive", PropertyShape::getMaxInclusive);
        fieldsAccessors.put("minInclusive", PropertyShape::getMinInclusive);
        fieldsAccessors.put("maxExclusive", PropertyShape::getMaxExclusive);
        fieldsAccessors.put("minExclusive", PropertyShape::getMinExclusive);
        fieldsAccessors.put("valuesIn", PropertyShape::getValuesIn);
        fieldsAccessors.put("equals", PropertyShape::getEquals);
    }
}

