/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.validator;

import com.ontotext.models.ErrorMessages;
import com.ontotext.models.LangConfig;
import com.ontotext.models.Properties;
import com.ontotext.models.PropertyShape;
import com.ontotext.models.Shape;
import com.ontotext.models.SomlSchema;
import com.ontotext.models.extensions.OperationResponse;
import com.ontotext.models.extensions.SchemaValidator;
import com.ontotext.models.query.LangFilter;
import com.ontotext.models.query.LangValidator;
import java.io.Serializable;
import java.util.Collections;
import java.util.Objects;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class LangConfigValidator
implements SchemaValidator {
    public OperationResponse validate(SomlSchema somlSchema) {
        OperationResponse response = new OperationResponse();
        somlSchema.getConfig().getLang().ifPresent(langConfig -> this.validateLanguageConfig(response, (LangConfig)langConfig, null));
        this.validateProperties(somlSchema.getProperties(), response);
        for (Shape shape : somlSchema.getObjects().values()) {
            if (shape.isSynthetic().booleanValue()) continue;
            this.validateProperties(shape.getProps(), response);
        }
        return response;
    }

    private void validateProperties(Properties properties, OperationResponse response) {
        for (PropertyShape property : properties.values()) {
            if (!(!property.isTracked("lang") || property.isScalarType() && property.getScalarType().isLangStringSupported())) {
                Shape containedIn = properties.getContainedIn();
                if (containedIn == null) {
                    response.addErrorMessage("property.lang.property.not.allowed", new Object[]{property.getName()});
                } else if (!Objects.equals(property.getAsAbsoluteRdfProp(), containedIn.getNameIri())) {
                    response.addErrorMessage("propertyOfType.lang.property.not.allowed", new Object[]{property.getName(), containedIn.getId()});
                }
            }
            if (!property.isTracked("lang") || !property.isScalarType()) continue;
            this.validateLanguageConfig(response, property.getLangConfig(), property);
        }
    }

    private void validateLanguageConfig(OperationResponse response, LangConfig langConfig, PropertyShape property) {
        if (langConfig == null) {
            return;
        }
        if (langConfig.isTracked("fetch") && StringUtils.isNotBlank((CharSequence)langConfig.getFetch())) {
            try {
                LangFilter.parseForFetching((String)langConfig.getFetch());
            }
            catch (IllegalArgumentException iae) {
                this.reportParsingError(response, iae, "fetch", langConfig.getFetch(), property);
            }
        }
        if (langConfig.isTracked("validate") && StringUtils.isNotBlank((CharSequence)langConfig.getValidate())) {
            try {
                LangValidator validation = LangFilter.parseForValidation((String)langConfig.getValidate());
                if (langConfig.getValidate().contains("~")) {
                    this.reportUnsupportedWildcardCharacter(response, langConfig, property);
                }
                this.checkForInvalidUseOfNone(response, property, validation);
            }
            catch (IllegalArgumentException iae) {
                this.reportParsingError(response, iae, "validate", langConfig.getValidate(), property);
            }
        }
        if (langConfig.isTracked("implicit") && StringUtils.isNotBlank((CharSequence)langConfig.getImplicit())) {
            try {
                LangFilter.parseForImplicit((String)langConfig.getImplicit());
            }
            catch (IllegalArgumentException iae) {
                this.reportParsingError(response, iae, "implicit", langConfig.getImplicit(), property);
            }
        }
        this.validateEffectiveImplicitConfig(response, langConfig, property);
    }

    private void reportParsingError(OperationResponse response, IllegalArgumentException iae, String langField, String configValue, PropertyShape property) {
        Object errorMessage = "property.lang.error";
        if (property == null) {
            errorMessage = (String)errorMessage + ".global";
            response.addErrorMessage((String)errorMessage, new Object[]{langField, configValue, iae.getMessage()});
        } else {
            Shape shape;
            Shape shape2 = shape = property.getContainedIn() != null ? property.getContainedIn().getContainedIn() : null;
            if (shape != null) {
                errorMessage = (String)errorMessage + ".inType";
                response.addErrorMessage((String)errorMessage, new Object[]{property.getName(), shape.getId(), langField, configValue, iae.getMessage()});
            } else {
                response.addErrorMessage((String)errorMessage, new Object[]{property.getName(), langField, configValue, iae.getMessage()});
            }
        }
    }

    private void reportUnsupportedWildcardCharacter(OperationResponse response, LangConfig langConfig, PropertyShape property) {
        String message = property == null ? ErrorMessages.get((String)"property.lang.validation.shacl.global", (Object[])new Object[]{langConfig.getValidate()}) : (property.getContainedIn() == null ? ErrorMessages.get((String)"property.lang.validation.shacl.schema", (Object[])new Object[]{property.getName(), langConfig.getValidate()}) : ErrorMessages.get((String)"property.lang.validation.shacl", (Object[])new Object[]{property.getName(), property.getContainedIn().getContainedIn().getId(), langConfig.getValidate()}));
        response.addWarningMessage((Serializable)((Object)message));
    }

    private void validateEffectiveImplicitConfig(OperationResponse response, LangConfig langConfig, PropertyShape property) {
        if (StringUtils.isNotBlank((CharSequence)langConfig.getImplicit()) && langConfig.getValidate() != null) {
            try {
                LangValidator validation = LangFilter.parseForValidation((String)langConfig.getValidate());
                Consumer<String> errorBuilder = this.buildImplicitValidationError(response, langConfig, property);
                LangFilter.parseForImplicit((String)langConfig.getEffectiveImplicit());
                validation.validate(Collections.singletonList(Pair.of((Object)"some value", (Object)langConfig.getEffectiveImplicit())), notAllowed -> errorBuilder.accept("property.lang.implicit.not.allowed"), excluded -> errorBuilder.accept("property.lang.implicit.excluded"));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private Consumer<String> buildImplicitValidationError(OperationResponse response, LangConfig langConfig, PropertyShape property) {
        return message -> {
            if (property == null) {
                response.addErrorMessage(message + ".global", new Object[]{langConfig.getImplicit(), langConfig.getValidate()});
            } else {
                Shape shape = this.getContainedInShape(property);
                if (shape != null) {
                    response.addErrorMessage(message + ".inType", new Object[]{property.getName(), shape.getId(), langConfig.getImplicit(), langConfig.getValidate()});
                } else {
                    response.addErrorMessage(message, new Object[]{property.getName(), langConfig.getImplicit(), langConfig.getValidate()});
                }
            }
        };
    }

    private void checkForInvalidUseOfNone(OperationResponse response, PropertyShape property, LangValidator validation) {
        if (property != null && property.getScalarType().isLangStringExclusive() && validation.getTokens().stream().anyMatch(token -> token.getType() == LangFilter.TokenType.NO_LANG)) {
            Shape shape = this.getContainedInShape(property);
            if (shape != null) {
                response.addErrorMessage("property.lang.validation.notAllowedNone.inType", new Object[]{property.getName(), shape.getId(), property.getRange()});
            } else {
                response.addErrorMessage("property.lang.validation.notAllowedNone", new Object[]{property.getName(), property.getRange()});
            }
        }
    }

    private Shape getContainedInShape(PropertyShape property) {
        Properties properties = property.getContainedIn();
        if (properties == null) {
            return null;
        }
        return properties.getContainedIn();
    }
}

