/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync;

import com.ontotext.trree.plugin.externalsync.ExternalSyncPlugin;
import com.ontotext.trree.plugin.externalsync.api.ConnectorServerException;
import com.ontotext.trree.plugin.externalsync.api.ConnectorUserException;
import com.ontotext.trree.plugin.externalsync.api.ExternalStore;
import com.ontotext.trree.plugin.externalsync.api.ExternalStoreStatus;
import com.ontotext.trree.plugin.externalsync.config.Option;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.config.OptionsParser;
import com.ontotext.trree.sdk.BadRequestException;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.Statements;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.io.FileUtils;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

final class StoresManager {
    private final ExternalSyncPlugin plugin;
    private Map<String, ExternalStore> transactionCreatedStores;
    private Map<String, Runnable> transactionCreatedStoresRegisterFunctions;
    private Map<String, ExternalStore> stores = new HashMap<String, ExternalStore>();

    StoresManager(ExternalSyncPlugin plugin) {
        this.plugin = plugin;
    }

    private synchronized Map<String, Options> loadStoresOptions(List<Option<?>> validOptions) {
        HashMap<String, Options> hashMap;
        File configFile = new File(this.plugin.getDataDir(), "config.json");
        if (!configFile.exists()) {
            return Collections.emptyMap();
        }
        JSONParser parser = new JSONParser();
        FileReader configReader = new FileReader(configFile);
        try {
            HashMap<String, Options> storesOptions = new HashMap<String, Options>();
            OptionsParser optionsParser = new OptionsParser(validOptions);
            JSONObject jobj = (JSONObject)parser.parse((Reader)configReader);
            for (Object entry : jobj.entrySet()) {
                String storeName = (String)((Map.Entry)entry).getKey();
                if (storeName.startsWith("_")) continue;
                Options storeOptions = optionsParser.parseFromJSONObject((JSONObject)((Map.Entry)entry).getValue());
                storesOptions.put(storeName, storeOptions);
            }
            hashMap = storesOptions;
        }
        catch (Throwable throwable) {
            try {
                try {
                    configReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ParseException e) {
                throw new BadRequestException("Unable to load or parse configuration file", e);
            }
        }
        configReader.close();
        return hashMap;
    }

    private synchronized Map<String, JSONObject> loadDynamicSettings() {
        HashMap<String, JSONObject> hashMap;
        File configFile = new File(this.plugin.getDataDir(), "dynamic_settings.json");
        if (!configFile.exists()) {
            return Collections.emptyMap();
        }
        JSONParser parser = new JSONParser();
        FileReader configReader = new FileReader(configFile);
        try {
            HashMap<String, JSONObject> dynamicSetttings = new HashMap<String, JSONObject>();
            JSONObject jobj = (JSONObject)parser.parse((Reader)configReader);
            for (Object entry : jobj.entrySet()) {
                String storeName = (String)((Map.Entry)entry).getKey();
                dynamicSetttings.put(storeName, (JSONObject)((Map.Entry)entry).getValue());
            }
            hashMap = dynamicSetttings;
        }
        catch (Throwable throwable) {
            try {
                try {
                    configReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ParseException e) {
                throw new BadRequestException("Unable to load or parse dynamic settings file", e);
            }
        }
        configReader.close();
        return hashMap;
    }

    void loadStores(PluginConnection pluginConnection) {
        this.stores = new ConcurrentHashMap<String, ExternalStore>();
        Map<String, Options> storesOptions = this.loadStoresOptions(this.plugin.getPossibleOptions(true));
        Map<String, JSONObject> dynamicSettings = this.loadDynamicSettings();
        for (Map.Entry<String, Options> entry : storesOptions.entrySet()) {
            String storeName = entry.getKey();
            Options storeOptions = entry.getValue();
            ExternalStore handler = this.plugin.openExistingStore(storeName, storeOptions, pluginConnection);
            JSONObject dSettings = dynamicSettings.get(storeName);
            if (dSettings != null) {
                handler.setSettingsFromJSON(dSettings);
            }
            handler.getStatus().status = ExternalStoreStatus.Status.BUILT;
            this.stores.put(handler.getName(), handler);
            this.plugin.getLogger().info("Loaded connector {}", (Object)handler.getName());
        }
    }

    Map<String, ExternalStore> getStores() {
        return this.stores;
    }

    void shutdownStores() {
        for (ExternalStore handler : this.stores.values()) {
            try {
                handler.close();
            }
            catch (Exception e) {
                this.plugin.getLogger().warn("Failed to close connector {}, message is {}", (Object)handler.getName(), (Object)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void createStore(IRI uri, Options options, PluginConnection pluginConnection, Entities entitiesForCreation, Statements statementsForCreation) {
        String storeName = options.getStoreName();
        if (storeName.startsWith("_")) {
            throw new ConnectorUserException("Connector name may not start with an underscore.");
        }
        if (this.stores.containsKey(storeName)) {
            throw new ConnectorUserException("Connector already exists: " + storeName + ". To recreate the connector you need to drop it first.");
        }
        if (this.transactionCreatedStores.containsKey(storeName)) {
            throw new ConnectorUserException("Connector with that name already requested in the same transaction: " + storeName);
        }
        File storeDir = new File(this.plugin.getDataDir(), storeName);
        if (storeDir.exists()) {
            throw new ConnectorServerException("Connector directory already exists: " + storeDir.getName());
        }
        try {
            ExternalStore store = this.plugin.createNewStore(storeName, options, pluginConnection, entitiesForCreation);
            this.transactionCreatedStores.put(storeName, store);
            this.transactionCreatedStoresRegisterFunctions.put(storeName, () -> this.registerStore(uri, store, pluginConnection.getEntities()));
            this.plugin.entityUpdateListener.scheduleSyncAllEntities(store, pluginConnection, entitiesForCreation, statementsForCreation, false);
        }
        catch (RuntimeException e) {
            try {
                FileUtils.deleteDirectory((File)storeDir);
            }
            catch (IOException iOException) {}
            finally {
                throw e;
            }
        }
    }

    void repairStore(ExternalStore store, PluginConnection pluginConnection, Entities entitiesForCreation, Statements statementsForCreation) {
        this.plugin.entityUpdateListener.scheduleSyncAllEntities(store, pluginConnection, entitiesForCreation, statementsForCreation, true);
        this.plugin.saveStoresOptions();
    }

    private void registerStore(IRI uri, ExternalStore store, Entities entities) {
        long uriId = entities.put((Value)uri, Entities.Scope.SYSTEM);
        this.plugin.searchPredicates.put(uriId, (Object)store);
        this.plugin.entityUpdateListener.addIndexHandler(store);
        this.plugin.saveStoresOptions();
    }

    void removeStore(ExternalStore store, IRI uri, Entities entities) {
        this.stores.remove(store.getName());
        this.plugin.searchPredicates.remove(entities.resolve((Value)uri));
        this.plugin.entityUpdateListener.removeIndexHandler(store);
        this.plugin.saveStoresOptions();
    }

    void beginTransaction() {
        this.transactionCreatedStores = new LinkedHashMap<String, ExternalStore>();
        this.transactionCreatedStoresRegisterFunctions = new LinkedHashMap<String, Runnable>();
    }

    void commitTransaction() {
        this.stores.putAll(this.transactionCreatedStores);
        this.transactionCreatedStoresRegisterFunctions.forEach((storeName, function) -> function.run());
        this.transactionCreatedStores = null;
        this.transactionCreatedStoresRegisterFunctions = null;
        this.saveDynamicSettings();
    }

    void abortTransaction() {
        Map<String, JSONObject> dynamicSettings = this.loadDynamicSettings();
        for (ExternalStore handler : this.stores.values()) {
            JSONObject dSettings = dynamicSettings.get(handler.getName());
            if (dSettings == null) continue;
            handler.setSettingsFromJSON(dSettings);
        }
    }

    void cleanupAbortedTransaction() {
        if (this.transactionCreatedStores != null) {
            this.transactionCreatedStores.forEach((storeName, store) -> {
                try {
                    store.remove(true);
                }
                catch (Exception e) {
                    this.plugin.getLogger().warn("[{}] Error while cleaning up index", storeName);
                }
            });
        }
        this.transactionCreatedStores = null;
        this.transactionCreatedStoresRegisterFunctions = null;
        this.saveDynamicSettings();
    }

    private void saveDynamicSettings() {
        for (ExternalStore store : this.stores.values()) {
            if (!store.settingsHaveChanged()) continue;
            this.plugin.saveDynamicSettings();
            break;
        }
    }
}

