/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.util;

import com.ontotext.graphdb.raft.grpc.RaftRpcConnectionException;
import io.grpc.stub.ServerCallStreamObserver;
import io.grpc.stub.StreamObserver;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamingResponseObserver<V>
extends ServerCallStreamObserver<V> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final StreamObserver<V> delegate;
    private final boolean isServerObserver;
    private final Lock serializationLock;
    private volatile boolean completed;

    public StreamingResponseObserver(StreamObserver<V> delegate) {
        this.delegate = delegate;
        this.serializationLock = new ReentrantLock(true);
        this.isServerObserver = delegate instanceof ServerCallStreamObserver;
    }

    public void onNext(V value) {
        this.serializationLock.lock();
        try {
            while (!this.isReady() && !Thread.currentThread().isInterrupted()) {
                if (this.isCancelled() || this.completed) {
                    throw new RaftRpcConnectionException("Connection is already closed");
                }
                Thread.onSpinWait();
            }
            this.delegate.onNext(value);
        }
        finally {
            this.serializationLock.unlock();
        }
    }

    public void onError(Throwable throwable) {
        this.completed = true;
        this.delegate.onError(throwable);
    }

    public void onCompleted() {
        this.serializationLock.lock();
        try {
            if (this.completed) {
                LOGGER.warn("Response observer already completed!");
                return;
            }
            this.completed = true;
            this.delegate.onCompleted();
        }
        finally {
            this.serializationLock.unlock();
        }
    }

    public boolean isCancelled() {
        if (this.isServerObserver) {
            boolean cancelled = ((ServerCallStreamObserver)this.delegate).isCancelled();
            if (cancelled) {
                this.completed = true;
            }
            return cancelled;
        }
        return false;
    }

    public void setOnCancelHandler(Runnable onCancelHandler) {
        if (this.isServerObserver) {
            ((ServerCallStreamObserver)this.delegate).setOnCancelHandler(onCancelHandler);
        }
    }

    public void setCompression(String compression) {
        if (this.isServerObserver) {
            ((ServerCallStreamObserver)this.delegate).setCompression(compression);
        }
    }

    public boolean isReady() {
        if (this.isServerObserver) {
            return ((ServerCallStreamObserver)this.delegate).isReady();
        }
        return true;
    }

    public void setOnReadyHandler(Runnable onReadyHandler) {
        if (this.isServerObserver) {
            ((ServerCallStreamObserver)this.delegate).setOnReadyHandler(onReadyHandler);
        }
    }

    public void disableAutoInboundFlowControl() {
        if (this.isServerObserver) {
            ((ServerCallStreamObserver)this.delegate).disableAutoInboundFlowControl();
        }
    }

    public void request(int count) {
        if (this.isServerObserver) {
            ((ServerCallStreamObserver)this.delegate).request(count);
        }
    }

    public void setMessageCompression(boolean enable) {
        if (this.isServerObserver) {
            ((ServerCallStreamObserver)this.delegate).setMessageCompression(enable);
        }
    }

    public boolean isCompleted() {
        return this.completed;
    }
}

