/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.storage.log.persistent;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.raft.grpc.AppendEntry;
import com.ontotext.graphdb.raft.grpc.BackupEntry;
import com.ontotext.graphdb.raft.grpc.ConfigEntry;
import com.ontotext.graphdb.raft.node.concurrent.SemaphoreLock;
import com.ontotext.graphdb.raft.storage.LogChannel;
import com.ontotext.graphdb.raft.storage.LogEntry;
import com.ontotext.graphdb.raft.storage.TransactionLogException;
import com.ontotext.graphdb.raft.storage.log.AbstractTransactionLog;
import com.ontotext.graphdb.raft.storage.log.persistent.LogIndex;
import com.ontotext.graphdb.raft.storage.log.persistent.PersistentLogChannel;
import com.ontotext.graphdb.raft.storage.log.persistent.PersistentLogEntry;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;

public class PersistentTransactionLog
extends AbstractTransactionLog {
    private static final AppendEntry EMPTY_METADATA = AppendEntry.newBuilder().build();
    private final Map<Integer, LogChannel> channelMap;
    private final Map<Long, PersistentLogEntry> lastLogEntries = new ConcurrentHashMap<Long, PersistentLogEntry>();
    private final LogIndex logIndex;
    private final String transactionLogDir;
    private volatile long startPos;
    private volatile long activeLogTerm;
    private volatile LogChannel activeChannel;

    public PersistentTransactionLog() {
        this(Config.getProperty((String)"graphdb.raft.transaction.log.dir", (String)Paths.get(Config.getDataDirectory(), "raft", "transaction-log").toString()));
    }

    @VisibleForTesting
    public PersistentTransactionLog(String dir) {
        this.channelMap = new ConcurrentHashMap<Integer, LogChannel>();
        this.transactionLogDir = dir;
        this.logIndex = new LogIndex(this.transactionLogDir, this.channelMap, this.lastLogEntries);
    }

    @Override
    public void initializeUnsafe() {
        block13: {
            this.channelIds.clear();
            this.channelRepoIds.clear();
            this.channelPermits.clear();
            this.channelMap.clear();
            this.lastLogEntries.clear();
            try {
                this.initializeLogChannels();
            }
            catch (Exception e) {
                this.initialized = false;
                if (e.getCause() instanceof NoSuchFileException) {
                    this.logger.error("Could not determine whether there is an active transaction log in dir {} due to: ", (Object)this.transactionLogDir, (Object)e);
                    break block13;
                }
                throw new TransactionLogException("Could not initialize transaction log", e);
            }
            finally {
                if (this.initialized) {
                    try {
                        this.initializeLogIndex();
                        this.setInitialSize();
                    }
                    catch (Exception e) {
                        this.logger.error("Failed to initialize log index due to: {}", (Object)e.getMessage());
                    }
                }
            }
        }
    }

    @VisibleForTesting
    public boolean isInitialized() {
        return this.initialized;
    }

    @VisibleForTesting
    public LogIndex getLogIndex() {
        return this.logIndex;
    }

    @Override
    protected void shutdownIndices(boolean isRequestingSnapshot) {
        if (!isRequestingSnapshot) {
            this.logIndex.shutdown();
            this.lastLogEntries.clear();
        }
        for (LogChannel channel : this.channelMap.values()) {
            channel.shutdown();
        }
    }

    @Override
    protected int putChannelIfAbsentUnsafe(String repository, SemaphoreLock permit) {
        boolean[] isNew = new boolean[1];
        int channel = this.channelIds.computeIfAbsent(repository, repo -> switch (repo) {
            case "SYSTEM" -> 0;
            case "CONFIG_CHANGE" -> -2;
            case "RECOVERY" -> -5;
            case "TRUNCATE" -> -6;
            case "SECONDARY" -> -8;
            case "LLM" -> -9;
            default -> {
                isNew[0] = true;
                int nextRepositoryIndex = this.logIndex.incrementAndGetRepositoryIndex();
                this.logger.info("Mapping repository {} to channel {}", (Object)repository, (Object)nextRepositoryIndex);
                yield nextRepositoryIndex;
            }
        });
        if (isNew[0] && (this.channelRepoIds.containsKey(channel) || this.channelPermits.containsKey(channel) || this.channelMap.containsKey(channel))) {
            throw new TransactionLogException("Duplicate channel id " + channel + " and repository " + repository);
        }
        if (this.channelRepoIds.putIfAbsent(channel, repository) == null) {
            this.channelPermits.computeIfAbsent(channel, ignored -> Objects.requireNonNullElseGet(permit, SemaphoreLock::new));
            this.channelMap.computeIfAbsent(channel, ch -> {
                try {
                    return new PersistentLogChannel(this.transactionLogDir, repository, this.logIndex::fetchLogEntryFromStorage, (int)ch);
                }
                catch (IOException e) {
                    throw new TransactionLogException("Unable to create log channel for repository " + repository, e);
                }
            });
        }
        try {
            this.channelMap.get(channel).initialize();
        }
        catch (IOException e) {
            throw new TransactionLogException("Unable to initialize log channel for repository " + repository, e);
        }
        return channel;
    }

    @Override
    public void removePersistentChannel(int id) {
        LogChannel channel = this.channelMap.remove(id);
        for (PersistentLogEntry entry : this.lastLogEntries.values()) {
            if (entry.getChannel() != id) continue;
            this.lastLogEntries.remove(entry.getIndex());
        }
        channel.deleteChannel();
    }

    @Override
    public long getValidLogCheckpoint() {
        long lastValidIndex = this.getLastLogIndex();
        for (LogChannel channel : this.channelMap.values()) {
            LogEntry entry = channel.getLastLogEntry();
            if (entry == null || entry.getStatus() == LogEntry.Status.VALID) continue;
            lastValidIndex = Math.min(lastValidIndex, entry.getIndex() - 1L);
        }
        return lastValidIndex;
    }

    @Override
    public long getEntryOffset() {
        return this.logIndex.getStartingIndex();
    }

    @Override
    public long getLastLogIndex() {
        return this.logIndex.getLastLogIndex();
    }

    @Override
    public long getLastLogTerm() {
        return this.logIndex.getLastLogTerm();
    }

    @Override
    public LogEntry getLastLog() {
        return this.logIndex.getLastLog();
    }

    @Override
    public long getLastValidLog() {
        return this.logIndex.getLastValidLog();
    }

    @Override
    protected void setLogStatusUnsafe(long entryId, LogEntry.Status status) {
        this.logIndex.setLogStatus(entryId, status);
    }

    @Override
    protected LogEntry fetchLogEntryUnsafe(long entryId) {
        LogEntry logEntry = this.lastLogEntries.get(entryId);
        return logEntry != null ? logEntry : this.logIndex.fetchLogEntry(entryId);
    }

    @Override
    protected LogEntry.Status fetchEntryStatusUnsafe(long entryId) {
        LogEntry logEntry = this.lastLogEntries.get(entryId);
        return logEntry != null ? logEntry.getStatus() : this.logIndex.fetchLogEntryStatus(entryId);
    }

    @Override
    protected LogEntry appendLogEntryUnsafe(AppendEntry entry) {
        return this.commitAtomicEntry(entry);
    }

    @Override
    public LogEntry appendConfigLogEntryUnsafe(ConfigEntry entry) {
        return this.commitAtomicEntry(entry);
    }

    @Override
    protected long appendLogEntryStreamUnsafe(AppendEntry entry, boolean isNewTransaction) {
        this.activeChannel = this.channelMap.get(entry.getChannel());
        if (isNewTransaction) {
            this.appendStreamLogMetadata(entry);
        } else {
            this.activeChannel.addData(entry);
        }
        return entry.getCommitIndex();
    }

    @Override
    protected long appendLogEntryStreamUnsafe(BackupEntry entry, boolean isNewTransaction) {
        this.activeChannel = this.channelMap.get(entry.getData().getChannel());
        if (isNewTransaction) {
            this.appendStreamLogMetadata(entry);
        } else {
            this.activeChannel.addData(entry.getData());
        }
        return entry.getData().getCommitIndex();
    }

    @Override
    protected LogEntry commitLogEntryStreamUnsafe(long entryId, String fingerprint) {
        int fingerprintSize = this.activeChannel.addFingerprint(fingerprint);
        LogEntry oldLastEntry = this.activeChannel.getLastLogEntry();
        long endPos = this.activeChannel.commitEntry();
        LogEntry newLastEntry = this.logIndex.appendLogEntryData(this.activeChannel.getChannelId(), this.startPos, endPos - this.startPos, this.activeLogTerm, fingerprintSize, LogEntry.Status.CREATED);
        this.updateLastEntries(oldLastEntry, newLastEntry);
        return newLastEntry;
    }

    @Override
    public int rollbackLogEntryStreamUnsafe(long entryId) {
        this.activeChannel.rollbackEntry();
        if (this.logIndex.getLastLogIndex() == entryId) {
            this.logIndex.rollbackUpTo(entryId);
            this.lastLogEntries.remove(entryId);
        }
        return this.activeChannel.getChannelId();
    }

    @Override
    protected boolean rollbackTransactionRecordUnsafe(String repository) {
        LogChannel channel = this.channelMap.get(this.channelIds.get(repository));
        return channel.rollbackEntry();
    }

    @Override
    public OutputStream beginTransactionRecordUnsafe(String repository) {
        LogChannel channel = this.channelMap.get(this.channelIds.get(repository));
        assert (channel != null);
        channel.begin();
        channel.addMetadata(EMPTY_METADATA);
        return channel.getChannelStream();
    }

    @Override
    protected LogEntry commitTransactionRecordUnsafe(String repository, AppendEntry metadata) {
        this.activeChannel = this.channelMap.get(this.channelIds.get(repository));
        LogEntry oldLastEntry = this.activeChannel.getLastLogEntry();
        long startPos = this.activeChannel.getLastOffset();
        int fingerprintSize = this.activeChannel.addFingerprint(metadata.getFingerprint());
        this.activeChannel.replaceMetadata(metadata);
        long endPos = this.activeChannel.commitEntry();
        LogEntry newLastEntry = this.logIndex.appendLogEntryData(metadata.getChannel(), startPos, endPos - startPos, metadata.getLogTerm(), fingerprintSize, this.activeChannel.getChannelId() == -8 ? LogEntry.Status.CREATED : LogEntry.Status.PROCESSED);
        this.updateLastEntries(oldLastEntry, newLastEntry);
        return newLastEntry;
    }

    @Override
    protected OutputStream beginBackupRecordUnsafe(List<String> affectedChannels, boolean clearAll) {
        LogChannel channel = this.channelMap.get(-5);
        assert (channel != null);
        channel.begin();
        channel.addMetadata(EMPTY_METADATA);
        channel.addAffectedChannels(affectedChannels, clearAll);
        return channel.getChannelStream();
    }

    @Override
    protected boolean rollbackBackupRecordUnsafe() {
        LogChannel channel = this.channelMap.get(-5);
        return channel.rollbackEntry();
    }

    @Override
    public void restoreRepositoryIndex(int repositoryIndex) {
        this.logIndex.restoreRepositoryIndex(repositoryIndex);
    }

    @Override
    public int getCurrentRepoIndex() {
        return this.logIndex.getRepositoryIndex();
    }

    @Override
    protected LogEntry commitBackupRecordUnsafe(AppendEntry metadata) {
        this.activeChannel = this.channelMap.get(-5);
        LogEntry oldLastEntry = this.activeChannel.getLastLogEntry();
        long startPos = this.activeChannel.getLastOffset();
        int fingerprintSize = this.activeChannel.addFingerprint(metadata.getFingerprint());
        this.activeChannel.replaceMetadata(metadata);
        long endPos = this.activeChannel.commitEntry();
        LogEntry newLastEntry = this.logIndex.appendLogEntryData(metadata.getChannel(), startPos, endPos - startPos, metadata.getLogTerm(), fingerprintSize, LogEntry.Status.CREATED);
        this.updateLastEntries(oldLastEntry, newLastEntry);
        return newLastEntry;
    }

    @Override
    protected LogEntry commitTruncateRecordUnsafe(AppendEntry metadata) {
        this.activeChannel = this.channelMap.get(-6);
        this.logIndex.truncate(metadata.getCommitIndex());
        this.activeChannel.truncate();
        this.activeChannel.begin();
        byte[] data = metadata.getFingerprint().getBytes(StandardCharsets.UTF_8);
        this.activeChannel.addMetadata(metadata);
        this.activeChannel.addData(data, data.length);
        int fingerprintSize = this.activeChannel.addFingerprint(metadata.getFingerprint());
        long startPos = this.activeChannel.getLastOffset();
        long endPos = this.activeChannel.commitEntry();
        LogEntry newLastEntry = this.logIndex.appendLogEntryData(metadata.getChannel(), startPos, endPos - startPos, metadata.getLogTerm(), fingerprintSize, LogEntry.Status.CREATED);
        this.updateLastEntries(null, newLastEntry);
        for (LogChannel channel : this.channelMap.values()) {
            if (channel.getChannelId() == -6) continue;
            channel.truncate();
        }
        return newLastEntry;
    }

    @Override
    protected void validateEntryUnsafe(LogEntry entry) {
        PersistentLogEntry lastEntry = this.lastLogEntries.get(entry.getIndex());
        this.logIndex.setLogStatus(entry.getIndex(), LogEntry.Status.VALID);
        entry.setStatus(LogEntry.Status.VALID);
        if (lastEntry != null && lastEntry != entry) {
            lastEntry.setStatus(LogEntry.Status.VALID);
        }
    }

    @Override
    protected boolean isEveryChannelValidUnsafe() {
        for (LogChannel channel : this.channelMap.values()) {
            LogEntry lastEntry = channel.getLastLogEntry();
            if (lastEntry == null || lastEntry.getStatus() == LogEntry.Status.VALID) continue;
            return false;
        }
        return true;
    }

    @Override
    protected long getLogEntryTermUnsafe(long entryId) {
        return entryId < 1L ? 0L : this.logIndex.fetchLogEntry(entryId).getTerm();
    }

    @Override
    public void verifyLastChannelEntries(Consumer<LogEntry> verificationFunction) {
        for (LogChannel channel : this.channelMap.values()) {
            if (channel.getLastLogEntry() == null) continue;
            verificationFunction.accept(channel.getLastLogEntry());
        }
    }

    @Override
    protected void resetChannelVars() {
        this.activeChannel = null;
        this.activeLogTerm = -1L;
        this.startPos = -1L;
    }

    private void initializeLogChannels() throws IOException {
        if (Files.exists(Path.of(this.transactionLogDir, new String[0]), new LinkOption[0])) {
            this.logger.info("Initializing transaction log with directory: {}", (Object)this.transactionLogDir);
            Collection files = FileUtils.listFiles((File)new File(this.transactionLogDir), (String[])new String[]{".channel".substring(1)}, (boolean)false);
            int highChannel = 0;
            if (files.isEmpty()) {
                this.logger.info("No log channels found in directory: {}", (Object)this.transactionLogDir);
                this.putChannelIfAbsent("SYSTEM");
                this.putChannelIfAbsent("LLM");
                this.putChannelIfAbsent("CONFIG_CHANGE");
            } else {
                for (File file : files) {
                    PersistentLogChannel channel = new PersistentLogChannel(file, this.logIndex::fetchLogEntryFromStorage);
                    highChannel = Math.max(channel.getChannelId(), highChannel);
                    this.channelRepoIds.putIfAbsent(channel.getChannelId(), channel.getRepositoryId());
                    this.channelIds.putIfAbsent(channel.getRepositoryId(), channel.getChannelId());
                    this.channelPermits.put(channel.getChannelId(), new SemaphoreLock());
                    this.channelMap.put(channel.getChannelId(), channel);
                }
            }
            this.putChannelIfAbsent("RECOVERY");
            this.putChannelIfAbsent("TRUNCATE");
            this.putChannelIfAbsent("SECONDARY");
            for (LogChannel channel : this.channelMap.values()) {
                channel.initialize();
                this.logger.info("Initialized channel for repository: {}", (Object)channel.getRepositoryId());
            }
        } else {
            File logDir = new File(this.transactionLogDir);
            this.logger.info("Creating directory for replication cluster transaction log: {}", (Object)this.transactionLogDir);
            logDir.mkdirs();
            this.logger.info("Initializing system log channel.");
            this.putChannelIfAbsent("SYSTEM");
            this.logger.info("Initializing config changes log channel.");
            this.putChannelIfAbsent("CONFIG_CHANGE");
            this.logger.info("Initializing backup log channel.");
            this.putChannelIfAbsent("RECOVERY");
            this.logger.info("Initializing truncate log channel.");
            this.putChannelIfAbsent("TRUNCATE");
            this.logger.info("Initializing secondary log channel.");
            this.putChannelIfAbsent("SECONDARY");
            this.logger.info("Initializing LLM log channel.");
            this.putChannelIfAbsent("LLM");
        }
        this.channelPermits.put(-4, new SemaphoreLock());
    }

    private void initializeLogIndex() {
        try {
            long index = 0L;
            for (LogChannel channel : this.channelMap.values()) {
                LogEntry entry = channel.getLastLogEntry();
                if (entry == null || entry.getIndex() <= index) continue;
                index = entry.getIndex();
            }
            while (this.fetchEntryStatus(index) != LogEntry.Status.VALID && index != 0L) {
                --index;
            }
            this.logIndex.initialize(index);
        }
        catch (Exception e) {
            this.logger.error("Failed to initialize log index due to: {}", (Object)e.getMessage());
            throw e;
        }
    }

    private LogEntry commitAtomicEntry(AppendEntry entry) {
        LogEntry newLastEntry;
        if (entry.getChannel() == -6) {
            return this.commitTruncateRecordUnsafe(entry);
        }
        if (entry.getChannel() != -4) {
            this.activeChannel = this.channelMap.get(entry.getChannel());
            LogEntry oldLastEntry = this.activeChannel.getLastLogEntry();
            long startPos = this.activeChannel.begin();
            this.activeChannel.addMetadata(entry);
            this.activeChannel.addData(entry);
            int fingerprintSize = this.activeChannel.addFingerprint(entry.getFingerprint());
            long endPos = this.activeChannel.commitEntry();
            newLastEntry = this.logIndex.appendLogEntryData(entry.getChannel(), startPos, endPos - startPos, entry.getLogTerm(), fingerprintSize, LogEntry.Status.CREATED);
            if (newLastEntry.getIndex() != entry.getCommitIndex()) {
                this.logger.warn("Mismatch in commit index with actual {} as opposed to expected {}", (Object)newLastEntry.getIndex(), (Object)entry.getCommitIndex());
            }
            this.updateLastEntries(oldLastEntry, newLastEntry);
        } else {
            newLastEntry = this.logIndex.appendLogEntryData(entry.getChannel(), 0L, 1L, entry.getLogTerm(), 0, LogEntry.Status.CREATED);
        }
        return newLastEntry;
    }

    private LogEntry commitAtomicEntry(ConfigEntry entry) {
        this.activeChannel = this.channelMap.get(entry.getChannel());
        LogEntry oldLastEntry = this.activeChannel.getLastLogEntry();
        long startPos = this.activeChannel.begin();
        this.activeChannel.addMetadata(entry);
        this.activeChannel.addData(entry);
        int fingerprintSize = this.activeChannel.addFingerprint(entry.getFingerprint());
        long endPos = this.activeChannel.commitConfigEntry();
        LogEntry newLastEntry = this.logIndex.appendLogEntryData(entry.getChannel(), startPos, endPos - startPos, entry.getLogTerm(), fingerprintSize, LogEntry.Status.CREATED);
        this.updateLastEntries(oldLastEntry, newLastEntry);
        return newLastEntry;
    }

    private void appendStreamLogMetadata(AppendEntry entry) {
        this.startPos = this.activeChannel.begin();
        this.activeLogTerm = entry.getLogTerm();
        this.activeChannel.addMetadata(entry);
    }

    private void appendStreamLogMetadata(BackupEntry entry) {
        this.appendStreamLogMetadata(entry.getData());
        this.activeChannel.addAffectedChannels((List<String>)entry.getUpdatedChannelsList(), entry.getClearAll());
    }

    private void updateLastEntries(LogEntry oldLastEntry, LogEntry newLastEntry) {
        if (oldLastEntry != null) {
            this.lastLogEntries.remove(oldLastEntry.getIndex());
        }
        this.activeChannel.updateLastLog(newLastEntry);
        this.lastLogEntries.put(newLastEntry.getIndex(), (PersistentLogEntry)newLastEntry);
    }

    @Override
    public void delete() {
        try {
            FileUtils.deleteDirectory((File)new File(this.transactionLogDir));
        }
        catch (IOException e) {
            this.logger.error("Unable to delete transaction log", (Throwable)e);
        }
    }
}

