/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.storage.log.memory;

import com.google.protobuf.ByteString;
import com.ontotext.graphdb.raft.grpc.AppendEntry;
import com.ontotext.graphdb.raft.grpc.BackupEntry;
import com.ontotext.graphdb.raft.grpc.ConfigEntry;
import com.ontotext.graphdb.raft.node.concurrent.SemaphoreLock;
import com.ontotext.graphdb.raft.storage.LogEntry;
import com.ontotext.graphdb.raft.storage.NoActiveTransactionException;
import com.ontotext.graphdb.raft.storage.log.AbstractTransactionLog;
import com.ontotext.graphdb.raft.storage.log.memory.InMemoryLogEntry;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.jetbrains.annotations.Nullable;

public class InMemoryTransactionLog
extends AbstractTransactionLog {
    private final AtomicLong appendIndex;
    private final AtomicLong lastValidEntry;
    private final AtomicInteger repositoryIndex;
    private final Map<Long, InMemoryLogEntry> entryMap;
    private final Map<String, ByteArrayOutputStream> repositoryTransactions;
    private final Map<Integer, LogEntry> lastLogEntryMap;
    private volatile long validLog;

    public InMemoryTransactionLog() {
        this.appendIndex = new AtomicLong(0L);
        this.lastValidEntry = new AtomicLong(0L);
        this.repositoryIndex = new AtomicInteger(0);
        this.entryMap = new ConcurrentHashMap<Long, InMemoryLogEntry>();
        this.repositoryTransactions = new ConcurrentHashMap<String, ByteArrayOutputStream>();
        this.lastLogEntryMap = new ConcurrentHashMap<Integer, LogEntry>();
    }

    public InMemoryTransactionLog(InMemoryTransactionLog log) {
        this.appendIndex = new AtomicLong(log.getLastLogIndex());
        this.lastValidEntry = new AtomicLong(log.getLastValidLog());
        this.repositoryIndex = new AtomicInteger(log.repositoryIndex.get());
        this.entryMap = new ConcurrentHashMap<Long, InMemoryLogEntry>();
        this.repositoryTransactions = new ConcurrentHashMap<String, ByteArrayOutputStream>();
        this.lastLogEntryMap = new ConcurrentHashMap<Integer, LogEntry>();
        for (Long l : log.entryMap.keySet()) {
            this.entryMap.put(l, log.entryMap.get(l));
        }
        for (Map.Entry entry : log.channelRepoIds.entrySet()) {
            this.channelRepoIds.put((Integer)entry.getKey(), (String)entry.getValue());
            this.channelIds.put((String)entry.getValue(), (Integer)entry.getKey());
        }
    }

    @Override
    protected void shutdownIndices(boolean isRequestingSnapshot) {
    }

    @Override
    public void initializeUnsafe() {
        this.channelIds.putIfAbsent("SYSTEM", 0);
        this.channelIds.putIfAbsent("CONFIG_CHANGE", -2);
        this.channelIds.putIfAbsent("RECOVERY", -5);
        this.channelIds.putIfAbsent("TRUNCATE", -6);
        this.channelIds.putIfAbsent("SECONDARY", -8);
        this.channelRepoIds.put(0, "SYSTEM");
        this.channelRepoIds.put(-2, "CONFIG_CHANGE");
        this.channelRepoIds.put(-5, "RECOVERY");
        this.channelRepoIds.put(-6, "TRUNCATE");
        this.channelRepoIds.put(-8, "SECONDARY");
        for (Integer id : this.channelIds.values()) {
            this.channelPermits.put(id, new SemaphoreLock());
        }
        this.channelPermits.put(-4, new SemaphoreLock());
        this.setInitialSize();
    }

    @Override
    public int putChannelIfAbsentUnsafe(String repository, SemaphoreLock permit) {
        Integer channel = (Integer)this.channelIds.get(repository);
        if (channel == null) {
            channel = this.channelIds.computeIfAbsent(repository, f -> this.repositoryIndex.incrementAndGet());
            this.channelRepoIds.putIfAbsent(channel, repository);
            this.channelPermits.putIfAbsent(channel, Objects.requireNonNullElseGet(permit, SemaphoreLock::new));
        }
        return channel;
    }

    @Override
    public void removePersistentChannel(int repository) {
    }

    @Override
    public long getLastLogIndex() {
        return this.appendIndex.get();
    }

    @Override
    public long getValidLogCheckpoint() {
        return this.validLog;
    }

    public void setLastValidLogCheckpoint(long checkpoint) {
        this.validLog = checkpoint;
    }

    @Override
    public long getEntryOffset() {
        return 0L;
    }

    @Override
    public long getLastLogTerm() {
        if (this.entryMap.isEmpty()) {
            return 0L;
        }
        return this.entryMap.get(this.appendIndex.get()).getTerm();
    }

    @Override
    public LogEntry getLastLog() {
        return this.entryMap.get(this.appendIndex.get());
    }

    @Override
    public void restoreRepositoryIndex(int index) {
        this.repositoryIndex.set(index);
    }

    @Override
    public int getCurrentRepoIndex() {
        return this.repositoryIndex.get();
    }

    @Override
    protected void setLogStatusUnsafe(long logIndex, LogEntry.Status status) {
        InMemoryLogEntry entry = this.entryMap.get(logIndex);
        entry.setStatus(status);
    }

    @Override
    protected LogEntry fetchLogEntryUnsafe(long entryId) {
        InMemoryLogEntry entry = this.entryMap.get(entryId);
        if (entry != null && !this.channelRepoIds.containsKey(entry.getChannel())) {
            entry.setChannel(-4);
            entry.setFingerprint("");
            entry.setSize(1L);
            entry.removeData();
        }
        return entry;
    }

    @Override
    protected LogEntry.Status fetchEntryStatusUnsafe(long entryId) {
        LogEntry entry = this.entryMap.get(entryId);
        if (entry == null) {
            return null;
        }
        return entry.getStatus();
    }

    @Override
    protected LogEntry appendLogEntryUnsafe(AppendEntry entry) {
        InMemoryLogEntry logEntry;
        long i = this.appendIndex.incrementAndGet();
        if (entry.getChannel() != -4) {
            logEntry = new InMemoryLogEntry(i, entry.getLogTerm(), entry.getRdfData(), entry.getFingerprint(), entry.getChannel(), (long)entry.getRdfData().size());
            logEntry.setRepository((String)this.channelRepoIds.get(entry.getChannel()));
        } else {
            logEntry = new InMemoryLogEntry(i, entry.getLogTerm(), ByteString.EMPTY, "", entry.getChannel(), 33L);
        }
        logEntry.setStatus(LogEntry.Status.CREATED);
        if (entry.getChannel() == -6) {
            this.entryMap.clear();
            this.lastLogEntryMap.clear();
        }
        this.entryMap.put(i, logEntry);
        this.lastLogEntryMap.put(entry.getChannel(), logEntry);
        return logEntry;
    }

    @Override
    protected LogEntry appendConfigLogEntryUnsafe(ConfigEntry entry) {
        long i = this.appendIndex.incrementAndGet();
        InMemoryLogEntry logEntry = entry.getNewConfigServersList().size() != 0 ? new InMemoryLogEntry(i, entry.getLogTerm() == 0L ? entry.getTerm() : entry.getLogTerm(), entry.getNewConfigServersList(), entry.getOldConfigList(), entry.getFingerprint(), entry.getChannel(), entry.getNewConfigServersList().size()) : new InMemoryLogEntry(i, entry.getLogTerm() == 0L ? entry.getTerm() : entry.getLogTerm(), entry.getProperties(), entry.getFingerprint(), entry.getChannel(), entry.getNewConfigServersList().size());
        logEntry.setStatus(LogEntry.Status.CREATED);
        this.entryMap.put(i, logEntry);
        this.lastLogEntryMap.put(entry.getChannel(), logEntry);
        return logEntry;
    }

    @Override
    public long getLogEntryTermUnsafe(long entryIndex) {
        if (entryIndex < 1L) {
            return 0L;
        }
        return this.entryMap.get(entryIndex).getTerm();
    }

    @Override
    public void verifyLastChannelEntries(Consumer<LogEntry> verificationFunction) {
        for (LogEntry entry : this.lastLogEntryMap.values()) {
            verificationFunction.accept(entry);
        }
    }

    @Override
    protected long appendLogEntryStreamUnsafe(AppendEntry request, boolean isNewTransaction) {
        InMemoryLogEntry entry = this.entryMap.get(request.getCommitIndex());
        if (entry == null) {
            return this.appendLogEntryUnsafe(request).getIndex();
        }
        entry.appendData(request.getRdfData());
        return entry.getIndex();
    }

    @Override
    protected long appendLogEntryStreamUnsafe(BackupEntry request, boolean isNewTransaction) {
        InMemoryLogEntry entry = this.entryMap.get(request.getData().getCommitIndex());
        if (entry == null) {
            InMemoryLogEntry log = (InMemoryLogEntry)this.appendLogEntryUnsafe(request.getData());
            log.setAffectedChannels(new ArrayList<String>((Collection<String>)request.getUpdatedChannelsList()));
            log.setClearAllChannels(!this.deletedRepositories.isEmpty());
            return log.getIndex();
        }
        if (request.getData().getChannel() == -5) assert (entry.getAffectedChannels() != null);
        entry.appendData(request.getData().getRdfData());
        return entry.getIndex();
    }

    @Override
    protected LogEntry commitLogEntryStreamUnsafe(long entry, String fingerprint) {
        InMemoryLogEntry logEntry = this.entryMap.get(entry);
        logEntry.setFingerprint(fingerprint);
        logEntry.setRepository((String)this.channelRepoIds.get(logEntry.getChannel()));
        return logEntry;
    }

    @Override
    public int rollbackLogEntryStreamUnsafe(long entry) {
        LogEntry logEntry = this.entryMap.remove(entry);
        this.appendIndex.decrementAndGet();
        Long prevEntryId = this.getPreviousEntryInChannel(logEntry.getChannel());
        if (prevEntryId == null) {
            this.lastLogEntryMap.remove(logEntry.getChannel());
        } else {
            this.lastLogEntryMap.put(logEntry.getChannel(), this.entryMap.get(prevEntryId));
        }
        return logEntry.getChannel();
    }

    @Nullable
    private Long getPreviousEntryInChannel(int channel) {
        return this.entryMap.keySet().stream().sorted().filter(id -> this.entryMap.get(id).getChannel() == channel).reduce((first, second) -> second).orElse(null);
    }

    @Override
    public boolean rollbackTransactionRecordUnsafe(String repository) {
        return this.repositoryTransactions.remove(repository) != null;
    }

    public boolean isRepositoryTransactionAvailable(String repository) {
        return this.repositoryTransactions.containsKey(repository);
    }

    @Override
    protected OutputStream beginTransactionRecordUnsafe(String repository) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.repositoryTransactions.put(repository, stream);
        return stream;
    }

    @Override
    protected LogEntry commitTransactionRecordUnsafe(String repository, AppendEntry metadata) {
        long i = this.appendIndex.incrementAndGet();
        ByteArrayOutputStream tempData = this.repositoryTransactions.remove(repository);
        if (tempData == null) {
            throw new NoActiveTransactionException("no active transaction for " + repository);
        }
        ByteString data = ByteString.copyFrom((byte[])tempData.toByteArray());
        InMemoryLogEntry logEntry = new InMemoryLogEntry(i, metadata.getLogTerm() == 0L ? metadata.getTerm() : metadata.getLogTerm(), data, metadata.getFingerprint(), metadata.getChannel(), (long)data.size());
        logEntry.setStatus(LogEntry.Status.PROCESSED);
        logEntry.setRepository((String)this.channelRepoIds.get(metadata.getChannel()));
        this.entryMap.put(i, logEntry);
        this.lastLogEntryMap.put(metadata.getChannel(), logEntry);
        return logEntry;
    }

    @Override
    protected OutputStream beginBackupRecordUnsafe(List<String> affectedChannels, boolean clearAll) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        this.repositoryTransactions.put("RECOVERY", stream);
        return stream;
    }

    @Override
    protected boolean rollbackBackupRecordUnsafe() {
        return this.repositoryTransactions.remove("RECOVERY") != null;
    }

    @Override
    protected LogEntry commitBackupRecordUnsafe(AppendEntry metadata) {
        long i = this.appendIndex.incrementAndGet();
        ByteString data = ByteString.copyFrom((byte[])this.repositoryTransactions.remove("RECOVERY").toByteArray());
        InMemoryLogEntry logEntry = new InMemoryLogEntry(i, metadata.getLogTerm() == 0L ? metadata.getTerm() : metadata.getLogTerm(), data, metadata.getFingerprint(), metadata.getChannel(), (long)data.size());
        logEntry.setStatus(LogEntry.Status.CREATED);
        logEntry.setRepository((String)this.channelRepoIds.get(metadata.getChannel()));
        logEntry.setAffectedChannels(new ArrayList<String>(this.backupRepositories));
        logEntry.setClearAllChannels(!this.deletedRepositories.isEmpty());
        this.entryMap.put(i, logEntry);
        this.lastLogEntryMap.put(metadata.getChannel(), logEntry);
        return logEntry;
    }

    @Override
    protected LogEntry commitTruncateRecordUnsafe(AppendEntry metadata) {
        long i = this.appendIndex.incrementAndGet();
        ByteString data = ByteString.copyFrom((byte[])metadata.getFingerprint().getBytes(StandardCharsets.UTF_8));
        InMemoryLogEntry logEntry = new InMemoryLogEntry(i, metadata.getLogTerm() == 0L ? metadata.getTerm() : metadata.getLogTerm(), data, metadata.getFingerprint(), metadata.getChannel(), (long)data.size());
        logEntry.setStatus(LogEntry.Status.CREATED);
        logEntry.setRepository((String)this.channelRepoIds.get(metadata.getChannel()));
        this.entryMap.clear();
        this.lastLogEntryMap.clear();
        this.entryMap.put(i, logEntry);
        this.lastLogEntryMap.put(metadata.getChannel(), logEntry);
        return logEntry;
    }

    @Override
    protected void validateEntryUnsafe(LogEntry logEntry) {
        InMemoryLogEntry entry = this.entryMap.get(logEntry.getIndex());
        entry.setStatus(LogEntry.Status.VALID);
        this.lastValidEntry.set(logEntry.getIndex());
    }

    @Override
    protected boolean isEveryChannelValidUnsafe() {
        HashMap<Integer, InMemoryLogEntry> entries = new HashMap<Integer, InMemoryLogEntry>();
        for (InMemoryLogEntry entry : this.entryMap.values()) {
            LogEntry current = entries.putIfAbsent(entry.getChannel(), entry);
            if (current == null || current.getIndex() >= entry.getIndex()) continue;
            entries.put(entry.getChannel(), entry);
        }
        for (LogEntry lastEntry : entries.values()) {
            if (lastEntry.getStatus() == LogEntry.Status.VALID) continue;
            return false;
        }
        return true;
    }

    @Override
    public long getLastValidLog() {
        return this.lastValidEntry.get();
    }

    public void applySnapshot(ObjectInputStream stream) {
        try {
            this.appendIndex.set(stream.readLong());
            this.lastValidEntry.set(stream.readLong());
            this.repositoryIndex.set(stream.readInt());
            this.channelIds.clear();
            this.channelIds.putAll((Map)stream.readObject());
            this.entryMap.clear();
            this.entryMap.putAll((Map)stream.readObject());
            this.channelRepoIds.clear();
            this.channelRepoIds.putAll((Map)stream.readObject());
            this.lastLogEntryMap.clear();
            this.lastLogEntryMap.putAll((Map)stream.readObject());
            for (Integer id : this.channelIds.values()) {
                this.channelPermits.put(id, new SemaphoreLock());
            }
        }
        catch (IOException | ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    protected void resetChannelVars() {
    }

    public void generateSnapshot(ObjectOutputStream stream) {
        try {
            stream.writeLong(this.appendIndex.get());
            stream.writeLong(this.lastValidEntry.get());
            stream.writeInt(this.repositoryIndex.get());
            stream.writeObject(this.channelIds);
            stream.writeObject(this.entryMap);
            stream.writeObject(this.channelRepoIds);
            stream.writeObject(this.lastLogEntryMap);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public final boolean hasWaitingUpdates(String repository) {
        return ((SemaphoreLock)this.channelPermits.get(this.getChannelId(repository))).hasQueuedThreads();
    }

    @Override
    public void delete() {
    }
}

