/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.storage.log;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.graphdb.raft.grpc.AppendEntry;
import com.ontotext.graphdb.raft.grpc.BackupEntry;
import com.ontotext.graphdb.raft.grpc.ConfigEntry;
import com.ontotext.graphdb.raft.grpc.NodeInfo;
import com.ontotext.graphdb.raft.node.concurrent.SemaphoreLock;
import com.ontotext.graphdb.raft.storage.LogEntry;
import com.ontotext.graphdb.raft.storage.NoActiveTransactionException;
import com.ontotext.graphdb.raft.storage.TransactionLog;
import com.ontotext.graphdb.raft.storage.TransactionLogException;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class AbstractTransactionLog
implements TransactionLog {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected static final long TRANSACTION_LOG_LOCK_ID = Long.MAX_VALUE;
    protected final Map<Integer, SemaphoreLock> channelPermits = new ConcurrentHashMap<Integer, SemaphoreLock>(16, 0.75f, 8);
    protected final Map<String, Integer> channelIds = new ConcurrentHashMap<String, Integer>(16, 0.75f, 8);
    protected final Map<Integer, String> channelRepoIds = new ConcurrentHashMap<Integer, String>(16, 0.75f, 8);
    protected final AtomicLong activeTransaction;
    private final ReadWriteLock snapshotLock = new ReentrantReadWriteLock();
    private final ReadWriteLock batchLock = new ReentrantReadWriteLock();
    private final Lock activeLock = new SemaphoreLock(true);
    protected volatile boolean initialized;
    protected volatile List<String> backupRepositories;
    protected volatile List<String> deletedRepositories;
    private final AtomicLong size;

    public AbstractTransactionLog() {
        this.activeTransaction = new AtomicLong(-1L);
        this.size = new AtomicLong(0L);
    }

    @Override
    public final void initialize() {
        this.snapshotLock.readLock().lock();
        try {
            if (this.initialized) {
                return;
            }
            this.batchLock.writeLock().lock();
            try {
                this.initialized = true;
                this.initializeUnsafe();
            }
            finally {
                this.batchLock.writeLock().unlock();
            }
        }
        finally {
            this.snapshotLock.readLock().unlock();
        }
    }

    @Override
    public final void shutdown(boolean isRequestingSnapshot) {
        this.logger.warn("Locking transaction log to prepare for shutdown.");
        if (isRequestingSnapshot) {
            this.lockChanelPermits();
        }
        try {
            this.snapshotLock.writeLock().lock();
            try {
                if (!this.initialized) {
                    return;
                }
                this.batchLock.writeLock().lock();
                try {
                    this.shutdownIndices(isRequestingSnapshot);
                    this.size.set(0L);
                    this.initialized = false;
                    this.backupRepositories = null;
                    this.deletedRepositories = null;
                    this.logger.info("Shut down transaction log successfully");
                }
                finally {
                    this.batchLock.writeLock().unlock();
                }
            }
            finally {
                this.snapshotLock.writeLock().unlock();
            }
        }
        catch (Exception e) {
            this.unlockChannels(new ArrayList<String>(this.channelIds.keySet()));
            throw e;
        }
    }

    @Override
    public final String getChannel(int id) {
        return this.channelRepoIds.get(id);
    }

    @Override
    public final int getChannelId(String repository) {
        return this.channelIds.getOrDefault(repository, -3);
    }

    @Override
    public final Map<String, Integer> getChannelIds() {
        return Collections.unmodifiableMap(this.channelIds);
    }

    @Override
    public final int putChannelIfAbsent(String repository) {
        this.verifyInit();
        return this.putChannelIfAbsentUnsafe(repository, null);
    }

    @Override
    public final void beginBatchingStream() {
        this.verifyInit();
        if (!this.batchLock.readLock().tryLock()) {
            throw new TransactionLogException("Unable to acquire batch read lock");
        }
        try {
            this.verifyInit();
        }
        catch (Exception e) {
            this.batchLock.readLock().unlock();
            throw e;
        }
    }

    @Override
    public final void endBatchingStream() {
        this.batchLock.readLock().unlock();
    }

    @Override
    public final void batchTransactionChannels(OutputStream output, long offsetEntry, long limitEntry) throws IOException {
        DataOutputStream stream = new DataOutputStream(output);
        stream.writeLong(offsetEntry);
        stream.writeLong(limitEntry);
        if (offsetEntry != limitEntry) {
            for (long i = offsetEntry + 1L; i <= limitEntry; ++i) {
                LogEntry entry = this.fetchLogEntryUnsafe(i);
                if (!this.isEntryValidForBatch(entry)) {
                    this.writeString("IGNORED", stream);
                    continue;
                }
                this.writeString(entry.getRepository(), stream);
                stream.writeInt(entry.getChannel());
                if (entry.isMembershipConfigEntry()) {
                    List<NodeInfo> config = entry.getNewConfig();
                    stream.writeInt(config.size());
                    for (NodeInfo node : config) {
                        this.writeString(node.getRpcAddress(), stream);
                        this.writeString(node.getHttpAddress(), stream);
                    }
                    continue;
                }
                stream.writeLong(entry.getDataSize());
                IOUtils.copy((InputStream)entry.getDataStream(), (OutputStream)stream);
                this.writeString(entry.getFingerprint(), stream);
            }
        }
        stream.flush();
    }

    private void writeString(String value, DataOutputStream stream) throws IOException {
        byte[] bytes = value.getBytes(StandardCharsets.UTF_8);
        stream.writeInt(bytes.length);
        stream.write(bytes);
    }

    private boolean isEntryValidForBatch(LogEntry entry) {
        if (entry == null) {
            return false;
        }
        int channel = entry.getChannel();
        if (channel == -2) {
            return entry.isMembershipConfigEntry();
        }
        return channel != -8 && channel != -6 && channel != -4;
    }

    @Override
    public final void removeChannel(String repository) {
        this.snapshotLock.readLock().lock();
        try {
            this.verifyInit();
            Integer id = this.channelIds.remove(repository);
            if (id != null) {
                this.logger.info("Removing transaction log channel for repository: {}", (Object)repository);
                this.channelRepoIds.remove(id);
                this.channelPermits.remove(id);
                this.removePersistentChannel(id);
            }
        }
        finally {
            this.snapshotLock.readLock().unlock();
        }
    }

    @Override
    public Map<String, Integer> getChannelMapping() {
        return Collections.unmodifiableMap(this.channelIds);
    }

    @Override
    public final void lockChannel(int channel) {
        SemaphoreLock lock = this.channelPermits.get(channel);
        if (lock == null) {
            throw new TransactionLogException("Cannot lock channel! Missing lock for channel " + channel);
        }
        lock.lock();
        if (channel != -4 && !this.channelRepoIds.containsKey(channel)) {
            lock.unlock();
            throw new TransactionLogException("Channel with id " + channel + " no longer exists");
        }
    }

    @Override
    public final void unlockChannel(int channel) {
        SemaphoreLock lock = this.channelPermits.get(channel);
        if (lock == null) {
            throw new TransactionLogException("Cannot unlock channel! Missing lock for channel " + channel);
        }
        lock.unlock();
    }

    @Override
    public final void lockTransactionLog() {
        this.logger.warn("Locking transaction log to prepare snapshot for replication to other nodes.");
        this.snapshotLock.writeLock().lock();
        try {
            this.awaitActiveTransaction(Long.MAX_VALUE);
            this.logger.warn("Successfully locked transaction log.");
        }
        finally {
            this.snapshotLock.writeLock().unlock();
        }
    }

    @Override
    public final void unlockTransactionLog() {
        this.resetTransactionVars(Long.MAX_VALUE);
        this.logger.info("Successfully unlocked transaction log.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void setLogStatus(long entryId, LogEntry.Status status) {
        this.snapshotLock.readLock().lock();
        try {
            this.verifyInit();
            this.setLogStatusUnsafe(entryId, status);
        }
        finally {
            this.snapshotLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LogEntry fetchLogEntry(long entryId) {
        this.snapshotLock.readLock().lock();
        try {
            this.verifyInit();
            if (entryId == 0L) {
                LogEntry logEntry = null;
                return logEntry;
            }
            LogEntry logEntry = this.fetchLogEntryUnsafe(entryId);
            return logEntry;
        }
        finally {
            this.snapshotLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LogEntry.Status fetchEntryStatus(long entryId) {
        this.snapshotLock.readLock().lock();
        try {
            this.verifyInit();
            if (entryId == 0L) {
                LogEntry.Status status = null;
                return status;
            }
            LogEntry.Status status = this.fetchEntryStatusUnsafe(entryId);
            return status;
        }
        finally {
            this.snapshotLock.readLock().unlock();
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public final LogEntry appendLogEntry(AppendEntry entry) {
        this.verifyInit();
        if (entry.getChannel() == -6) {
            this.lockTruncateChannels();
        } else {
            this.lockChannel(entry.getChannel());
        }
        try {
            this.snapshotLock.readLock().lock();
            try {
                this.verifyInit();
                this.awaitActiveTransaction(entry.getCommitIndex());
                try {
                    LogEntry logEntry = this.appendLogEntryUnsafe(entry);
                    this.resetTransactionVars(entry.getCommitIndex());
                    return logEntry;
                }
                catch (Throwable throwable) {
                    this.resetTransactionVars(entry.getCommitIndex());
                    throw throwable;
                }
            }
            finally {
                this.snapshotLock.readLock().unlock();
            }
        }
        catch (Exception e) {
            if (entry.getChannel() == -6) {
                this.unlockTruncateChannels();
            } else {
                try {
                    this.unlockChannel(entry.getChannel());
                }
                catch (RuntimeException ex) {
                    e.addSuppressed(ex);
                }
            }
            throw e;
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public final LogEntry appendConfigLogEntry(ConfigEntry entry) {
        this.verifyInit();
        this.lockChannel(entry.getChannel());
        try {
            this.snapshotLock.readLock().lock();
            try {
                this.verifyInit();
                this.awaitActiveTransaction(entry.getCommitIndex());
                try {
                    LogEntry logEntry = this.appendConfigLogEntryUnsafe(entry);
                    this.resetTransactionVars(entry.getCommitIndex());
                    return logEntry;
                }
                catch (Throwable throwable) {
                    this.resetTransactionVars(entry.getCommitIndex());
                    throw throwable;
                }
            }
            finally {
                this.snapshotLock.readLock().unlock();
            }
        }
        catch (Exception e) {
            try {
                this.unlockChannel(entry.getChannel());
            }
            catch (RuntimeException ex) {
                e.addSuppressed(ex);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long appendLogEntryStream(AppendEntry entry) {
        if (entry.getChannel() == -4) {
            throw new TransactionLogException("Cannot append entry to deleted channel through streaming");
        }
        this.verifyInit();
        boolean isNewTransaction = false;
        boolean checkNewTransaction = this.checkNewTransaction(entry.getCommitIndex());
        if (checkNewTransaction) {
            this.lockChannel(entry.getChannel());
            try {
                this.snapshotLock.readLock().lock();
            }
            catch (Exception e) {
                try {
                    this.unlockChannel(entry.getChannel());
                }
                catch (RuntimeException ex) {
                    e.addSuppressed(ex);
                }
                throw e;
            }
            try {
                isNewTransaction = this.awaitActiveTransaction(entry.getCommitIndex());
            }
            finally {
                this.snapshotLock.readLock().unlock();
            }
        }
        try {
            this.verifyInit();
            return this.appendLogEntryStreamUnsafe(entry, isNewTransaction);
        }
        catch (Exception e) {
            if (isNewTransaction) {
                this.resetTransactionVars(entry.getCommitIndex());
            }
            if (!checkNewTransaction) {
                this.rollbackLogEntryStream(entry.getCommitIndex());
            } else {
                try {
                    this.unlockChannel(entry.getChannel());
                }
                catch (RuntimeException ex) {
                    e.addSuppressed(ex);
                }
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long appendLogEntryStream(BackupEntry entry) {
        if (entry.getData().getChannel() != -5) {
            throw new TransactionLogException("Cannot append entry with channel " + entry.getData().getChannel() + " in a recovery channel");
        }
        this.verifyInit();
        boolean isNewTransaction = false;
        boolean checkNewTransaction = this.checkNewTransaction(entry.getData().getCommitIndex());
        if (checkNewTransaction) {
            this.lockBackupChannels(new ArrayList<String>((Collection<String>)entry.getUpdatedChannelsList()), entry.getClearAll());
            try {
                this.snapshotLock.readLock().lock();
            }
            catch (Exception e) {
                this.unlockBackupChannels();
                throw e;
            }
            try {
                isNewTransaction = this.awaitActiveTransaction(entry.getData().getCommitIndex());
            }
            finally {
                this.snapshotLock.readLock().unlock();
            }
        }
        try {
            this.verifyInit();
            return this.appendLogEntryStreamUnsafe(entry, isNewTransaction);
        }
        catch (Exception e) {
            if (isNewTransaction) {
                this.resetTransactionVars(entry.getData().getCommitIndex());
            }
            if (!checkNewTransaction) {
                this.rollbackLogEntryStream(entry.getData().getCommitIndex());
            } else {
                this.unlockBackupChannels();
            }
            throw e;
        }
    }

    private void unlockBackupChannels() {
        if (this.backupRepositories != null) {
            this.unlockChannels(this.backupRepositories);
        }
        if (this.deletedRepositories != null) {
            this.unlockChannels(this.deletedRepositories);
        }
        this.unlockChannel(-5);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LogEntry commitLogEntryStream(long entryId, String fingerprint) {
        try {
            this.verifyInit();
            LogEntry entry = this.commitLogEntryStreamUnsafe(entryId, fingerprint);
            if (entry.getChannel() == -5) {
                this.processAffectedChannels(entry);
            }
            LogEntry logEntry = entry;
            return logEntry;
        }
        finally {
            this.resetTransactionVars(entryId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final void rollbackLogEntryStream(long entryId) {
        boolean isNotActiveEntry = false;
        int channel = -1;
        try {
            this.verifyInit();
            isNotActiveEntry = this.checkNewTransaction(entryId);
            if (isNotActiveEntry) {
                throw new TransactionLogException("No active transaction with id " + entryId);
            }
            this.logger.info("Rolling back transaction with id {}", (Object)entryId);
            channel = this.rollbackLogEntryStreamUnsafe(entryId);
            return;
        }
        finally {
            if (!isNotActiveEntry) {
                try {
                    this.resetTransactionVars(entryId);
                }
                finally {
                    try {
                        if (this.backupRepositories != null) {
                            this.unlockChannels(this.backupRepositories);
                        }
                        if (this.deletedRepositories != null) {
                            this.unlockChannels(this.deletedRepositories);
                        }
                        if (channel != -1) {
                            this.unlockChannel(channel);
                        }
                    }
                    catch (Exception e) {
                        this.logger.warn("error occurred during rollback of transaction log for channel {}", (Object)this.getChannel(channel), (Object)e);
                    }
                    finally {
                        this.backupRepositories = null;
                        this.deletedRepositories = null;
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void rollbackTransactionRecord(String repository) {
        boolean hasActiveTransaction = false;
        try {
            this.verifyInit();
            hasActiveTransaction = this.rollbackTransactionRecordUnsafe(repository);
            if (hasActiveTransaction) {
                this.snapshotLock.readLock().unlock();
            }
        }
        finally {
            if (hasActiveTransaction || this.isChannelLocked(repository)) {
                try {
                    this.unlockChannel(this.getChannelId(repository));
                }
                catch (RuntimeException e) {
                    this.logger.warn("error occurred during rollback of transaction log for repository {}", (Object)repository, (Object)e);
                }
            }
            this.logger.warn("Rolled back transaction record for repository {}", (Object)repository);
        }
    }

    @Override
    public final OutputStream beginTransactionRecord(String repository, AtomicBoolean isRecovering) {
        this.verifyInit();
        Integer channelId = this.channelIds.get(repository);
        if (channelId == null) {
            throw new TransactionLogException("Missing channel for repository " + repository);
        }
        this.lockChannel(channelId);
        try {
            if (isRecovering.get()) {
                throw new TransactionLogException("Cannot process transaction during node recovery");
            }
            this.snapshotLock.readLock().lock();
            try {
                if (isRecovering.get()) {
                    throw new TransactionLogException("Cannot process transaction during node recovery");
                }
                this.verifyInit();
                this.awaitLogLock();
                return this.beginTransactionRecordUnsafe(repository);
            }
            catch (Exception e) {
                this.snapshotLock.readLock().unlock();
                throw e;
            }
        }
        catch (Exception e) {
            try {
                this.unlockChannel(channelId);
            }
            catch (RuntimeException e1) {
                e.addSuppressed(e1);
            }
            throw e;
        }
    }

    @Override
    public final LogEntry commitTransactionRecord(String repository, AppendEntry metadata) {
        boolean shouldUnlock = true;
        try {
            this.verifyInit();
            this.awaitActiveTransaction(metadata.getCommitIndex());
            LogEntry logEntry = this.commitTransactionRecordUnsafe(repository, metadata);
            return logEntry;
        }
        catch (NoActiveTransactionException e) {
            shouldUnlock = false;
            throw e;
        }
        finally {
            this.resetTransactionVars(metadata.getCommitIndex());
            if (shouldUnlock) {
                this.snapshotLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final OutputStream beginBackupRecord(List<String> affectedRepositories, boolean clearAll) {
        this.verifyInit();
        ArrayList<String> affectedChannels = new ArrayList<String>(affectedRepositories);
        Collections.sort(affectedChannels);
        this.lockBackupChannels(affectedChannels, clearAll);
        this.snapshotLock.readLock().lock();
        try {
            this.awaitLogLock();
            return this.beginBackupRecordUnsafe(affectedChannels, clearAll);
        }
        catch (Exception e) {
            try {
                this.snapshotLock.readLock().unlock();
            }
            finally {
                this.unlockBackupChannels();
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final LogEntry commitBackupRecord(AppendEntry metadata) {
        try {
            this.verifyInit();
            this.awaitActiveTransaction(metadata.getCommitIndex());
            LogEntry entry = this.commitBackupRecordUnsafe(metadata);
            this.processAffectedChannels(entry);
            LogEntry logEntry = entry;
            return logEntry;
        }
        finally {
            try {
                this.resetTransactionVars(metadata.getCommitIndex());
            }
            finally {
                this.snapshotLock.readLock().unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void rollbackBackupRecord() {
        boolean hasActiveBackup = false;
        boolean isChannelLocked = false;
        try {
            this.verifyInit();
            hasActiveBackup = this.rollbackBackupRecordUnsafe();
            boolean bl = isChannelLocked = hasActiveBackup || this.isChannelLocked("RECOVERY");
            if (hasActiveBackup) {
                this.snapshotLock.readLock().unlock();
            }
        }
        finally {
            try {
                if (isChannelLocked) {
                    if (this.backupRepositories != null) {
                        this.unlockChannels(this.backupRepositories);
                    }
                    if (this.deletedRepositories != null) {
                        this.unlockChannels(this.deletedRepositories);
                    }
                    this.unlockChannel(-5);
                }
            }
            finally {
                if (isChannelLocked) {
                    this.backupRepositories = null;
                    this.deletedRepositories = null;
                }
            }
        }
    }

    @Override
    public void beginTruncate() {
        this.snapshotLock.readLock().lock();
        try {
            this.verifyInit();
            this.awaitLogLock();
            this.lockTruncateChannels();
        }
        finally {
            this.snapshotLock.readLock().unlock();
        }
    }

    @Override
    public LogEntry commitTruncate(AppendEntry metadata) {
        this.verifyInit();
        this.batchLock.writeLock().lock();
        try {
            this.verifyInit();
            LogEntry logEntry = this.commitTruncateRecordUnsafe(metadata);
            return logEntry;
        }
        finally {
            this.batchLock.writeLock().unlock();
        }
    }

    @Override
    public void rollbackTruncate() {
        this.unlockTruncateChannels();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void validateEntry(LogEntry entry) {
        this.snapshotLock.readLock().lock();
        try {
            this.verifyInit();
            try {
                this.awaitLogLock();
                this.validateEntryUnsafe(entry);
                if (entry.getChannel() != -6) {
                    this.size.addAndGet(entry.getSize());
                } else {
                    this.size.set(entry.getSize());
                }
            }
            finally {
                if (entry.getChannel() == -5 && this.backupRepositories != null) {
                    for (String repo : this.backupRepositories) {
                        try {
                            this.unlockChannel(this.getChannelId(repo));
                        }
                        catch (RuntimeException e) {
                            this.logger.warn("Failed to unlock backup channel for repo {}", (Object)repo, (Object)e);
                        }
                    }
                    this.backupRepositories = null;
                    this.deletedRepositories = null;
                }
                if (entry.getChannel() == -6) {
                    this.unlockTruncateChannels();
                } else {
                    try {
                        this.unlockChannel(entry.getChannel());
                    }
                    catch (RuntimeException e) {
                        this.logger.warn("Failed to unlock backup channel for entry {}", (Object)entry.getChannel(), (Object)e);
                    }
                }
            }
        }
        finally {
            this.snapshotLock.readLock().unlock();
        }
    }

    @Override
    public boolean isEveryChannelValid() {
        this.snapshotLock.readLock().lock();
        try {
            this.verifyInit();
            boolean bl = this.isEveryChannelValidUnsafe();
            return bl;
        }
        finally {
            this.snapshotLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final long getLogEntryTerm(long entryId) {
        this.snapshotLock.readLock().lock();
        try {
            this.verifyInit();
            long l = this.getLogEntryTermUnsafe(entryId);
            return l;
        }
        finally {
            this.snapshotLock.readLock().unlock();
        }
    }

    @Override
    public boolean isLocked() {
        ReentrantReadWriteLock reentrantReadWriteLock = (ReentrantReadWriteLock)this.snapshotLock;
        return reentrantReadWriteLock.isWriteLocked() || reentrantReadWriteLock.getReadLockCount() > 0;
    }

    protected abstract void initializeUnsafe();

    protected abstract void shutdownIndices(boolean var1);

    protected abstract int putChannelIfAbsentUnsafe(String var1, SemaphoreLock var2);

    protected abstract void setLogStatusUnsafe(long var1, LogEntry.Status var3);

    protected abstract LogEntry fetchLogEntryUnsafe(long var1);

    protected abstract LogEntry.Status fetchEntryStatusUnsafe(long var1);

    protected abstract LogEntry appendLogEntryUnsafe(AppendEntry var1);

    protected abstract LogEntry appendConfigLogEntryUnsafe(ConfigEntry var1);

    protected abstract long appendLogEntryStreamUnsafe(AppendEntry var1, boolean var2);

    protected abstract long appendLogEntryStreamUnsafe(BackupEntry var1, boolean var2);

    protected abstract LogEntry commitLogEntryStreamUnsafe(long var1, String var3);

    protected abstract int rollbackLogEntryStreamUnsafe(long var1);

    protected abstract OutputStream beginTransactionRecordUnsafe(String var1);

    protected abstract boolean rollbackTransactionRecordUnsafe(String var1);

    protected abstract LogEntry commitTransactionRecordUnsafe(String var1, AppendEntry var2);

    protected abstract OutputStream beginBackupRecordUnsafe(List<String> var1, boolean var2);

    protected abstract boolean rollbackBackupRecordUnsafe();

    protected abstract LogEntry commitBackupRecordUnsafe(AppendEntry var1);

    protected abstract LogEntry commitTruncateRecordUnsafe(AppendEntry var1);

    protected abstract void validateEntryUnsafe(LogEntry var1);

    protected abstract boolean isEveryChannelValidUnsafe();

    protected abstract long getLogEntryTermUnsafe(long var1);

    protected abstract void removePersistentChannel(int var1);

    @VisibleForTesting
    public final boolean isChannelLocked(String repository) {
        boolean free = false;
        try {
            free = this.channelPermits.get(this.getChannelId(repository)).tryLock();
        }
        finally {
            if (free) {
                this.channelPermits.get(this.getChannelId(repository)).unlock();
            }
        }
        return !free;
    }

    public final int getChannelPermits(String repository) {
        return this.channelPermits.get(this.getChannelId(repository)).availablePermits();
    }

    protected final void lockBackupChannels(List<String> affectedChannels, boolean clearAll) {
        ArrayList<String> deletedChannels = new ArrayList<String>();
        if (clearAll) {
            for (Map.Entry<String, Integer> channel : this.channelIds.entrySet()) {
                String key;
                if (channel.getValue() <= 0 || affectedChannels.contains(key = channel.getKey())) continue;
                deletedChannels.add(key);
            }
            Collections.sort(deletedChannels);
        }
        this.lockChannel(-5);
        this.backupRepositories = affectedChannels;
        this.lockChannels(this.backupRepositories);
        this.deletedRepositories = deletedChannels;
        this.lockChannels(this.deletedRepositories);
    }

    protected void awaitLogLock() {
        while (this.activeTransaction.get() == Long.MAX_VALUE && !Thread.currentThread().isInterrupted()) {
            Thread.onSpinWait();
        }
    }

    protected void lockTruncateChannels() {
        ArrayList<Integer> lockedChannels = new ArrayList<Integer>();
        try {
            this.logger.info("Locking channels for log truncate");
            for (Integer channel : this.channelRepoIds.keySet()) {
                this.lockChannel(channel);
                lockedChannels.add(channel);
                this.logger.info("Successfully locked channel {} with id {}", (Object)channel, (Object)this.channelRepoIds.get(channel));
            }
            this.logger.info("Locked all channels for log truncate");
        }
        catch (Exception e) {
            for (Integer lockedChannel : lockedChannels) {
                try {
                    this.unlockChannel(lockedChannel);
                }
                catch (Exception exception) {}
            }
            throw e;
        }
    }

    protected void unlockTruncateChannels() {
        for (Integer channel : this.channelRepoIds.keySet()) {
            try {
                this.unlockChannel(channel);
                this.logger.info("Successfully unlocked channel {} with id {}", (Object)channel, (Object)this.channelRepoIds.get(channel));
            }
            catch (Exception exception) {}
        }
        this.logger.info("Unlocked all channels for log truncate");
    }

    protected final void processAffectedChannels(LogEntry entry) {
        assert (entry.getAffectedChannels() != null);
        if (entry.clearAllChannels()) {
            this.logger.info("Removing deleted channels");
            assert (this.deletedRepositories != null);
            this.removeChannels(this.deletedRepositories, true);
        }
        List<String> backupRepositories = entry.getAffectedChannels();
        HashMap<String, SemaphoreLock> semaphoreMap = new HashMap<String, SemaphoreLock>();
        for (String repo : backupRepositories) {
            Integer id = this.channelIds.get(repo);
            if (id == null) continue;
            SemaphoreLock permit = this.channelPermits.get(id);
            if (permit != null) {
                semaphoreMap.put(repo, permit);
                continue;
            }
            this.logger.warn("Missing lock permit for repository {} with channel {} ", (Object)repo, (Object)id);
        }
        this.removeChannels(backupRepositories, false);
        for (String repo : backupRepositories) {
            this.logger.info("Recreating channel for repository {} after backup restore", (Object)repo);
            SemaphoreLock permit = (SemaphoreLock)semaphoreMap.get(repo);
            int id = this.putChannelIfAbsentUnsafe(repo, permit);
            if (permit != null) continue;
            this.lockChannel(id);
        }
        this.logger.info("Successfully recreated channels for all repositories after backup restore");
    }

    protected final void unlockChannels(List<String> channels) {
        for (String repository : channels) {
            Integer id = this.channelIds.get(repository);
            if (id == null) continue;
            try {
                this.unlockChannel(this.getChannelId(repository));
            }
            catch (Exception e) {
                this.logger.warn("Failed to unlock channel {} with repository {}", new Object[]{id, repository, e});
            }
        }
    }

    protected final void lockChannels(List<String> channels) {
        for (String channel : channels) {
            Integer id = this.channelIds.get(channel);
            if (id == null) continue;
            this.lockChannel(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void removeChannels(List<String> channels, boolean releaseOnRemoval) {
        for (String repo : channels) {
            Integer id = this.channelIds.get(repo);
            if (id == null) continue;
            this.logger.info("Removing outdated channel {} for repository {} after backup restore", (Object)id, (Object)repo);
            SemaphoreLock semaphore = null;
            try {
                semaphore = this.channelPermits.get(id);
                this.removeChannel(repo);
            }
            finally {
                if (!releaseOnRemoval) continue;
                try {
                    if (semaphore == null) continue;
                    semaphore.unlock();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected final void lockChanelPermits() {
        int i = 0;
        ArrayList<Map.Entry<Integer, SemaphoreLock>> permits = new ArrayList<Map.Entry<Integer, SemaphoreLock>>(this.channelPermits.entrySet());
        try {
            for (Map.Entry<Integer, SemaphoreLock> entry : permits) {
                String channel = this.getChannel(entry.getKey());
                this.logger.info("Attempting to lock transaction channel for repository {}", (Object)channel);
                if (!entry.getValue().tryLock(1L, TimeUnit.MINUTES)) {
                    throw new TransactionLogException("Unable to acquire lock for repository " + channel + " for 60s");
                }
                this.logger.info("Successfully locked transaction channel for repository {}", (Object)channel);
                ++i;
            }
        }
        catch (Exception e) {
            this.logger.error("Unable to acquire all channel permits due to: ", (Throwable)e);
            for (Map.Entry<Integer, SemaphoreLock> entry : permits) {
                if (i-- <= 0) break;
                try {
                    entry.getValue().unlock();
                }
                catch (Exception exception) {}
            }
            throw e;
        }
    }

    protected final boolean checkNewTransaction(long commitIndex) {
        return this.activeTransaction.get() != commitIndex;
    }

    protected final boolean awaitActiveTransaction(long commitIndex) {
        if (this.activeTransaction.get() != commitIndex) {
            try {
                this.activeLock.lockInterruptibly();
                this.activeTransaction.set(commitIndex);
                return true;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new TransactionLogException("Could not acquire active transaction lock", e);
            }
        }
        return false;
    }

    protected void verifyInit() {
        if (!this.initialized) {
            throw new TransactionLogException("Transaction log is not initialized");
        }
    }

    private void resetTransactionVars(long id) {
        if (this.activeTransaction.compareAndSet(id, -1L)) {
            try {
                this.resetChannelVars();
            }
            finally {
                this.activeLock.unlock();
            }
        } else {
            this.logger.warn("Cannot reset transaction vars because they were not held by current thread {}", (Object)id);
        }
    }

    protected void setInitialSize() {
        long tempSize = 0L;
        for (long i = 0L; i <= this.getLastLogIndex(); ++i) {
            LogEntry entry;
            LogEntry logEntry = entry = i < 1L ? null : this.fetchLogEntryUnsafe(i);
            if (entry == null || entry.getStatus() != LogEntry.Status.VALID) continue;
            tempSize += entry.getSize();
        }
        this.size.set(tempSize);
    }

    @Override
    public AtomicLong getSize() {
        return this.size;
    }

    protected abstract void resetChannelVars();
}

