/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.observe;

import com.ontotext.graphdb.raft.NodeState;
import com.ontotext.graphdb.raft.grpc.NodeInfo;
import com.ontotext.graphdb.raft.observe.RaftObserver;
import java.lang.invoke.MethodHandles;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftObservers {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final Set<RaftObserver> observers = new CopyOnWriteArraySet<RaftObserver>();

    public void attach(RaftObserver observer, long currentTerm, NodeState state, NodeInfo leaderInfo) {
        Objects.requireNonNull(observer, "Cannot attach null observer!");
        LOGGER.debug("Attaching observer {}", (Object)observer.getClass().getSimpleName());
        this.observers.add(observer);
        if (currentTerm > 0L) {
            try {
                observer.update(currentTerm);
            }
            catch (Exception ex) {
                LOGGER.warn("Could not apply term update to {}", (Object)observer.getClass().getSimpleName(), (Object)ex);
            }
        }
        if (state != null) {
            try {
                observer.update(state);
            }
            catch (Exception ex) {
                LOGGER.warn("Could not apply state update to {}", (Object)observer.getClass().getSimpleName(), (Object)ex);
            }
        }
        this.notifyOnLeaderChange(observer, leaderInfo);
    }

    public void detach(RaftObserver observer) {
        if (observer == null) {
            return;
        }
        LOGGER.info("Detaching raft observer {}", (Object)observer.getClass().getSimpleName());
        this.observers.remove(observer);
    }

    public void detachAll() {
        LOGGER.warn("Detaching all raft observers!");
        this.observers.clear();
    }

    public void notifyOnLeaderChange(NodeInfo leaderInfo) {
        for (RaftObserver observer : this.observers) {
            this.notifyOnLeaderChange(observer, leaderInfo);
        }
    }

    private void notifyOnLeaderChange(RaftObserver observer, NodeInfo leaderInfo) {
        String leaderRpcAddress = null;
        String leaderHttpAddress = null;
        if (leaderInfo != null) {
            leaderRpcAddress = leaderInfo.getRpcAddress();
            leaderHttpAddress = leaderInfo.getHttpAddress();
        }
        try {
            observer.update(leaderRpcAddress, leaderHttpAddress);
        }
        catch (Exception ex) {
            LOGGER.warn("Could not apply leader update to {}", (Object)observer.getClass().getSimpleName(), (Object)ex);
        }
    }

    public void notifyOnStateUpdate(NodeState state) {
        for (RaftObserver observer : this.observers) {
            try {
                observer.update(state);
            }
            catch (Exception ex) {
                LOGGER.warn("Could not apply state update to {}", (Object)observer.getClass().getSimpleName(), (Object)ex);
            }
        }
    }

    public void notifyOnTermUpdate(long term) {
        for (RaftObserver observer : this.observers) {
            try {
                observer.update(term);
            }
            catch (Exception ex) {
                LOGGER.warn("Could not apply term update to {}", (Object)observer.getClass().getSimpleName(), (Object)ex);
            }
        }
    }

    public void notifyOnNewNodes(Iterable<NodeInfo> addedNodes) {
        for (RaftObserver observer : this.observers) {
            for (NodeInfo node : addedNodes) {
                try {
                    observer.nodeAdded(node.getRpcAddress(), node.getHttpAddress());
                }
                catch (Exception ex) {
                    LOGGER.warn("Could not apply node added update to {}", (Object)observer.getClass().getSimpleName(), (Object)ex);
                }
            }
        }
    }

    public void notifyOnRemovedNodes(Iterable<NodeInfo> removedNodes) {
        for (RaftObserver observer : this.observers) {
            for (NodeInfo node : removedNodes) {
                try {
                    observer.nodeRemoved(node.getRpcAddress(), node.getHttpAddress());
                }
                catch (Exception ex) {
                    LOGGER.warn("Could not apply node removed update to {}", (Object)observer.getClass().getSimpleName(), (Object)ex);
                }
            }
        }
    }
}

