/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.node.task;

import com.ontotext.graphdb.raft.grpc.AppendResponse;
import com.ontotext.graphdb.raft.grpc.BackupEntry;
import com.ontotext.graphdb.raft.grpc.RaftRpcConnectionException;
import com.ontotext.graphdb.raft.grpc.RpcNodeClient;
import com.ontotext.graphdb.raft.node.Quorum;
import com.ontotext.graphdb.raft.node.RaftTaskController;
import com.ontotext.graphdb.raft.node.task.AppendTask;
import java.io.InputStream;

public class BackupEntryTask
extends AppendTask {
    protected final BackupEntry entry;
    protected final InputStream backupStream;

    public BackupEntryTask(RpcNodeClient rpcNode, BackupEntry entry, InputStream backupStream, Quorum quorum, RaftTaskController state) {
        super(rpcNode, quorum, state);
        this.entry = entry;
        this.backupStream = backupStream;
    }

    @Override
    public void run() {
        RpcNodeClient.Status status = this.rpcNode.getStatus();
        if (status == RpcNodeClient.Status.SYNCING || status == RpcNodeClient.Status.NO_CONNECTION) {
            this.logger.warn("Skip backup entry to node {} due to status {}", (Object)this.rpcNode.getAddress(), (Object)status);
            if (this.quorum != null) {
                this.quorum.incrementStart();
            }
            return;
        }
        this.appendBackupEntryToNode();
    }

    private void appendBackupEntryToNode() {
        try {
            AppendResponse response;
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Sending message {} to {} ", (Object)this.entry, (Object)this.rpcNode.getAddress());
            }
            if ((response = this.rpcNode.sendBackupStreamRpc(this.backupStream, this.entry, this.quorum)) == null) {
                this.logger.error("Follower {} did not respond for update with ID {}", (Object)this.rpcNode.getAddress(), (Object)this.getEntryCommitIndex());
                return;
            }
            this.processResponse(response.getTerm(), response.getMatchIndex(), response.getSuccess());
        }
        catch (RaftRpcConnectionException e) {
            this.rpcNode.setNoConnectionStatus(e);
        }
    }

    @Override
    protected long getEntryCommitIndex() {
        return this.entry.getData().getCommitIndex();
    }
}

