/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.node.task;

import com.ontotext.graphdb.raft.grpc.RpcNodeClient;
import com.ontotext.graphdb.raft.node.Quorum;
import com.ontotext.graphdb.raft.node.RaftTaskController;
import com.ontotext.graphdb.raft.util.RaftUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AppendTask
implements Runnable {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final RpcNodeClient rpcNode;
    protected final Quorum quorum;
    protected final RaftTaskController state;

    protected AppendTask(RpcNodeClient rpcNode, Quorum quorum, RaftTaskController state) {
        this.rpcNode = rpcNode;
        this.quorum = quorum;
        this.state = state;
    }

    protected void processResponse(long responseTerm, long responseMatchIndex, boolean success) {
        this.handleResponseTerm(responseTerm);
        this.handleNodeStatus();
        if (responseTerm == this.state.getCurrentTerm()) {
            this.rpcNode.setMatchIndex(responseMatchIndex);
            this.rpcNode.setNextIndex(responseMatchIndex + 1L);
            if (success) {
                if (responseMatchIndex == this.state.getLastLogIndex()) {
                    this.rpcNode.setInSyncStatus();
                }
            } else if (responseMatchIndex < this.state.getLastLogIndex() && this.rpcNode.setSyncingStatus()) {
                this.handleOutOfSyncFollower(responseMatchIndex);
            }
            this.handleQuorumIncrement(responseMatchIndex, success);
        } else if (responseTerm < this.state.getCurrentTerm()) {
            this.logger.warn("[Node {}] Stale append response with term {} when current term is {} from node {}", new Object[]{this.state.getCurrentAddress(), responseTerm, this.state.getCurrentTerm(), this.rpcNode});
        } else {
            this.logger.warn("[Node {}] Received higher append response term {} when current term is {} from node {}", new Object[]{this.state.getCurrentAddress(), responseTerm, this.state.getCurrentTerm(), this.rpcNode});
        }
    }

    protected void handleOutOfSyncFollower(long responseMatchIndex) {
        this.logger.error("Node {} could not process entry {} and node match index {}", new Object[]{this.rpcNode.getAddress(), this.state.getLastLogIndex(), responseMatchIndex});
        RaftUtil.handleOutOfSyncFollower(this.rpcNode, responseMatchIndex, null, this.state, false);
    }

    protected void handleQuorumIncrement(long responseMatchIndex, boolean success) {
        if (this.quorum != null && this.getEntryCommitIndex() == responseMatchIndex) {
            this.quorum.increment(success);
        }
    }

    protected void handleNodeStatus() {
        if (this.rpcNode.getStatus() == RpcNodeClient.Status.NO_CONNECTION) {
            this.rpcNode.setInSyncStatus();
        }
    }

    protected void handleResponseTerm(long responseTerm) {
        try {
            this.state.getResponseLock().lock();
            if (this.state.getCurrentTerm() < responseTerm) {
                this.state.stepDown(responseTerm);
            }
        }
        finally {
            this.state.getResponseLock().unlock();
        }
    }

    protected abstract long getEntryCommitIndex();
}

