/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.node;

import com.ontotext.graphdb.raft.ClusterGroup;
import com.ontotext.graphdb.raft.NodeState;
import com.ontotext.graphdb.raft.grpc.RpcNodeClient;
import com.ontotext.graphdb.raft.storage.LogEntry;
import com.ontotext.graphdb.raft.util.StreamingResponseObserver;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RaftStreamObserver<T, U>
implements StreamObserver<T> {
    private static final Logger logger = LoggerFactory.getLogger(RaftStreamObserver.class);
    private static final String NO_LICENSE_MESSAGE = "Cannot append entry: node is restricted due to a missing Enterprise license or CLUSTER capability.";
    protected final AtomicBoolean isInit;
    protected final StreamingResponseObserver<U> responseObserver;
    protected final AtomicReference<NodeState> state;
    protected final ClusterGroup group;
    protected boolean sentError;
    protected LogEntry committableEntry;
    protected String currentLeader;
    protected int channel;
    protected long entity;
    protected boolean committed;
    protected final Lock instanceLock;
    protected final AtomicBoolean isApplyingSecondaryEntry;

    protected RaftStreamObserver(StreamingResponseObserver<U> responseObserver, AtomicReference<NodeState> state, ClusterGroup group, Lock instanceLock, AtomicBoolean isApplyingEntry) {
        this.responseObserver = responseObserver;
        this.state = state;
        this.group = group;
        this.instanceLock = instanceLock;
        this.isApplyingSecondaryEntry = isApplyingEntry;
        this.isInit = new AtomicBoolean(false);
        this.sentError = false;
        this.channel = -1;
        this.entity = -1L;
        this.committed = false;
    }

    public final synchronized void onNext(T entry) {
        if (this.sentError) {
            return;
        }
        if (NodeState.OUT_OF_SYNC == this.state.get()) {
            this.handleOutOfSyncOnStream();
            this.respondOutOfSync();
            return;
        }
        if (this.isInit.compareAndSet(false, true)) {
            this.validateAndRecordFirstEntry(entry);
        } else {
            this.processStreamingEntry(entry);
        }
    }

    public synchronized void onError(Throwable throwable) {
        try {
            logger.warn("Could not process streaming entry {} from leader due to: ", (Object)this.entity, (Object)throwable);
            if (!this.sentError && this.entity > 0L) {
                if (this.committableEntry != null && this.committableEntry.getFingerprint() != null && !this.committableEntry.getFingerprint().isEmpty()) {
                    this.verifyAppendEntry(this.committableEntry, this.group.getClusterRpcNode(this.currentLeader), true);
                } else {
                    this.group.getTransactionLog().rollbackLogEntryStream(this.entity);
                }
            }
        }
        finally {
            this.resetElectionTimeout();
            if (!this.committed) {
                this.group.setStreaming(false);
                if (this.entity > 0L) {
                    try {
                        this.instanceLock.unlock();
                    }
                    catch (Exception exception) {}
                }
            }
            if (!this.sentError) {
                this.sentError = true;
                this.responseObserver.onError((Throwable)new StatusRuntimeException(Status.INTERNAL.withDescription(throwable.getMessage())));
            }
        }
    }

    public synchronized void onCompleted() {
        try {
            if (!this.sentError) {
                if (this.entity < 0L && !this.responseObserver.isCompleted()) {
                    this.rejectEntry((StreamObserver<U>)this.responseObserver);
                }
                this.resetElectionTimeout();
                if (this.entity > 0L && this.committableEntry != null) {
                    if (this.state.get() == NodeState.OUT_OF_SYNC) {
                        logger.warn("Cannot verify entry {} with channel {} as node is out of sync", (Object)this.committableEntry.getIndex(), (Object)this.committableEntry.getChannel());
                        this.group.getTransactionLog().unlockChannel(this.committableEntry.getChannel());
                    } else {
                        this.verifyAppendEntry(this.committableEntry, this.group.getClusterRpcNode(this.currentLeader), false);
                    }
                }
            }
        }
        finally {
            if (!this.responseObserver.isCompleted()) {
                this.responseObserver.onCompleted();
            }
        }
    }

    protected void validateAndRecordFirstEntry(T entry) {
        this.logIncomingStream(entry);
        if (this.group.isBuildingSnapshot()) {
            this.rejectEntryWithError("Cannot process streaming entry as node is building a snapshot");
            return;
        }
        this.instanceLock.lock();
        try {
            this.channel = this.getChannel(entry);
            if (this.isRestrictedOnNoEnterpriseLicense()) {
                this.updateTerm(entry);
                this.respondNoLicense();
                return;
            }
            if (!this.isAppendEntryValid(entry)) {
                this.rejectEntryWithError("Could not process streaming entry with match index " + this.group.getTransactionLog().getLastLogIndex());
                return;
            }
            if (NodeState.OUT_OF_SYNC == this.state.get()) {
                this.handleOutOfSyncOnStream();
                this.respondOutOfSync();
                return;
            }
            this.updateTerm(entry);
            this.setFromCandidateToFollower(entry);
            if (this.state.get() == NodeState.FOLLOWER && this.validateLeader(entry)) {
                this.currentLeader = this.getLeader(entry);
                this.entity = this.processFirstStreamingEntry(entry, (StreamObserver<U>)this.responseObserver);
                if (this.entity < 1L) {
                    this.rejectEntryWithError("Could not start processing streaming entry with match index " + this.group.getTransactionLog().getLastLogIndex());
                }
            } else {
                logger.error("Node {} with state {} cannot append entry {}", new Object[]{this.group.getCurrentAddress(), this.state.get(), entry});
                this.rejectEntryWithError("Could not process streaming entry with node state " + String.valueOf((Object)this.state.get()));
            }
        }
        catch (Exception e) {
            this.respondInternalError(e);
        }
        finally {
            if (this.entity < 1L) {
                this.instanceLock.unlock();
            } else {
                this.group.setStreaming(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processStreamingEntry(T entry) {
        if (!this.hasFingerprint(entry)) {
            try {
                this.appendLogEntryStream(entry);
            }
            catch (Exception e) {
                try {
                    this.instanceLock.unlock();
                }
                finally {
                    this.respondInternalError(e);
                }
            }
        } else {
            this.group.incrementUpdate();
            Lock systemLock = this.getSystemLock(this.getChannel(entry));
            try {
                LogEntry logEntry;
                try {
                    systemLock.lock();
                    try {
                        logEntry = this.commitLogEntryStream(this.entity, entry);
                    }
                    catch (Exception e) {
                        systemLock.unlock();
                        throw e;
                    }
                }
                finally {
                    this.committed = true;
                    this.group.setStreaming(false);
                    this.instanceLock.unlock();
                }
                this.group.getStateMachine().readLock();
                try {
                    try {
                        this.setIsApplyingSecondaryEntry(entry, true);
                        if (this.applyEntryToMachine(logEntry)) {
                            this.committableEntry = logEntry;
                            logger.info("Entry {} successfully committed", (Object)logEntry.getIndex());
                        }
                    }
                    finally {
                        this.setIsApplyingSecondaryEntry(entry, false);
                        systemLock.unlock();
                    }
                }
                finally {
                    this.group.getStateMachine().readUnlock();
                }
            }
            catch (Exception e) {
                this.respondInternalError(e);
            }
            finally {
                this.group.decrementUpdate();
            }
        }
    }

    protected abstract void logIncomingStream(T var1);

    protected abstract void updateTerm(T var1);

    protected abstract void resetElectionTimeout();

    protected abstract int getChannel(T var1);

    protected abstract boolean isAppendEntryValid(T var1);

    protected abstract boolean isRestrictedOnNoEnterpriseLicense();

    protected abstract void setFromCandidateToFollower(T var1);

    protected abstract boolean applyEntryToMachine(LogEntry var1);

    protected abstract void rejectEntry(StreamObserver<U> var1);

    protected abstract void verifyAppendEntry(LogEntry var1, RpcNodeClient var2, boolean var3);

    protected abstract boolean hasFingerprint(T var1);

    protected abstract boolean validateLeader(T var1);

    protected abstract String getLeader(T var1);

    protected abstract void appendLogEntryStream(T var1);

    protected abstract LogEntry commitLogEntryStream(long var1, T var3);

    protected abstract long processFirstStreamingEntry(T var1, StreamObserver<U> var2);

    protected abstract void handleOutOfSyncOnStream();

    private void rejectEntryWithError(String message) {
        if (!this.sentError) {
            this.sentError = true;
            this.responseObserver.onError((Throwable)new StatusRuntimeException(Status.FAILED_PRECONDITION.withDescription(message)));
        }
    }

    private Lock getSystemLock(int channel) {
        ReadWriteLock systemLock = this.group.getSystemLock();
        if (channel == 0 || channel == -8) {
            return systemLock.writeLock();
        }
        return systemLock.readLock();
    }

    private void respondOutOfSync() {
        if (!this.sentError) {
            this.sentError = true;
            this.responseObserver.onError((Throwable)new StatusRuntimeException(Status.FAILED_PRECONDITION.withDescription("Unable to process entry during snapshot recovery")));
        }
    }

    private void respondInternalError(Exception e) {
        logger.error("Unexpected error occurred during stream processing: ", (Throwable)e);
        this.sentError = true;
        this.responseObserver.onError((Throwable)new StatusRuntimeException(Status.INTERNAL.withDescription(e.getMessage())));
    }

    private void respondNoLicense() {
        logger.error(NO_LICENSE_MESSAGE);
        this.rejectEntryWithError(NO_LICENSE_MESSAGE);
    }

    private void setIsApplyingSecondaryEntry(T entry, boolean value) {
        if (this.getChannel(entry) == -8) {
            this.isApplyingSecondaryEntry.set(value);
        }
    }
}

