/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.node;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.ByteString;
import com.google.protobuf.GraphDBByteString;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.raft.ClusterGroup;
import com.ontotext.graphdb.raft.NodeState;
import com.ontotext.graphdb.raft.RaftException;
import com.ontotext.graphdb.raft.RecoveryState;
import com.ontotext.graphdb.raft.ReplicationCluster;
import com.ontotext.graphdb.raft.config.ConfigUtil;
import com.ontotext.graphdb.raft.grpc.AppendEntry;
import com.ontotext.graphdb.raft.grpc.AppendResponse;
import com.ontotext.graphdb.raft.grpc.BackupEntry;
import com.ontotext.graphdb.raft.grpc.ConfigEntry;
import com.ontotext.graphdb.raft.grpc.ConfigResponse;
import com.ontotext.graphdb.raft.grpc.NodeInfo;
import com.ontotext.graphdb.raft.grpc.PullEntry;
import com.ontotext.graphdb.raft.grpc.PullRequest;
import com.ontotext.graphdb.raft.grpc.RaftRpcConnectionException;
import com.ontotext.graphdb.raft.grpc.RecoveryStateOperation;
import com.ontotext.graphdb.raft.grpc.RpcNodeClient;
import com.ontotext.graphdb.raft.grpc.StatusRequest;
import com.ontotext.graphdb.raft.grpc.StatusResponse;
import com.ontotext.graphdb.raft.grpc.VerifyEntry;
import com.ontotext.graphdb.raft.grpc.VerifyResponse;
import com.ontotext.graphdb.raft.grpc.VoteRequest;
import com.ontotext.graphdb.raft.grpc.VoteResponse;
import com.ontotext.graphdb.raft.node.Quorum;
import com.ontotext.graphdb.raft.node.QuorumCache;
import com.ontotext.graphdb.raft.node.RaftStreamObserver;
import com.ontotext.graphdb.raft.node.RaftTaskController;
import com.ontotext.graphdb.raft.node.concurrent.SemaphoreLock;
import com.ontotext.graphdb.raft.node.task.AppendEntryTask;
import com.ontotext.graphdb.raft.node.task.BackupEntryTask;
import com.ontotext.graphdb.raft.node.task.ConfigEntryTask;
import com.ontotext.graphdb.raft.node.task.HeartbeatCatchupTask;
import com.ontotext.graphdb.raft.node.task.HeartbeatTask;
import com.ontotext.graphdb.raft.node.task.PullPrimarySnapshotTask;
import com.ontotext.graphdb.raft.node.task.PullPrimaryUpdateTask;
import com.ontotext.graphdb.raft.node.task.StopSecondaryModeTask;
import com.ontotext.graphdb.raft.node.task.TruncateLogTask;
import com.ontotext.graphdb.raft.node.task.UpdateSecondaryTagsTask;
import com.ontotext.graphdb.raft.node.task.VerifyEntryTask;
import com.ontotext.graphdb.raft.observe.RaftObserver;
import com.ontotext.graphdb.raft.observe.RaftObservers;
import com.ontotext.graphdb.raft.observe.RaftSubject;
import com.ontotext.graphdb.raft.recovery.RaftRecoveryException;
import com.ontotext.graphdb.raft.recovery.RecoveryHook;
import com.ontotext.graphdb.raft.recovery.RecoveryTask;
import com.ontotext.graphdb.raft.statistics.ClusterStatistics;
import com.ontotext.graphdb.raft.storage.LogEntry;
import com.ontotext.graphdb.raft.storage.TransactionLog;
import com.ontotext.graphdb.raft.storage.TransactionLogException;
import com.ontotext.graphdb.raft.util.RaftUtil;
import com.ontotext.graphdb.raft.util.RpcOutputStream;
import com.ontotext.graphdb.raft.util.StreamingResponseObserver;
import common.DecoratingExecutorService;
import common.GraphDBMDCExecutorBuilder;
import io.grpc.Context;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.Nullable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftNode
implements RaftSubject,
ReplicationCluster {
    private static final Logger logger = LoggerFactory.getLogger(RaftNode.class);
    private static final String NO_LEADER = "";
    private final ClusterGroup clusterGroup;
    private final AtomicReference<String> leader;
    private final TransactionLog transactionLog;
    private final AtomicReference<NodeState> state;
    private final AtomicReference<RecoveryState> recoveryState;
    private String votedFor;
    private volatile long currentTerm;
    private volatile boolean failedInitialization;
    private volatile boolean isInitialized;
    public static final String SECONDARY_FINGERPRINT = "SECONDARY";
    public static final String DISABLE_PLUGIN_FINGERPRINT_CHECK = "graphdb.disable.cluster.fingerprint.check";
    private final boolean disablePluginFingerprint = Config.getPropertyAsBoolean((String)"graphdb.disable.cluster.fingerprint.check", (boolean)false);
    private final Set<String> votesRespondedSet;
    private final Set<String> votesGrantedSet;
    private volatile ExecutorService updatePropagationService;
    private final Supplier<ScheduledExecutorService> executorServiceCreator;
    private ScheduledExecutorService executorService;
    private volatile ScheduledFuture<?> electionTask;
    private volatile ScheduledFuture<?> heartbeatTask;
    private volatile Future<?> pullUpdateTask;
    private final QuorumCache quorumCache;
    @VisibleForTesting
    protected final Lock instanceLock;
    private final Lock electionLock;
    private final Lock recoveryLock;
    private final ReadWriteLock systemLock;
    private final RaftTaskController raftTaskController;
    private final RaftObservers observers;
    private volatile AppendEntry temporaryHeartbeat;
    private final AtomicInteger numberOfFailedTransactions;
    private final AtomicInteger numberOfFailedRecoveries;
    protected final AtomicBoolean isApplyingSecondaryEntry;

    protected RaftNode(ClusterGroup clusterGroup) {
        this(clusterGroup, () -> GraphDBMDCExecutorBuilder.build((ScheduledExecutorService)Executors.newScheduledThreadPool(16, new ThreadFactoryBuilder().setNameFormat("graphdb-raft-server-%d").build())));
    }

    @VisibleForTesting
    protected RaftNode(ClusterGroup clusterGroup, Supplier<ScheduledExecutorService> executorServiceCreator) {
        this.clusterGroup = clusterGroup;
        this.executorServiceCreator = executorServiceCreator;
        this.executorService = executorServiceCreator.get();
        this.updatePropagationService = this.buildUpdatePropagationService();
        this.instanceLock = new SemaphoreLock();
        this.electionLock = new SemaphoreLock();
        this.recoveryLock = new SemaphoreLock();
        this.systemLock = clusterGroup.getSystemLock();
        this.leader = new AtomicReference();
        this.currentTerm = 1L;
        this.state = new AtomicReference<NodeState>(NodeState.NO_CLUSTER);
        this.recoveryState = new AtomicReference<RecoveryState>(new RecoveryState());
        this.votedFor = null;
        this.votesRespondedSet = ConcurrentHashMap.newKeySet();
        this.votesGrantedSet = ConcurrentHashMap.newKeySet();
        this.transactionLog = clusterGroup.getTransactionLog();
        this.observers = new RaftObservers();
        this.quorumCache = new QuorumCache(64, clusterGroup.size());
        this.raftTaskController = new RaftTaskController(() -> this.currentTerm, this::stepDown, this::goOutOfSync, clusterGroup, this.state, () -> this.executorService, this.quorumCache, this::areFingerprintsEqual);
        this.numberOfFailedTransactions = new AtomicInteger(0);
        this.numberOfFailedRecoveries = new AtomicInteger(0);
        this.isInitialized = false;
        this.isApplyingSecondaryEntry = new AtomicBoolean(false);
    }

    public ClusterGroup getClusterGroup() {
        return this.clusterGroup;
    }

    public String getAddress() {
        return this.clusterGroup.getCurrentAddress();
    }

    public NodeState getState() {
        return this.state.get();
    }

    public String getLeader() {
        return this.leader.get();
    }

    public int getNumberOfFailedTransactions() {
        return this.numberOfFailedTransactions.get();
    }

    public long getTerm() {
        return this.currentTerm;
    }

    public AtomicReference<RecoveryState> getRecoveryState() {
        return this.recoveryState;
    }

    @Override
    public void initialize(List<String> repositoryIds) {
        try {
            this.transactionLog.initialize();
            ArrayList<String> repositoryIdsCopy = new ArrayList<String>(repositoryIds);
            Collections.sort(repositoryIdsCopy);
            repositoryIdsCopy.forEach(this.transactionLog::putChannelIfAbsent);
        }
        catch (Exception e) {
            logger.error("[Node {}] Failed during initialization", (Object)this.getAddress(), (Object)e);
            this.failedInitialization = true;
        }
    }

    @Override
    public void start(boolean shouldRestrict) {
        this.instanceLock.lock();
        try {
            if (this.executorService.isShutdown()) {
                this.executorService = this.executorServiceCreator.get();
                this.updatePropagationService = this.buildUpdatePropagationService();
                this.clusterGroup.reset();
            } else {
                this.clusterGroup.generateNodeChannels();
            }
            this.resetClusterStatistics();
            this.updateMachineHook();
            this.update(NodeState.NO_CLUSTER);
            if (shouldRestrict) {
                this.update(NodeState.NO_CLUSTER);
                logger.warn("Node {} was part of another cluster group, in order for it to function, replace the node in the cluster", (Object)this.getAddress());
                if (this.isFailedInitialization()) {
                    logger.error("Data is corrupted");
                }
                return;
            }
            if (this.isFailedInitialization()) {
                this.goOutOfSync();
                this.failedInitialization = false;
            } else {
                this.verifyLastChannelEntries();
                RaftUtil.checkForMarkedSnapshots(this.clusterGroup);
                if (this.state.get() != NodeState.OUT_OF_SYNC && !this.clusterGroup.isRecovering()) {
                    this.update(NodeState.FOLLOWER);
                    this.resetElectionTimeout();
                }
            }
        }
        finally {
            this.isInitialized = true;
            this.instanceLock.unlock();
        }
    }

    public boolean isFailedInitialization() {
        return this.failedInitialization;
    }

    public boolean isInitialized() {
        return this.isInitialized;
    }

    public void updateMachineHook() {
        this.clusterGroup.getStateMachine().setGroup(this.clusterGroup);
    }

    public boolean isRunning() {
        return !this.executorService.isShutdown();
    }

    @Override
    public void shutdown() {
        this.failedInitialization = false;
        this.isInitialized = false;
        if (!this.executorService.isShutdown()) {
            try {
                if (this.electionTask != null) {
                    this.electionTask.cancel(true);
                }
                if (this.heartbeatTask != null) {
                    this.heartbeatTask.cancel(true);
                }
                this.executorService.shutdownNow();
                this.updatePropagationService.shutdownNow();
                this.clusterGroup.shutdown();
                this.transactionLog.shutdown(false);
            }
            finally {
                this.update(NodeState.NO_CLUSTER);
            }
        }
    }

    @Override
    public OutputStream recordUpdate(String repository) {
        this.validatePrimaryState();
        if (this.state.get() == NodeState.OUT_OF_SYNC) {
            throw new RaftException("Cannot start new transaction when out of sync");
        }
        return this.transactionLog.beginTransactionRecord(repository, this.getClusterGroup().getRecoveryFlag());
    }

    @Override
    public OutputStream recordBackup(List<String> affectedRepositories, boolean clearAll) {
        this.validatePrimaryState();
        if (this.state.get() == NodeState.OUT_OF_SYNC) {
            throw new RaftException("Cannot start new transaction when out of sync");
        }
        return this.transactionLog.beginBackupRecord(affectedRepositories, clearAll);
    }

    @Override
    public void rollbackUpdate(String repository) {
        this.recoveryLock.lock();
        try {
            this.clusterGroup.getTransactionLog().rollbackTransactionRecord(repository);
        }
        finally {
            this.recoveryLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long replicateUpdate(String repository, String fingerprint) {
        if (this.clusterGroup.isSecondary() && !SECONDARY_FINGERPRINT.equals(repository)) {
            throw new RaftException("Secondary cluster nodes cannot directly process updates");
        }
        this.instanceLock.lock();
        Quorum quorum = this.quorumCache.fetchQuorum(this.clusterGroup.size());
        boolean isInstanceLocked = true;
        try {
            long prevLastLogIndex = this.transactionLog.getLastLogIndex();
            long prevLastLogTerm = this.transactionLog.getLastLogTerm();
            this.temporaryHeartbeat = this.createHeartbeatEntry(prevLastLogIndex, prevLastLogTerm);
            AppendEntry metadata = this.buildUpdateEntry(repository, fingerprint, prevLastLogIndex, prevLastLogTerm);
            LogEntry appendedEntry = this.transactionLog.commitTransactionRecord(repository, metadata);
            if (appendedEntry.getChannel() == -8) {
                this.clusterGroup.getStateMachine().apply(appendedEntry);
            }
            Future<LogEntry> updatePropagation = this.updatePropagationService.submit(new UpdatePropagationTask(quorum, metadata, appendedEntry));
            if (appendedEntry.getChannel() != 0 && appendedEntry.getChannel() != -8) {
                this.instanceLock.unlock();
                isInstanceLocked = false;
            }
            LogEntry newLastLog = null;
            while (newLastLog == null && !Thread.currentThread().isInterrupted()) {
                if (this.state.get() == NodeState.OUT_OF_SYNC || this.state.get() == NodeState.NO_CLUSTER || this.updatePropagationService.isShutdown()) {
                    throw new RaftException("Cluster is not in sync to replicate update");
                }
                try {
                    newLastLog = updatePropagation.get(20L, TimeUnit.SECONDS);
                    if (newLastLog != null) continue;
                    throw new RaftException("Cluster is not in sync to replicate update");
                }
                catch (TimeoutException timeoutException) {
                }
            }
            quorum.await();
            long l = this.handleQuorumResponses(quorum.getState(), newLastLog);
            return l;
        }
        catch (Exception e) {
            logger.error("[Node {}] Pending transaction for repository {} failed. Node will go out of sync due to: ", new Object[]{this.getAddress(), repository, e});
            this.incrementFailedTransactionsCount();
            this.handleFailedUpdate(repository, true, isInstanceLocked);
            long l = -1L;
            return l;
        }
        finally {
            this.temporaryHeartbeat = null;
            this.quorumCache.releaseQuorum(quorum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long replicateBackup(String fingerprint) {
        this.validatePrimaryState();
        this.instanceLock.lock();
        boolean isInstanceLocked = true;
        Quorum quorum = this.quorumCache.fetchQuorum(this.clusterGroup.size());
        int lastRepoIndex = this.clusterGroup.getTransactionLog().getCurrentRepoIndex();
        try {
            if (this.isUpdateReplicable(quorum) && RaftUtil.isClusterInSync(quorum, this.raftTaskController)) {
                LogEntry newLastLog = this.replicateBackupEntry(fingerprint, quorum);
                this.instanceLock.unlock();
                isInstanceLocked = false;
                quorum.await();
                long l = this.handleQuorumResponses(quorum.getState(), newLastLog);
                return l;
            }
            logger.error("[Node {}] Pending backup failed as update is not replicable to all cluster nodes", (Object)this.getAddress());
            this.handleFailedUpdate("RECOVERY", false, isInstanceLocked);
            this.incrementClusterStatistics(-5);
            long newLastLog = -1L;
            return newLastLog;
        }
        catch (Exception e) {
            this.transactionLog.restoreRepositoryIndex(lastRepoIndex);
            logger.error("[Node {}] Pending backup failed to replicate to cluster due to: ", (Object)this.getAddress(), (Object)e);
            this.handleFailedUpdate("RECOVERY", true, isInstanceLocked);
            this.incrementClusterStatistics(-5);
            long l = -1L;
            return l;
        }
        finally {
            this.quorumCache.releaseQuorum(quorum);
        }
    }

    @Override
    public void rollbackBackup() {
        this.recoveryLock.lock();
        try {
            if (this.state.get() != NodeState.OUT_OF_SYNC) {
                this.transactionLog.rollbackBackupRecord();
            }
        }
        finally {
            this.recoveryLock.unlock();
        }
    }

    @Override
    public void truncateLog() {
        new TruncateLogTask(this.quorumCache.fetchTotalQuorum(this.clusterGroup.size()), this.raftTaskController, entry -> this.verifyAppendEntry((LogEntry)entry, null, false, true, false), entry -> {
            this.temporaryHeartbeat = entry == null ? null : this.createHeartbeatEntry(entry.getIndex(), entry.getTerm());
        }).run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pullTransactions(PullRequest request, StreamObserver<PullEntry> observer) {
        StreamingResponseObserver<PullEntry> delegateObserver = new StreamingResponseObserver<PullEntry>(observer);
        try {
            this.verifyPrimaryLeader();
            this.updateSecondaryTagMatchIndex(request);
            this.transactionLog.beginBatchingStream();
            try {
                this.verifyPrimaryLeader();
                long matchIndex = request.getLastIndex();
                long lastValidLog = this.transactionLog.getValidLogCheckpoint();
                if (matchIndex >= lastValidLog) {
                    delegateObserver.onNext(PullEntry.newBuilder().setHasData(false).build());
                    delegateObserver.onCompleted();
                    return;
                }
                if (matchIndex < this.clusterGroup.getTransactionLog().getEntryOffset()) {
                    delegateObserver.onError((Throwable)new StatusRuntimeException(Status.INTERNAL.withDescription("Unable to provide batch update for match index " + matchIndex + " as current log has been truncated to " + this.clusterGroup.getTransactionLog().getEntryOffset() + ". Please consider reattaching the secondary cluster.")));
                    return;
                }
                this.transactionLog.batchTransactionChannels(new RpcOutputStream(delegateObserver, 0x200000, data -> PullEntry.newBuilder().setData((ByteString)new GraphDBByteString((byte[])data)).setHasData(true).build()), matchIndex, lastValidLog);
                delegateObserver.onNext(PullEntry.newBuilder().setHasData(false).build());
                delegateObserver.onCompleted();
                logger.info("Sent bulk entries to secondary cluster node {} from index {} to {} ", new Object[]{request.getAddress(), matchIndex, lastValidLog});
            }
            finally {
                this.transactionLog.endBatchingStream();
            }
        }
        catch (Throwable t) {
            logger.error("Failed to send bulk entries to node {} due to:", (Object)request.getAddress(), (Object)t);
            if (t instanceof StatusRuntimeException) {
                delegateObserver.onError(t);
            }
            delegateObserver.onError((Throwable)new StatusRuntimeException(Status.INTERNAL.withDescription(t.getMessage())));
        }
    }

    private void verifyPrimaryLeader() {
        if (this.clusterGroup.isSecondary()) {
            throw new StatusRuntimeException(Status.FAILED_PRECONDITION.withDescription("Secondary clusters cannot be polled for updates by other secondary clusters"));
        }
        if (!this.isLeader()) {
            throw new StatusRuntimeException(Status.INTERNAL.withDescription("Node cannot provide transactions as it is not leader"));
        }
    }

    private void updateSecondaryTagMatchIndex(PullRequest request) {
        if (!this.clusterGroup.getTagMap().containsKey(request.getTag())) {
            throw new StatusRuntimeException(Status.FAILED_PRECONDITION.withDescription("Tag " + request.getTag() + " is not registered with this cluster"));
        }
        this.clusterGroup.getTagMap().computeIfPresent(request.getTag(), (k, v) -> request.getLastIndex());
    }

    private void handleFailedUpdate(String repository, boolean goOutOfSync, boolean unlockInstance) {
        if (goOutOfSync) {
            this.goOutOfSync();
        }
        if (unlockInstance) {
            try {
                this.instanceLock.unlock();
            }
            catch (IllegalMonitorStateException illegalMonitorStateException) {
                // empty catch block
            }
        }
        try {
            if (repository.equals("RECOVERY")) {
                this.transactionLog.rollbackBackupRecord();
            } else {
                this.transactionLog.rollbackTransactionRecord(repository);
            }
        }
        catch (Exception ex) {
            logger.warn("[Node {}] Error occurred during rollback of transaction record for repository {} : ", new Object[]{this.getAddress(), repository, ex});
        }
    }

    @Override
    public boolean isWritable() {
        int inSyncCount = 1;
        for (RpcNodeClient client : this.clusterGroup) {
            if (client.getStatus() != RpcNodeClient.Status.IN_SYNC) continue;
            ++inSyncCount;
        }
        return inSyncCount >= (int)Math.round((double)(this.clusterGroup.size() + 1) / 2.0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogEntry replicateLogEntry(AppendEntry metadata, Quorum quorum, LogEntry appendedEntry) {
        try {
            quorum.increment(true);
            quorum.incrementStart();
            boolean shouldStream = appendedEntry.getSize() > (long)this.getClusterGroup().getMessageSizeBytes();
            AppendEntry.Builder builder = AppendEntry.newBuilder().mergeFrom(metadata).setCommitIndex(appendedEntry.getIndex());
            if (!shouldStream) {
                try (InputStream stream = appendedEntry.getDataStream();){
                    builder.setRdfData(ByteString.readFrom((InputStream)stream));
                }
                catch (IOException e) {
                    throw new RaftException("Unable to replicate entry", (Throwable)e);
                }
            }
            AppendEntry replicationEntry = builder.build();
            logger.info("Replicating entry {} with transaction log {} and channel {}", new Object[]{replicationEntry.getCommitIndex(), appendedEntry.getIndex(), replicationEntry.getChannel()});
            for (RpcNodeClient rpcNode : this.clusterGroup) {
                quorum.addTask(this.executorService.submit(new AppendEntryTask(rpcNode, replicationEntry, shouldStream ? appendedEntry.getDataStream() : null, quorum, this.raftTaskController)));
            }
            quorum.awaitStart();
            LogEntry logEntry = appendedEntry;
            return logEntry;
        }
        finally {
            this.temporaryHeartbeat = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private LogEntry replicateBackupEntry(String fingerprint, Quorum quorum) {
        LogEntry oldLastLog = this.transactionLog.getLastLog();
        long oldLastLogIndex = oldLastLog == null ? 0L : oldLastLog.getIndex();
        long oldLastLogTerm = oldLastLog == null ? 0L : oldLastLog.getTerm();
        this.temporaryHeartbeat = this.createHeartbeatEntry(oldLastLogIndex, oldLastLogTerm);
        try {
            AppendEntry metadata = this.buildBackupEntry(fingerprint);
            LogEntry appendedEntry = this.transactionLog.commitBackupRecord(metadata);
            logger.info("Successfully recorded backup in transaction log");
            this.clusterGroup.getStateMachine().readLock();
            try {
                this.clusterGroup.getStateMachine().apply(appendedEntry);
            }
            finally {
                this.clusterGroup.getStateMachine().readUnlock();
            }
            quorum.increment(true);
            quorum.incrementStart();
            BackupEntry backupEntry = this.buildBackupEntry(appendedEntry, metadata, oldLastLogIndex, oldLastLogTerm);
            for (RpcNodeClient rpcNode : this.clusterGroup) {
                logger.info("Propagating backup to follower {}", (Object)rpcNode.getAddress());
                quorum.addTask(this.executorService.submit(new BackupEntryTask(rpcNode, backupEntry, appendedEntry.getDataStream(), quorum, this.raftTaskController)));
            }
            quorum.awaitStart();
            LogEntry logEntry = appendedEntry;
            return logEntry;
        }
        finally {
            this.temporaryHeartbeat = null;
        }
    }

    private BackupEntry buildBackupEntry(LogEntry logEntry, AppendEntry metadata, long oldLastLogIndex, long oldLastLogTerm) {
        AppendEntry.Builder replicationEntry = AppendEntry.newBuilder().mergeFrom(metadata).setCommitIndex(logEntry.getIndex()).setPrevLogIndex(oldLastLogIndex).setPrevLogTerm(oldLastLogTerm);
        return BackupEntry.newBuilder().setData(replicationEntry).setClearAll(logEntry.clearAllChannels()).addAllUpdatedChannels(logEntry.getAffectedChannels()).build();
    }

    private boolean catchUpNewNodes(List<NodeInfo> newAddresses) {
        if (this.transactionLog.getLastValidLog() == 0L) {
            return true;
        }
        Quorum quorum = this.quorumCache.fetchTotalQuorum(newAddresses.size());
        this.sendHeartbeat(quorum, newAddresses, true);
        quorum.awaitAll();
        return quorum.getState() == Quorum.State.SUCCESSFUL;
    }

    private void validatePrimaryState() {
        if (this.clusterGroup.isSecondary()) {
            throw new RaftException("Secondary cluster nodes cannot directly process updates");
        }
    }

    public LogEntry replicateConfigLogEntry(ConfigEntry entry, Quorum quorum) {
        long oldLastLogIndex = this.transactionLog.getLastLogIndex();
        long oldLastLogTerm = this.transactionLog.getLastLogTerm();
        LogEntry appendedEntry = this.transactionLog.appendConfigLogEntry(entry);
        this.transactionLog.setLogStatus(appendedEntry.getIndex(), LogEntry.Status.PROCESSED);
        quorum.increment(true);
        for (RpcNodeClient rpcNode : this.clusterGroup) {
            ConfigEntry configEntry = ConfigEntry.newBuilder(entry).setTerm(this.currentTerm).setCommitIndex(appendedEntry.getIndex()).setPrevLogIndex(oldLastLogIndex).setPrevLogTerm(oldLastLogTerm).build();
            if (entry.hasProperties() || entry.getNewConfigServersList().stream().map(NodeInfo::getRpcAddress).anyMatch(Predicate.isEqual(rpcNode.getAddress()))) {
                quorum.addTask(this.executorService.submit(new ConfigEntryTask(rpcNode, configEntry, quorum, this.raftTaskController)));
                continue;
            }
            this.executorService.submit(new ConfigEntryTask(rpcNode, configEntry, null, this.raftTaskController));
        }
        return appendedEntry;
    }

    private boolean isUpdateReplicable(Quorum quorum) {
        if (this.state.get() != NodeState.LEADER) {
            throw new RaftException("Node must be leader to replicate messages to other nodes");
        }
        if (!this.isWritable()) {
            logger.warn("Cluster is not writable. Waiting for nodes to sync up");
            while (this.state.get() == NodeState.LEADER && !this.isWritable() && !Thread.currentThread().isInterrupted()) {
                Thread.onSpinWait();
            }
            quorum.increment(true);
            this.sendHeartbeat(quorum);
            quorum.await();
            Quorum.State state = quorum.getState();
            quorum.clear();
            return state == Quorum.State.SUCCESSFUL;
        }
        quorum.clear();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isUpdateReplicableWithTotalQuorum(int quorumSize, List<NodeInfo> clusterGroup) {
        if (this.state.get() != NodeState.LEADER) {
            throw new RaftException("Node must be leader to replicate messages to other nodes");
        }
        Quorum quorum = this.quorumCache.fetchTotalQuorum(quorumSize);
        try {
            quorum.increment(true);
            this.sendHeartbeat(quorum, clusterGroup, false);
            quorum.awaitAll();
            boolean bl = quorum.getState() == Quorum.State.SUCCESSFUL;
            return bl;
        }
        finally {
            this.quorumCache.releaseQuorum(quorum);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long handleQuorumResponses(Quorum.State quorumState, LogEntry newLastLog) {
        if (quorumState == Quorum.State.UNSUCCESSFUL) {
            try {
                if (newLastLog.getChannel() == -2 && newLastLog.isMembershipConfigEntry()) {
                    this.rollbackClusterGroupUpdate(newLastLog.getOldConfig(), newLastLog.getNewConfig());
                }
                this.incrementClusterStatistics(newLastLog.getChannel());
                this.goOutOfSync();
                long l = -1L;
                return l;
            }
            finally {
                this.transactionLog.unlockChannel(newLastLog.getChannel());
            }
        }
        if (quorumState == Quorum.State.NOT_REACHED) {
            this.verifyAppendEntry(newLastLog, null, false, true, newLastLog.getChannel() == -2);
            if (newLastLog.getStatus() == LogEntry.Status.VALID) {
                this.truncateLogIfNeeded();
                this.updateSecondaryStatusIfNeeded(newLastLog);
                long l = newLastLog.getIndex();
                return l;
            }
            if (newLastLog.getChannel() == -2 && newLastLog.isMembershipConfigEntry()) {
                this.rollbackClusterGroupUpdate(newLastLog.getOldConfig(), newLastLog.getNewConfig());
            }
            this.incrementClusterStatistics(newLastLog.getChannel());
            this.goOutOfSync();
            long l = -1L;
            return l;
        }
        this.transactionLog.validateEntry(newLastLog);
        logger.info("Successfully verified entry {} with follower nodes", (Object)newLastLog.getIndex());
        this.truncateLogIfNeeded();
        this.updateSecondaryStatusIfNeeded(newLastLog);
        long l = newLastLog.getIndex();
        return l;
        finally {
            if (newLastLog.getChannel() == 0 || newLastLog.getChannel() == -8) {
                this.instanceLock.unlock();
            }
        }
    }

    private void truncateLogIfNeeded() {
        if (this.clusterGroup.getTransactionLogMaxSizeGB() >= 0.0f && this.transactionLog.getSize().get() > this.clusterGroup.getTransactionLogThreshold()) {
            logger.info("Triggered automatic log truncation due to transaction log size {} being bigger than the transaction log maximum size {}", (Object)this.transactionLog.getSize().get(), (Object)this.clusterGroup.getTransactionLogThreshold());
            if (this.areAllNodesAvailable()) {
                try {
                    this.truncateLog();
                }
                catch (RaftException e) {
                    logger.error(e.getMessage());
                }
            } else {
                logger.error("Unable to automatically truncate log as not all nodes are in sync");
            }
        }
    }

    private void updateSecondaryStatusIfNeeded(LogEntry entry) {
        if (entry.getChannel() != -8) {
            return;
        }
        if (entry.getSecondaryType() == 1) {
            this.clusterGroup.setIsSecondary(true);
            this.pullUpdatesFromPrimary();
        } else if (entry.getSecondaryType() == 2) {
            this.clusterGroup.setIsSecondary(false);
        }
    }

    @Override
    public boolean areAllNodesAvailable() {
        int nodesInSync = 1;
        for (RpcNodeClient client : this.clusterGroup) {
            if (client.getStatus() != RpcNodeClient.Status.IN_SYNC) continue;
            ++nodesInSync;
        }
        return nodesInSync == this.clusterGroup.size();
    }

    @Override
    public boolean isPrimaryCluster() {
        return !this.clusterGroup.isSecondary();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long enableSecondaryClusterMode(NodeInfo primaryNode, String tag) {
        block6: {
            this.validatePrimaryState();
            Quorum quorum = this.quorumCache.fetchQuorum(this.clusterGroup.size());
            try {
                if (this.isUpdateReplicable(quorum) && RaftUtil.isClusterInSync(quorum, this.raftTaskController)) {
                    new PullPrimarySnapshotTask(this.raftTaskController, primaryNode, tag).run();
                    break block6;
                }
                long l = -1L;
                return l;
            }
            catch (Exception e) {
                logger.error("[Node {}] Could not start secondary cluster mode due to : ", (Object)this.getAddress(), (Object)e);
                long l = -1L;
                return l;
            }
            finally {
                this.quorumCache.releaseQuorum(quorum);
            }
        }
        return this.replicateUpdate(SECONDARY_FINGERPRINT, SECONDARY_FINGERPRINT);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long disableSecondaryClusterMode() {
        block7: {
            if (this.isPrimaryCluster()) {
                throw new RaftException("Node is not in secondary cluster mode");
            }
            Quorum quorum = this.quorumCache.fetchQuorum(this.clusterGroup.size());
            try {
                if (this.isUpdateReplicable(quorum) && RaftUtil.isClusterInSync(quorum, this.raftTaskController)) {
                    new StopSecondaryModeTask(this.raftTaskController).run();
                    break block7;
                }
                long l = -1L;
                return l;
            }
            catch (Exception e) {
                logger.error("[Node {}] Could not stop secondary cluster mode due to : ", (Object)this.getAddress(), (Object)e);
                long l = -1L;
                return l;
            }
            finally {
                this.quorumCache.releaseQuorum(quorum);
            }
        }
        return this.replicateUpdate(SECONDARY_FINGERPRINT, SECONDARY_FINGERPRINT);
    }

    @Override
    public boolean addTag(String tag) {
        return this.updateTag(tag, true);
    }

    @Override
    public boolean removeTag(String tag) {
        return this.updateTag(tag, false);
    }

    private boolean updateTag(String tag, boolean add) {
        block9: {
            this.validatePrimaryState();
            Quorum quorum = this.quorumCache.fetchQuorum(this.clusterGroup.size());
            try {
                if (this.isUpdateReplicable(quorum) && RaftUtil.isClusterInSync(quorum, this.raftTaskController)) {
                    AtomicBoolean updated = new AtomicBoolean(true);
                    new UpdateSecondaryTagsTask(this.raftTaskController, tag, add, updated).run();
                    if (!updated.get()) {
                        boolean bl = false;
                        return bl;
                    }
                    break block9;
                }
                throw new UpdateExecutionException("Cannot update tags as not enough nodes are in sync");
            }
            catch (Exception e) {
                if (e instanceof UpdateExecutionException) {
                    throw (UpdateExecutionException)e;
                }
                throw new UpdateExecutionException("Error occurred during secondary tags update: ", (Throwable)e);
            }
            finally {
                this.quorumCache.releaseQuorum(quorum);
            }
        }
        return this.replicateUpdate(SECONDARY_FINGERPRINT, SECONDARY_FINGERPRINT) > 0L;
    }

    private void incrementClusterStatistics(int channel) {
        if (channel > 0) {
            this.incrementFailedTransactionsCount();
        } else if (channel == -5) {
            this.numberOfFailedRecoveries.incrementAndGet();
        }
    }

    private AppendEntry buildBackupEntry(String fingerprint) {
        return this.buildUpdateEntry("RECOVERY", fingerprint, null, null);
    }

    private AppendEntry buildUpdateEntry(String repository, String fingerprint, Long lastLogIndex, Long lastLogTerm) {
        AppendEntry.Builder builder = AppendEntry.newBuilder().setFingerprint(fingerprint).setCommitIndex(this.transactionLog.getNextLogIndex()).setLeaderId(this.clusterGroup.getCurrentAddress()).setLogTerm(this.currentTerm).setTerm(this.currentTerm);
        if (lastLogIndex != null) {
            builder.setPrevLogIndex(lastLogIndex);
            builder.setPrevLogTerm(lastLogTerm);
        }
        if (repository == null || repository.equals("SYSTEM")) {
            return builder.setChannel(0).build();
        }
        return builder.setChannel(this.transactionLog.putChannelIfAbsent(repository)).build();
    }

    private ConfigEntry buildConfigEntry(List<NodeInfo> newConfig, List<NodeInfo> oldConfig) {
        String fingerprint = ConfigUtil.generateFingerprint(newConfig);
        return ConfigEntry.newBuilder().setFingerprint(fingerprint).setCommitIndex(this.transactionLog.getNextLogIndex()).setLeaderId(this.clusterGroup.getCurrentAddress()).setLogTerm(this.currentTerm).setTerm(this.currentTerm).setChannel(-2).addAllNewConfigServers(newConfig).addAllOldConfig(oldConfig).build();
    }

    private ConfigEntry buildConfigEntry(Map<String, Number> properties) {
        String fingerprint = ConfigUtil.generateFingerprint(properties);
        return ConfigEntry.newBuilder().setFingerprint(fingerprint).setCommitIndex(this.transactionLog.getNextLogIndex()).setLeaderId(this.clusterGroup.getCurrentAddress()).setLogTerm(this.currentTerm).setTerm(this.currentTerm).setChannel(-2).setProperties(RaftUtil.buildClusterConfigOptions(properties)).build();
    }

    @Override
    public Map<String, String> getSyncStatus() {
        if (!NodeState.LEADER.equals((Object)this.state.get())) {
            return Collections.emptyMap();
        }
        TreeMap<String, String> syncStatus = new TreeMap<String, String>();
        for (RpcNodeClient rpcNode : this.clusterGroup) {
            syncStatus.put(rpcNode.getAddress(), rpcNode.getStatus().name());
        }
        return syncStatus;
    }

    @Override
    public boolean isLeader() {
        return NodeState.LEADER.equals((Object)this.state.get());
    }

    @Override
    public void incrementFailedTransactionsCount() {
        this.numberOfFailedTransactions.incrementAndGet();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, StatusResponse> getGroupStatus() {
        LinkedHashMap<String, ListenableFuture<StatusResponse>> futures = new LinkedHashMap<String, ListenableFuture<StatusResponse>>();
        for (RpcNodeClient rpcNode : this.clusterGroup) {
            ListenableFuture<StatusResponse> statusResponse = rpcNode.requestStatus();
            futures.put(rpcNode.getAddress(), statusResponse);
        }
        TreeMap<String, StatusResponse> groupStatus = new TreeMap<String, StatusResponse>();
        ArrayList<String> outOfSyncAddresses = new ArrayList<String>();
        StatusResponse currentNodeStatus = this.getNodeStatus();
        groupStatus.put(this.getAddress(), currentNodeStatus);
        if (currentNodeStatus.getStatus() == StatusResponse.Status.OUT_OF_SYNC) {
            outOfSyncAddresses.add(this.getAddress());
        }
        try {
            Futures.whenAllComplete(futures.values()).call(() -> {
                futures.forEach((address, future) -> {
                    try {
                        StatusResponse statusResponse = (StatusResponse)Futures.getDone((Future)future);
                        StatusResponse previousResponse = groupStatus.put((String)address, statusResponse);
                        if (statusResponse.getStatus() == StatusResponse.Status.OUT_OF_SYNC) {
                            outOfSyncAddresses.add((String)address);
                        }
                        assert (previousResponse == null) : "Didn't expect duplicate address : " + address;
                    }
                    catch (RaftRpcConnectionException | ExecutionException e) {
                        RpcNodeClient rpcNode = this.clusterGroup.getClusterRpcNode((String)address);
                        if (rpcNode != null) {
                            rpcNode.setNoConnectionStatus(e);
                        }
                        Optional<NodeInfo> remoteNode = this.clusterGroup.getNodeByRpcAddress((String)address);
                        groupStatus.put((String)address, StatusResponse.newBuilder().setStatus(StatusResponse.Status.NO_CONNECTION).setEndpoint(remoteNode.map(NodeInfo::getHttpAddress).orElse(NO_LEADER)).build());
                        String exMessage = e instanceof ExecutionException ? e.getCause().getMessage() : e.getMessage();
                        logger.error("Cannot get status of {} due to: {}. Please, verify that the node is running.", address, (Object)exMessage);
                    }
                });
                return null;
            }, (Executor)this.executorService).get(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (ExecutionException e) {
            logger.error("Could not collect group status.", e.getCause());
        }
        catch (TimeoutException e) {
            logger.error("Could not get group status.", e.getCause());
        }
        finally {
            if (!outOfSyncAddresses.isEmpty() && this.leader.get() != null && groupStatus.get(this.leader.get()) != null) {
                outOfSyncAddresses.forEach(outOfSyncAddress -> {
                    StatusResponse response = ((StatusResponse)groupStatus.get(this.leader.get())).toBuilder().putSyncStatus((String)outOfSyncAddress, StatusResponse.Status.OUT_OF_SYNC.name()).build();
                    groupStatus.put(this.leader.get(), response);
                });
            }
        }
        return groupStatus;
    }

    @Override
    public StatusResponse getNodeStatus() {
        long lastLogIndex = this.transactionLog.getLastLogIndex();
        StatusResponse.Builder builder = StatusResponse.newBuilder().setEndpoint(Config.getExternalUrl(null)).setStatus(this.isRunning() ? StatusResponse.Status.valueOf(this.state.get().toString()) : StatusResponse.Status.NO_CLUSTER).setTerm(this.currentTerm).setLastLogTerm(this.transactionLog.getLastLogTerm()).setLastLogIndex(lastLogIndex).putAllSyncStatus(this.getSyncStatus()).setRecoveryState(this.buildRecoveryStatusMessage());
        if (this.isPrimaryCluster()) {
            StatusResponse.PrimaryStatus.Builder primaryStatus = StatusResponse.PrimaryStatus.newBuilder();
            if (this.state.get() == NodeState.LEADER) {
                primaryStatus.putAllTagStatus(this.clusterGroup.getTagMap()).build();
            }
            builder.setTopologyStatus(StatusResponse.ClusterTopologyStatus.newBuilder().setPrimaryStatus(primaryStatus.build()));
        } else {
            StatusResponse.SecondaryStatus.Builder secondaryStatus = StatusResponse.SecondaryStatus.newBuilder().setPrimaryIndex(this.clusterGroup.getPrimaryIndex());
            RpcNodeClient leader = this.clusterGroup.getPrimaryLeader();
            if (leader != null && this.state.get() == NodeState.LEADER) {
                secondaryStatus.setPrimaryLeader(leader.getAddress());
            }
            builder.setTopologyStatus(StatusResponse.ClusterTopologyStatus.newBuilder().setSecondaryStatus(secondaryStatus));
        }
        return builder.build();
    }

    private RecoveryStateOperation buildRecoveryStatusMessage() {
        HashSet<String> otherNodesAddresses = this.recoveryState.get().getAffectedNodeAddresses() == null ? new HashSet<String>() : this.recoveryState.get().getAffectedNodeAddresses();
        return RecoveryStateOperation.newBuilder().setRecoveryOperationMessage(this.recoveryState.get().getCurrentStateMessage()).addAllAffectedNodeAddresses(this.buildOtherNodesHttpAddresses(otherNodesAddresses)).build();
    }

    private List<String> buildOtherNodesHttpAddresses(Set<String> otherNodeAddresses) {
        List<NodeInfo> nodeInfos = this.clusterGroup.getNodes();
        return nodeInfos.stream().filter(nodeInfo -> otherNodeAddresses.contains(nodeInfo.getRpcAddress())).map(NodeInfo::getHttpAddress).collect(Collectors.toList());
    }

    private void resetElectionTimeout() {
        this.electionLock.lock();
        try {
            this.cancelElectionTask();
            if (this.state.get() == NodeState.LEADER) {
                this.electionTask = null;
                logger.info("Leader {} should not wait for heartbeats", (Object)this.clusterGroup.getCurrentAddress());
                return;
            }
            int timeout = this.clusterGroup.getRandomTimeout();
            if (logger.isDebugEnabled()) {
                logger.debug("Resetting election timeout timer for {} with ms {}", (Object)this.clusterGroup.getCurrentAddress(), (Object)timeout);
            }
            this.electionTask = this.executorService.schedule(new ElectionTask(), (long)timeout, TimeUnit.MILLISECONDS);
        }
        finally {
            this.electionLock.unlock();
        }
    }

    private void cancelElectionTask() {
        if (this.electionTask != null && !this.electionTask.isDone()) {
            this.electionTask.cancel(true);
        }
    }

    private void resetPullTask() {
        this.executorService.schedule(this::pullUpdatesFromPrimary, (long)this.clusterGroup.getBatchUpdateIntervalMs(), TimeUnit.MILLISECONDS);
    }

    private void resetHeartbeat() {
        this.cancelHeartbeat();
        if (this.state.get() != NodeState.LEADER) {
            logger.warn("Node {} attempted to set heartbeat while not leader", (Object)this.clusterGroup.getCurrentAddress());
            return;
        }
        this.heartbeatTask = this.executorService.schedule(() -> this.sendHeartbeat(null), (long)this.clusterGroup.getHeartbeatInterval(), TimeUnit.MILLISECONDS);
    }

    private void cancelHeartbeat() {
        if (this.heartbeatTask != null && !this.heartbeatTask.isDone()) {
            this.heartbeatTask.cancel(true);
        }
    }

    @VisibleForTesting
    protected void sendHeartbeat(@Nullable Quorum quorum) {
        if (this.isRestrictedOnNoEnterpriseLicense()) {
            logger.warn("Not sending heartbeat: node is restricted due to a missing Enterprise license or CLUSTER capability.");
            if (quorum != null) {
                quorum.fail();
            }
            return;
        }
        AppendEntry entry = this.createHeartbeatEntry();
        for (RpcNodeClient rpcNode : this.clusterGroup) {
            Future<?> future = this.executorService.submit(new HeartbeatTask(rpcNode, entry, quorum, this.raftTaskController));
            if (quorum == null) continue;
            quorum.addTask(future);
        }
        this.resetHeartbeat();
    }

    public void pullUpdatesFromPrimary() {
        Future<?> task = this.pullUpdateTask;
        if (task != null && !task.isDone()) {
            logger.info("Node is already pulling updates from primary cluster");
        } else {
            NodeState tmpState = this.state.get();
            if (tmpState != NodeState.LEADER) {
                logger.warn("Node with state {} attempted to pull updates from primary cluster", (Object)tmpState);
                return;
            }
            if (!this.getClusterGroup().isSecondary()) {
                logger.warn("Node without secondary state enabled attempted to pull updates from primary cluster");
                return;
            }
            try {
                this.pullUpdateTask = this.executorService.submit(new PullPrimaryUpdateTask(this.raftTaskController, () -> this.replicateUpdate(SECONDARY_FINGERPRINT, SECONDARY_FINGERPRINT)));
            }
            catch (Exception e) {
                logger.warn("Unable to pull updates from primary cluster due to ", (Throwable)e);
            }
        }
        this.resetPullTask();
    }

    private void sendHeartbeat(Quorum quorum, List<NodeInfo> nodes, boolean isCatchUp) {
        if (this.isRestrictedOnNoEnterpriseLicense()) {
            logger.warn("Not sending heartbeat: node is restricted due to a missing Enterprise license or CLUSTER capability.");
            if (quorum != null) {
                quorum.fail();
            }
            return;
        }
        AppendEntry entry = this.createHeartbeatEntry();
        for (NodeInfo nodeInfo : nodes) {
            if (nodeInfo.getRpcAddress().equals(this.getAddress())) continue;
            RpcNodeClient rpcNode = this.clusterGroup.getClusterRpcNode(nodeInfo.getRpcAddress());
            if (isCatchUp) {
                quorum.addTask(this.executorService.submit(new HeartbeatCatchupTask(rpcNode, entry, quorum, this.raftTaskController)));
                continue;
            }
            quorum.addTask(this.executorService.submit(new HeartbeatTask(rpcNode, entry, quorum, this.raftTaskController)));
        }
        this.resetHeartbeat();
    }

    @NotNull
    private AppendEntry createHeartbeatEntry() {
        AppendEntry entry = this.temporaryHeartbeat;
        if (entry != null) {
            return entry;
        }
        LogEntry logEntry = this.transactionLog.getLastLog();
        if (logEntry != null) {
            return this.createHeartbeatEntry(logEntry.getIndex(), logEntry.getTerm());
        }
        return this.createHeartbeatEntry(0L, 0L);
    }

    @NotNull
    private AppendEntry createHeartbeatEntry(long index, long term) {
        return AppendEntry.newBuilder().setCommitIndex(index).setPrevLogIndex(index).setPrevLogTerm(term).setLeaderId(this.clusterGroup.getCurrentAddress()).setTerm(this.currentTerm).setChannel(-1).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long addNodes(List<NodeInfo> addedNodes) {
        this.instanceLock.lock();
        try {
            if (this.state.get() != NodeState.LEADER) {
                throw new RaftException("Node must be leader to change configuration");
            }
            ArrayList<NodeInfo> oldConfigNodes = new ArrayList<NodeInfo>(this.clusterGroup.getNodes());
            if (!this.isUpdateReplicableWithTotalQuorum(this.clusterGroup.size(), this.clusterGroup.getNodes())) {
                logger.error("Cannot replicate config change");
                long l = -1L;
                return l;
            }
            this.addNodesToCurrentGroup(addedNodes);
            if (!this.catchUpNodesIfNeeded(addedNodes)) {
                long l = -1L;
                return l;
            }
            Quorum newGroupQuorum = this.quorumCache.fetchTotalQuorum(this.clusterGroup.size());
            LogEntry newLastLog = this.replicateConfigLogEntry(this.buildConfigEntry(new ArrayList<NodeInfo>(this.clusterGroup.getNodes()), oldConfigNodes), newGroupQuorum);
            newGroupQuorum.awaitAll();
            long logIndex = this.handleQuorumResponses(newGroupQuorum.getState(), newLastLog);
            if (logIndex > 0L) {
                this.observers.notifyOnNewNodes(addedNodes);
            }
            long l = logIndex;
            return l;
        }
        finally {
            this.instanceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long removeNodes(List<NodeInfo> removedNodes) {
        this.instanceLock.lock();
        try {
            long logIndex;
            if (this.state.get() != NodeState.LEADER) {
                throw new RaftException("Node must be leader to change configuration");
            }
            List<NodeInfo> newConfigNodes = this.getNewConfigNodeInfos(removedNodes);
            int quorumSize = newConfigNodes.size();
            if (!newConfigNodes.contains(this.clusterGroup.getCurrentNode())) {
                ++quorumSize;
            }
            if (!this.isUpdateReplicableWithTotalQuorum(quorumSize, newConfigNodes)) {
                logger.error("Cannot replicate config change");
                long l = -1L;
                return l;
            }
            Quorum quorum = this.quorumCache.fetchTotalQuorum(quorumSize);
            LogEntry newLastLog = this.replicateConfigLogEntry(this.buildConfigEntry(newConfigNodes, new ArrayList<NodeInfo>(this.clusterGroup.getNodes())), quorum);
            quorum.awaitAll();
            this.removeNodesFromCurrentGroup(removedNodes);
            if (!this.clusterGroup.containsNode(this.getAddress())) {
                logger.info("[Node {}] node has been removed from the cluster. Stepping down from LEADER role", (Object)this.getAddress());
                this.stepDown(this.currentTerm);
            }
            if ((logIndex = this.handleQuorumResponses(quorum.getState(), newLastLog)) > 0L) {
                this.observers.notifyOnRemovedNodes(removedNodes);
            }
            long l = logIndex;
            return l;
        }
        finally {
            this.instanceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long updateGroupProperties(Map<String, Number> properties) {
        this.instanceLock.lock();
        try {
            if (this.state.get() != NodeState.LEADER) {
                throw new RaftException("Node must be leader to change configuration");
            }
            if (!this.isUpdateReplicableWithTotalQuorum(this.clusterGroup.size(), this.clusterGroup.getNodes())) {
                logger.error("Cannot replicate config change on all nodes in the old configuration");
                long l = -1L;
                return l;
            }
            Quorum quorum = this.quorumCache.fetchTotalQuorum(this.clusterGroup.size());
            LogEntry newLastLog = this.replicateConfigLogEntry(this.buildConfigEntry(properties), quorum);
            quorum.awaitAll();
            long logIndex = this.handleQuorumResponses(quorum.getState(), newLastLog);
            if (logIndex > 0L) {
                this.clusterGroup.updateProperties(properties);
                logger.info("[Node {}] Successfully updated properties to {}", (Object)this.clusterGroup.getCurrentAddress(), (Object)this.clusterGroup.getClusterParametersAsString());
            }
            long l = logIndex;
            return l;
        }
        catch (RaftException e) {
            logger.error(e.getMessage());
            this.transactionLog.unlockChannel(-2);
            long l = -1L;
            return l;
        }
        finally {
            this.instanceLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long replaceNodes(List<NodeInfo> oldNodes, List<NodeInfo> newNodes) {
        this.instanceLock.lock();
        Quorum quorum = this.quorumCache.fetchQuorum(this.clusterGroup.size());
        try {
            if (this.state.get() != NodeState.LEADER) {
                throw new RaftException("Node must be leader to change configuration");
            }
            if (this.isUpdateReplicable(quorum)) {
                ArrayList<NodeInfo> oldConfig = new ArrayList<NodeInfo>(this.clusterGroup.getNodes());
                this.addNodesToCurrentGroup(newNodes);
                if (!this.catchUpNodesIfNeeded(newNodes)) {
                    long l = -1L;
                    return l;
                }
                List<NodeInfo> newConfigNodes = this.getNewConfigNodeInfos(oldNodes);
                Quorum newGroupQuorum = this.quorumCache.fetchTotalQuorum(newConfigNodes.size());
                LogEntry newLastLog = this.replicateConfigLogEntry(this.buildConfigEntry(newConfigNodes, oldConfig), newGroupQuorum);
                newGroupQuorum.awaitAll();
                this.removeNodesFromCurrentGroup(oldNodes);
                long logIndex = this.handleQuorumResponses(newGroupQuorum.getState(), newLastLog);
                if (logIndex > 0L) {
                    this.observers.notifyOnNewNodes(newNodes);
                    this.observers.notifyOnRemovedNodes(oldNodes);
                }
                long l = logIndex;
                return l;
            }
            logger.error("Cannot replicate config change");
            long oldConfig = -1L;
            return oldConfig;
        }
        catch (RaftException e) {
            logger.error(e.getMessage());
            this.transactionLog.unlockChannel(-2);
            long l = -1L;
            return l;
        }
        finally {
            this.instanceLock.unlock();
        }
    }

    private void removeNodesFromCurrentGroup(List<NodeInfo> oldNodes) {
        for (NodeInfo address : oldNodes) {
            this.clusterGroup.removeClusterRpcNode(address);
        }
    }

    private void addNodesToCurrentGroup(List<NodeInfo> newNodes) {
        for (NodeInfo info : newNodes) {
            if (info.getRpcAddress().equals(this.clusterGroup.getCurrentAddress())) continue;
            this.clusterGroup.addClusterRpcNode(info).ifPresent(RpcNodeClient::setOutOfSyncStatus);
        }
    }

    @NotNull
    private List<NodeInfo> getNewConfigNodeInfos(List<NodeInfo> oldNodes) {
        ArrayList<NodeInfo> newConfigNodes = new ArrayList<NodeInfo>(this.clusterGroup.getNodes());
        newConfigNodes.removeAll(oldNodes);
        return newConfigNodes;
    }

    private boolean catchUpNodesIfNeeded(List<NodeInfo> newNodes) {
        logger.info("Start catch up of new nodes");
        boolean isCatchUpSuccess = this.catchUpNewNodes(newNodes);
        if (!isCatchUpSuccess) {
            logger.error("Some of the new nodes could not catch up");
            for (NodeInfo address : newNodes) {
                this.clusterGroup.removeClusterRpcNode(address).setOutOfSyncStatus();
            }
            return false;
        }
        logger.info("Finished catch up on new nodes");
        return true;
    }

    public void handleGetStatus(StatusRequest request, StreamObserver<StatusResponse> responseObserver) {
        if (!this.clusterGroup.containsNode(request.getRequestingNodeId())) {
            logger.error("Cannot send status of {} to {}, because {} is not part of the cluster group", new Object[]{this.getAddress(), request.getRequestingNodeId(), request.getRequestingNodeId()});
            responseObserver.onError((Throwable)new StatusRuntimeException(Status.UNAVAILABLE.withDescription(request.getRequestingNodeId() + " is not part of the cluster group.")));
            return;
        }
        responseObserver.onNext((Object)this.getNodeStatus());
        responseObserver.onCompleted();
    }

    @Override
    public ClusterStatistics getClusterStatistics() {
        ClusterStatistics clusterStatistics = new ClusterStatistics();
        clusterStatistics.setTerm(this.currentTerm);
        clusterStatistics.setNodesStats(this.getNodesStats());
        clusterStatistics.setFailureRecoveriesCount(this.numberOfFailedRecoveries.get());
        clusterStatistics.setFailedTransactionsCount(this.numberOfFailedTransactions.get());
        return clusterStatistics;
    }

    @NotNull
    private ClusterStatistics.NodeStats getNodesStats() {
        Map<String, String> syncStatuses = this.getSyncStatus();
        Map<String, StatusResponse> groupStatus = this.getGroupStatus();
        int disconnectedNodes = 0;
        int outOfSyncNodes = 0;
        int syncingNodes = 0;
        int inSyncNodes = 0;
        for (Map.Entry<String, StatusResponse> nodeStatus : groupStatus.entrySet()) {
            if (syncStatuses.containsKey(nodeStatus.getKey()) && syncStatuses.get(nodeStatus.getKey()).equals(RpcNodeClient.Status.SYNCING.toString())) {
                ++syncingNodes;
                continue;
            }
            if (nodeStatus.getValue().getStatus() == StatusResponse.Status.LEADER || nodeStatus.getValue().getStatus() == StatusResponse.Status.FOLLOWER || nodeStatus.getValue().getStatus() == StatusResponse.Status.CANDIDATE || nodeStatus.getValue().getStatus() == StatusResponse.Status.CREATING_SNAPSHOT) {
                ++inSyncNodes;
                continue;
            }
            if (nodeStatus.getValue().getStatus() == StatusResponse.Status.OUT_OF_SYNC) {
                ++outOfSyncNodes;
                continue;
            }
            ++disconnectedNodes;
        }
        return new ClusterStatistics.NodeStats(this.clusterGroup.getNodeIds().size(), inSyncNodes, outOfSyncNodes, disconnectedNodes, syncingNodes);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleAppendEntry(AppendEntry entry, StreamObserver<AppendResponse> observer) {
        LogEntry logEntry;
        if (!RaftUtil.isHeartbeat(entry)) {
            logger.info("[Node {}] Incoming entry {} with prev log index {} and channel {}", new Object[]{this.getAddress(), entry.getCommitIndex(), entry.getPrevLogIndex(), entry.getChannel()});
        }
        if (NodeState.OUT_OF_SYNC == this.state.get()) {
            if (this.leader.get() == null || !this.leader.get().equals(entry.getLeaderId())) {
                this.update(entry.getLeaderId());
            }
            logger.warn("[Node {}] is out of sync and cannot handle entry {}", (Object)this.getAddress(), (Object)entry.getCommitIndex());
            observer.onError((Throwable)new StatusRuntimeException(Status.FAILED_PRECONDITION.withDescription("Unable to process entry during snapshot recovery")));
            return;
        }
        if (this.executorService.isShutdown()) {
            observer.onError((Throwable)new StatusRuntimeException(Status.INTERNAL.withDescription("Node is being shutdown")));
            return;
        }
        if (this.isNodeProcessingOrBuildingSnapshot(entry) || this.isNodeApplyingEntryInSecondaryCluster()) {
            this.cancelElectionTask();
            if (RaftUtil.isHeartbeat(entry)) {
                if (RaftUtil.isSystemHeartbeat(entry)) {
                    this.rejectEntry(observer, entry);
                } else {
                    this.acceptEntry(observer, this.transactionLog.getLastLogIndex());
                    observer.onCompleted();
                }
                return;
            }
            if (this.isBuildingSnapshot()) {
                this.rejectEntry(observer, entry);
                return;
            }
        }
        Lock systemLock = this.getSystemLock(entry.getChannel());
        this.instanceLock.lock();
        try {
            systemLock.lock();
            try {
                logEntry = this.handleAppendEntryUnsafe(entry, observer);
            }
            catch (Exception e) {
                systemLock.unlock();
                throw e;
            }
        }
        finally {
            this.instanceLock.unlock();
        }
        this.clusterGroup.getStateMachine().readLock();
        try {
            if (logEntry != null && !this.commitEntry(logEntry, observer, false)) {
                logEntry = null;
            }
        }
        finally {
            try {
                systemLock.unlock();
            }
            finally {
                this.clusterGroup.getStateMachine().readUnlock();
            }
        }
        if (!RaftUtil.isHeartbeat(entry) && logEntry != null) {
            if (this.state.get() == NodeState.OUT_OF_SYNC) {
                logger.warn("[Node {}] Cannot verify entry {} with channel {} as node is out of sync", new Object[]{this.getAddress(), entry.getCommitIndex(), entry.getChannel()});
                this.transactionLog.unlockChannel(entry.getChannel());
            } else {
                this.verifyAppendEntry(logEntry, this.clusterGroup.getClusterRpcNode(entry.getLeaderId()), false, false, false);
            }
        }
    }

    private LogEntry handleAppendEntryUnsafe(AppendEntry entry, StreamObserver<AppendResponse> observer) {
        if (this.isRestrictedOnNoEnterpriseLicense()) {
            this.updateTerm(entry.getTerm(), entry.getLeaderId());
            this.rejectEntry(observer, entry);
            this.logNoLicense();
        } else if (NodeState.OUT_OF_SYNC == this.state.get()) {
            logger.warn("[Node {}] is out of sync and cannot handle entry {} under instance lock", (Object)this.getAddress(), (Object)entry.getCommitIndex());
            observer.onError((Throwable)new StatusRuntimeException(Status.FAILED_PRECONDITION.withDescription("Unable to process entry during snapshot recovery")));
        } else if (!this.isAppendEntryValid(entry)) {
            if (RaftUtil.isHeartbeat(entry) && this.checkIfNodeIsSyncing(entry.getCommitIndex(), entry.getTerm(), entry.getLeaderId())) {
                this.resetElectionTimeout();
            } else if (entry.getPrevLogIndex() > this.transactionLog.getLastLogIndex() && entry.getPrevLogTerm() > 0L) {
                this.setNodeToFollower(entry.getLeaderId(), entry.getTerm());
            }
            this.rejectEntry(observer, entry);
        } else {
            this.updateTerm(entry.getTerm(), entry.getLeaderId());
            this.setFromCandidateToFollower(entry.getTerm(), entry.getLeaderId());
            if (this.state.get() == NodeState.FOLLOWER && this.currentTerm == entry.getTerm() && this.validateLeader(entry.getLeaderId())) {
                return this.processAppendEntry(entry, observer);
            }
            logger.error("[Node {}] with state {} cannot append entry {} coming from node {}", new Object[]{this.clusterGroup.getCurrentAddress(), this.state.get(), entry.getCommitIndex(), entry.getLeaderId()});
            this.rejectEntry(observer, entry);
        }
        return null;
    }

    private boolean isNodeProcessingOrBuildingSnapshot(AppendEntry entry) {
        return (this.clusterGroup.isStreaming() || this.isBuildingSnapshot()) && entry.getLeaderId().equals(this.leader.get());
    }

    private boolean isNodeApplyingEntryInSecondaryCluster() {
        return this.clusterGroup.isSecondary() && this.isApplyingSecondaryEntry.get();
    }

    private void logNoLicense() {
        logger.error("Cannot append entry: node is restricted due to a missing Enterprise license or CLUSTER capability.");
    }

    private void setFromCandidateToFollower(long entryTerm, String entryLeaderId) {
        if (this.currentTerm == entryTerm && this.state.get() == NodeState.CANDIDATE) {
            this.update(NodeState.FOLLOWER);
            this.update(entryLeaderId);
        }
    }

    private boolean checkIfNodeIsSyncing(long entryCommitIndex, long entryTerm, String leaderId) {
        return entryCommitIndex >= this.transactionLog.getLastLogIndex() && leaderId.equals(this.leader.get()) && entryTerm >= this.currentTerm;
    }

    private void setNodeToFollower(String entryLeaderId, long entryTerm) {
        this.update(NodeState.FOLLOWER);
        this.update(entryLeaderId);
        this.update(entryTerm);
        this.resetElectionTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleConfigEntry(ConfigEntry entry, StreamObserver<ConfigResponse> observer) {
        logger.info("[Node {}] Incoming config entry {} with prev log index {}", new Object[]{this.getAddress(), entry.getCommitIndex(), entry.getPrevLogIndex()});
        this.instanceLock.lock();
        Lock lock = this.getSystemLock(entry.getChannel());
        lock.lock();
        LogEntry logEntry = null;
        try {
            if (this.isRestrictedOnNoEnterpriseLicense()) {
                this.updateTerm(entry.getTerm(), entry.getLeaderId());
                this.rejectConfigEntry(observer, this.transactionLog.getLastLogIndex(), this.currentTerm, entry.getOldConfigList(), entry.getNewConfigServersList(), false);
                this.logNoLicense();
                return;
            }
            if (!this.isConfigEntryValid(entry)) {
                if (this.checkIfNodeIsSyncing(entry.getCommitIndex(), entry.getTerm(), entry.getLeaderId())) {
                    this.resetElectionTimeout();
                } else if (entry.getPrevLogIndex() > this.transactionLog.getLastLogIndex() && entry.getPrevLogTerm() > 0L) {
                    this.setNodeToFollower(entry.getLeaderId(), entry.getTerm());
                }
                this.rejectConfigEntry(observer, this.transactionLog.getLastLogIndex(), this.currentTerm, entry.getOldConfigList(), entry.getNewConfigServersList(), entry.getShouldKeepCurrentGroup());
                return;
            }
            this.updateTerm(entry.getTerm(), entry.getLeaderId());
            this.setFromCandidateToFollower(entry.getTerm(), entry.getLeaderId());
            if (this.state.get() == NodeState.FOLLOWER && this.currentTerm == entry.getTerm() && this.validateLeader(entry.getLeaderId())) {
                logEntry = this.processConfigEntry(entry, observer);
            } else {
                logger.error("Node {} with state {} cannot append entry coming from node {}", new Object[]{this.clusterGroup.getCurrentAddress(), this.state.get(), entry.getLeaderId()});
                this.rejectConfigEntry(observer, this.transactionLog.getLastLogIndex(), this.currentTerm, entry.getOldConfigList(), entry.getNewConfigServersList(), entry.getShouldKeepCurrentGroup());
            }
        }
        finally {
            lock.unlock();
            this.instanceLock.unlock();
        }
        if (logEntry != null) {
            if (this.state.get() == NodeState.OUT_OF_SYNC) {
                logger.warn("[Node {}] Cannot verify config entry {} as node is out of sync", (Object)this.getAddress(), (Object)entry.getCommitIndex());
                this.transactionLog.unlockChannel(entry.getChannel());
            } else {
                RpcNodeClient leaderNode = this.clusterGroup.getClusterRpcNode(entry.getLeaderId());
                this.verifyAppendEntry(logEntry, leaderNode, false, false, true);
            }
        }
    }

    public StreamObserver<AppendEntry> handleAppendEntry(StreamObserver<AppendResponse> observer) {
        if (this.executorService.isShutdown()) {
            observer.onError((Throwable)new StatusRuntimeException(Status.INTERNAL.withDescription("Node is being shutdown")));
            throw new RaftException("Node is shutdown");
        }
        StreamingResponseObserver<AppendResponse> responseObserver = new StreamingResponseObserver<AppendResponse>(observer);
        return new DataStreamObserver(responseObserver, this.state, this.clusterGroup, this.instanceLock, this.isApplyingSecondaryEntry);
    }

    public StreamObserver<BackupEntry> handleBackupEntry(StreamObserver<AppendResponse> observer) {
        if (this.executorService.isShutdown()) {
            observer.onError((Throwable)new StatusRuntimeException(Status.INTERNAL.withDescription("Node is being shutdown")));
            throw new RaftException("Node is shutdown");
        }
        StreamingResponseObserver<AppendResponse> responseObserver = new StreamingResponseObserver<AppendResponse>(observer);
        return new BackupStreamObserver(responseObserver, this.state, this.clusterGroup, this.instanceLock, this.isApplyingSecondaryEntry);
    }

    private void verifyAppendEntry(LogEntry entry, RpcNodeClient leader, boolean failToCommit, boolean synchronous, boolean totalQuorum) {
        if (logger.isDebugEnabled()) {
            logger.debug("Verifying processed entry {} status", (Object)entry.getIndex());
        }
        int quorumSize = this.clusterGroup.size();
        if (totalQuorum && entry.isMembershipConfigEntry()) {
            quorumSize = entry.getNewConfig().size();
            if (entry.getNewConfig().stream().noneMatch(node -> node.getRpcAddress().equals(this.clusterGroup.getCurrentAddress()))) {
                ++quorumSize;
            }
        }
        Quorum quorum = this.quorumCache.fetchQuorum(quorumSize);
        quorum.setTotal(totalQuorum);
        Future<?> future = this.executorService.submit(new VerifyEntryTask(this.raftTaskController, entry, quorum, leader, failToCommit, synchronous));
        if (synchronous) {
            try {
                future.get();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.stepDown(this.currentTerm);
                throw new RaftException((Exception)e);
            }
            catch (CancellationException | ExecutionException e) {
                this.stepDown(this.currentTerm);
                throw new RaftException(e);
            }
        }
    }

    public void handleValidateEntry(VerifyEntry entry, StreamObserver<VerifyResponse> observer) {
        try {
            VerifyResponse.Builder builder = VerifyResponse.newBuilder();
            builder.setLogIndex(entry.getLogIndex());
            long index = this.transactionLog.getLastLogIndex();
            if (this.state.get() == NodeState.OUT_OF_SYNC) {
                throw new RaftRecoveryException("Node is out of sync. Last index " + index + ", entry index " + entry.getLogIndex());
            }
            if (index < entry.getLogIndex()) {
                builder.setStatus(VerifyResponse.Status.NOT_REACHED);
                builder.setLogIndex(index);
                builder.setLogTerm(index > 0L ? this.transactionLog.fetchLogEntry(index).getTerm() : 0L);
            } else {
                LogEntry logEntry = this.transactionLog.fetchLogEntry(entry.getLogIndex());
                builder.setFingerprint(logEntry.getFingerprint());
                builder.setChannel(logEntry.getChannel());
                builder.setLogTerm(logEntry.getTerm());
                builder.setStatus(VerifyResponse.Status.valueOf(logEntry.getStatus().name()));
            }
            if (this.executorService.isShutdown()) {
                observer.onError((Throwable)new StatusRuntimeException(Status.INTERNAL.withDescription("Node is being shutdown")));
                return;
            }
            observer.onNext((Object)builder.build());
            observer.onCompleted();
        }
        catch (Exception e) {
            logger.error("Couldn't validate entry {} due to: ", (Object)entry.getLogIndex(), (Object)e);
            observer.onError((Throwable)new StatusRuntimeException(Status.INTERNAL.withDescription(e.getMessage())));
        }
    }

    private LogEntry processAppendEntry(AppendEntry entry, StreamObserver<AppendResponse> observer) {
        LogEntry committableEntry = null;
        this.resetElectionTimeout();
        long lastLogIndex = this.transactionLog.getLastLogIndex();
        if (RaftUtil.isHeartbeat(entry)) {
            this.processHeartbeatEntry(entry, observer);
        } else if (lastLogIndex == entry.getPrevLogIndex() && this.transactionLog.getLastLogTerm() == entry.getPrevLogTerm()) {
            try {
                committableEntry = this.transactionLog.appendLogEntry(entry);
            }
            catch (Exception e) {
                logger.error("[Node {}] Could not handle append entry {} due to: ", new Object[]{this.getAddress(), entry.getCommitIndex(), e});
                this.goOutOfSync();
                this.waitForRecoveryToBegin();
                this.transactionLog.unlockChannel(entry.getChannel());
                observer.onError((Throwable)new StatusRuntimeException(Status.INTERNAL.withDescription(e.getMessage())));
                throw e;
            }
        } else {
            logger.error("[Node {}] Could not process append entry {} due to mismatch with last log index {}", new Object[]{this.getAddress(), entry.getCommitIndex(), lastLogIndex});
            this.rejectEntry(observer, entry);
        }
        return committableEntry;
    }

    private void waitForRecoveryToBegin() {
        while (!this.clusterGroup.isRecovering() && this.state.get() == NodeState.OUT_OF_SYNC) {
            Thread.onSpinWait();
        }
    }

    private void processHeartbeatEntry(AppendEntry entry, StreamObserver<AppendResponse> observer) {
        long lastLogIndex = this.transactionLog.getLastLogIndex();
        if (RaftUtil.isSystemHeartbeat(entry)) {
            if (lastLogIndex != entry.getPrevLogIndex() || lastLogIndex != entry.getCommitIndex()) {
                logger.warn("Invalid system heartbeat previous log index {} and commit index {}", (Object)entry.getPrevLogIndex(), (Object)entry.getPrevLogTerm());
                this.rejectEntry(observer, entry);
            } else if (!this.transactionLog.isEveryChannelValid()) {
                logger.warn("Unsuccessful system heartbeat verification as not all channels are validated");
                this.rejectEntry(observer, entry);
            } else {
                logger.info("Successful system heartbeat verification");
                this.acceptEntry(observer, entry.getCommitIndex());
                observer.onCompleted();
            }
        } else if (lastLogIndex < entry.getCommitIndex()) {
            this.rejectEntry(observer, entry);
        } else {
            this.acceptEntry(observer, entry.getCommitIndex());
            observer.onCompleted();
        }
    }

    private LogEntry processConfigEntry(ConfigEntry entry, StreamObserver<ConfigResponse> observer) {
        LogEntry committableEntry = null;
        this.resetElectionTimeout();
        if (this.transactionLog.getLastLogIndex() == entry.getPrevLogIndex() && this.transactionLog.getLastLogTerm() == entry.getPrevLogTerm()) {
            committableEntry = this.transactionLog.appendConfigLogEntry(entry);
            this.transactionLog.setLogStatus(committableEntry.getIndex(), LogEntry.Status.PROCESSING);
        } else {
            this.rejectConfigEntry(observer, this.transactionLog.getLastLogIndex(), entry.getTerm(), entry.getOldConfigList(), entry.getNewConfigServersList(), entry.getShouldKeepCurrentGroup());
        }
        if (committableEntry != null && this.commitConfigEntry(committableEntry, observer, entry.getLeaderId(), entry.getShouldKeepCurrentGroup())) {
            return committableEntry;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean commitEntry(LogEntry logEntry, StreamObserver<AppendResponse> observer, boolean streaming) {
        try {
            if (logEntry.getChannel() != -4) {
                this.getClusterGroup().incrementUpdate();
                try {
                    String fingerprint = this.flushEntryToMachine(logEntry);
                    this.validateFingerprint(fingerprint, logEntry);
                    logger.debug("fingerprint validated for entry {}", (Object)logEntry.getIndex());
                }
                finally {
                    this.getClusterGroup().decrementUpdate();
                }
            } else {
                this.transactionLog.setLogStatus(logEntry.getIndex(), LogEntry.Status.PROCESSED);
            }
            try {
                this.acceptEntry(observer, logEntry.getIndex());
                if (!streaming) {
                    observer.onCompleted();
                }
            }
            catch (Error | Exception e) {
                logger.warn("[Node {}] Unable to propagate accept entry message with leader id {} and leader {} due to: ", new Object[]{this.getAddress(), logEntry.getIndex(), this.leader.get(), e});
            }
            finally {
                this.resetElectionTimeout();
            }
            return true;
        }
        catch (Error | Exception e) {
            logger.error("[Node {}] Went out of sync for entry with id {} and leader {} due to: ", new Object[]{this.getAddress(), logEntry.getIndex(), this.leader.get(), e});
            this.goOutOfSync();
            this.waitForRecoveryToBegin();
            this.transactionLog.unlockChannel(logEntry.getChannel());
            observer.onError((Throwable)new StatusRuntimeException(Status.INTERNAL.withDescription(e.getMessage())));
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean commitConfigEntry(LogEntry logEntry, StreamObserver<ConfigResponse> observer, String leader, boolean flagUpdateGroup) {
        try {
            this.clusterGroup.getStateMachine().readLock();
            try {
                String fingerprint = this.flushEntryToMachine(logEntry);
                this.validateFingerprint(fingerprint, logEntry);
            }
            finally {
                this.clusterGroup.getStateMachine().readUnlock();
            }
            try {
                this.acceptConfigEntry(observer, logEntry.getIndex(), logEntry.getOldConfig(), logEntry.getNewConfig(), flagUpdateGroup);
            }
            catch (Error | Exception e) {
                logger.warn("[Node {}] Unable to propagate accept config entry message with leader id {} and leader {} due to: ", new Object[]{this.getAddress(), logEntry.getIndex(), leader, e});
            }
            return true;
        }
        catch (Error | Exception e) {
            logger.error("[Node {}] Went out of sync with leader due to: {}", (Object)this.getAddress(), (Object)e.getMessage());
            this.rejectConfigEntry(observer, this.transactionLog.getLastLogIndex(), this.currentTerm, logEntry.getOldConfig(), logEntry.getNewConfig(), flagUpdateGroup);
            this.verifyAppendEntry(logEntry, this.clusterGroup.getClusterRpcNode(leader), true, false, true);
            return false;
        }
    }

    private void validateFingerprint(String fingerprint, LogEntry logEntry) {
        if (fingerprint == null) {
            throw new TransactionLogException("Entry " + String.valueOf(logEntry) + " not applied successfully to GraphDB");
        }
        if (!this.areFingerprintsEqual(fingerprint, logEntry.getFingerprint())) {
            throw new TransactionLogException("Mismatch in fingerprint with leader " + fingerprint + " > " + logEntry.getFingerprint());
        }
    }

    private String flushEntryToMachine(LogEntry entry) {
        String committed = this.clusterGroup.getStateMachine().apply(entry);
        logger.info("[Node {}] Flushed entry with index {} to state machine", (Object)this.getAddress(), (Object)entry.getIndex());
        return committed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleVoteRequest(VoteRequest request, StreamObserver<VoteResponse> observer) {
        this.instanceLock.lock();
        try {
            boolean voteFor;
            if (this.state.get() == NodeState.OUT_OF_SYNC || this.isRestrictedOnNoEnterpriseLicense()) {
                logger.error("[Node {}] Cannot vote for candidate {}", (Object)this.getAddress(), (Object)request.getCandidateId());
                observer.onNext((Object)VoteResponse.newBuilder().setTerm(this.currentTerm).setVoteGranted(false).build());
                observer.onCompleted();
                return;
            }
            if (!this.clusterGroup.containsNode(request.getCandidateId())) {
                logger.error("[Node {}] Cannot vote for candidate {} as node is not part of the cluster group", (Object)this.getAddress(), (Object)request.getCandidateId());
                observer.onError((Throwable)new StatusRuntimeException(Status.UNAVAILABLE.withDescription("Cannot collect vote from " + this.getAddress() + ", because " + request.getCandidateId() + " is not part of the cluster group.")));
                return;
            }
            if (this.currentTerm < request.getTerm() && (this.shouldStepDown(request) || this.shouldFollow(request))) {
                this.update(request.getTerm());
                this.cancelHeartbeat();
                this.update(NO_LEADER);
                if (this.state.get() != NodeState.FOLLOWER) {
                    this.update(NodeState.FOLLOWER);
                }
            } else {
                if (this.isLeaderSet()) {
                    observer.onNext((Object)VoteResponse.newBuilder().setTerm(this.currentTerm).setVoteGranted(false).build());
                    observer.onCompleted();
                    return;
                }
                if (this.currentTerm < request.getTerm() && (this.state.get().equals((Object)NodeState.CANDIDATE) || this.state.get().equals((Object)NodeState.FOLLOWER))) {
                    this.update(request.getTerm());
                }
            }
            boolean bl = voteFor = this.isVoteRequestValid(request) && request.getTerm() == this.currentTerm && this.votedFor == null;
            if (voteFor) {
                logger.info("[Node {}] Voting for {}", (Object)this.clusterGroup.getCurrentAddress(), (Object)request.getCandidateId());
                this.cancelHeartbeat();
                this.update(NO_LEADER);
                if (this.state.get() != NodeState.FOLLOWER) {
                    this.update(NodeState.FOLLOWER);
                }
                this.resetElectionTimeout();
                this.votedFor = request.getCandidateId();
            }
            observer.onNext((Object)VoteResponse.newBuilder().setTerm(this.currentTerm).setVoteGranted(voteFor && this.currentTerm >= request.getTerm()).build());
            observer.onCompleted();
        }
        finally {
            this.instanceLock.unlock();
        }
    }

    private boolean isLeaderSet() {
        return NodeState.FOLLOWER == this.state.get() && this.leader.get() != null && !NO_LEADER.equals(this.leader.get());
    }

    private boolean shouldStepDown(VoteRequest request) {
        return this.state.get() == NodeState.LEADER && request.getLastLogIndex() > this.transactionLog.getLastLogIndex();
    }

    private boolean shouldFollow(VoteRequest request) {
        NodeState currState = this.state.get();
        if (currState == NodeState.FOLLOWER) {
            String currLeader = this.leader.get();
            if (currLeader == null || currLeader.equals(NO_LEADER)) {
                return request.getLastLogIndex() >= this.transactionLog.getLastLogIndex();
            }
            return request.getLastLogIndex() > this.transactionLog.getLastLogIndex();
        }
        return currState == NodeState.CANDIDATE && request.getLastLogIndex() >= this.transactionLog.getLastLogIndex();
    }

    public void handleVoteResponse(String address, VoteResponse response) {
        logger.info("[Node {}] Receiving vote during current term {} from {} with response {} and node term {} ", new Object[]{this.clusterGroup.getCurrentAddress(), this.currentTerm, address, response.getVoteGranted(), response.getTerm()});
        if (response.getTerm() == this.currentTerm && response.getVoteGranted()) {
            this.votesGrantedSet.add(address);
            if (this.hasReachedQuorum(this.votesGrantedSet.size())) {
                this.becomeLeader();
            }
        }
    }

    public void setBuildingSnapshot(boolean isBuilding) {
        if (this.state.get() != NodeState.LEADER) {
            if (isBuilding) {
                this.cancelElectionTask();
                logger.info("[Node {}] Stopping election task timeout before building snapshot", (Object)this.getAddress());
            } else {
                logger.info("[Node {}] Resetting election task timeout after building snapshot", (Object)this.getAddress());
                this.resetElectionTimeout();
            }
        }
        this.clusterGroup.setBuildingSnapshot(isBuilding);
    }

    public boolean isBuildingSnapshot() {
        return this.clusterGroup.isBuildingSnapshot();
    }

    private void rejectEntry(StreamObserver<AppendResponse> observer, AppendEntry entry) {
        long matchIndex = this.transactionLog.getLastLogIndex();
        long term = this.currentTerm;
        if (entry != null) {
            logger.warn("[Node {}] Rejected incoming entry {} for channel {} with match index {} and term {}", new Object[]{this.getAddress(), entry.getCommitIndex(), entry.getChannel(), matchIndex, term});
        } else {
            logger.warn("[Node {}] Rejected incoming entry with match index {} and term {}", new Object[]{this.getAddress(), matchIndex, term});
        }
        observer.onNext((Object)AppendResponse.newBuilder().setMatchIndex(matchIndex).setTerm(term).setFollowerId(this.getAddress()).setSuccess(false).build());
        observer.onCompleted();
    }

    private void rejectConfigEntry(StreamObserver<ConfigResponse> observer, long matchIndex, long term, List<NodeInfo> oldConfig, List<NodeInfo> newConfig, boolean flagToUpdateGroup) {
        logger.error("[Node {}] Rejected incoming config entry with current last log index {}, match index {} and term={}", new Object[]{this.getAddress(), this.transactionLog.getLastLogIndex(), matchIndex, term});
        if (!flagToUpdateGroup && newConfig != null && !newConfig.isEmpty()) {
            this.rollbackClusterGroupUpdate(oldConfig, newConfig);
        }
        observer.onNext((Object)ConfigResponse.newBuilder().setMatchIndex(matchIndex).setTerm(term).setFollowerId(this.getAddress()).setSuccess(false).build());
        observer.onCompleted();
    }

    private void rollbackClusterGroupUpdate(List<NodeInfo> oldConfig, List<NodeInfo> newConfig) {
        Set<NodeInfo> added = ConfigUtil.getDifference(new HashSet<NodeInfo>(newConfig), new HashSet<NodeInfo>(oldConfig));
        Set<NodeInfo> removed = ConfigUtil.getDifference(new HashSet<NodeInfo>(oldConfig), new HashSet<NodeInfo>(newConfig));
        added.forEach(this.clusterGroup::removeClusterRpcNode);
        removed.forEach(this.clusterGroup::addClusterRpcNode);
    }

    private void acceptEntry(StreamObserver<AppendResponse> observer, long matchIndex) {
        observer.onNext((Object)AppendResponse.newBuilder().setMatchIndex(matchIndex).setTerm(this.currentTerm).setFollowerId(this.getAddress()).setSuccess(true).build());
    }

    private void acceptConfigEntry(StreamObserver<ConfigResponse> observer, long matchIndex, List<NodeInfo> oldConfig, List<NodeInfo> newConfig, boolean shouldUpdateClusterGroup) {
        if (!shouldUpdateClusterGroup && newConfig != null && !newConfig.isEmpty()) {
            this.raftTaskController.updateClusterGroup(oldConfig, newConfig);
        }
        ConfigResponse.Builder builder = ConfigResponse.newBuilder().setMatchIndex(matchIndex).setTerm(this.currentTerm).setFollowerId(this.getAddress()).setSuccess(true);
        observer.onNext((Object)builder.build());
        observer.onCompleted();
    }

    private void becomeLeader() {
        if (this.state.get() == NodeState.CANDIDATE) {
            logger.info("[Node {}] Became leader in term {} with {} votes", new Object[]{this.getAddress(), this.currentTerm, this.votesGrantedSet.size()});
            this.update(NodeState.LEADER);
            this.update(this.clusterGroup.getCurrentAddress());
            this.resetNodesSyncingStatuses();
            this.sendHeartbeat(null);
            this.cancelElectionTask();
            this.resetClusterStatistics();
            if (this.clusterGroup.isSecondary()) {
                this.pullUpdatesFromPrimary();
            }
        }
    }

    private void resetNodesSyncingStatuses() {
        for (RpcNodeClient node : this.clusterGroup) {
            node.setInSyncStatus();
        }
    }

    private void resetClusterStatistics() {
        this.numberOfFailedTransactions.set(0);
        this.numberOfFailedRecoveries.set(0);
    }

    private void stepDown(long newTerm) {
        if (this.state.get() == NodeState.OUT_OF_SYNC) {
            logger.warn("[Node {}] Cannot step down as node is already out of sync", (Object)this.getAddress());
            return;
        }
        if (this.currentTerm > newTerm) {
            logger.debug("[Node {}] Cannot step down when current term {} > {}", new Object[]{this.getAddress(), this.currentTerm, newTerm});
            return;
        }
        this.update(newTerm);
        this.update(NO_LEADER);
        this.update(NodeState.FOLLOWER);
        this.cancelHeartbeat();
        this.resetElectionTimeout();
    }

    @Override
    public void goOutOfSync() {
        block8: {
            this.recoveryLock.lock();
            try {
                if (this.state.get() == NodeState.LEADER) {
                    this.update(NO_LEADER);
                }
                if (this.state.getAndSet(NodeState.OUT_OF_SYNC) == NodeState.OUT_OF_SYNC) break block8;
                logger.warn("[Node {}] Going out of sync. Attempting to recover through snapshot replication", (Object)this.clusterGroup.getCurrentAddress());
                if (this.updatePropagationService.isShutdown()) {
                    logger.warn("Rebuilding update propagation service");
                    this.updatePropagationService = this.buildUpdatePropagationService();
                }
                this.update(NodeState.OUT_OF_SYNC);
                this.cancelHeartbeat();
                this.cancelElectionTask();
                if (!this.clusterGroup.isRecovering()) {
                    try {
                        this.executorService.submit(this.buildRecoveryTask(this.clusterGroup, this::goInSync, this.recoveryState));
                        break block8;
                    }
                    catch (RejectedExecutionException e) {
                        logger.warn("[Node {}] is shutting down and would not recover through snapshot replication", (Object)this.clusterGroup.getCurrentAddress());
                        throw new RaftException("Node is shutting down", (Throwable)e);
                    }
                }
                logger.warn("[Node {}] Already attempting to recover through snapshot replication", (Object)this.clusterGroup.getCurrentAddress());
            }
            finally {
                this.recoveryLock.unlock();
            }
        }
    }

    private void goInSync() {
        boolean recovery;
        logger.info("[Node {}] Successfully recovered from snapshot", (Object)this.getAddress());
        boolean bl = recovery = this.state.get() == NodeState.OUT_OF_SYNC;
        if (recovery) {
            this.instanceLock.lock();
        }
        try {
            if (!this.clusterGroup.isRecovering()) {
                this.update(NodeState.FOLLOWER);
                this.update(this.leader.get());
                this.verifyLastChannelEntries();
                if (this.state.get() != NodeState.OUT_OF_SYNC) {
                    this.resetElectionTimeout();
                    if (this.updatePropagationService.isShutdown()) {
                        logger.warn("Rebuilding update propagation service after node goes in sync");
                        this.updatePropagationService = this.buildUpdatePropagationService();
                    }
                }
            } else {
                logger.warn("[Node {}] Cannot go in sync as node is still recovering through snapshot replication", (Object)this.getAddress());
            }
        }
        finally {
            if (recovery) {
                this.instanceLock.unlock();
            }
        }
    }

    private void verifyLastChannelEntries() {
        try {
            this.transactionLog.verifyLastChannelEntries(entry -> {
                if (this.state.get() == NodeState.OUT_OF_SYNC) {
                    logger.warn("Unable to verify last channel entry {} as node is out of sync", (Object)entry.getIndex());
                    return;
                }
                if (entry.getStatus() == LogEntry.Status.PROCESSING) {
                    logger.warn("Found entry with index {} and fingerprint {} in processing state during verification of last channel entries. Going out of sync to correct it.", (Object)entry.getIndex(), (Object)entry.getFingerprint());
                    this.goOutOfSync();
                }
            });
            if (this.state.get() == NodeState.OUT_OF_SYNC) {
                return;
            }
        }
        finally {
            this.isInitialized = true;
        }
        this.transactionLog.verifyLastChannelEntries(entry -> {
            LogEntry.Status status;
            if (this.state.get() == NodeState.OUT_OF_SYNC) {
                logger.warn("Unable to verify last channel entry {} as node is out of sync", (Object)entry.getIndex());
                return;
            }
            boolean shouldLockChannel = true;
            boolean shouldGoOutOfSync = false;
            if (entry.getStatus() == LogEntry.Status.CREATED) {
                this.transactionLog.lockChannel(entry.getChannel());
                shouldLockChannel = false;
                logger.warn("Entry with index {} and fingerprint {} will be processed during verification of last channel entries", (Object)entry.getIndex(), (Object)entry.getFingerprint());
                try {
                    if (!this.areFingerprintsEqual(this.flushEntryToMachine((LogEntry)entry), entry.getFingerprint()) && this.transactionLog.fetchEntryStatus(entry.getIndex()) != LogEntry.Status.PROCESSED) {
                        logger.error("Entry with index {} could not be processed during verification of last channel entries", (Object)entry.getIndex());
                        shouldGoOutOfSync = true;
                    }
                }
                catch (Error | Exception e) {
                    logger.error("Could not process entry {} with status {} during verification of last channel entries due to: ", new Object[]{entry.getIndex(), entry.getStatus(), e});
                    shouldGoOutOfSync = true;
                }
            }
            if ((status = this.transactionLog.fetchEntryStatus(entry.getIndex())) != LogEntry.Status.VALID && !shouldGoOutOfSync) {
                LogEntry unverifiedEntry = this.transactionLog.fetchLogEntry(entry.getIndex());
                if (shouldLockChannel) {
                    this.transactionLog.lockChannel(unverifiedEntry.getChannel());
                }
                this.verifyAppendEntry(unverifiedEntry, null, status != LogEntry.Status.PROCESSED, true, false);
            }
            if (shouldGoOutOfSync) {
                this.goOutOfSync();
            }
        });
    }

    private void updateTerm(long entryTerm, String entryLeaderId) {
        if (this.currentTerm < entryTerm) {
            this.update(entryTerm);
            this.cancelHeartbeat();
            if (this.state.get() != NodeState.FOLLOWER && this.state.get() != NodeState.OUT_OF_SYNC && this.state.get() != NodeState.RESTRICTED) {
                this.update(NodeState.FOLLOWER);
            }
            logger.info("[Node {}] Leader set to {} in update term", (Object)this.clusterGroup.getCurrentAddress(), (Object)entryLeaderId);
            this.update(entryLeaderId);
            this.votedFor = null;
        }
    }

    private boolean validateLeader(String leaderId) {
        if (this.leader.get() == null) {
            logger.info("Leader set in update term for {} with new leader {}", (Object)this.clusterGroup.getCurrentAddress(), (Object)leaderId);
            this.update(leaderId);
        } else if (!leaderId.equals(this.leader.get())) {
            logger.error("Node already has leader {}. Cannot accept entry from {}", (Object)this.leader.get(), (Object)leaderId);
            return false;
        }
        return true;
    }

    private Lock getSystemLock(int channel) {
        if (channel == 0 || channel == -8) {
            return this.systemLock.writeLock();
        }
        return this.systemLock.readLock();
    }

    protected RecoveryTask buildRecoveryTask(ClusterGroup group, RecoveryHook hook, AtomicReference<RecoveryState> state) {
        return new RecoveryTask(group, hook, state);
    }

    private boolean isAppendEntryValid(AppendEntry entry) {
        if (this.isTermOutdated(entry.getTerm())) {
            logger.warn("[Node {}] Term is outdated for entry {} with term {}", new Object[]{this.getAddress(), entry.getCommitIndex(), entry.getTerm()});
            return false;
        }
        if (!this.isPreviousEntryMatching(entry.getPrevLogIndex(), entry.getPrevLogTerm())) {
            if (RaftUtil.isHeartbeat(entry)) {
                logger.warn("[Node {}] Could not process heartbeat {} with term {} from node {} as match index is {}", new Object[]{this.getAddress(), entry.getCommitIndex(), entry.getTerm(), entry.getLeaderId(), this.transactionLog.getLastLogIndex()});
            } else {
                logger.warn("[Node {}] Previous entry is not matching for entry {} with prev index {} and term {}", new Object[]{this.getAddress(), entry.getCommitIndex(), entry.getPrevLogIndex(), entry.getPrevLogTerm()});
            }
            return false;
        }
        if (!this.isCommitEntryValid(entry.getCommitIndex(), entry.getPrevLogIndex())) {
            logger.warn("[Node {}] Commit entry is not valid for entry {}", (Object)this.getAddress(), (Object)entry.getCommitIndex());
            return false;
        }
        if (entry.getChannel() > 0 && this.transactionLog.getChannel(entry.getChannel()) == null) {
            logger.warn("[Node {}] Missing channel for entry {} with channel {}", new Object[]{this.getAddress(), entry.getCommitIndex(), entry.getChannel()});
            return false;
        }
        return true;
    }

    private boolean isConfigEntryValid(ConfigEntry entry) {
        return !this.isTermOutdated(entry.getTerm()) && this.isPreviousEntryMatching(entry.getPrevLogIndex(), entry.getPrevLogTerm()) && this.isCommitEntryValid(entry.getCommitIndex(), entry.getPrevLogIndex());
    }

    private boolean isTermOutdated(long term) {
        return term < this.currentTerm;
    }

    private boolean isPreviousEntryMatching(long entryPrevLogIndex, long entryPrevLogTerm) {
        long currentLastIndex = this.transactionLog.getLastLogIndex();
        if (currentLastIndex == 0L && entryPrevLogIndex == 0L) {
            return true;
        }
        return entryPrevLogIndex <= currentLastIndex && entryPrevLogTerm <= this.transactionLog.getLogEntryTerm(currentLastIndex);
    }

    private boolean isCommitEntryValid(long entryCommitIndex, long entryPrevLogIndex) {
        return entryCommitIndex == entryPrevLogIndex || entryCommitIndex == entryPrevLogIndex + 1L;
    }

    private boolean isVoteRequestValid(VoteRequest request) {
        return request.getLastLogIndex() == 0L && this.transactionLog.getLastLogIndex() == 0L || request.getLastLogIndex() > this.transactionLog.getLastLogIndex() && request.getLastLogTerm() >= this.transactionLog.getLastLogTerm() || this.hasSameLastLog(request);
    }

    private boolean hasSameLastLog(VoteRequest request) {
        return request.getLastLogTerm() == this.transactionLog.getLastLogTerm() && request.getLastLogIndex() == this.transactionLog.getLastLogIndex();
    }

    private boolean hasReachedQuorum(int count) {
        return count * 2 > this.clusterGroup.size();
    }

    @Override
    public void attach(RaftObserver observer) {
        this.observers.attach(observer, this.currentTerm, this.state.get(), this.clusterGroup.getNodeByRpcAddress(StringUtils.trimToNull((String)this.leader.get())).orElse(null));
    }

    @Override
    public void detach(RaftObserver observer) {
        this.observers.detach(observer);
    }

    @Override
    public void detachAll() {
        this.observers.detachAll();
    }

    @Override
    public void update(NodeState state) {
        this.state.set(state);
        this.observers.notifyOnStateUpdate(state);
    }

    @Override
    public void update(String leader) {
        NodeInfo leaderInfo = null;
        if (NO_LEADER.equals(leader)) {
            this.leader.set(null);
        } else {
            this.leader.set(leader);
            leaderInfo = this.clusterGroup.getNodeByRpcAddress(leader).orElse(null);
        }
        this.votedFor = null;
        this.observers.notifyOnLeaderChange(leaderInfo);
    }

    @Override
    public void update(long term) {
        this.currentTerm = term;
        this.observers.notifyOnTermUpdate(term);
    }

    private boolean isRestrictedOnNoEnterpriseLicense() {
        boolean isRestricted = this.clusterGroup.getStateMachine().isRestricted();
        if (isRestricted) {
            if (this.state.get() != NodeState.RESTRICTED) {
                this.update(NodeState.RESTRICTED);
                this.resetElectionTimeout();
            }
            return true;
        }
        if (this.state.get() == NodeState.RESTRICTED) {
            this.goInSync();
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleOutOfSyncOnStream(AtomicBoolean isInit, long entity, ClusterGroup group) {
        if (isInit.get()) {
            try {
                this.resetElectionTimeout();
                if (entity > 1L) {
                    this.transactionLog.rollbackLogEntryStream(entity);
                }
            }
            finally {
                group.setStreaming(false);
                try {
                    this.instanceLock.unlock();
                }
                catch (Exception e) {
                    logger.warn("Instance unlock threw error: ", (Throwable)e);
                }
            }
        }
    }

    private boolean areFingerprintsEqual(String response, String actual) {
        boolean realResult = response.equals(actual);
        if (!this.disablePluginFingerprint) {
            return realResult;
        }
        if (!realResult) {
            logger.warn("Fingerprint mismatch where expected: {} but actual: {}", (Object)response, (Object)actual);
        }
        return this.checkFingerprintSkipPlugins(response, actual);
    }

    private boolean checkFingerprintSkipPlugins(String responseFingerprint, String actualFingerprint) {
        if (responseFingerprint.split(" ").length > 2 && actualFingerprint.split(" ").length > 2) {
            String responseToCompare = RaftNode.extractRepoFingerprint(responseFingerprint);
            String actualToCompare = RaftNode.extractRepoFingerprint(actualFingerprint);
            return responseToCompare.equals(actualToCompare);
        }
        return responseFingerprint.equals(actualFingerprint);
    }

    @NotNull
    private static String extractRepoFingerprint(String responseFingerprint) {
        return responseFingerprint.substring(0, responseFingerprint.indexOf(" ")).concat(responseFingerprint.substring(responseFingerprint.lastIndexOf(" ") + 1));
    }

    @VisibleForTesting
    protected ExecutorService buildUpdatePropagationService() {
        return new DecoratingExecutorService(GraphDBMDCExecutorBuilder.build((ExecutorService)Executors.newSingleThreadExecutor(runnable -> {
            Thread thread = new Thread(runnable);
            thread.setDaemon(true);
            thread.setName("raft-update-propagation");
            return thread;
        })), runnable -> Context.current().wrap(runnable), callable -> Context.current().wrap(callable));
    }

    private class UpdatePropagationTask
    implements Callable<LogEntry> {
        final Quorum quorum;
        final AppendEntry metadata;
        final LogEntry appendedEntry;

        private UpdatePropagationTask(Quorum quorum, AppendEntry metadata, LogEntry appendedEntry) {
            this.quorum = quorum;
            this.metadata = metadata;
            this.appendedEntry = appendedEntry;
        }

        @Override
        public LogEntry call() throws RaftException {
            try {
                if (RaftNode.this.isUpdateReplicable(this.quorum)) {
                    return RaftNode.this.replicateLogEntry(this.metadata, this.quorum, this.appendedEntry);
                }
                throw new RaftException("Cluster is not in sync to replicate update");
            }
            catch (Exception e) {
                RaftNode.this.updatePropagationService.shutdownNow();
                throw e;
            }
        }
    }

    @VisibleForTesting
    public class ElectionTask
    implements Runnable {
        @Override
        public void run() {
            this.startElection();
        }

        private void startElection() {
            if (RaftNode.this.instanceLock.tryLock()) {
                try {
                    if (Thread.currentThread().isInterrupted()) {
                        RaftNode.this.resetElectionTimeout();
                        return;
                    }
                    if (RaftNode.this.isRestrictedOnNoEnterpriseLicense()) {
                        logger.warn("Election can't be started: node is restricted due to a missing Enterprise license or CLUSTER capability.");
                        RaftNode.this.resetElectionTimeout();
                        return;
                    }
                    if (RaftNode.this.isBuildingSnapshot()) {
                        logger.warn("Cannot start election as node is building a snapshot");
                        RaftNode.this.resetElectionTimeout();
                        return;
                    }
                    if (RaftNode.this.getClusterGroup().isProcessingUpdates()) {
                        logger.warn("Cannot start election as node is processing update/s");
                        RaftNode.this.resetElectionTimeout();
                        return;
                    }
                    if (RaftNode.this.state.get() == NodeState.OUT_OF_SYNC || RaftNode.this.clusterGroup.isRecovering()) {
                        logger.warn("[Node {}] With state {} and active recovery {} cannot start election", new Object[]{RaftNode.this.getAddress(), RaftNode.this.state.get(), RaftNode.this.clusterGroup.isRecovering()});
                        if (RaftNode.this.clusterGroup.isRecovering() && RaftNode.this.state.get() != NodeState.OUT_OF_SYNC) {
                            RaftNode.this.state.set(NodeState.OUT_OF_SYNC);
                            RaftNode.this.cancelElectionTask();
                            RaftNode.this.cancelHeartbeat();
                        }
                        return;
                    }
                    if (RaftNode.this.state.get() == NodeState.LEADER) {
                        logger.warn("Leader should not request votes");
                        RaftNode.this.cancelElectionTask();
                        return;
                    }
                    if (!RaftNode.this.clusterGroup.containsNode(RaftNode.this.getAddress())) {
                        logger.warn("Node has been removed from current group, could not request votes");
                        RaftNode.this.cancelElectionTask();
                        return;
                    }
                    if (logger.isDebugEnabled()) {
                        logger.debug("Requesting vote for: {}", (Object)RaftNode.this.clusterGroup.getCurrentAddress());
                    }
                    RaftNode.this.update(NodeState.CANDIDATE);
                    RaftNode.this.update(RaftNode.this.currentTerm + 1L);
                    RaftNode.this.update(RaftNode.NO_LEADER);
                    RaftNode.this.votedFor = RaftNode.this.clusterGroup.getCurrentAddress();
                    RaftNode.this.votesRespondedSet.clear();
                    RaftNode.this.votesRespondedSet.add(RaftNode.this.clusterGroup.getCurrentAddress());
                    RaftNode.this.votesGrantedSet.clear();
                    RaftNode.this.votesGrantedSet.add(RaftNode.this.clusterGroup.getCurrentAddress());
                    logger.info("Running election in term {} for node {}", (Object)RaftNode.this.currentTerm, (Object)RaftNode.this.clusterGroup.getCurrentAddress());
                }
                finally {
                    RaftNode.this.instanceLock.unlock();
                }
                for (RpcNodeClient rpcNode : RaftNode.this.clusterGroup) {
                    RaftNode.this.executorService.submit(new RequestVoteTask(rpcNode));
                }
            } else {
                logger.info("Resetting timeout as node could not acquire instance lock for election task");
            }
            RaftNode.this.resetElectionTimeout();
        }
    }

    protected class DataStreamObserver
    extends RaftStreamObserver<AppendEntry, AppendResponse> {
        protected DataStreamObserver(StreamingResponseObserver<AppendResponse> responseObserver, AtomicReference<NodeState> state, ClusterGroup group, Lock instanceLock, AtomicBoolean isApplyingEntry) {
            super(responseObserver, state, group, instanceLock, isApplyingEntry);
        }

        @Override
        protected int getChannel(AppendEntry entry) {
            return entry.getChannel();
        }

        @Override
        protected String getLeader(AppendEntry entry) {
            return entry.getLeaderId();
        }

        @Override
        protected void logIncomingStream(AppendEntry entry) {
            logger.info("[Node {}] Incoming streaming entry {} with prev log index {} and channel {}", new Object[]{RaftNode.this.getAddress(), entry.getCommitIndex(), entry.getPrevLogIndex(), entry.getChannel()});
        }

        @Override
        protected void updateTerm(AppendEntry entry) {
            RaftNode.this.updateTerm(entry.getTerm(), entry.getLeaderId());
        }

        @Override
        protected void resetElectionTimeout() {
            RaftNode.this.resetElectionTimeout();
        }

        @Override
        protected boolean isAppendEntryValid(AppendEntry entry) {
            return RaftNode.this.isAppendEntryValid(entry);
        }

        @Override
        protected boolean isRestrictedOnNoEnterpriseLicense() {
            return RaftNode.this.isRestrictedOnNoEnterpriseLicense();
        }

        @Override
        protected void setFromCandidateToFollower(AppendEntry entry) {
            RaftNode.this.setFromCandidateToFollower(entry.getTerm(), entry.getLeaderId());
        }

        @Override
        protected boolean applyEntryToMachine(LogEntry entry) {
            RaftNode.this.cancelElectionTask();
            return RaftNode.this.commitEntry(entry, (StreamObserver<AppendResponse>)this.responseObserver, true);
        }

        @Override
        protected void rejectEntry(StreamObserver<AppendResponse> observer) {
            RaftNode.this.rejectEntry(observer, null);
        }

        @Override
        protected void verifyAppendEntry(LogEntry entry, RpcNodeClient leader, boolean synchronous) {
            RaftNode.this.verifyAppendEntry(this.committableEntry, RaftNode.this.clusterGroup.getClusterRpcNode(this.currentLeader), false, false, false);
        }

        @Override
        protected boolean hasFingerprint(AppendEntry entry) {
            return !entry.getFingerprint().isEmpty();
        }

        @Override
        protected boolean validateLeader(AppendEntry entry) {
            return RaftNode.this.validateLeader(entry.getLeaderId());
        }

        @Override
        protected void appendLogEntryStream(AppendEntry entry) {
            RaftNode.this.transactionLog.appendLogEntryStream(entry);
        }

        @Override
        protected LogEntry commitLogEntryStream(long entity, AppendEntry entry) {
            RaftNode.this.cancelElectionTask();
            return RaftNode.this.transactionLog.commitLogEntryStream(entity, entry.getFingerprint());
        }

        @Override
        protected long processFirstStreamingEntry(AppendEntry entry, StreamObserver<AppendResponse> observer) {
            if (RaftNode.this.transactionLog.getLastLogIndex() == entry.getPrevLogIndex() && RaftNode.this.transactionLog.getLastLogTerm() == entry.getPrevLogTerm()) {
                RaftNode.this.cancelElectionTask();
                return RaftNode.this.transactionLog.appendLogEntryStream(entry);
            }
            return -1L;
        }

        @Override
        protected void handleOutOfSyncOnStream() {
            RaftNode.this.handleOutOfSyncOnStream(this.isInit, this.entity, this.group);
        }
    }

    protected class BackupStreamObserver
    extends RaftStreamObserver<BackupEntry, AppendResponse> {
        protected BackupStreamObserver(StreamingResponseObserver<AppendResponse> responseObserver, AtomicReference<NodeState> state, ClusterGroup group, Lock instanceLock, AtomicBoolean isApplyingEntry) {
            super(responseObserver, state, group, instanceLock, isApplyingEntry);
        }

        @Override
        protected int getChannel(BackupEntry entry) {
            return entry.getData().getChannel();
        }

        @Override
        protected String getLeader(BackupEntry entry) {
            return entry.getData().getLeaderId();
        }

        @Override
        protected void logIncomingStream(BackupEntry entry) {
            logger.info("[Node {}] Incoming backup stream for channels {}", (Object)RaftNode.this.getAddress(), (Object)entry.getUpdatedChannelsList());
        }

        @Override
        protected void updateTerm(BackupEntry entry) {
            RaftNode.this.updateTerm(entry.getData().getTerm(), entry.getData().getLeaderId());
        }

        @Override
        protected void resetElectionTimeout() {
            RaftNode.this.resetElectionTimeout();
        }

        @Override
        protected boolean isAppendEntryValid(BackupEntry entry) {
            return RaftNode.this.isAppendEntryValid(entry.getData());
        }

        @Override
        protected boolean isRestrictedOnNoEnterpriseLicense() {
            return RaftNode.this.isRestrictedOnNoEnterpriseLicense();
        }

        @Override
        protected void setFromCandidateToFollower(BackupEntry entry) {
            RaftNode.this.setFromCandidateToFollower(entry.getData().getTerm(), entry.getData().getLeaderId());
        }

        @Override
        protected boolean applyEntryToMachine(LogEntry entry) {
            logger.info("[Node {}] Restoring from backup with index {}", (Object)RaftNode.this.getAddress(), (Object)entry.getIndex());
            RaftNode.this.cancelElectionTask();
            return RaftNode.this.commitEntry(entry, (StreamObserver<AppendResponse>)this.responseObserver, true);
        }

        @Override
        protected void rejectEntry(StreamObserver<AppendResponse> observer) {
            RaftNode.this.rejectEntry(observer, null);
        }

        @Override
        protected void verifyAppendEntry(LogEntry entry, RpcNodeClient leader, boolean synchronous) {
            RaftNode.this.verifyAppendEntry(this.committableEntry, RaftNode.this.clusterGroup.getClusterRpcNode(this.currentLeader), false, false, false);
        }

        @Override
        protected boolean hasFingerprint(BackupEntry entry) {
            return !entry.getData().getFingerprint().isEmpty();
        }

        @Override
        protected boolean validateLeader(BackupEntry entry) {
            return RaftNode.this.validateLeader(entry.getData().getLeaderId());
        }

        @Override
        protected void appendLogEntryStream(BackupEntry entry) {
            RaftNode.this.transactionLog.appendLogEntryStream(entry);
        }

        @Override
        protected LogEntry commitLogEntryStream(long entity, BackupEntry entry) {
            return RaftNode.this.transactionLog.commitLogEntryStream(entity, entry.getData().getFingerprint());
        }

        @Override
        protected long processFirstStreamingEntry(BackupEntry entry, StreamObserver<AppendResponse> observer) {
            if (RaftNode.this.transactionLog.getLastLogIndex() == entry.getData().getPrevLogIndex() && RaftNode.this.transactionLog.getLastLogTerm() == entry.getData().getPrevLogTerm()) {
                logger.info("Received backup stream for cluster restore procedure");
                RaftNode.this.cancelElectionTask();
                return RaftNode.this.transactionLog.appendLogEntryStream(entry);
            }
            return -1L;
        }

        @Override
        protected void handleOutOfSyncOnStream() {
            RaftNode.this.handleOutOfSyncOnStream(this.isInit, this.entity, this.group);
        }
    }

    @VisibleForTesting
    public class RequestVoteTask
    implements Runnable {
        private final RpcNodeClient rpcNode;

        public RequestVoteTask(RpcNodeClient rpcNode) {
            this.rpcNode = rpcNode;
        }

        @Override
        public void run() {
            this.requestVote(this.rpcNode);
        }

        private void requestVote(RpcNodeClient rpcNode) {
            if (RaftNode.this.state.get() != NodeState.CANDIDATE) {
                logger.warn("Only candidates can request votes");
                return;
            }
            if (RaftNode.this.votesRespondedSet.add(rpcNode.getAddress())) {
                logger.info("Node {} requesting vote from: {}", (Object)RaftNode.this.clusterGroup.getCurrentAddress(), (Object)rpcNode.getAddress());
                try {
                    VoteResponse response = rpcNode.requestVote(RaftNode.this.currentTerm, RaftNode.this.transactionLog.getLastLogIndex(), RaftNode.this.transactionLog.getLastLogTerm());
                    this.processVoteResponse(rpcNode.getAddress(), response);
                }
                catch (RaftRpcConnectionException e) {
                    logger.error("Cannot send request vote to {} due to: {}", (Object)rpcNode.getAddress(), (Object)e.getMessage());
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void processVoteResponse(String address, VoteResponse response) {
            RaftNode.this.instanceLock.lock();
            try {
                if (RaftNode.this.currentTerm < response.getTerm()) {
                    RaftNode.this.update(response.getTerm());
                    RaftNode.this.cancelHeartbeat();
                    NodeState previousState = RaftNode.this.state.get();
                    if (RaftNode.this.state.get() != NodeState.FOLLOWER) {
                        RaftNode.this.update(NodeState.FOLLOWER);
                    }
                    RaftNode.this.update(RaftNode.NO_LEADER);
                    if (previousState == NodeState.LEADER) {
                        RaftNode.this.resetElectionTimeout();
                    }
                }
                RaftNode.this.handleVoteResponse(address, response);
                if (response.getTerm() < RaftNode.this.currentTerm) {
                    logger.warn("Stale vote response to node {}: {} from {}", new Object[]{RaftNode.this.clusterGroup.getCurrentAddress(), response, address});
                }
            }
            finally {
                RaftNode.this.instanceLock.unlock();
            }
        }
    }
}

