/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.node;

import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.raft.RaftException;
import com.ontotext.graphdb.raft.grpc.AppendEntry;
import com.ontotext.graphdb.raft.grpc.AppendResponse;
import com.ontotext.graphdb.raft.grpc.BackupEntry;
import com.ontotext.graphdb.raft.grpc.ConfigEntry;
import com.ontotext.graphdb.raft.grpc.ConfigResponse;
import com.ontotext.graphdb.raft.grpc.LeaderRequest;
import com.ontotext.graphdb.raft.grpc.LeaderResponse;
import com.ontotext.graphdb.raft.grpc.PullEntry;
import com.ontotext.graphdb.raft.grpc.PullRequest;
import com.ontotext.graphdb.raft.grpc.RaftServiceGrpc;
import com.ontotext.graphdb.raft.grpc.StatusRequest;
import com.ontotext.graphdb.raft.grpc.StatusResponse;
import com.ontotext.graphdb.raft.grpc.VerifyEntry;
import com.ontotext.graphdb.raft.grpc.VerifyResponse;
import com.ontotext.graphdb.raft.grpc.VoteRequest;
import com.ontotext.graphdb.raft.grpc.VoteResponse;
import com.ontotext.graphdb.raft.node.RaftNode;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RaftHandlerService
extends RaftServiceGrpc.RaftServiceImplBase {
    private volatile RaftNode raftNode;
    private static final String RAFT_NODE_NULL = " No raft node found.";
    private static final Logger logger = LoggerFactory.getLogger(RaftHandlerService.class);

    @Override
    public void addTransaction(AppendEntry request, StreamObserver<AppendResponse> responseObserver) {
        if (this.raftNode == null || !this.raftNode.isInitialized()) {
            this.handleRaftNodeNull(responseObserver, "Transaction not added.");
        } else {
            this.raftNode.handleAppendEntry(request, responseObserver);
        }
    }

    @Override
    public StreamObserver<AppendEntry> addTransactions(StreamObserver<AppendResponse> responseObserver) {
        if (this.raftNode == null || !this.raftNode.isInitialized()) {
            this.handleRaftNodeNull(responseObserver, "Transactions not added.");
            return null;
        }
        return this.raftNode.handleAppendEntry(responseObserver);
    }

    @Override
    public StreamObserver<BackupEntry> applyBackup(StreamObserver<AppendResponse> responseObserver) {
        if (this.raftNode == null || !this.raftNode.isInitialized()) {
            this.handleRaftNodeNull(responseObserver, "Backup not processed.");
            return null;
        }
        return this.raftNode.handleBackupEntry(responseObserver);
    }

    @Override
    public void requestVote(VoteRequest request, StreamObserver<VoteResponse> responseObserver) {
        if (this.raftNode == null || !this.raftNode.isInitialized()) {
            this.handleRaftNodeNull(responseObserver, "Vote cannot be requested.");
        } else {
            this.raftNode.handleVoteRequest(request, responseObserver);
        }
    }

    @Override
    public void validateEntry(VerifyEntry request, StreamObserver<VerifyResponse> responseObserver) {
        if (this.raftNode == null || !this.raftNode.isInitialized()) {
            this.handleRaftNodeNull(responseObserver, "Entry cannot be validated.");
        } else {
            this.raftNode.handleValidateEntry(request, responseObserver);
        }
    }

    @Override
    public void pullTransactions(PullRequest request, StreamObserver<PullEntry> observer) {
        if (this.raftNode == null || !this.raftNode.isInitialized()) {
            this.handleRaftNodeNull(observer, "Entry cannot be validated.");
        } else {
            this.raftNode.pullTransactions(request, observer);
        }
    }

    @Override
    public void updateClusterConfig(ConfigEntry request, StreamObserver<ConfigResponse> responseObserver) {
        if (this.raftNode == null || !this.raftNode.isInitialized()) {
            this.handleRaftNodeNull(responseObserver, "Entry cannot update its cluster group.");
        } else {
            this.raftNode.handleConfigEntry(request, responseObserver);
        }
    }

    @Override
    public void getLeader(LeaderRequest request, StreamObserver<LeaderResponse> responseObserver) {
        if (this.raftNode == null || !this.raftNode.isInitialized()) {
            this.handleRaftNodeNull(responseObserver, "Leader cannot be requested.");
        } else if (this.raftNode.isLeader()) {
            this.sendLeader(this.raftNode.getAddress(), responseObserver);
        } else {
            String leader = this.raftNode.getLeader();
            if (leader == null) {
                responseObserver.onError((Throwable)new StatusRuntimeException(Status.UNAVAILABLE.withCause((Throwable)new RaftException("Primary cluster does not have leader"))));
            } else {
                this.sendLeader(leader, responseObserver);
            }
        }
    }

    private void sendLeader(String leader, StreamObserver<LeaderResponse> responseObserver) {
        responseObserver.onNext((Object)LeaderResponse.newBuilder().setLeader(leader).build());
        responseObserver.onCompleted();
    }

    public void injectRaftNode(RaftNode raftNode) {
        if (this.raftNode == null) {
            this.raftNode = raftNode;
        } else if (this.raftNode != raftNode) {
            throw new IllegalStateException("Raft node already injected");
        }
    }

    public void removeRaftNode() {
        this.raftNode = null;
    }

    @Override
    public void getStatus(StatusRequest request, StreamObserver<StatusResponse> responseObserver) {
        if (this.raftNode == null || !this.raftNode.isRunning()) {
            responseObserver.onNext((Object)StatusResponse.newBuilder().setStatus(StatusResponse.Status.NO_CLUSTER).setEndpoint(Config.getExternalUrl(null)).build());
            responseObserver.onCompleted();
        } else {
            this.raftNode.handleGetStatus(request, responseObserver);
        }
    }

    private void handleRaftNodeNull(StreamObserver<?> responseObserver, String message) {
        logger.warn(message + RAFT_NODE_NULL);
        responseObserver.onError((Throwable)new StatusRuntimeException(Status.UNAVAILABLE.withCause((Throwable)new RaftException(message + RAFT_NODE_NULL))));
    }

    public RaftNode getRaftNode() {
        return this.raftNode;
    }
}

