/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.node;

import com.ontotext.graphdb.raft.ClusterGroup;
import com.ontotext.graphdb.raft.ReplicationCluster;
import com.ontotext.graphdb.raft.grpc.RpcServer;
import com.ontotext.graphdb.raft.node.RaftNode;
import com.ontotext.graphdb.raft.observe.RaftObserver;
import com.ontotext.graphdb.raft.security.MDCHeadersClientInterceptor;
import com.ontotext.graphdb.raft.security.RequestSignerInterceptor;
import com.ontotext.graphdb.raft.security.SecurityConfig;
import com.ontotext.graphdb.raft.security.SecurityUtil;
import io.grpc.BindableService;
import io.grpc.ChannelCredentials;
import io.grpc.ClientInterceptor;
import io.grpc.Grpc;
import io.grpc.ManagedChannelBuilder;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClusterFactory {
    private static final Logger logger = LoggerFactory.getLogger(ClusterFactory.class);

    private ClusterFactory() {
    }

    public static ReplicationCluster buildRaftCluster(RpcServer rpcServer, ClusterGroup group, Collection<RaftObserver> observers) {
        RaftNode node = rpcServer.getRaftNode().orElseGet(() -> new RaftNode(group));
        for (RaftObserver observer : observers) {
            node.attach(observer);
        }
        logger.info("Initialized replication cluster with address {} and members {}", (Object)group.getCurrentAddress(), group.getNodeIds());
        rpcServer.injectRaftNode(node);
        return node;
    }

    public static RpcServer createRpcServer(List<BindableService> services, String hostname, int port) {
        return new RpcServer(services, hostname, port);
    }

    public static ManagedChannelBuilder<?> createChannelTo(String clientAddress) {
        ChannelCredentials channelCredentials = SecurityUtil.createChannelCredentials((SecurityConfig)SecurityConfig.INSTANCE);
        return Grpc.newChannelBuilder((String)clientAddress, (ChannelCredentials)channelCredentials).intercept(new ClientInterceptor[]{new RequestSignerInterceptor(clientAddress), new MDCHeadersClientInterceptor()});
    }
}

