/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.grpc;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.ByteString;
import com.ontotext.graphdb.raft.RaftException;
import com.ontotext.graphdb.raft.grpc.AbstractRpcClient;
import com.ontotext.graphdb.raft.grpc.AppendEntry;
import com.ontotext.graphdb.raft.grpc.AppendResponse;
import com.ontotext.graphdb.raft.grpc.AzureBackupRequest;
import com.ontotext.graphdb.raft.grpc.AzureBackupResponse;
import com.ontotext.graphdb.raft.grpc.BackupEntry;
import com.ontotext.graphdb.raft.grpc.BackupRequest;
import com.ontotext.graphdb.raft.grpc.ConfigEntry;
import com.ontotext.graphdb.raft.grpc.ConfigResponse;
import com.ontotext.graphdb.raft.grpc.GoogleBackupRequest;
import com.ontotext.graphdb.raft.grpc.GoogleBackupResponse;
import com.ontotext.graphdb.raft.grpc.LeaderRequest;
import com.ontotext.graphdb.raft.grpc.PullEntry;
import com.ontotext.graphdb.raft.grpc.PullRequest;
import com.ontotext.graphdb.raft.grpc.RaftRpcConnectionException;
import com.ontotext.graphdb.raft.grpc.RaftServiceGrpc;
import com.ontotext.graphdb.raft.grpc.RecoveryServiceGrpc;
import com.ontotext.graphdb.raft.grpc.ReportingIterator;
import com.ontotext.graphdb.raft.grpc.S3BackupRequest;
import com.ontotext.graphdb.raft.grpc.S3BackupResponse;
import com.ontotext.graphdb.raft.grpc.SnapshotData;
import com.ontotext.graphdb.raft.grpc.SnapshotRequest;
import com.ontotext.graphdb.raft.grpc.SnapshotResponse;
import com.ontotext.graphdb.raft.grpc.StatusRequest;
import com.ontotext.graphdb.raft.grpc.StatusResponse;
import com.ontotext.graphdb.raft.grpc.VerifyEntry;
import com.ontotext.graphdb.raft.grpc.VerifyResponse;
import com.ontotext.graphdb.raft.grpc.VoteRequest;
import com.ontotext.graphdb.raft.grpc.VoteResponse;
import com.ontotext.graphdb.raft.node.Quorum;
import com.ontotext.graphdb.raft.util.RaftUtil;
import io.grpc.Channel;
import io.grpc.ClientCall;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.ClientCalls;
import io.grpc.stub.StreamObserver;
import java.io.BufferedInputStream;
import java.io.InputStream;
import java.util.List;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.Nullable;

public class RpcNodeClient
extends AbstractRpcClient {
    protected final String nodeAddress;
    protected final AtomicLong nextIndex;
    protected final AtomicLong matchIndex;
    protected final AtomicReference<Status> status;
    protected final SortedSet<Long> updateCounter;
    protected volatile RaftServiceGrpc.RaftServiceFutureStub raftFutureStub;
    protected volatile RaftServiceGrpc.RaftServiceBlockingStub raftBlockingStub;
    protected volatile RaftServiceGrpc.RaftServiceStub raftAsyncStub;
    protected volatile RecoveryServiceGrpc.RecoveryServiceBlockingStub recoveryBlockingStub;

    public RpcNodeClient(String clientAddress, long nextIndex, String nodeAddress, int messageSizeBytes) {
        super(clientAddress, messageSizeBytes);
        this.nodeAddress = nodeAddress;
        this.nextIndex = new AtomicLong(nextIndex);
        this.matchIndex = new AtomicLong(0L);
        this.status = new AtomicReference<Status>(Status.NO_CONNECTION);
        this.updateCounter = new ConcurrentSkipListSet<Long>();
    }

    public AppendResponse sendTransactionRpc(AppendEntry entry, Quorum quorum) {
        try {
            this.init();
            AtomicReference<AppendResponse> finalResponse = new AtomicReference<AppendResponse>();
            CountDownLatch finishLatch = new CountDownLatch(1);
            AtomicReference<Throwable> error = new AtomicReference<Throwable>();
            ((RaftServiceGrpc.RaftServiceStub)this.raftAsyncStub.withDeadlineAfter(RaftUtil.isHeartbeat(entry) ? 10L : 120L, TimeUnit.SECONDS)).addTransaction(entry, this.buildResponseObserver(finalResponse, finishLatch, error));
            if (quorum != null) {
                quorum.incrementStart();
            }
            finishLatch.await();
            if (error.get() != null) {
                throw new RaftRpcConnectionException(error.get());
            }
            return finalResponse.get();
        }
        catch (Exception e) {
            this.moveChannelToIdleIfNeeded(e);
            if (e instanceof RaftRpcConnectionException) {
                throw (RaftRpcConnectionException)e;
            }
            throw new RaftRpcConnectionException(e);
        }
    }

    public VerifyResponse sendValidateRpc(VerifyEntry entry) {
        try {
            this.init();
            return ((RaftServiceGrpc.RaftServiceBlockingStub)this.raftBlockingStub.withDeadlineAfter(10L, TimeUnit.SECONDS)).validateEntry(entry);
        }
        catch (Exception e) {
            this.moveChannelToIdleIfNeeded(e);
            throw new RaftRpcConnectionException(e);
        }
    }

    public ConfigResponse sendConfigUpdateRpc(ConfigEntry entry) {
        try {
            this.init();
            return ((RaftServiceGrpc.RaftServiceBlockingStub)this.raftBlockingStub.withDeadlineAfter(120L, TimeUnit.SECONDS)).updateClusterConfig(entry);
        }
        catch (Exception e) {
            this.moveChannelToIdleIfNeeded(e);
            this.logger.error("Node with address {} cannot send config entry message to member {} due to : {}", new Object[]{this.nodeAddress, this.clientAddress, e.getMessage()});
            throw new RaftRpcConnectionException(e);
        }
    }

    public AppendResponse sendTransactionStreamRpc(InputStream stream, AppendEntry metadata, Quorum quorum) {
        AppendResponse appendResponse;
        block10: {
            InputStream inputStream = stream;
            try {
                this.init();
                AtomicReference<AppendResponse> finalResponse = new AtomicReference<AppendResponse>();
                CountDownLatch finishLatch = new CountDownLatch(1);
                AtomicReference<Throwable> error = new AtomicReference<Throwable>();
                StreamObserver<AppendEntry> adder = this.fetchAppendStream(finalResponse, finishLatch, quorum, error);
                this.propagateTransactionEntries(adder, this.bufferStream(stream), metadata, finishLatch, quorum, error);
                if (error.get() != null) {
                    throw new RaftRpcConnectionException(error.get());
                }
                appendResponse = finalResponse.get();
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.moveChannelToIdleIfNeeded(e);
                    if (e instanceof RaftRpcConnectionException) {
                        throw (RaftRpcConnectionException)e;
                    }
                    throw new RaftRpcConnectionException(e);
                }
            }
            inputStream.close();
        }
        return appendResponse;
    }

    protected StreamObserver<AppendEntry> fetchAppendStream(AtomicReference<AppendResponse> finalResponse, CountDownLatch finishLatch, Quorum quorum, AtomicReference<Throwable> error) {
        try {
            return ((RaftServiceGrpc.RaftServiceStub)this.raftAsyncStub.withDeadlineAfter(2L, TimeUnit.HOURS)).addTransactions(this.buildResponseObserver(finalResponse, finishLatch, error));
        }
        catch (Exception e) {
            if (quorum != null) {
                quorum.incrementStart();
            }
            throw e;
        }
    }

    public AppendResponse sendBackupStreamRpc(InputStream stream, BackupEntry metadata, Quorum quorum) {
        AppendResponse appendResponse;
        block9: {
            InputStream inputStream = stream;
            try {
                this.init();
                AtomicReference<AppendResponse> finalResponse = new AtomicReference<AppendResponse>();
                CountDownLatch finishLatch = new CountDownLatch(1);
                AtomicReference<Throwable> error = new AtomicReference<Throwable>();
                StreamObserver<BackupEntry> adder = this.fetchBackupStream(finalResponse, finishLatch, quorum, error);
                this.propagateBackupEntries(adder, this.bufferStream(stream), metadata, finishLatch, quorum, error);
                if (error.get() != null) {
                    throw new RaftException(error.get());
                }
                appendResponse = finalResponse.get();
                if (inputStream == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    this.moveChannelToIdleIfNeeded(e);
                    throw new RaftRpcConnectionException(e);
                }
            }
            inputStream.close();
        }
        return appendResponse;
    }

    protected StreamObserver<BackupEntry> fetchBackupStream(AtomicReference<AppendResponse> finalResponse, CountDownLatch finishLatch, Quorum quorum, AtomicReference<Throwable> error) {
        try {
            final StreamObserver<BackupEntry> observer = this.raftAsyncStub.applyBackup(this.buildResponseObserver(finalResponse, finishLatch, error));
            if (observer instanceof ClientCallStreamObserver) {
                return new ClientCallStreamObserver<BackupEntry>(this){
                    final ClientCallStreamObserver<BackupEntry> actualObserver;
                    {
                        this.actualObserver = (ClientCallStreamObserver)observer;
                    }

                    public void cancel(@Nullable String message, @Nullable Throwable cause) {
                        this.actualObserver.cancel(message, cause);
                    }

                    public boolean isReady() {
                        return this.actualObserver.isReady();
                    }

                    public void setOnReadyHandler(Runnable onReadyHandler) {
                        this.actualObserver.setOnReadyHandler(onReadyHandler);
                    }

                    public void request(int count) {
                        this.actualObserver.request(count);
                    }

                    public void setMessageCompression(boolean enable) {
                        this.actualObserver.setMessageCompression(enable);
                    }

                    public void disableAutoInboundFlowControl() {
                        this.actualObserver.disableAutoInboundFlowControl();
                    }

                    public void onNext(BackupEntry value) {
                        while (!this.isReady() && !Thread.currentThread().isInterrupted()) {
                            Thread.onSpinWait();
                        }
                        this.actualObserver.onNext((Object)value);
                    }

                    public void onError(Throwable t) {
                        this.actualObserver.onError(t);
                    }

                    public void onCompleted() {
                        this.actualObserver.onCompleted();
                    }
                };
            }
            return observer;
        }
        catch (Exception e) {
            if (quorum != null) {
                quorum.incrementStart();
            }
            throw e;
        }
    }

    private BufferedInputStream bufferStream(InputStream stream) {
        if (!(stream instanceof BufferedInputStream)) {
            return new BufferedInputStream(stream, this.messageSizeBytes);
        }
        return (BufferedInputStream)stream;
    }

    public ReportingIterator<SnapshotData> requestSnapshot(long matchIndex) {
        try {
            this.init();
            return this.requestSnapshot(SnapshotRequest.newBuilder().setNodeId(this.nodeAddress).setMatchIndex(matchIndex).build());
        }
        catch (Exception e) {
            this.logger.error("Node with address {} cannot request recovery snapshot from member {} due to : {}", new Object[]{this.nodeAddress, this.clientAddress, e.getMessage()});
            throw new RaftRpcConnectionException(e);
        }
    }

    public ReportingIterator<SnapshotData> requestSnapshot(long matchIndex, String tag) {
        try {
            this.init();
            return this.requestSnapshot(SnapshotRequest.newBuilder().setNodeId(this.nodeAddress).setMatchIndex(matchIndex).setTag(tag).build());
        }
        catch (Exception e) {
            this.logger.error("Node with address {} cannot request recovery snapshot from member {} due to : {}", new Object[]{this.nodeAddress, this.clientAddress, e.getMessage()});
            throw new RaftRpcConnectionException(e);
        }
    }

    public ReportingIterator<SnapshotData> requestBackup(boolean withSystemData, boolean withRepositoryData, List<String> repositories) {
        try {
            this.init();
            return this.requestBackup(BackupRequest.newBuilder().setNodeId(this.nodeAddress).setWithSystemData(withSystemData).setWithRepositoryData(withRepositoryData).addAllRepositories(repositories == null ? List.of() : repositories).build());
        }
        catch (Exception e) {
            this.logger.error("Node with address {} cannot request backup from member {} due to : {}", new Object[]{this.nodeAddress, this.clientAddress, e.getMessage()});
            throw new RaftRpcConnectionException(e);
        }
    }

    private ReportingIterator<SnapshotData> requestSnapshot(SnapshotRequest request) {
        ClientCall call = this.mainChannel.newCall(RecoveryServiceGrpc.getRequestSnapshotMethod(), this.recoveryBlockingStub.getCallOptions());
        return new ReportingIterator<SnapshotData>(ClientCalls.blockingServerStreamingCall((ClientCall)call, (Object)request), (message, throwable) -> {
            call.cancel(message, throwable);
            this.moveChannelToIdleIfNeeded((Throwable)throwable);
        });
    }

    private ReportingIterator<SnapshotData> requestBackup(BackupRequest request) {
        ClientCall call = this.mainChannel.newCall(RecoveryServiceGrpc.getRequestBackupMethod(), this.recoveryBlockingStub.getCallOptions());
        return new ReportingIterator<SnapshotData>(ClientCalls.blockingServerStreamingCall((ClientCall)call, (Object)request), (message, throwable) -> {
            call.cancel(message, throwable);
            this.moveChannelToIdleIfNeeded((Throwable)throwable);
        });
    }

    public SnapshotResponse sendSnapshotQuery(long matchIndex) {
        try {
            this.init();
            return ((RecoveryServiceGrpc.RecoveryServiceBlockingStub)this.recoveryBlockingStub.withDeadlineAfter(5L, TimeUnit.SECONDS)).hasSnapshot(SnapshotRequest.newBuilder().setNodeId(this.nodeAddress).setMatchIndex(matchIndex).build());
        }
        catch (Exception e) {
            this.moveChannelToIdleIfNeeded(e);
            this.logger.error("Node with address {} cannot send message to member {} due to : {}", new Object[]{this.nodeAddress, this.clientAddress, e.getMessage()});
            throw new RaftRpcConnectionException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propagateTransactionEntries(StreamObserver<AppendEntry> adder, InputStream stream, AppendEntry metadata, CountDownLatch finishLatch, Quorum quorum, AtomicReference<Throwable> error) {
        try {
            this.sendMetadata(adder, metadata, quorum);
            byte[] buffer = new byte[this.messageSizeBytes];
            int size = 0;
            AppendEntry.Builder builder = AppendEntry.newBuilder().setCommitIndex(metadata.getCommitIndex()).setChannel(metadata.getChannel());
            while ((size = stream.read(buffer)) > 0) {
                if (error.get() != null) {
                    this.logAbortingStream(error.get().getMessage());
                    return;
                }
                adder.onNext((Object)builder.setRdfData(ByteString.copyFrom((byte[])buffer, (int)0, (int)size)).build());
            }
            if (error.get() != null) {
                this.logAbortingStream(error.get().getMessage());
                return;
            }
            adder.onNext((Object)metadata);
            if (error.get() != null) {
                this.logAbortingStream(error.get().getMessage());
                return;
            }
            adder.onCompleted();
            finishLatch.await();
        }
        catch (Exception e) {
            try {
                adder.onError((Throwable)e);
            }
            finally {
                finishLatch.countDown();
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            throw new RaftRpcConnectionException(e);
        }
    }

    private void logAbortingStream(String errorMessage) {
        this.logger.warn("Aborting stream propagation to node {} due to: {} ", (Object)this.nodeAddress, (Object)errorMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void propagateBackupEntries(StreamObserver<BackupEntry> adder, InputStream stream, BackupEntry metadata, CountDownLatch finishLatch, Quorum quorum, AtomicReference<Throwable> error) {
        try {
            this.sendMetadata(adder, metadata, quorum);
            byte[] buffer = new byte[0x100000];
            int size = 0;
            AppendEntry.Builder dataBuilder = AppendEntry.newBuilder().setCommitIndex(metadata.getData().getCommitIndex()).setChannel(metadata.getData().getChannel());
            BackupEntry.Builder builder = BackupEntry.newBuilder();
            while ((size = stream.read(buffer)) > 0) {
                if (error.get() != null) {
                    this.logAbortingBackupPropagation(error.get().getMessage());
                    return;
                }
                adder.onNext((Object)builder.setData(dataBuilder.setRdfData(ByteString.copyFrom((byte[])buffer, (int)0, (int)size)).build()).build());
            }
            if (error.get() != null) {
                this.logAbortingBackupPropagation(error.get().getMessage());
                return;
            }
            adder.onNext((Object)metadata);
            if (error.get() != null) {
                this.logAbortingBackupPropagation(error.get().getMessage());
                return;
            }
            adder.onCompleted();
            finishLatch.await();
        }
        catch (Exception e) {
            try {
                adder.onError((Throwable)e);
            }
            finally {
                finishLatch.countDown();
                if (e instanceof InterruptedException) {
                    Thread.currentThread().interrupt();
                }
            }
            throw new RaftRpcConnectionException(e);
        }
    }

    private void logAbortingBackupPropagation(String errorMessage) {
        this.logger.warn("Aborting backup propagation to node {} due to: {}", (Object)this.nodeAddress, (Object)errorMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMetadata(StreamObserver<AppendEntry> adder, AppendEntry metadata, Quorum quorum) {
        try {
            adder.onNext((Object)AppendEntry.newBuilder().mergeFrom(metadata).setFingerprint("").build());
        }
        finally {
            if (quorum != null) {
                quorum.incrementStart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendMetadata(StreamObserver<BackupEntry> adder, BackupEntry metadata, Quorum quorum) {
        try {
            AppendEntry meta = AppendEntry.newBuilder().mergeFrom(metadata.getData()).setFingerprint("").build();
            adder.onNext((Object)BackupEntry.newBuilder().addAllUpdatedChannels((Iterable<String>)metadata.getUpdatedChannelsList()).setClearAll(metadata.getClearAll()).setData(meta).build());
        }
        finally {
            if (quorum != null) {
                quorum.incrementStart();
            }
        }
    }

    private StreamObserver<AppendResponse> buildResponseObserver(final AtomicReference<AppendResponse> finalResponse, final CountDownLatch latch, final AtomicReference<Throwable> error) {
        return new StreamObserver<AppendResponse>(){

            public void onNext(AppendResponse value) {
                finalResponse.set(value);
            }

            public void onError(Throwable t) {
                error.set(t);
                latch.countDown();
                RpcNodeClient.this.logger.error("Unable to send streaming entry to {} due to: ", (Object)RpcNodeClient.this.clientAddress, (Object)t.getCause());
            }

            public void onCompleted() {
                latch.countDown();
            }
        };
    }

    public VoteResponse requestVote(long term, long lastLogIndex, long lastLogTerm) {
        try {
            this.init();
            return this.raftBlockingStub.requestVote(VoteRequest.newBuilder().setCandidateId(this.nodeAddress).setTerm(term).setLastLogIndex(lastLogIndex).setLastLogTerm(lastLogTerm).build());
        }
        catch (Exception e) {
            this.moveChannelToIdleIfNeeded(e);
            this.logger.error("Node with address {} cannot request vote from member {} due to : {}", new Object[]{this.nodeAddress, this.clientAddress, e.getMessage()});
            throw new RaftRpcConnectionException(e);
        }
    }

    public ListenableFuture<StatusResponse> requestStatus() {
        try {
            this.init();
            return ((RaftServiceGrpc.RaftServiceFutureStub)this.raftFutureStub.withDeadlineAfter(20L, TimeUnit.SECONDS)).getStatus(StatusRequest.newBuilder().setRequestingNodeId(this.nodeAddress).build());
        }
        catch (Exception e) {
            this.moveChannelToIdleIfNeeded(e);
            throw new RaftRpcConnectionException(e.getMessage(), e);
        }
    }

    public String getLeader() {
        try {
            this.init();
            return this.raftBlockingStub.getLeader(LeaderRequest.newBuilder().build()).getLeader();
        }
        catch (Exception e) {
            this.moveChannelToIdleIfNeeded(e);
            throw new RaftRpcConnectionException(e.getMessage(), e);
        }
    }

    public ReportingIterator<PullEntry> pullTransactions(PullRequest request) {
        try {
            this.init();
            ClientCall call = this.mainChannel.newCall(RaftServiceGrpc.getPullTransactionsMethod(), this.raftBlockingStub.getCallOptions());
            return new ReportingIterator<PullEntry>(ClientCalls.blockingServerStreamingCall((ClientCall)call, (Object)request), (message, throwable) -> {
                call.cancel(message, throwable);
                this.moveChannelToIdleIfNeeded((Throwable)throwable);
            });
        }
        catch (Exception e) {
            this.moveChannelToIdleIfNeeded(e);
            throw new RaftRpcConnectionException(e.getMessage(), e);
        }
    }

    public long getNextIndex() {
        return this.nextIndex.get();
    }

    public long getMatchIndex() {
        return this.matchIndex.get();
    }

    public void setNextIndex(long index) {
        this.nextIndex.set(index);
    }

    public void setMatchIndex(long index) {
        this.matchIndex.set(index);
    }

    public void beginUpdate(long id) {
        this.updateCounter.add(id);
    }

    public void finishUpdate(long id) {
        this.updateCounter.remove(id);
    }

    public boolean isProcessingUpdate() {
        return !this.updateCounter.isEmpty();
    }

    public boolean isProcessingUpdate(long id) {
        if (this.matchIndex.get() >= id) {
            if (!this.updateCounter.isEmpty()) {
                try {
                    Long min = this.updateCounter.first();
                    return min == null || min > id;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            return true;
        }
        return false;
    }

    public Status getStatus() {
        return this.status.get();
    }

    public boolean setSyncingStatus() {
        return this.status.compareAndSet(Status.IN_SYNC, Status.SYNCING) || this.status.compareAndSet(Status.NO_CONNECTION, Status.SYNCING) || this.status.compareAndSet(Status.OUT_OF_SYNC, Status.SYNCING);
    }

    public void setInSyncStatus() {
        this.status.set(Status.IN_SYNC);
    }

    public void setOutOfSyncStatus() {
        this.status.set(Status.OUT_OF_SYNC);
    }

    public void setNoConnectionStatus(Exception e) {
        if (!(e instanceof RaftRpcConnectionException) || !this.isNodeFailure((RaftRpcConnectionException)e)) {
            this.status.set(Status.NO_CONNECTION);
        }
    }

    private boolean isNodeFailure(RaftRpcConnectionException e) {
        io.grpc.Status status = e.getStatus();
        return status == io.grpc.Status.DEADLINE_EXCEEDED || status == io.grpc.Status.INTERNAL || status == io.grpc.Status.FAILED_PRECONDITION || status == io.grpc.Status.NOT_FOUND;
    }

    @Override
    public void initStubs() {
        this.raftBlockingStub = RaftServiceGrpc.newBlockingStub((Channel)this.mainChannel);
        this.raftAsyncStub = RaftServiceGrpc.newStub((Channel)this.mainChannel);
        this.recoveryBlockingStub = RecoveryServiceGrpc.newBlockingStub((Channel)this.mainChannel);
        this.raftFutureStub = RaftServiceGrpc.newFutureStub((Channel)this.mainChannel);
    }

    public S3BackupResponse requestCloudBackup(S3BackupRequest s3BackupRequest) {
        try {
            return this.recoveryBlockingStub.requestS3Backup(s3BackupRequest);
        }
        catch (Exception e) {
            this.moveChannelToIdleIfNeeded(e);
            this.logger.error("Node with address {} cannot request backup from member {} due to : {}", new Object[]{this.nodeAddress, this.clientAddress, e.getMessage()});
            throw new RaftRpcConnectionException(e);
        }
    }

    public AzureBackupResponse requestAzureBackup(AzureBackupRequest azureBackupRequest) {
        try {
            return this.recoveryBlockingStub.requestAzureBackup(azureBackupRequest);
        }
        catch (Exception e) {
            this.moveChannelToIdleIfNeeded(e);
            this.logger.error("Node with address {} cannot request backup from member {} due to : {}", new Object[]{this.nodeAddress, this.clientAddress, e.getMessage()});
            throw new RaftRpcConnectionException(e);
        }
    }

    public GoogleBackupResponse requestGoogleBackup(GoogleBackupRequest googleBackupRequest) {
        try {
            return this.recoveryBlockingStub.requestGoogleBackup(googleBackupRequest);
        }
        catch (Exception e) {
            this.moveChannelToIdleIfNeeded(e);
            this.logger.error("Node with address {} cannot request backup from member {} due to : {}", new Object[]{this.nodeAddress, this.clientAddress, e.getMessage()});
            throw new RaftRpcConnectionException(e);
        }
    }

    public static enum Status {
        IN_SYNC,
        SYNCING,
        OUT_OF_SYNC,
        NO_CONNECTION;

    }
}

