/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.grpc;

import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.StatusRuntimeException;

public class RaftRpcConnectionException
extends RuntimeException {
    private final Status grpcStatus;

    public RaftRpcConnectionException(String message, Throwable e) {
        super(message);
        this.grpcStatus = this.extractStatusFromException(e);
    }

    public RaftRpcConnectionException(Throwable e) {
        super(e);
        this.grpcStatus = this.extractStatusFromException(e);
    }

    public RaftRpcConnectionException(String message) {
        super(message);
        this.grpcStatus = null;
    }

    @Override
    public Throwable fillInStackTrace() {
        return this;
    }

    public Status getStatus() {
        return this.grpcStatus;
    }

    protected Status extractStatusFromException(Throwable e) {
        if (e instanceof StatusException) {
            return ((StatusException)e).getStatus();
        }
        if (e instanceof StatusRuntimeException) {
            return ((StatusRuntimeException)e).getStatus();
        }
        return null;
    }
}

