/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft.config;

import com.ontotext.graphdb.raft.grpc.NodeInfo;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ConfigUtil {
    private ConfigUtil() {
    }

    public static Set<NodeInfo> getDifference(Set<NodeInfo> config1, Set<NodeInfo> config2) {
        HashSet<NodeInfo> resultSet = new HashSet<NodeInfo>(config1);
        resultSet.removeAll(config2);
        return resultSet;
    }

    public static String generateFingerprint(List<NodeInfo> nodes) {
        nodes.sort(Comparator.comparing(NodeInfo::getRpcAddress));
        StringBuilder fingerprint = new StringBuilder();
        for (NodeInfo nodeInfo : nodes) {
            fingerprint.append(nodeInfo.getRpcAddress().hashCode());
        }
        return fingerprint.toString();
    }

    public static String generateFingerprint(Map<String, Number> newProperties) {
        long hash = 0L;
        hash += (long)Long.hashCode(((Integer)newProperties.get("graphdb.raft.election.min.ms")).intValue());
        hash += (long)Long.hashCode(((Integer)newProperties.get("graphdb.raft.election.range.ms")).intValue());
        hash += (long)Long.hashCode(((Integer)newProperties.get("graphdb.raft.election.heartbeat.ms")).intValue());
        hash += (long)Long.hashCode(((Integer)newProperties.get("graphdb.raft.rpc.message.size")).intValue());
        hash += (long)Long.hashCode(((Integer)newProperties.get("graphdb.raft.rpc.verification.ms")).intValue());
        hash += (long)Long.hashCode(((Integer)newProperties.get("graphdb.raft.batch.update.interval.ms")).intValue());
        return Long.toString(hash += (long)Long.hashCode((long)(((Float)newProperties.get("graphdb.raft.transaction.log.threshold.gb")).floatValue() * 1024.0f * 1024.0f * 1024.0f)));
    }
}

