/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.graphdb.raft.ClusterGroup;
import com.ontotext.graphdb.raft.RaftException;
import com.ontotext.graphdb.raft.grpc.NodeInfo;
import com.ontotext.graphdb.raft.grpc.SnapshotData;
import com.ontotext.graphdb.raft.storage.LogEntry;
import io.grpc.stub.StreamObserver;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.commons.io.input.BoundedInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class StateMachine {
    public static final String RECOVERY_FOLDER = "cluster-recovery";
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    protected final ReadWriteLock readWriteLock = new ReentrantReadWriteLock();
    private volatile ClusterGroup group;
    private volatile boolean shutdown = false;

    protected StateMachine() {
    }

    public static String readString(DataInputStream stream) throws IOException {
        return new String(stream.readNBytes(stream.readInt()), StandardCharsets.UTF_8);
    }

    public void setGroup(ClusterGroup group) {
        this.group = group;
    }

    public void shutdown() {
        if (this.shutdown) {
            return;
        }
        try {
            if (this.readWriteLock.writeLock().tryLock(30L, TimeUnit.SECONDS)) {
                this.shutdown = true;
                this.logger.info("Successfully locked state machine for shutdown, within 30s");
                this.readWriteLock.writeLock().unlock();
            } else {
                this.logger.warn("Unable to acquire state machine lock for shutdown, within 30s");
            }
        }
        catch (InterruptedException e) {
            this.logger.warn("Interrupted shutdown");
            Thread.currentThread().interrupt();
        }
    }

    public void readLock() {
        this.readWriteLock.readLock().lock();
    }

    public void readUnlock() {
        this.readWriteLock.readLock().unlock();
    }

    public final String apply(LogEntry entry) {
        this.checkForShutdown();
        this.updateEntryStatus(entry, LogEntry.Status.PROCESSING);
        String fingerprint = this.applyInternal(entry);
        this.updateEntryStatus(entry, LogEntry.Status.PROCESSED);
        return fingerprint;
    }

    public boolean tryLockMachine(long timeoutMs) {
        try {
            return this.readWriteLock.writeLock().tryLock(timeoutMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.logger.warn("Interrupted attempt to lock machine");
            Thread.currentThread().interrupt();
            throw new RuntimeException(e);
        }
    }

    public void lockMachine() {
        this.readWriteLock.writeLock().lock();
        this.logger.info("Successfully locked state machine processing");
    }

    public void unlockMachine() {
        this.readWriteLock.writeLock().unlock();
        this.logger.info("Successfully unlocked state machine");
    }

    public void generateBackup(List<String> repositories, boolean withSystemData, boolean withRepositoryData, StreamObserver<SnapshotData> response) {
        throw new UnsupportedOperationException("Operation not implemented for " + String.valueOf(this.getClass()));
    }

    public void generateBackup(List<String> repositories, boolean withSystemData, boolean withRepositoryData, OutputStream outputStream) {
        throw new UnsupportedOperationException("Operation not implemented for " + String.valueOf(this.getClass()));
    }

    public long estimateBackupSize(List<String> repositories, boolean withSystemData, boolean withRepositoryData) {
        throw new UnsupportedOperationException("Operation not implemented for " + String.valueOf(this.getClass()));
    }

    public void invalidateChannelProcessor(String repositoryId) {
        throw new UnsupportedOperationException("Operation not implemented for " + String.valueOf(this.getClass()));
    }

    public abstract File generateSnapshot(long var1);

    public abstract void applySnapshot(File var1);

    public abstract File getLatestSnapshot();

    public abstract long getLatestSnapshotIndex();

    public abstract String getFingerprint(String var1);

    public abstract boolean isRestricted();

    public abstract void deleteClusterRecoveryDir();

    protected abstract String processRepositoryEntry(String var1, InputStream var2);

    protected abstract String processRecoveryEntry(InputStream var1);

    protected abstract String processSystemEntry(InputStream var1);

    protected abstract String processConfigEntry(LogEntry var1);

    protected abstract void applySecondarySnapshot(InputStream var1) throws IOException;

    protected void checkForShutdown() {
        if (this.shutdown) {
            throw new IllegalStateException("Cannot handle request after server has initiated a shutdown");
        }
    }

    protected String applyInternal(LogEntry entry) {
        String fingerprint;
        if (entry.getChannel() > 0) {
            fingerprint = this.processRepositoryEntry(entry.getRepository(), entry.getDataStream());
        } else if (entry.getChannel() == -2) {
            fingerprint = this.processConfigEntry(entry);
        } else if (entry.getChannel() == -5) {
            fingerprint = this.processRecoveryEntry(entry.getDataStream());
        } else if (entry.getChannel() == -6) {
            this.deleteClusterRecoveryDir();
            fingerprint = entry.getFingerprint();
        } else if (entry.getChannel() == -8) {
            this.processSecondaryUpdate(entry);
            fingerprint = entry.getFingerprint();
        } else {
            fingerprint = this.processSystemEntry(entry.getDataStream());
        }
        return fingerprint;
    }

    @VisibleForTesting
    protected void updateEntryStatus(LogEntry entry, LogEntry.Status status) {
        this.getClusterGroup().getTransactionLog().setLogStatus(entry.getIndex(), status);
    }

    protected void processSecondaryUpdate(LogEntry entry) {
        block12: {
            try (DataInputStream stream = new DataInputStream(entry.getDataStream());){
                byte type = stream.readByte();
                if (type == 1) {
                    this.processSecondaryCreate(stream);
                    break block12;
                }
                if (type == 2) {
                    this.processSecondaryDelete();
                    break block12;
                }
                if (type == 3) {
                    this.processSecondaryBatchUpdate(stream);
                    break block12;
                }
                if (type == 4) {
                    this.addTag(StateMachine.readString(stream));
                    break block12;
                }
                if (type == 5) {
                    this.removeTag(StateMachine.readString(stream));
                    break block12;
                }
                throw new RuntimeException("Unexpected log entry type: " + type);
            }
            catch (IOException e) {
                throw new RaftException((Exception)e);
            }
        }
    }

    protected void processSecondaryCreate(DataInputStream stream) throws IOException {
        String tag = StateMachine.readString(stream);
        long matchIndex = stream.readLong();
        List<NodeInfo> primaryGroup = this.readPrimaryGroup(stream);
        this.setAllSecondaryProperties(primaryGroup, tag, matchIndex);
        Map<String, Integer> primaryChannelMapping = this.readChannelMapping(stream);
        for (String existingChannel : this.group.getTransactionLog().getChannelMapping().keySet()) {
            if (primaryChannelMapping.containsKey(existingChannel)) continue;
            this.removeChannel(existingChannel);
        }
        for (String channel : primaryChannelMapping.keySet()) {
            this.addChannel(channel);
        }
        this.applySecondarySnapshot(stream);
    }

    protected void processSecondaryDelete() throws IOException {
        this.setAllSecondaryProperties(Collections.emptyList(), null, 0L);
    }

    protected void processSecondaryBatchUpdate(DataInputStream stream) throws IOException {
        long offsetEntry = stream.readLong();
        long limitEntry = stream.readLong();
        for (long size = limitEntry - offsetEntry; size > 0L; --size) {
            String fingerprint;
            long dataSize;
            String repo = StateMachine.readString(stream);
            if (repo.equals("IGNORED")) continue;
            Integer channel = this.getChannel(repo, stream.readInt());
            if (channel > 0) {
                dataSize = stream.readLong();
                fingerprint = this.processRepositoryEntry(repo, (InputStream)((Object)new SecondaryBoundStream(stream, dataSize)));
                this.assertFingerprint(stream, fingerprint);
                continue;
            }
            if (channel == -2) {
                this.processSecondaryConfigChange(stream);
                continue;
            }
            if (channel == -5) {
                dataSize = stream.readLong();
                fingerprint = this.processRecoveryEntry((InputStream)((Object)new SecondaryBoundStream(stream, dataSize)));
                this.assertFingerprint(stream, fingerprint);
                continue;
            }
            if (channel == 0) {
                dataSize = stream.readLong();
                fingerprint = this.processSystemEntry((InputStream)((Object)new SecondaryBoundStream(stream, dataSize)));
                this.assertFingerprint(stream, fingerprint);
                continue;
            }
            this.logger.warn("Cannot process entry as it is from an unknown channel: {} {}", (Object)channel, (Object)repo);
            this.skipEntry(stream);
        }
        this.setPrimaryIndex(limitEntry);
    }

    protected void addTag(String tag) throws IOException {
        this.getClusterGroup().addTag(tag);
    }

    protected void removeTag(String tag) throws IOException {
        this.getClusterGroup().removeTag(tag);
    }

    protected void addChannel(String channel) {
        this.getClusterGroup().getTransactionLog().putChannelIfAbsent(channel);
    }

    protected void removeChannel(String channel) {
        this.getClusterGroup().getTransactionLog().removeChannel(channel);
    }

    protected void setAllSecondaryProperties(List<NodeInfo> nodes, String tag, long primaryIndex) {
        this.getClusterGroup().setPrimaryNodes(nodes);
        this.getClusterGroup().setSecondaryTag(tag);
        this.getClusterGroup().setPrimaryIndex(primaryIndex);
    }

    protected void setPrimaryGroup(List<NodeInfo> nodes) {
        this.getClusterGroup().setPrimaryNodes(nodes);
    }

    protected void setPrimaryIndex(long primaryIndex) throws IOException {
        this.getClusterGroup().setPrimaryIndex(primaryIndex);
    }

    @VisibleForTesting
    protected ClusterGroup getClusterGroup() {
        if (this.group == null) {
            throw new RaftException("Cluster group not set");
        }
        return this.group;
    }

    private Integer getChannel(String repository, int primaryChannel) {
        if (primaryChannel <= 0) {
            return this.getClusterGroup().getTransactionLog().getChannelId(repository);
        }
        return this.getClusterGroup().getTransactionLog().putChannelIfAbsent(repository);
    }

    private void assertFingerprint(DataInputStream stream, String actualFingerprint) throws IOException {
        String expectedFingerprint = StateMachine.readString(stream);
        if (!expectedFingerprint.equals(actualFingerprint)) {
            throw new RaftException("Fingerprint mismatch for secondary batch entry with expected fingerprint: " + expectedFingerprint + " against actual fingerprint: " + actualFingerprint);
        }
    }

    private void processSecondaryConfigChange(DataInputStream stream) throws IOException {
        int topologySize = stream.readInt();
        ArrayList<NodeInfo> list = new ArrayList<NodeInfo>();
        for (int i = 0; i < topologySize; ++i) {
            NodeInfo info = NodeInfo.newBuilder().setRpcAddress(StateMachine.readString(stream)).setHttpAddress(StateMachine.readString(stream)).build();
            list.add(info);
        }
        this.setPrimaryGroup(list);
    }

    private List<NodeInfo> readPrimaryGroup(DataInputStream stream) throws IOException {
        ArrayList<NodeInfo> primaryGroup = new ArrayList<NodeInfo>();
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            String rpcAddress = new String(stream.readNBytes(stream.readInt()), StandardCharsets.UTF_8);
            String httpAddress = "";
            int httpSize = stream.readInt();
            if (httpSize > 0) {
                httpAddress = new String(stream.readNBytes(httpSize), StandardCharsets.UTF_8);
            }
            primaryGroup.add(NodeInfo.newBuilder().setRpcAddress(rpcAddress).setHttpAddress(httpAddress).build());
        }
        return primaryGroup;
    }

    private Map<String, Integer> readChannelMapping(DataInputStream stream) throws IOException {
        HashMap<String, Integer> channelMapping = new HashMap<String, Integer>();
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            String repository = new String(stream.readNBytes(stream.readInt()), StandardCharsets.UTF_8);
            int index = stream.readInt();
            channelMapping.putIfAbsent(repository, index);
        }
        return channelMapping;
    }

    private void skipEntry(DataInputStream stream) throws IOException {
        stream.skipNBytes(stream.readLong());
        stream.skipNBytes(stream.readInt());
    }

    private static class SecondaryBoundStream
    extends BoundedInputStream {
        public SecondaryBoundStream(InputStream inputStream, long maxLength) {
            super(inputStream, maxLength);
        }

        public void close() {
        }
    }
}

