/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.graphdb.raft;

import com.ontotext.graphdb.raft.grpc.NodeInfo;
import com.ontotext.graphdb.raft.grpc.StatusResponse;
import com.ontotext.graphdb.raft.statistics.ClusterStatistics;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;

public interface ReplicationCluster {
    public long replicateUpdate(String var1, String var2);

    public OutputStream recordUpdate(String var1);

    public void rollbackUpdate(String var1);

    default public OutputStream recordBackup(List<String> affectedRepositories, boolean clearAll) {
        throw new UnsupportedOperationException("Operation is not implemented");
    }

    default public void rollbackBackup() {
        throw new UnsupportedOperationException("Operation is not implemented");
    }

    default public long replicateBackup(String fingerprint) {
        throw new UnsupportedOperationException("Operation is not implemented");
    }

    public boolean isWritable();

    public boolean areAllNodesAvailable();

    public boolean isPrimaryCluster();

    public long enableSecondaryClusterMode(NodeInfo var1, String var2);

    public long disableSecondaryClusterMode();

    public boolean addTag(String var1);

    public boolean removeTag(String var1);

    public long addNodes(List<NodeInfo> var1);

    public long removeNodes(List<NodeInfo> var1);

    public long updateGroupProperties(Map<String, Number> var1);

    public long replaceNodes(List<NodeInfo> var1, List<NodeInfo> var2);

    public ClusterStatistics getClusterStatistics();

    public void initialize(List<String> var1);

    public void start(boolean var1);

    public void shutdown();

    default public void truncateLog() {
        throw new UnsupportedOperationException("Operation not implemented for " + this.getClass().getName());
    }

    public Map<String, StatusResponse> getGroupStatus();

    public StatusResponse getNodeStatus();

    public Map<String, String> getSyncStatus();

    public boolean isLeader();

    public void incrementFailedTransactionsCount();

    public void goOutOfSync();
}

