/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.VectorStoreChunkingStrategyRequest;
import com.azure.ai.openai.assistants.models.VectorStoreChunkingStrategyRequestType;
import com.azure.ai.openai.assistants.models.VectorStoreStaticChunkingStrategyOptions;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class VectorStoreStaticChunkingStrategyRequest
extends VectorStoreChunkingStrategyRequest {
    private VectorStoreChunkingStrategyRequestType type = VectorStoreChunkingStrategyRequestType.STATIC;
    private final VectorStoreStaticChunkingStrategyOptions staticProperty;

    public VectorStoreStaticChunkingStrategyRequest(VectorStoreStaticChunkingStrategyOptions staticProperty) {
        this.staticProperty = staticProperty;
    }

    @Override
    public VectorStoreChunkingStrategyRequestType getType() {
        return this.type;
    }

    public VectorStoreStaticChunkingStrategyOptions getStaticProperty() {
        return this.staticProperty;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("static", (JsonSerializable)this.staticProperty);
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static VectorStoreStaticChunkingStrategyRequest fromJson(JsonReader jsonReader) throws IOException {
        return (VectorStoreStaticChunkingStrategyRequest)jsonReader.readObject(reader -> {
            VectorStoreStaticChunkingStrategyOptions staticProperty = null;
            VectorStoreChunkingStrategyRequestType type = VectorStoreChunkingStrategyRequestType.STATIC;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("static".equals(fieldName)) {
                    staticProperty = VectorStoreStaticChunkingStrategyOptions.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = VectorStoreChunkingStrategyRequestType.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            VectorStoreStaticChunkingStrategyRequest deserializedVectorStoreStaticChunkingStrategyRequest = new VectorStoreStaticChunkingStrategyRequest(staticProperty);
            deserializedVectorStoreStaticChunkingStrategyRequest.type = type;
            return deserializedVectorStoreStaticChunkingStrategyRequest;
        });
    }
}

