/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.VectorStoreFileErrorCode;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class VectorStoreFileError
implements JsonSerializable<VectorStoreFileError> {
    private final VectorStoreFileErrorCode code;
    private final String message;

    private VectorStoreFileError(VectorStoreFileErrorCode code, String message) {
        this.code = code;
        this.message = message;
    }

    public VectorStoreFileErrorCode getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("code", this.code == null ? null : this.code.toString());
        jsonWriter.writeStringField("message", this.message);
        return jsonWriter.writeEndObject();
    }

    public static VectorStoreFileError fromJson(JsonReader jsonReader) throws IOException {
        return (VectorStoreFileError)jsonReader.readObject(reader -> {
            VectorStoreFileErrorCode code = null;
            String message = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("code".equals(fieldName)) {
                    code = VectorStoreFileErrorCode.fromString(reader.getString());
                    continue;
                }
                if ("message".equals(fieldName)) {
                    message = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new VectorStoreFileError(code, message);
        });
    }
}

