/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.RunStepCodeInterpreterToolCall;
import com.azure.ai.openai.assistants.models.RunStepFileSearchToolCall;
import com.azure.ai.openai.assistants.models.RunStepFunctionToolCall;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class RunStepToolCall
implements JsonSerializable<RunStepToolCall> {
    private final String id;
    private String type = "RunStepToolCall";

    protected RunStepToolCall(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("id", this.id);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static RunStepToolCall fromJson(JsonReader jsonReader) throws IOException {
        return (RunStepToolCall)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                RunStepToolCall runStepToolCall;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("code_interpreter".equals(discriminatorValue)) {
                    runStepToolCall = RunStepCodeInterpreterToolCall.fromJson(readerToUse.reset());
                    return runStepToolCall;
                }
                if ("file_search".equals(discriminatorValue)) {
                    runStepToolCall = RunStepFileSearchToolCall.fromJson(readerToUse.reset());
                    return runStepToolCall;
                }
                if ("function".equals(discriminatorValue)) {
                    runStepToolCall = RunStepFunctionToolCall.fromJson(readerToUse.reset());
                    return runStepToolCall;
                }
                runStepToolCall = RunStepToolCall.fromJsonKnownDiscriminator(readerToUse.reset());
                return runStepToolCall;
            }
        });
    }

    static RunStepToolCall fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (RunStepToolCall)jsonReader.readObject(reader -> {
            String id = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("id".equals(fieldName)) {
                    id = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new RunStepToolCall(id);
        });
    }

    public String getType() {
        return this.type;
    }
}

