/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.MessageDeltaTextAnnotation;
import com.azure.ai.openai.assistants.models.MessageDeltaTextFilePathAnnotation;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MessageDeltaTextFilePathAnnotationObject
extends MessageDeltaTextAnnotation {
    private String type = "file_path";
    private MessageDeltaTextFilePathAnnotation filePath;
    private Integer startIndex;
    private Integer endIndex;
    private String text;

    private MessageDeltaTextFilePathAnnotationObject(int index) {
        super(index);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public MessageDeltaTextFilePathAnnotation getFilePath() {
        return this.filePath;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public Integer getEndIndex() {
        return this.endIndex;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("index", this.getIndex());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("file_path", (JsonSerializable)this.filePath);
        jsonWriter.writeNumberField("start_index", (Number)this.startIndex);
        jsonWriter.writeNumberField("end_index", (Number)this.endIndex);
        jsonWriter.writeStringField("text", this.text);
        return jsonWriter.writeEndObject();
    }

    public static MessageDeltaTextFilePathAnnotationObject fromJson(JsonReader jsonReader) throws IOException {
        return (MessageDeltaTextFilePathAnnotationObject)jsonReader.readObject(reader -> {
            int index = 0;
            String type = "file_path";
            MessageDeltaTextFilePathAnnotation filePath = null;
            Integer startIndex = null;
            Integer endIndex = null;
            String text = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("file_path".equals(fieldName)) {
                    filePath = MessageDeltaTextFilePathAnnotation.fromJson(reader);
                    continue;
                }
                if ("start_index".equals(fieldName)) {
                    startIndex = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("end_index".equals(fieldName)) {
                    endIndex = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            MessageDeltaTextFilePathAnnotationObject deserializedMessageDeltaTextFilePathAnnotationObject = new MessageDeltaTextFilePathAnnotationObject(index);
            deserializedMessageDeltaTextFilePathAnnotationObject.type = type;
            deserializedMessageDeltaTextFilePathAnnotationObject.filePath = filePath;
            deserializedMessageDeltaTextFilePathAnnotationObject.startIndex = startIndex;
            deserializedMessageDeltaTextFilePathAnnotationObject.endIndex = endIndex;
            deserializedMessageDeltaTextFilePathAnnotationObject.text = text;
            return deserializedMessageDeltaTextFilePathAnnotationObject;
        });
    }

    public String getText() {
        return this.text;
    }
}

