/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.MessageDeltaTextAnnotation;
import com.azure.ai.openai.assistants.models.MessageDeltaTextFileCitationAnnotation;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class MessageDeltaTextFileCitationAnnotationObject
extends MessageDeltaTextAnnotation {
    private String type = "file_citation";
    private MessageDeltaTextFileCitationAnnotation fileCitation;
    private Integer startIndex;
    private Integer endIndex;
    private String text;

    private MessageDeltaTextFileCitationAnnotationObject(int index) {
        super(index);
    }

    @Override
    public String getType() {
        return this.type;
    }

    public MessageDeltaTextFileCitationAnnotation getFileCitation() {
        return this.fileCitation;
    }

    public Integer getStartIndex() {
        return this.startIndex;
    }

    public Integer getEndIndex() {
        return this.endIndex;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeIntField("index", this.getIndex());
        jsonWriter.writeStringField("type", this.type);
        jsonWriter.writeJsonField("file_citation", (JsonSerializable)this.fileCitation);
        jsonWriter.writeStringField("text", this.text);
        jsonWriter.writeNumberField("start_index", (Number)this.startIndex);
        jsonWriter.writeNumberField("end_index", (Number)this.endIndex);
        return jsonWriter.writeEndObject();
    }

    public static MessageDeltaTextFileCitationAnnotationObject fromJson(JsonReader jsonReader) throws IOException {
        return (MessageDeltaTextFileCitationAnnotationObject)jsonReader.readObject(reader -> {
            int index = 0;
            String type = "file_citation";
            MessageDeltaTextFileCitationAnnotation fileCitation = null;
            String text = null;
            Integer startIndex = null;
            Integer endIndex = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("index".equals(fieldName)) {
                    index = reader.getInt();
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                if ("file_citation".equals(fieldName)) {
                    fileCitation = MessageDeltaTextFileCitationAnnotation.fromJson(reader);
                    continue;
                }
                if ("text".equals(fieldName)) {
                    text = reader.getString();
                    continue;
                }
                if ("start_index".equals(fieldName)) {
                    startIndex = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("end_index".equals(fieldName)) {
                    endIndex = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                reader.skipChildren();
            }
            MessageDeltaTextFileCitationAnnotationObject deserializedMessageDeltaTextFileCitationAnnotationObject = new MessageDeltaTextFileCitationAnnotationObject(index);
            deserializedMessageDeltaTextFileCitationAnnotationObject.type = type;
            deserializedMessageDeltaTextFileCitationAnnotationObject.fileCitation = fileCitation;
            deserializedMessageDeltaTextFileCitationAnnotationObject.text = text;
            deserializedMessageDeltaTextFileCitationAnnotationObject.startIndex = startIndex;
            deserializedMessageDeltaTextFileCitationAnnotationObject.endIndex = endIndex;
            return deserializedMessageDeltaTextFileCitationAnnotationObject;
        });
    }

    public String getText() {
        return this.text;
    }
}

