/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.MessageImageFileContent;
import com.azure.ai.openai.assistants.models.MessageTextContent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class MessageContent
implements JsonSerializable<MessageContent> {
    private String type = "MessageContent";

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static MessageContent fromJson(JsonReader jsonReader) throws IOException {
        return (MessageContent)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                MessageContent messageContent;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("text".equals(discriminatorValue)) {
                    messageContent = MessageTextContent.fromJson(readerToUse.reset());
                    return messageContent;
                }
                if ("image_file".equals(discriminatorValue)) {
                    messageContent = MessageImageFileContent.fromJson(readerToUse.reset());
                    return messageContent;
                }
                messageContent = MessageContent.fromJsonKnownDiscriminator(readerToUse.reset());
                return messageContent;
            }
        });
    }

    static MessageContent fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (MessageContent)jsonReader.readObject(reader -> {
            MessageContent deserializedMessageContent = new MessageContent();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                reader.skipChildren();
            }
            return deserializedMessageContent;
        });
    }

    public String getType() {
        return this.type;
    }
}

