/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class FunctionDefinition
implements JsonSerializable<FunctionDefinition> {
    private final String name;
    private String description;
    private final BinaryData parameters;

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public BinaryData getParameters() {
        return this.parameters;
    }

    public FunctionDefinition setDescription(String description) {
        this.description = description;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("name", this.name);
        jsonWriter.writeRawField("parameters", this.parameters.toString());
        jsonWriter.writeStringField("description", this.description);
        return jsonWriter.writeEndObject();
    }

    public static FunctionDefinition fromJson(JsonReader jsonReader) throws IOException {
        return (FunctionDefinition)jsonReader.readObject(reader -> {
            String name = null;
            BinaryData parameters = null;
            String description = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("name".equals(fieldName)) {
                    name = reader.getString();
                    continue;
                }
                if ("parameters".equals(fieldName)) {
                    parameters = BinaryData.fromObject((Object)reader.readUntyped());
                    continue;
                }
                if ("description".equals(fieldName)) {
                    description = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            FunctionDefinition deserializedFunctionDefinition = new FunctionDefinition(name, parameters);
            deserializedFunctionDefinition.description = description;
            return deserializedFunctionDefinition;
        });
    }

    public FunctionDefinition(String name, BinaryData parameters) {
        this.name = name;
        this.parameters = parameters;
    }
}

