/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.models;

import com.azure.ai.openai.assistants.models.ApiResponseFormat;
import com.azure.ai.openai.assistants.models.AssistantsApiResponseFormatJsonObject;
import com.azure.ai.openai.assistants.models.AssistantsApiResponseFormatJsonSchema;
import com.azure.ai.openai.assistants.models.AssistantsApiResponseFormatText;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public class AssistantsApiResponseFormat
implements JsonSerializable<AssistantsApiResponseFormat> {
    private ApiResponseFormat type = ApiResponseFormat.fromString("AssistantsApiResponseFormat");

    public AssistantsApiResponseFormat() {
    }

    public AssistantsApiResponseFormat(ApiResponseFormat type) {
        this.type = type;
    }

    public ApiResponseFormat getType() {
        return this.type;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("type", this.type == null ? null : this.type.toString());
        return jsonWriter.writeEndObject();
    }

    public static AssistantsApiResponseFormat fromJson(JsonReader jsonReader) throws IOException {
        return (AssistantsApiResponseFormat)jsonReader.readObject(reader -> {
            String discriminatorValue = null;
            try (JsonReader readerToUse = reader.bufferObject();){
                AssistantsApiResponseFormat assistantsApiResponseFormat;
                readerToUse.nextToken();
                while (readerToUse.nextToken() != JsonToken.END_OBJECT) {
                    String fieldName = readerToUse.getFieldName();
                    readerToUse.nextToken();
                    if ("type".equals(fieldName)) {
                        discriminatorValue = readerToUse.getString();
                        break;
                    }
                    readerToUse.skipChildren();
                }
                if ("text".equals(discriminatorValue)) {
                    assistantsApiResponseFormat = AssistantsApiResponseFormatText.fromJson(readerToUse.reset());
                    return assistantsApiResponseFormat;
                }
                if ("json_object".equals(discriminatorValue)) {
                    assistantsApiResponseFormat = AssistantsApiResponseFormatJsonObject.fromJson(readerToUse.reset());
                    return assistantsApiResponseFormat;
                }
                if ("json_schema".equals(discriminatorValue)) {
                    assistantsApiResponseFormat = AssistantsApiResponseFormatJsonSchema.fromJson(readerToUse.reset());
                    return assistantsApiResponseFormat;
                }
                assistantsApiResponseFormat = AssistantsApiResponseFormat.fromJsonKnownDiscriminator(readerToUse.reset());
                return assistantsApiResponseFormat;
            }
        });
    }

    static AssistantsApiResponseFormat fromJsonKnownDiscriminator(JsonReader jsonReader) throws IOException {
        return (AssistantsApiResponseFormat)jsonReader.readObject(reader -> {
            AssistantsApiResponseFormat deserializedAssistantsApiResponseFormat = new AssistantsApiResponseFormat();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("type".equals(fieldName)) {
                    deserializedAssistantsApiResponseFormat.type = ApiResponseFormat.fromString(reader.getString());
                    continue;
                }
                reader.skipChildren();
            }
            return deserializedAssistantsApiResponseFormat;
        });
    }
}

