/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.implementation.streaming;

import com.azure.ai.openai.assistants.models.AssistantStreamEvent;
import com.azure.ai.openai.assistants.models.AssistantThread;
import com.azure.ai.openai.assistants.models.MessageDeltaChunk;
import com.azure.ai.openai.assistants.models.RunStep;
import com.azure.ai.openai.assistants.models.RunStepDeltaChunk;
import com.azure.ai.openai.assistants.models.StreamMessageCreation;
import com.azure.ai.openai.assistants.models.StreamMessageUpdate;
import com.azure.ai.openai.assistants.models.StreamRequiredAction;
import com.azure.ai.openai.assistants.models.StreamRunCreation;
import com.azure.ai.openai.assistants.models.StreamRunStepUpdate;
import com.azure.ai.openai.assistants.models.StreamThreadCreation;
import com.azure.ai.openai.assistants.models.StreamThreadRunCreation;
import com.azure.ai.openai.assistants.models.StreamUpdate;
import com.azure.ai.openai.assistants.models.ThreadMessage;
import com.azure.ai.openai.assistants.models.ThreadRun;
import com.azure.core.util.BinaryData;

public final class StreamTypeFactory {
    public StreamUpdate deserializeEvent(String eventName, BinaryData eventJson) throws IllegalArgumentException {
        AssistantStreamEvent event = AssistantStreamEvent.fromString(eventName);
        if (AssistantStreamEvent.THREAD_CREATED.equals((Object)event)) {
            return new StreamThreadCreation((AssistantThread)eventJson.toObject(AssistantThread.class), event);
        }
        if (AssistantStreamEvent.THREAD_RUN_CREATED.equals((Object)event) || AssistantStreamEvent.THREAD_RUN_QUEUED.equals((Object)event) || AssistantStreamEvent.THREAD_RUN_IN_PROGRESS.equals((Object)event) || AssistantStreamEvent.THREAD_RUN_COMPLETED.equals((Object)event) || AssistantStreamEvent.THREAD_RUN_CANCELLED.equals((Object)event) || AssistantStreamEvent.THREAD_RUN_CANCELLING.equals((Object)event) || AssistantStreamEvent.THREAD_RUN_FAILED.equals((Object)event) || AssistantStreamEvent.THREAD_RUN_EXPIRED.equals((Object)event)) {
            return new StreamThreadRunCreation((ThreadRun)eventJson.toObject(ThreadRun.class), event);
        }
        if (AssistantStreamEvent.THREAD_RUN_STEP_CREATED.equals((Object)event) || AssistantStreamEvent.THREAD_RUN_STEP_IN_PROGRESS.equals((Object)event) || AssistantStreamEvent.THREAD_RUN_STEP_COMPLETED.equals((Object)event) || AssistantStreamEvent.THREAD_RUN_STEP_FAILED.equals((Object)event) || AssistantStreamEvent.THREAD_RUN_STEP_CANCELLED.equals((Object)event) || AssistantStreamEvent.THREAD_RUN_STEP_EXPIRED.equals((Object)event)) {
            return new StreamRunCreation((RunStep)eventJson.toObject(RunStep.class), event);
        }
        if (AssistantStreamEvent.THREAD_MESSAGE_CREATED.equals((Object)event) || AssistantStreamEvent.THREAD_MESSAGE_IN_PROGRESS.equals((Object)event) || AssistantStreamEvent.THREAD_MESSAGE_COMPLETED.equals((Object)event) || AssistantStreamEvent.THREAD_MESSAGE_INCOMPLETE.equals((Object)event)) {
            return new StreamMessageCreation((ThreadMessage)eventJson.toObject(ThreadMessage.class), event);
        }
        if (AssistantStreamEvent.THREAD_MESSAGE_DELTA.equals((Object)event)) {
            return new StreamMessageUpdate((MessageDeltaChunk)eventJson.toObject(MessageDeltaChunk.class), event);
        }
        if (AssistantStreamEvent.THREAD_RUN_STEP_DELTA.equals((Object)event)) {
            return new StreamRunStepUpdate((RunStepDeltaChunk)eventJson.toObject(RunStepDeltaChunk.class), event);
        }
        if (AssistantStreamEvent.THREAD_RUN_REQUIRES_ACTION.equals((Object)event)) {
            return new StreamRequiredAction((ThreadRun)eventJson.toObject(ThreadRun.class), event);
        }
        throw new IllegalArgumentException("Unknown event type: " + (Object)((Object)event));
    }
}

