/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.assistants.implementation.streaming;

import com.azure.ai.openai.assistants.implementation.streaming.StreamTypeFactory;
import com.azure.ai.openai.assistants.models.AssistantStreamEvent;
import com.azure.ai.openai.assistants.models.StreamUpdate;
import com.azure.core.util.BinaryData;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public final class OpenAIServerSentEvents {
    private static final int SSE_CHUNK_LINE_BREAK_COUNT_MARKER = 2;
    private final StreamTypeFactory eventDeserializer = new StreamTypeFactory();
    private final Flux<ByteBuffer> source;
    private ByteArrayOutputStream outStream;

    public OpenAIServerSentEvents(Flux<ByteBuffer> source) {
        this.source = source;
        this.outStream = new ByteArrayOutputStream();
    }

    public Flux<StreamUpdate> getEvents() {
        return this.mapEventStream();
    }

    private Flux<StreamUpdate> mapEventStream() {
        return this.source.publishOn(Schedulers.boundedElastic()).concatMap(byteBuffer -> {
            ArrayList<StreamUpdate> values = new ArrayList<StreamUpdate>();
            byte[] byteArray = byteBuffer.array();
            byte[] outByteArray = this.outStream.toByteArray();
            int lineBreakCharsEncountered = outByteArray.length > 0 && this.isByteLineFeed(outByteArray[outByteArray.length - 1]) ? 1 : 0;
            for (byte currentByte : byteArray) {
                this.outStream.write(currentByte);
                if (this.isByteLineFeed(currentByte)) {
                    if (++lineBreakCharsEncountered != 2) continue;
                    try {
                        String currentLine = this.outStream.toString(StandardCharsets.UTF_8.name());
                        this.handleCurrentEvent(currentLine, values);
                    }
                    catch (IOException e) {
                        return Flux.error((Throwable)e);
                    }
                    this.outStream = new ByteArrayOutputStream();
                    continue;
                }
                if (this.isByteCarriageReturn(currentByte)) continue;
                lineBreakCharsEncountered = 0;
            }
            try {
                String remainingBytes = this.outStream.toString(StandardCharsets.UTF_8.name());
                if (remainingBytes.endsWith("\n\n") || remainingBytes.endsWith("\r\n\r\n")) {
                    this.handleCurrentEvent(remainingBytes, values);
                }
            }
            catch (UncheckedIOException | IllegalArgumentException e) {
                return Flux.fromIterable(values);
            }
            catch (IOException e) {
                return Flux.error((Throwable)e);
            }
            return Flux.fromIterable(values);
        }).cache();
    }

    private boolean isByteLineFeed(byte character) {
        return character == 10;
    }

    private boolean isByteCarriageReturn(byte character) {
        return character == 13;
    }

    public void handleCurrentEvent(String currentEvent, List<StreamUpdate> outputValues) throws IllegalArgumentException {
        if (currentEvent.isEmpty()) {
            return;
        }
        String[] lines = currentEvent.split("\n", 2);
        if (lines.length != 2) {
            return;
        }
        if (lines[0].isEmpty() || lines[1].isEmpty()) {
            return;
        }
        String eventName = lines[0].substring(6).trim();
        String eventJson = lines[1].substring(5).trim();
        if (AssistantStreamEvent.DONE.equals((Object)AssistantStreamEvent.fromString(eventName))) {
            return;
        }
        if (AssistantStreamEvent.ERROR.equals((Object)AssistantStreamEvent.fromString(eventName))) {
            throw new IllegalArgumentException(eventJson);
        }
        outputValues.add(this.eventDeserializer.deserializeEvent(eventName, BinaryData.fromString((String)eventJson)));
    }
}

